/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.Filter;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GzipRequestWrapper
extends HttpServletRequestWrapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(GzipRequestWrapper.class);
    private HttpServletRequest request;

    public GzipRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public ServletInputStream getInputStream() throws IOException {
        ServletInputStream stream = this.request.getInputStream();
        String contentEncoding = this.request.getHeader("Content-Encoding");
        if (null != contentEncoding && contentEncoding.indexOf("gzip") != -1) {
            try {
                final GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)stream);
                ServletInputStream newStream = new ServletInputStream(){

                    public int read() throws IOException {
                        return gzipInputStream.read();
                    }
                };
                return newStream;
            }
            catch (Exception e) {
                LOGGER.debug("ungzip content fail.", (Throwable)e);
            }
        }
        return stream;
    }
}

