/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.omd.annotation.RefCheck;
import com.efuture.omd.common.component.BasicComponent;
import com.efuture.omd.common.entity.AbstractEntityBean;
import com.efuture.omd.common.entity.ServiceResponse;
import com.efuture.omd.common.entity.ServiceSession;
import com.efuture.omd.common.exception.ServiceException;
import com.efuture.omd.common.intf.AnnotationActionService;
import com.efuture.omd.common.intf.AnnotationBeanService;
import com.efuture.omd.common.language.MessageSourceHelper;
import com.efuture.omd.common.util.SpringBeanFactory;
import com.efuture.omd.common.util.StorageUtils;
import com.efuture.omd.common.util.UniqueID;
import com.efuture.omd.storage.FStorageOperations;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicComponentService<T extends AbstractEntityBean>
extends BasicComponent {
    protected static final String PARENT_ID_KEY = "parent_id";
    protected List<AnnotationActionService> plugins;
    final Class<T> beanClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), BasicComponentService.class);
    private int i = 0;

    public BasicComponentService() {
        this(false);
    }

    public BasicComponentService(boolean useStringRegex) {
        super(useStringRegex);
    }

    public List<AnnotationActionService> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<AnnotationActionService>();
        }
        return this.plugins;
    }

    public void setPlugins(List<AnnotationActionService> plugins) {
        this.plugins = plugins;
    }

    public void addPlugins(AnnotationActionService plugin) {
        this.getPlugins().add(plugin);
    }

    protected Class<T> getBeanClass() {
        return this.beanClass;
    }

    protected String getBeanTable() {
        return AbstractEntityBean.fetchAnnotationTableName(this.getBeanClass());
    }

    protected String getIdKey() throws IllegalArgumentException, IllegalAccessException {
        return this.getIdKey(null);
    }

    protected String getIdKey(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        return (String)AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "ID_KEY").get(null);
    }

    protected String[] getUniqueKeys() throws IllegalArgumentException, IllegalAccessException {
        return this.getUniqueKeys(null);
    }

    protected String[] getUniqueKeys(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "UNIQUE_KEYS");
        if (fld == null) {
            return null;
        }
        return (String[])fld.get(null);
    }

    protected Map<String, Object> getDependency(Class<?> cl) throws IllegalArgumentException, IllegalAccessException {
        Field fld = AbstractEntityBean.fetchDeclaredField(cl == null ? this.getBeanClass() : cl, "DEPENDENCY");
        if (fld == null) {
            return null;
        }
        return (Map)fld.get(null);
    }

    protected Field getIdField() throws IllegalArgumentException, IllegalAccessException {
        Field idfld = AbstractEntityBean.fetchDeclaredField(this.getBeanClass(), this.getIdKey());
        return idfld;
    }

    protected void checkDependency(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys) throws Exception {
        if (storage == null) {
            return;
        }
        Map<String, Object> dependencys = this.getDependency(bean.getClass());
        if (dependencys == null) {
            return;
        }
        Set<String> depkeys = dependencys.keySet();
        for (String key : depkeys) {
            Field codefld;
            String codekey;
            Map depbean;
            Field depfld;
            Object depval;
            Object depobj = dependencys.get(key);
            if (depobj == null) continue;
            if (key.startsWith("$set")) {
                boolean toNext = false;
                JSONObject params = JSON.parseObject((String)depobj.toString());
                boolean ignore = false;
                if (params.containsKey((Object)"ignore") && params.getBooleanValue("ignore")) {
                    ignore = true;
                }
                boolean ignoreEnt = false;
                if (params.containsKey((Object)"ignoreEnt") && params.getBooleanValue("ignoreEnt")) {
                    ignoreEnt = true;
                }
                String tabname = params.getString("table");
                Map mapSet = (Map)params.getObject("set", Map.class);
                Map mapQuery = (Map)params.getObject("query", Map.class);
                Criteria criteria = null;
                if (ignoreEnt) {
                    criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id());
                }
                Set querySet = mapQuery.keySet();
                for (String keyname : querySet) {
                    String keyvalue = mapQuery.get(keyname).toString();
                    if (keyvalue.startsWith("$")) {
                        Field refField = AbstractEntityBean.fetchDeclaredField(bean.getClass(), keyvalue.substring(1));
                        if (refField == null) continue;
                        Object refValue = refField.get(bean);
                        if ((refValue instanceof Long || refValue instanceof Integer) && Long.parseLong(refValue.toString()) <= 0L) {
                            refField.set(bean, 0);
                            toNext = true;
                            break;
                        }
                        if (criteria == null) {
                            criteria = Criteria.where((String)keyname).is(refValue);
                            continue;
                        }
                        criteria.and(keyname).is(refValue);
                        continue;
                    }
                    if (criteria == null) {
                        criteria = Criteria.where((String)keyname).is((Object)keyvalue);
                        continue;
                    }
                    criteria.and(keyname).is((Object)keyvalue);
                }
                if (toNext) continue;
                Query query = null;
                query = criteria != null ? new Query((CriteriaDefinition)criteria) : new Query();
                Set setSet = mapSet.keySet();
                for (String keyname : setSet) {
                    query.fields().include(mapSet.get(keyname).toString());
                }
                Map depbean2 = storage.selectOne(query, tabname);
                if (depbean2 == null && !ignore) {
                    throw new ServiceException("10006", "relation {0} does not exist with {1} ", query.toString(), MessageSourceHelper.getMessage(tabname, bean.getLang(), new Object[0]));
                }
                if (depbean2 == null) continue;
                for (String keyname : setSet) {
                    Field relationField = AbstractEntityBean.fetchDeclaredField(bean.getClass(), keyname);
                    if (relationField == null) continue;
                    if (keys != null && !keys.contains(keyname)) {
                        keys.add(keyname);
                    }
                    relationField.set(bean, depbean2.get(mapSet.get(keyname).toString()));
                }
                continue;
            }
            if (keys != null && !keys.contains(key) || StringUtils.isEmpty((Object)(depval = (depfld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), key)).get(bean)))) continue;
            if ((depval instanceof Long || depval instanceof Integer) && Long.parseLong(depval.toString()) <= 0L) {
                depfld.set(bean, 0);
                continue;
            }
            String deptable = null;
            String idkey = null;
            String[] ohkey = null;
            if (depobj instanceof String) {
                String[] ss = ((String)depobj).split(":");
                if (ss.length > 0) {
                    deptable = ss[0].trim();
                }
                if (ss.length > 1) {
                    ohkey = ss[1].split(",");
                    idkey = ohkey[0].trim();
                }
            } else if (depobj instanceof Class) {
                idkey = (String)AbstractEntityBean.fetchDeclaredField((Class)depobj, "ID_KEY").get(null);
                deptable = AbstractEntityBean.fetchAnnotationTableName((Class)depobj);
            }
            if (StringUtils.isEmpty(idkey)) {
                throw new ServiceException("10005", "{0} 's dependency {1} is illegal key in {2}", key, idkey, MessageSourceHelper.getMessage(deptable, bean.getLang(), new Object[0]));
            }
            Criteria criteria = Criteria.where(idkey).is(depval);
            if (ohkey != null && ohkey.length > 1) {
                for (int i = 1; i < ohkey.length; ++i) {
                    String[] ss = ohkey[i].split("=");
                    if (ss.length <= 1) continue;
                    criteria = criteria.and(ss[0].trim()).is((Object)ss[1].trim());
                }
            }
            Query query = new Query((CriteriaDefinition)criteria);
            query.fields().include(idkey);
            if (key.endsWith("_id")) {
                query.fields().include("code");
                query.fields().include("name");
            }
            if ((depbean = storage.selectOne(query, deptable)) == null) {
                throw new ServiceException("10006", "{0} [{1}] does not exist with {2} of {3}", key, depval, idkey, MessageSourceHelper.getMessage(deptable, bean.getLang(), new Object[0]));
            }
            if (!key.endsWith("_id")) continue;
            if (!StringUtils.isEmpty(depbean.get("code"))) {
                codekey = key.replace("_id", "_code");
                codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);
                if (codefld != null) {
                    codefld.set(bean, depbean.get("code"));
                    if (keys != null && !keys.contains(codekey)) {
                        keys.add(codekey);
                    }
                }
            }
            if (StringUtils.isEmpty(depbean.get("name"))) continue;
            codekey = key.replace("_id", "_name");
            codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);
            if (codefld != null) {
                codefld.set(bean, depbean.get("name"));
                if (keys == null || keys.contains(codekey)) continue;
                keys.add(codekey);
                continue;
            }
            codekey = key.replace("_id", "");
            codefld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), codekey);
            if (codefld == null) continue;
            codefld.set(bean, depbean.get("name"));
            if (keys == null || keys.contains(codekey)) continue;
            keys.add(codekey);
        }
    }

    protected boolean haveParentDependency() throws IllegalArgumentException, IllegalAccessException {
        Map<String, Object> dependencys = this.getDependency(null);
        return dependencys != null && dependencys.keySet().contains(PARENT_ID_KEY);
    }

    protected void onBeforeAdd(ServiceSession session, String param) throws Exception {
    }

    protected void onBeforeUpdate(ServiceSession session, String param) throws Exception {
    }

    protected void onBeforeSave(ServiceSession session, String param) throws Exception {
    }

    protected void onBeforeDelete(ServiceSession session, String param) throws Exception {
    }

    protected void onBeforeGet(ServiceSession session, JSONObject jsonparam) throws Exception {
    }

    protected void onBeforeGetChildren(ServiceSession session, JSONObject jsonparam) throws Exception {
    }

    protected void onBeforeSearch(ServiceSession session, JSONObject jsonparam) throws Exception {
    }

    protected void onBeforeExport(ServiceSession session, JSONObject jsonparam) throws Exception {
    }

    protected void onAfterAdd(ServiceSession session, T bean) throws Exception {
    }

    protected void onAfterUpdate(ServiceSession session, T bean) throws Exception {
    }

    protected void onAfterSave(ServiceSession session, String param) throws Exception {
    }

    protected void onAfterDelete(ServiceSession session, T bean) throws Exception {
    }

    protected void onAfterGet(ServiceSession session, JSONObject jsonparam) throws Exception {
    }

    protected void onAfterGetChildren(ServiceSession session, JSONObject jsonparam) throws Exception {
    }

    protected void onAfterSearch(ServiceSession session, JSONObject jsonparam) throws Exception {
    }

    protected void onAfterExport(ServiceSession session, JSONObject jsonparam) throws Exception {
    }

    @Override
    protected void onAddValid(FStorageOperations storage, AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        super.onAddValid(storage, bean, id, uniques);
        this.checkDependency(storage, bean, null);
    }

    public ServiceResponse add(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.onBeforeAdd(session, param);
            AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(param, this.getBeanClass(), null, false);
            this.onSetNewID(bean);
            bean.initInsertMember(session);
            JSONObject paramJson = JSON.parseObject((String)param);
            if (!StringUtils.isEmpty((Object)paramJson.getString("status"))) {
                bean.setStatus(paramJson.getString("status"));
            }
            List<AnnotationActionService> tagPlugins = this.getPlugins();
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isBeforeAdd()) continue;
                plugin.onAction(bean, this.getBeanClass());
            }
            List<Annotation> checkAnnotation = this.getCheckAnnotations(bean);
            this.executCheck(session, bean, checkAnnotation, "beforeAdd");
            String idkey = this.getIdKey();
            long id = this.doAdd(bean, idkey, this.getUniqueKeys());
            this.updateIsParent(bean);
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isAfterAdd()) continue;
                plugin.onAction(bean, this.getBeanClass());
            }
            this.executCheck(session, bean, checkAnnotation, "beforeAfter");
            JSONObject respdata = new JSONObject();
            respdata.put(idkey, (Object)id);
            this.onAfterAdd(session, bean);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public ServiceResponse add1(ServiceSession session, String param) throws Exception {
        try {
            JSONObject paramflag = JSON.parseObject((String)param);
            String paramentid = paramflag.getString("ent_id_data");
            paramflag.remove((Object)"paramflag");
            param = paramflag.toString();
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.onBeforeAdd(session, param);
            AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(param, this.getBeanClass(), null, false);
            if (!paramentid.equals("0")) {
                bean.setEnt_id(Long.valueOf(paramentid));
            } else {
                this.onSetNewID(bean);
            }
            bean.initInsertMember(session);
            JSONObject paramJson = JSON.parseObject((String)param);
            if (!StringUtils.isEmpty((Object)paramJson.getString("status"))) {
                bean.setStatus(paramJson.getString("status"));
            }
            List<AnnotationActionService> tagPlugins = this.getPlugins();
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isBeforeAdd()) continue;
                plugin.onAction(bean, this.getBeanClass());
            }
            List<Annotation> checkAnnotation = this.getCheckAnnotations(bean);
            this.executCheck(session, bean, checkAnnotation, "beforeAdd");
            String idkey = this.getIdKey();
            long id = this.doAdd(bean, idkey, this.getUniqueKeys());
            this.updateIsParent(bean);
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isAfterAdd()) continue;
                plugin.onAction(bean, this.getBeanClass());
            }
            this.executCheck(session, bean, checkAnnotation, "beforeAfter");
            JSONObject respdata = new JSONObject();
            respdata.put(idkey, (Object)id);
            this.onAfterAdd(session, bean);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    protected void isfalse(T bean) throws Exception {
        if (this.i > 5) {
            throw new Exception("\u51fa\u73b0\u5185\u90e8error\uff01ent_id\u91cd\u590d\u3002");
        }
        StringBuffer total = new StringBuffer();
        JSONObject jsonb = new JSONObject();
        jsonb.put("ent_id", (Object)((AbstractEntityBean)bean).getEnt_id());
        List<Map<String, Object>> list = this.doSearchForMap(jsonb, AbstractEntityBean.class, total);
        if (list.size() != 0) {
            this.onSetNewID(bean);
            this.isfalse(bean);
            ++this.i;
        }
    }

    protected Boolean examentid(String param) throws Exception {
        StringBuffer total = new StringBuffer();
        Boolean flag = true;
        JSONObject paramJson = JSON.parseObject((String)param);
        String data = paramJson.get((Object)"ent_id_data").toString();
        if (data.equals("0")) {
            return true;
        }
        JSONObject obj = new JSONObject();
        obj.put("ent_id", (Object)data);
        List<Map<String, Object>> list = this.doSearchForMap(obj, this.getBeanClass(), total);
        flag = list.size() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return flag;
    }

    @Override
    protected AbstractEntityBean onUpdateValid(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        AbstractEntityBean original = super.onUpdateValid(storage, bean, keys, id, uniques);
        this.checkDependency(storage, bean, keys);
        return original;
    }

    public ServiceResponse update(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.onBeforeUpdate(session, param);
            StringBuffer newParam = new StringBuffer();
            AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(param, this.getBeanClass(), newParam, true);
            bean.initUpdateMember(session);
            HashSet<String> keys = new HashSet<String>(JSON.parseObject((String)newParam.toString()).keySet());
            String idkey = this.getIdKey();
            long id = 0L;
            List<AnnotationActionService> tagPlugins = this.getPlugins();
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isBeforeUpdate()) continue;
                plugin.onAction(bean, this.getBeanClass());
            }
            if (this.haveParentDependency() && keys.contains(PARENT_ID_KEY)) {
                AbstractEntityBean original = this.execUpdate(bean, keys, idkey, this.getUniqueKeys());
                this.updateIsParent(bean);
                if (original != null) {
                    this.updateIsParent(original);
                    Field fld = bean.fetchDeclaredField(idkey);
                    id = fld.getLong(original);
                }
            } else {
                id = this.doUpdate(bean, keys, idkey, this.getUniqueKeys());
            }
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isAfterUpdate()) continue;
                plugin.onAction(bean, this.getBeanClass());
            }
            JSONObject respdata = new JSONObject();
            respdata.put(idkey, (Object)id);
            this.onAfterUpdate(session, bean);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    @Override
    public AbstractEntityBean onDeleteValid(FStorageOperations storage, AbstractEntityBean bean, String id, String ... keys) throws Exception {
        AbstractEntityBean original = super.onDeleteValid(storage, bean, id, keys);
        if (storage != null) {
            Map<String, Object> dependencys = this.getDependency(bean.getClass());
            if (dependencys == null || !dependencys.keySet().contains(PARENT_ID_KEY)) {
                return original;
            }
            if (original != null) {
                Field idfld = bean.fetchDeclaredField(id);
                if (bean.fetchDeclaredField("is_parent").getBoolean(original)) {
                    throw new ServiceException("10007", "{0} {1} [{2}] is parent,can not delete", MessageSourceHelper.getMessage(bean.fetchAnnotationTableName(), bean.getLang(), new Object[0]), id, idfld.get(bean));
                }
            }
        }
        return original;
    }

    public ServiceResponse delete(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.onBeforeDelete(session, param);
            AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(param, this.getBeanClass(), null, false);
            bean.initUpdateMember(session);
            String idkey = this.getIdKey();
            long id = 0L;
            List<AnnotationActionService> tagPlugins = this.getPlugins();
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isBeforeDelete()) continue;
                plugin.onAction(bean, this.getBeanClass());
            }
            if (this.haveParentDependency()) {
                AbstractEntityBean original = this.execDelete(bean, idkey, new String[0]);
                if (original != null) {
                    this.updateIsParent(original);
                    Field fld = bean.fetchDeclaredField(idkey);
                    id = fld.getLong(original);
                }
            } else {
                id = this.doDelete(bean, idkey, new String[0]);
            }
            JSONObject respdata = new JSONObject();
            respdata.put(idkey, (Object)id);
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isAfterDelete()) continue;
                plugin.onAction(bean, this.getBeanClass());
            }
            this.onAfterDelete(session, bean);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    protected void updateIsParent(AbstractEntityBean bean) throws Exception {
        String idkey = this.getIdKey();
        if (!this.haveParentDependency()) {
            return;
        }
        Object parent_id = bean.fetchDeclaredField(PARENT_ID_KEY).get(bean);
        if ((parent_id instanceof Long || parent_id instanceof Integer) && Long.parseLong(parent_id.toString()) <= 0L) {
            return;
        }
        if (parent_id instanceof String && StringUtils.isEmpty((Object)parent_id)) {
            return;
        }
        JSONObject json = new JSONObject();
        json.put("ent_id", (Object)bean.getEnt_id());
        json.put(PARENT_ID_KEY, parent_id);
        AbstractEntityBean childbean = (AbstractEntityBean)this.doSearchOne(json, this.getBeanClass());
        json.clear();
        json.put("ent_id", (Object)bean.getEnt_id());
        json.put(idkey, parent_id);
        AbstractEntityBean parentBean = (AbstractEntityBean)this.doSearchOne(json, this.getBeanClass());
        if (parentBean != null) {
            json.put("is_parent", (Object)(childbean != null ? 1 : 0));
            json.put("timestamp", (Object)parentBean.getTimestamp());
            json.put("modifier", (Object)parentBean.getModifier());
            json.put("modifier_id", (Object)parentBean.getModifier_id());
        }
        this.doUpdate((AbstractEntityBean)JSON.toJavaObject((JSON)json, this.getBeanClass()), json.keySet(), idkey, new String[0]);
    }

    public ServiceResponse save(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.onBeforeSave(session, param);
            JSONArray jsonarray = null;
            Object obj = JSON.parse((String)param);
            if (obj instanceof JSONArray) {
                jsonarray = (JSONArray)obj;
            } else if (obj instanceof JSONObject && (jsonarray = ((JSONObject)obj).getJSONArray(this.getBeanTable())) == null) {
                jsonarray = new JSONArray();
                jsonarray.add(obj);
            }
            if (jsonarray == null) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            JSONArray returnarray = this.doSave(session, jsonarray);
            this.onAfterSave(session, param);
            return ServiceResponse.buildSuccess(returnarray);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    protected void onSetNewID(T bean) throws Exception {
        this.getIdField().set(bean, UniqueID.getUniqueID());
    }

    protected JSONArray doSave(ServiceSession session, JSONArray jsonarray) throws Exception {
        JSONArray returnarray = new JSONArray();
        String flag = "flag";
        String idkey = this.getIdKey();
        for (int i = 0; i < jsonarray.size(); ++i) {
            JSONObject json = jsonarray.getJSONObject(i);
            if (!json.containsKey((Object)flag)) {
                returnarray.add(null);
                continue;
            }
            AbstractEntityBean bean = (AbstractEntityBean)StorageUtils.parseBeanObject(json, this.getBeanClass(), null, false);
            if ("I".equalsIgnoreCase(json.getString(flag))) {
                this.onSetNewID(bean);
                bean.initInsertMember(session);
                returnarray.add((Object)this.doAdd(bean, idkey, this.getUniqueKeys()));
                continue;
            }
            if ("U".equalsIgnoreCase(json.getString(flag))) {
                bean.initUpdateMember(session);
                returnarray.add((Object)this.doUpdate(bean, json.keySet(), idkey, this.getUniqueKeys()));
                continue;
            }
            if (!"D".equalsIgnoreCase(json.getString(flag))) continue;
            bean.initUpdateMember(session);
            returnarray.add((Object)this.doDelete(bean, idkey, new String[0]));
        }
        return returnarray;
    }

    public ServiceResponse get(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.onBeforeGet(session, jsonparam);
            String idkey = this.getIdKey();
            String table = this.getBeanTable();
            if (!jsonparam.containsKey((Object)idkey) || StringUtils.isEmpty((Object)jsonparam.get((Object)idkey))) {
                return ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", table, idkey);
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            List<AnnotationActionService> tagPlugins = this.getPlugins();
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isBeforeGet()) continue;
                plugin.setEnt_id(session.getEnt_id());
                plugin.onAction(jsonparam, this.getBeanClass());
            }
            Map<String, Object> obj = null;
            obj = !jsonparam.containsKey((Object)"fields") ? (Map<String, Object>)this.doSearchOne(jsonparam, this.getBeanClass()) : this.doSearchOneForMap(jsonparam, this.getBeanClass());
            if (obj == null) {
                return ServiceResponse.buildFailure(session, "10003", "{0} {1} [{2}] does not exist", table, idkey, jsonparam.getLong(idkey));
            }
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isAfterGet()) continue;
                plugin.setEnt_id(session.getEnt_id());
                plugin.onAction(obj, this.getBeanClass());
            }
            JSONObject respdata = new JSONObject();
            respdata.put(table, obj);
            this.onAfterGet(session, jsonparam);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public ServiceResponse getWithOutEnt(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.onBeforeGet(session, jsonparam);
            String idkey = this.getIdKey();
            String table = this.getBeanTable();
            if (!jsonparam.containsKey((Object)idkey) || StringUtils.isEmpty((Object)jsonparam.get((Object)idkey))) {
                return ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", table, idkey);
            }
            Map<String, Object> obj = null;
            obj = !jsonparam.containsKey((Object)"fields") ? (Map<String, Object>)this.doSearchOne(jsonparam, this.getBeanClass()) : this.doSearchOneForMap(jsonparam, this.getBeanClass());
            if (obj == null) {
                return ServiceResponse.buildFailure(session, "10003", "{0} {1} [{2}] does not exist", table, idkey, jsonparam.getLong(idkey));
            }
            JSONObject respdata = new JSONObject();
            respdata.put(table, obj);
            this.onAfterGet(session, jsonparam);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public ServiceResponse search(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.searchWithHint(session, jsonparam, null);
    }

    public ServiceResponse searchWithHint(ServiceSession session, JSONObject jsonparam, String idxName) throws Exception {
        return this.searchWithHint(session, jsonparam, idxName, true);
    }

    public ServiceResponse searchWithHint(ServiceSession session, JSONObject jsonparam, String idxName, boolean withCount) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.onBeforeSearch(session, jsonparam);
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            List<AnnotationActionService> tagPlugins = this.getPlugins();
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isBeforeQuery()) continue;
                plugin.setEnt_id(session.getEnt_id());
                plugin.onAction(jsonparam, this.getBeanClass());
            }
            StringBuffer total = new StringBuffer();
            List<Object> list = null;
            list = !jsonparam.containsKey((Object)"fields") ? this.doSearch(jsonparam, this.getBeanClass(), idxName, withCount, total) : this.doSearchForMap(jsonparam, this.getBeanClass(), idxName, withCount, total);
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isAfterQuery()) continue;
                for (Object bean : list) {
                    plugin.setEnt_id(session.getEnt_id());
                    plugin.onAction(bean, this.getBeanClass());
                }
            }
            JSONObject respdata = new JSONObject();
            respdata.put("total_results", (Object)Long.parseLong(total.toString()));
            respdata.put(this.getBeanTable(), list);
            this.onAfterSearch(session, jsonparam);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public ServiceResponse searchWithOutEnt(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.onBeforeSearch(session, jsonparam);
            List<AnnotationActionService> tagPlugins = this.getPlugins();
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isBeforeQuery()) continue;
                plugin.onAction(jsonparam, this.getBeanClass());
            }
            StringBuffer total = new StringBuffer();
            List<Object> list = null;
            list = !jsonparam.containsKey((Object)"fields") ? this.doSearch(jsonparam, this.getBeanClass(), total) : this.doSearchForMap(jsonparam, this.getBeanClass(), total);
            JSONObject respdata = new JSONObject();
            respdata.put("total_results", (Object)Long.parseLong(total.toString()));
            respdata.put(this.getBeanTable(), list);
            for (AnnotationActionService plugin : tagPlugins) {
                if (!plugin.isBeforeQuery()) continue;
                for (Object bean : list) {
                    plugin.onAction(bean, this.getBeanClass());
                }
            }
            this.onAfterSearch(session, jsonparam);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public ServiceResponse getchildren(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.onBeforeGetChildren(session, jsonparam);
            String idkey = this.getIdKey();
            String table = this.getBeanTable();
            if (!jsonparam.containsKey((Object)idkey) || StringUtils.isEmpty((Object)jsonparam.get((Object)idkey))) {
                return ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", table, idkey);
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            jsonparam.put(PARENT_ID_KEY, jsonparam.get((Object)idkey));
            jsonparam.remove((Object)idkey);
            List<Object> list = null;
            list = !jsonparam.containsKey((Object)"fields") ? this.doSearch(jsonparam, this.getBeanClass(), null) : this.doSearchForMap(jsonparam, this.getBeanClass(), null);
            JSONObject respdata = new JSONObject();
            respdata.put(table, list);
            this.onAfterGetChildren(session, jsonparam);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public String export(ServiceSession session, JSONObject jsonparam) throws Exception {
        return this.export(session, jsonparam, null, null);
    }

    public String export(ServiceSession session, JSONObject jsonparam, JSONObject ddw, JSONObject ddwcol) throws Exception {
        try {
            if (session == null) {
                return JSON.toJSONString((Object)ServiceResponse.buildFailure(session, "50001"));
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return JSON.toJSONString((Object)ServiceResponse.buildFailure(session, "50003"));
            }
            if (!jsonparam.containsKey((Object)"fields") || StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
                return JSON.toJSONString((Object)ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", this.getBeanTable(), "fields"));
            }
            this.onBeforeExport(session, jsonparam);
            String[] fields = jsonparam.getString("fields").split(",");
            StringBuffer flds = new StringBuffer();
            ArrayList<String> fldlst = new ArrayList<String>();
            HashMap<String, String> disps = new HashMap<String, String>();
            HashMap<String, String> fmts = new HashMap<String, String>();
            for (String s : fields) {
                String[] ss = s.split(":");
                flds.append(ss[0].trim() + ",");
                fldlst.add(ss[0].trim());
                if (ss.length > 1) {
                    disps.put(ss[0].trim(), ss[1].trim());
                    if (ss.length <= 2) continue;
                    fmts.put(ss[0].trim(), ss[2].trim().replace(";", ","));
                    continue;
                }
                disps.put(ss[0].trim(), ss[0].trim());
            }
            jsonparam.put("fields", (Object)flds.toString());
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            StringBuffer total = null;
            if (jsonparam.containsKey((Object)"page_size") && jsonparam.getInteger("page_size") < 0 || jsonparam.containsKey((Object)"page_no") && jsonparam.getInteger("page_no") < 0) {
                jsonparam.remove((Object)"page_size");
                jsonparam.remove((Object)"page_no");
            } else {
                total = new StringBuffer();
            }
            List<Map<String, Object>> list = this.doSearchForMap(jsonparam, this.getBeanClass(), total);
            StringBuffer sb = this.export2XmlExcel(ddw, ddwcol, fldlst, disps, fmts, list);
            this.onAfterExport(session, jsonparam);
            return sb.toString();
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return JSON.toJSONString((Object)ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs()));
        }
    }

    public Object exportCsv(ServiceSession session, JSONObject jsonparam, JSONObject ddw, JSONObject ddwcol) throws Exception {
        try {
            if (session == null) {
                return JSON.toJSONString((Object)ServiceResponse.buildFailure(session, "50001"));
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return JSON.toJSONString((Object)ServiceResponse.buildFailure(session, "50003"));
            }
            if (!jsonparam.containsKey((Object)"fields") || StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
                return JSON.toJSONString((Object)ServiceResponse.buildFailure(session, "50004", "{0} {1} is empty", this.getBeanTable(), "fields"));
            }
            this.onBeforeExport(session, jsonparam);
            String[] fields = jsonparam.getString("fields").split(",");
            StringBuffer flds = new StringBuffer();
            ArrayList<String> fldlst = new ArrayList<String>();
            HashMap<String, String> disps = new HashMap<String, String>();
            HashMap<String, String> fmts = new HashMap<String, String>();
            for (String s : fields) {
                String[] ss = s.split(":");
                flds.append(ss[0].trim() + ",");
                fldlst.add(ss[0].trim());
                if (ss.length > 1) {
                    disps.put(ss[0].trim(), ss[1].trim());
                    if (ss.length <= 2) continue;
                    fmts.put(ss[0].trim(), ss[2].trim().replace(";", ","));
                    continue;
                }
                disps.put(ss[0].trim(), ss[0].trim());
            }
            jsonparam.put("fields", (Object)flds.toString());
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            StringBuffer total = null;
            if (jsonparam.containsKey((Object)"page_size") && jsonparam.getInteger("page_size") < 0 || jsonparam.containsKey((Object)"page_no") && jsonparam.getInteger("page_no") < 0) {
                jsonparam.remove((Object)"page_size");
                jsonparam.remove((Object)"page_no");
            } else {
                total = new StringBuffer();
            }
            List<Map<String, Object>> list = this.doSearchForMap(jsonparam, this.getBeanClass(), total);
            ByteArrayOutputStream sb = null;
            sb = this.export2CsvExcel(ddw, ddwcol, fldlst, disps, fmts, list, "GBK");
            this.onAfterExport(session, jsonparam);
            return sb;
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ex.getMessage();
        }
    }

    private StringBuffer export2XmlExcel(JSONObject ddw, JSONObject ddwcol, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, List<Map<String, Object>> list) {
        StringBuffer sb = new StringBuffer();
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\r\n");
        sb.append("<table cellspacing=\"0\" cellpadding=\"5\" rules=\"all\" border=\"1\">\r\n");
        sb.append("<tr style=\"font-weight: bold; color:red; white-space: nowrap;\">\r\n");
        for (String string : fldlst) {
            sb.append(String.format("<td>%1$s</td>\r\n", disps.get(string)));
        }
        sb.append("</tr>\r\n");
        System.out.println();
        for (Map map : list) {
            sb.append("<tr>\r\n");
            for (String s : fldlst) {
                Object obj = map.get(s);
                if (ddw != null && ddw.containsKey((Object)s) && ddwcol != null && ddwcol.containsKey((Object)s) && obj != null) {
                    JSONArray array = ddw.getJSONArray(s);
                    for (int i = 0; i < array.size(); ++i) {
                        try {
                            if (!array.getJSONObject(i).getString(ddwcol.getJSONArray(s).getString(0)).equals(obj.toString())) continue;
                            obj = array.getJSONObject(i).get((Object)ddwcol.getJSONArray(s).getString(1));
                            break;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (obj == null) {
                    sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:@\">%1$s</td>\r\n", ""));
                    continue;
                }
                String style = fmts.get(s);
                if (obj instanceof Date) {
                    if (StringUtils.isEmpty((Object)style)) {
                        style = "yyyy-mm-dd";
                    }
                    long date = ((Date)obj).getTime() / 86400000L + 25569L;
                    sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:" + style + "\">%1$s</td>\r\n", date));
                    continue;
                }
                if (StringUtils.isEmpty((Object)style)) {
                    style = obj instanceof Integer || obj instanceof Long || obj instanceof Short ? "0" : (obj instanceof Double || obj instanceof Float ? "#,##0.00" : "@");
                }
                sb.append(String.format("<td style=\"vnd.ms-excel.numberformat:" + style + "\">%1$s</td>\r\n", obj));
            }
            sb.append("</tr>\r\n");
        }
        sb.append("</table>\r\n");
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ByteArrayOutputStream export2CsvExcel(JSONObject ddw, JSONObject ddwcol, List<String> fldlst, Map<String, String> disps, Map<String, String> fmts, List<Map<String, Object>> list, String chartset) {
        ByteArrayOutputStream baos;
        block51: {
            Object v0;
            int c = 9;
            UUID uuid = UUID.randomUUID();
            String fileName = uuid + "_excel.csv";
            File file = new File(fileName);
            FileOutputStream fos = null;
            BufferedWriter bw = null;
            FileInputStream fis = null;
            baos = new ByteArrayOutputStream();
            fos = new FileOutputStream(file);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, chartset));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < fldlst.size(); ++i) {
                String s = fldlst.get(i);
                if (s.indexOf(34) > 0 || s.indexOf(44) > 0) {
                    sb.append("\"");
                    if (s.indexOf(34) > 0) {
                        String a = disps.get(s).replaceAll("\"", "\"\"\"\"");
                        sb.append(a);
                    } else {
                        sb.append(disps.get(s));
                    }
                    sb.append("\"");
                } else {
                    sb.append(disps.get(s));
                }
                if (i == fldlst.size() - 1) continue;
                sb.append(",");
            }
            bw.write(sb.toString());
            for (Map<String, Object> map : list) {
                sb = new StringBuilder();
                bw.newLine();
                for (String s : fldlst) {
                    Object obj = map.get(s);
                    if (ddw != null && ddw.containsKey((Object)s) && ddwcol != null && ddwcol.containsKey((Object)s) && obj != null) {
                        JSONArray array = ddw.getJSONArray(s);
                        for (int i = 0; i < array.size(); ++i) {
                            try {
                                if (!array.getJSONObject(i).getString(ddwcol.getJSONArray(s).getString(0)).equals(obj.toString())) continue;
                                obj = array.getJSONObject(i).get((Object)ddwcol.getJSONArray(s).getString(1));
                                break;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    if (obj == null) {
                        sb.append(",");
                        continue;
                    }
                    String style = fmts.get(s);
                    if (obj instanceof Date) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String date = sdf.format(obj);
                        sb.append(date);
                    } else if (obj instanceof String) {
                        String tempStr = obj.toString().trim();
                        if (tempStr.indexOf(34) > 0 || tempStr.indexOf(44) > 0) {
                            if (tempStr.startsWith("0")) {
                                sb.append('\t');
                            }
                            if (tempStr.indexOf(34) > 0) {
                                tempStr = tempStr.replaceAll("\"", "\"\"");
                                sb.append(tempStr);
                            } else {
                                sb.append(tempStr);
                            }
                            sb.append("\"");
                        } else {
                            if (tempStr.startsWith("0")) {
                                sb.append("\"");
                                sb.append('\t');
                            }
                            sb.append(tempStr);
                            if (tempStr.startsWith("0")) {
                                sb.append("\"");
                            }
                        }
                    } else {
                        sb.append(obj);
                    }
                    sb.append(",");
                }
                bw.write(sb.substring(0, sb.length() - 1));
            }
            bw.flush();
            fis = new FileInputStream(file);
            byte[] buffer = new byte[128];
            int iLength = 0;
            while ((iLength = fis.read(buffer)) != -1) {
                baos.write(buffer, 0, iLength);
            }
            Object var26_31 = null;
            try {
                try {
                    if (fis != null) {
                        fis.close();
                        fis = null;
                    }
                    if (bw != null) {
                        bw.flush();
                        bw.close();
                        bw = null;
                    }
                    if (fos != null) {
                        fos.flush();
                        fos.close();
                        fos = null;
                    }
                    v0 = null;
                }
                catch (IOException e2) {
                    this.getLogger().error((Object)String.format("\u5bfc\u51facsvexcel\u51fa\u9519,%s", e2.getMessage()));
                    e2.printStackTrace();
                    v0 = null;
                }
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var29_40 = v0;
            try {
                file.delete();
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            break block51;
            {
                catch (IOException e) {
                    Object v1;
                    e.printStackTrace();
                    Object var26_32 = null;
                    try {
                        try {
                            if (fis != null) {
                                fis.close();
                                fis = null;
                            }
                            if (bw != null) {
                                bw.flush();
                                bw.close();
                                bw = null;
                            }
                            if (fos != null) {
                                fos.flush();
                                fos.close();
                                fos = null;
                            }
                            v1 = null;
                        }
                        catch (IOException e2) {
                            this.getLogger().error((Object)String.format("\u5bfc\u51facsvexcel\u51fa\u9519,%s", e2.getMessage()));
                            e2.printStackTrace();
                            v1 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var29_41 = v1;
                    try {
                        file.delete();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object v2;
                Object var26_33 = null;
                try {
                    try {
                        if (fis != null) {
                            fis.close();
                            fis = null;
                        }
                        if (bw != null) {
                            bw.flush();
                            bw.close();
                            bw = null;
                        }
                        if (fos != null) {
                            fos.flush();
                            fos.close();
                            fos = null;
                        }
                        v2 = null;
                    }
                    catch (IOException e2) {
                        this.getLogger().error((Object)String.format("\u5bfc\u51facsvexcel\u51fa\u9519,%s", e2.getMessage()));
                        e2.printStackTrace();
                        v2 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v2 = null;
                }
                Object var29_42 = v2;
                try {
                    file.delete();
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                throw throwable;
            }
        }
        return baos;
    }

    public ServiceResponse formatData(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            JSONArray jsonarray = null;
            Object obj = JSON.parse((String)param);
            if (obj instanceof JSONArray) {
                jsonarray = (JSONArray)obj;
            } else if (obj instanceof JSONObject && (jsonarray = ((JSONObject)obj).getJSONArray(this.getBeanTable())) == null) {
                jsonarray = new JSONArray();
                jsonarray.add(obj);
            }
            if (jsonarray == null) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            JSONArray returnarray = this.doFormatData();
            return ServiceResponse.buildSuccess(returnarray);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    protected JSONArray doFormatData() throws Exception {
        return null;
    }

    protected List<Annotation> getCheckAnnotations(T bean) throws Exception {
        Field[] flds;
        ArrayList<Annotation> rtn = new ArrayList<Annotation>();
        for (Field field : flds = bean.getClass().getDeclaredFields()) {
            Annotation[] annotations;
            for (Annotation a : annotations = field.getAnnotations()) {
                if (!(a instanceof RefCheck)) continue;
                rtn.add(a);
            }
        }
        return rtn;
    }

    protected void executCheck(ServiceSession session, T bean, List<Annotation> annotations, String execTime) throws Exception {
        for (Annotation a : annotations) {
            String[] executionTime;
            if (!(a instanceof RefCheck)) continue;
            for (String s : executionTime = ((RefCheck)a).executionTime().split(",")) {
                if (!execTime.equalsIgnoreCase(s)) continue;
                this.executCheckAnnotations(session, bean, (RefCheck)a);
            }
        }
    }

    protected void executCheckAnnotations(ServiceSession session, T bean, RefCheck refcheck) throws Exception {
        AnnotationBeanService service;
        Map<String, Object> map;
        String beanId = refcheck.beanId();
        boolean ignore = refcheck.ignore();
        String queryStr = refcheck.query();
        String setStr = refcheck.set();
        String serviceName = refcheck.serviceName();
        JSONObject qry_json = this.parseString2Json(bean, queryStr);
        JSONObject set_json = null;
        if (!StringUtils.isEmpty((Object)setStr)) {
            set_json = JSONObject.parseObject((String)setStr);
        }
        if ((map = (service = SpringBeanFactory.getBean(beanId, AnnotationBeanService.class)).onBeanAction(session, serviceName, qry_json, ignore)) == null && ignore) {
            throw new Exception(String.format("\u8bbf\u95ee\u3010%1$s\u3011\u3010%2$s\u3011\u83b7\u5f97\u6570\u636e\u4e3a\u7a7a!\u8bf7\u6c42\u53c2\u6570\uff1a\u3010%3$s\u3011", service.getRemoteURL(), serviceName, qry_json.toJSONString()));
        }
        if (set_json != null && set_json.size() > 0) {
            Set set_key = set_json.keySet();
            for (String key : set_key) {
                BeanUtils.setProperty(bean, (String)key, (Object)map.get(set_json.get((Object)key)));
            }
        }
    }

    private JSONObject parseString2Json(T bean, String str) throws Exception {
        JSONObject params = null;
        try {
            params = JSON.parseObject((String)str);
            Set qryKey = params.keySet();
            String valueStr = null;
            for (String key : qryKey) {
                valueStr = params.getString(key);
                System.out.println(key);
                System.out.println(valueStr);
                if (!valueStr.startsWith("$")) continue;
                valueStr = valueStr.substring(1);
                params.put(key, (Object)BeanUtils.getProperty(bean, (String)valueStr));
            }
            return params;
        }
        catch (Exception e) {
            throw new Exception(String.format("\u89e3\u6790\u67e5\u8be2JSON\u3010%1$s\u3011\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u6b63\u5e38!", str));
        }
    }

    protected JSONObject validateRequestParam(ServiceSession session, String param, String ... keyNames) throws Exception {
        if (session == null) {
            throw new ServiceException("50001", MessageSourceHelper.getMessage("50001", "zh", new Object[0]), new Object[0]);
        }
        if (StringUtils.isEmpty((Object)param)) {
            throw new ServiceException("50001", MessageSourceHelper.getMessage("50003", session.getLocale(), new Object[0]), new Object[0]);
        }
        JSONObject paramJson = JSON.parseObject((String)param);
        for (String key : keyNames) {
            String[] tmp = key.split("\\.");
            if (tmp.length == 2) {
                JSONArray jsonArray = paramJson.getJSONArray(tmp[0]);
                if (jsonArray != null) {
                    for (JSONObject tmp_JSONObject : jsonArray) {
                        if (tmp_JSONObject.containsKey((Object)tmp[1]) && tmp_JSONObject.get((Object)tmp[1]) != null) continue;
                        throw new ServiceException("50000", key + "\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
                    }
                    continue;
                }
                if (paramJson.containsKey((Object)key) && paramJson.get((Object)key) != null && (!(paramJson.get((Object)key) instanceof String) || !StringUtils.isEmpty((Object)paramJson.getString(key).trim()))) continue;
                throw new ServiceException("50000", key + "\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
            }
            if (paramJson.containsKey((Object)key) && paramJson.get((Object)key) != null && (!(paramJson.get((Object)key) instanceof String) || !StringUtils.isEmpty((Object)paramJson.getString(key).trim()))) continue;
            throw new ServiceException("50000", key + "\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        return paramJson;
    }
}

