/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.omd.common.component.BasicComponentService;
import com.efuture.omd.common.entity.AbstractEntityBean;
import com.efuture.omd.common.entity.ServiceResponse;
import com.efuture.omd.common.entity.ServiceSession;
import com.efuture.omd.common.exception.ServiceException;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultReportServiceImpl<T extends AbstractEntityBean>
extends BasicComponentService<T> {
    public String getTableName() {
        return this.getBeanTable();
    }

    public List<T> getBeanList(Long entID, JSONObject jsonparam, StringBuffer total) throws Exception {
        jsonparam.put("ent_id", (Object)entID);
        this.onBeforeGet(jsonparam);
        List list = this.doSearch(jsonparam, this.getBeanClass(), total);
        this.onAfterGet(list);
        return list;
    }

    public List<Map<String, Object>> getMapList(Long entID, JSONObject jsonparam, StringBuffer total) throws Exception {
        jsonparam.put("ent_id", (Object)entID);
        this.onBeforeGet(jsonparam);
        List<Map<String, Object>> list = this.doSearchForMap(jsonparam, this.getBeanClass(), total);
        this.onAfterGet(list);
        return list;
    }

    @Override
    protected void onBeforeGet(JSONObject jsonparam) {
    }

    protected void onAfterGet(List<?> list) {
    }

    public ServiceResponse getResponse(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            StringBuffer total = new StringBuffer();
            List<Object> list = null;
            if (!jsonparam.containsKey((Object)"fields")) {
                this.onBeforeGet(jsonparam);
                list = this.doSearch(jsonparam, this.getBeanClass(), total);
                this.onAfterGet(list);
            } else {
                this.onBeforeGet(jsonparam);
                list = this.doSearchForMap(jsonparam, this.getBeanClass(), total);
                this.onAfterGet(list);
            }
            JSONObject respdata = new JSONObject();
            respdata.put("total_results", (Object)Long.parseLong(total.toString()));
            respdata.put(AbstractEntityBean.fetchAnnotationTableName(this.getBeanClass()), list);
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }
}

