/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.omd.common.component.BasicComponent;
import com.efuture.omd.common.entity.AbstractEntityBean;
import com.efuture.omd.common.entity.FileImportObject;
import com.efuture.omd.common.entity.ServiceResponse;
import com.efuture.omd.common.entity.ServiceSession;
import com.efuture.omd.common.exception.ServiceException;
import com.efuture.omd.common.language.MessageSourceHelper;
import com.efuture.omd.common.util.Utils;
import com.efuture.omd.storage.FStorageOperations;
import java.util.List;
import java.util.Locale;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleComponent
extends BasicComponent {
    public ServiceResponse serviceTemplate(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure(session, "50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure(session, "50003");
            }
            this.doServiceTemplate(jsonparam);
            JSONObject respdata = new JSONObject();
            return ServiceResponse.buildSuccess(respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure(session, ex.getErrorCode(), ex.getMessage(), ex.getErrorArgs());
        }
    }

    public Object doServiceTemplate(Object param) throws Exception {
        FStorageOperations storage = null;
        try {
            AbstractEntityBean.validateBean(param, new String[0]);
            storage = this.getStorageOperations();
            throw new ServiceException("10000", "error", new Object[0]);
        }
        catch (Throwable throwable) {
            block2: {
                Object var4_4 = null;
                if (storage == null) break block2;
                storage.destroy();
            }
            throw throwable;
        }
    }

    public Object exampleService(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName() + "(ServiceSession,JSONObject)\n");
            sb.append("\nsession:\n");
            sb.append(JSON.toJSONString((Object)session) + "\n");
            sb.append("\njsonparam:\n");
            sb.append(jsonparam.toJSONString() + "\n");
            if (jsonparam.containsKey((Object)"locale") && jsonparam.containsKey((Object)"code")) {
                sb.append("\nmsg:\n");
                sb.append(MessageSourceHelper.getDefault().getMessage(jsonparam.getString("code"), null, null, new Locale(jsonparam.getString("locale"))) + "\n");
            }
            return ServiceResponse.buildSuccess(sb.toString());
        }
        catch (Exception ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return Utils.getLastExceptionMessage(ex);
        }
    }

    public Object exampleService(ServiceSession session, String param) throws Exception {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName() + "(ServiceSession,String)\n");
            sb.append("\nsession:\n");
            sb.append(JSON.toJSONString((Object)session) + "\n");
            sb.append("\nparam:\n");
            sb.append(param + "\n");
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public Object exampleService(ServiceSession session, String param, List<FileImportObject> list) throws Exception {
        System.out.println("param: " + param);
        for (FileImportObject fio : list) {
            System.out.println("filename: " + fio.getFilename());
            byte[] b = new byte[100];
            fio.getStream().read(b, 0, 100);
            System.out.println("fileline: " + new String(b));
        }
        return list.size();
    }

    public Object exampleService(String param) throws Exception {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName() + "(String)\n");
            sb.append("\nparam:\n");
            sb.append(param + "\n");
            sb.append("\nmsg:\n");
            sb.append(MessageSourceHelper.getDefault().getMessage(param, null, null, null) + "\n");
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public Object exampleService() throws Exception {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName() + "(void)\n");
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}

