/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.omd.common.component.BaseServiceIntf;
import com.efuture.omd.common.component.BasicComponentService;
import com.efuture.omd.common.entity.AbstractEntityBean;
import com.efuture.omd.common.entity.ServiceSession;
import com.efuture.omd.common.exception.ServiceException;
import com.efuture.omd.common.util.StorageUtils;
import com.efuture.omd.storage.FStorageOperations;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterSlaveComponent<T extends AbstractEntityBean>
extends BasicComponentService<T>
implements BaseServiceIntf {
    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public long doAdd(AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        long masterid = super.doAdd(bean, id, uniques);
        Field fld = this.getMasterSlaveField(bean.getClass());
        if (fld == null) {
            return masterid;
        }
        String masterkey = (String)fld.get(null);
        if (StringUtils.isEmpty((Object)masterkey)) {
            return masterid;
        }
        Object masterval = AbstractEntityBean.fetchDeclaredField(bean.getClass(), masterkey).get(bean);
        Map<String, Class<?>> flds = this.getSlaveFields(bean.getClass());
        for (String key : flds.keySet()) {
            fld = bean.fetchDeclaredField(key);
            fld.setAccessible(true);
            Object obj = fld.get(bean);
            if (obj == null) continue;
            Class<?> clazz = flds.get(key);
            String slavekey = (String)this.getMasterSlaveField(clazz).get(null);
            List detlist = (List)obj;
            for (AbstractEntityBean slaveBean : detlist) {
                slaveBean.fetchDeclaredField(this.getIdKey(clazz)).set(slaveBean, 0);
                slaveBean.fetchDeclaredField(slavekey).set(slaveBean, masterval);
                slaveBean.initInsertMember(bean);
                super.doAdd(slaveBean, this.getIdKey(clazz), this.getUniqueKeys(clazz));
            }
        }
        return masterid;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray doSave(ServiceSession session, JSONArray jsonarray) throws Exception {
        JSONArray returnarray = super.doSave(session, jsonarray);
        Field fld = this.getMasterSlaveField(this.getBeanClass());
        if (fld == null) {
            return returnarray;
        }
        String masterkey = (String)fld.get(null);
        if (StringUtils.isEmpty((Object)masterkey)) {
            return returnarray;
        }
        String flag = "flag";
        Map flds = this.getSlaveFields(this.getBeanClass());
        for (int i = 0; i < jsonarray.size(); ++i) {
            JSONObject json = jsonarray.getJSONObject(i);
            if (!"U".equalsIgnoreCase(json.getString(flag))) continue;
            for (String key : flds.keySet()) {
                if (!json.containsKey((Object)key)) continue;
                JSONArray slaveArray = json.getJSONArray(key);
                for (int j = 0; slaveArray != null && j < slaveArray.size(); ++j) {
                    JSONObject slavejson = slaveArray.getJSONObject(j);
                    if (!slavejson.containsKey((Object)flag)) continue;
                    Class clazz = flds.get(key);
                    String slavekey = (String)this.getMasterSlaveField(clazz).get(null);
                    AbstractEntityBean slaveBean = (AbstractEntityBean)StorageUtils.parseBeanObject(slavejson, clazz);
                    slaveBean.fetchDeclaredField(slavekey).set(slaveBean, json.get((Object)masterkey));
                    if ("I".equalsIgnoreCase(slavejson.getString(flag))) {
                        AbstractEntityBean.fetchDeclaredField(clazz, this.getIdKey(clazz)).set(slaveBean, 0);
                        slaveBean.initInsertMember(session);
                        super.doAdd(slaveBean, this.getIdKey(clazz), this.getUniqueKeys(clazz));
                        continue;
                    }
                    if ("U".equalsIgnoreCase(slavejson.getString(flag))) {
                        slaveBean.initUpdateMember(session);
                        super.doUpdate(slaveBean, slavejson.keySet(), this.getIdKey(clazz), this.getUniqueKeys(clazz));
                        continue;
                    }
                    if (!"D".equalsIgnoreCase(slavejson.getString(flag))) continue;
                    slaveBean.initUpdateMember(session);
                    super.doDelete(slaveBean, this.getIdKey(clazz), new String[0]);
                }
            }
        }
        return returnarray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public long doDelete(AbstractEntityBean bean, String id, String ... keys) throws Exception {
        Field fld = this.getMasterSlaveField(bean.getClass());
        if (fld == null) {
            return super.doDelete(bean, id, keys);
        }
        String masterkey = (String)fld.get(null);
        if (StringUtils.isEmpty((Object)masterkey)) {
            return super.doDelete(bean, id, keys);
        }
        Object masterval = AbstractEntityBean.fetchDeclaredField(bean.getClass(), masterkey).get(bean);
        if (StringUtils.isEmpty((Object)masterval)) {
            throw new ServiceException("50004", "{0} {1} is empty", bean.fetchAnnotationTableName(), masterkey);
        }
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            Map<String, Class<?>> flds = this.getSlaveFields(bean.getClass());
            for (String key : flds.keySet()) {
                Class<?> clazz = flds.get(key);
                String slavekey = (String)this.getMasterSlaveField(clazz).get(null);
                Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(slavekey).is(masterval);
                Query query = new Query((CriteriaDefinition)criteria);
                storage.delete(query, clazz);
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return super.doDelete(bean, id, keys);
    }

    @Override
    protected List<?> doGet(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception {
        List<?> masterList;
        String masterkey = null;
        Field fld = this.getMasterSlaveField(objClass);
        if (fld != null) {
            masterkey = (String)fld.get(null);
        }
        if (jsonparam != null && !StringUtils.isEmpty(masterkey)) {
            ArrayList<String> removekeys = new ArrayList<String>();
            for (String qkey : jsonparam.keySet()) {
                if (qkey.indexOf(":") <= 0) continue;
                removekeys.add(qkey);
            }
            for (String qkey : removekeys) {
                String[] ss = qkey.split(":");
                String slvtable = ss[0];
                String slvfield = ss[1];
                StringBuffer sb = new StringBuffer();
                sb.append("(select " + masterkey + " from " + slvtable + " where ent_id = " + jsonparam.get((Object)"ent_id") + " and " + masterkey + " = " + AbstractEntityBean.fetchAnnotationTableName(objClass) + "." + masterkey);
                Object slvobj = jsonparam.get((Object)qkey);
                if (slvobj instanceof JSONObject) {
                    JSONObject jo = (JSONObject)slvobj;
                    for (String s : jo.keySet()) {
                        Object o;
                        String op = this.convertOperator(s);
                        sb.append(" and " + slvfield);
                        sb.append(" " + op + " ");
                        if (op.equalsIgnoreCase("in") || op.equalsIgnoreCase("not in")) {
                            sb.append("(");
                            o = jo.get((Object)s);
                            if (o instanceof JSONArray) {
                                JSONArray array = (JSONArray)o;
                                for (int i = 0; i < array.size(); ++i) {
                                    if (array.get(i) instanceof String && !((String)array.get(i)).startsWith("'")) {
                                        sb.append("'" + array.get(i) + "',");
                                        continue;
                                    }
                                    sb.append(array.get(i) + ",");
                                }
                            } else if (o instanceof String) {
                                String[] os;
                                for (String sk : os = ((String)o).split(",")) {
                                    if (!sk.startsWith("'")) {
                                        sb.append("'" + sk + "',");
                                        continue;
                                    }
                                    sb.append(sk + ",");
                                }
                            } else {
                                sb.append(o + ",");
                            }
                            sb.setCharAt(sb.length() - 1, ')');
                            continue;
                        }
                        o = jo.get((Object)s);
                        if (o instanceof String && !((String)o).startsWith("'")) {
                            sb.append("'" + o + "'");
                            continue;
                        }
                        sb.append(o);
                    }
                } else if (slvobj instanceof JSONArray) {
                    JSONArray array = (JSONArray)slvobj;
                    sb.append(" and " + slvfield + " in (");
                    for (int i = 0; i < array.size(); ++i) {
                        Object o = array.get(i);
                        if (o instanceof String && !((String)o).startsWith("'")) {
                            sb.append("'" + o + "',");
                            continue;
                        }
                        sb.append(o + ",");
                    }
                    sb.setCharAt(sb.length() - 1, ')');
                } else {
                    sb.append(" and " + slvfield);
                    if (slvobj instanceof String && !((String)slvobj).startsWith("'")) {
                        sb.append(" = '" + slvobj + "'");
                    } else {
                        sb.append(" = " + slvobj);
                    }
                }
                sb.append(")");
                jsonparam.remove((Object)qkey);
                String instr = sb.toString();
                if (!jsonparam.containsKey((Object)masterkey)) {
                    JSONObject json = new JSONObject();
                    json.put("$in", (Object)instr);
                    jsonparam.put(masterkey, (Object)json);
                    continue;
                }
                Object obj = jsonparam.get((Object)masterkey);
                if (obj instanceof JSONObject) {
                    JSONArray array = new JSONArray();
                    JSONObject json = new JSONObject();
                    json.put("$in", (Object)instr);
                    JSONObject jsn = new JSONObject();
                    jsn.put(masterkey, (Object)json);
                    array.add((Object)jsn);
                    jsn = new JSONObject();
                    jsn.put(masterkey, obj);
                    array.add((Object)jsn);
                    JSONArray ary = jsonparam.getJSONArray("$and");
                    if (ary == null) {
                        jsonparam.put("$and", (Object)array);
                    } else {
                        ary.addAll((Collection)array);
                    }
                    jsonparam.remove((Object)masterkey);
                    continue;
                }
                JSONObject json = new JSONObject();
                json.put("$in", (Object)instr);
                json.put("=", obj);
                jsonparam.put(masterkey, (Object)json);
            }
        }
        if ((masterList = super.doGet(jsonparam, objClass, total)) == null || masterList.size() <= 0) {
            return masterList;
        }
        if (StringUtils.isEmpty((Object)masterkey)) {
            return masterList;
        }
        Field masterFld = AbstractEntityBean.fetchDeclaredField(objClass, masterkey);
        Map<String, Class<?>> flds = this.getSlaveFields(objClass);
        for (String key : flds.keySet()) {
            int page_no = -1;
            int page_size = -1;
            String slaveField = null;
            if (!StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
                if (jsonparam.getString("fields").indexOf(key) < 0) continue;
                slaveField = StorageUtils.parseChildParamKeyFields(jsonparam.getString("fields"), key);
                if (!StringUtils.isEmpty((Object)slaveField)) {
                    StringBuffer sb = new StringBuffer();
                    String[] ss = slaveField.split(",");
                    for (int i = 0; i < ss.length; ++i) {
                        if (ss[i].toLowerCase().startsWith("page_no=")) {
                            page_no = Integer.parseInt(ss[i].split("=")[1]);
                            continue;
                        }
                        if (ss[i].toLowerCase().startsWith("page_size=")) {
                            page_size = Integer.parseInt(ss[i].split("=")[1]);
                            continue;
                        }
                        sb.append(ss[i] + ",");
                    }
                    if (sb.length() > 0) {
                        sb.setLength(sb.length() - 1);
                    }
                    slaveField = sb.toString();
                    if (page_size > 0 && page_no <= 0) {
                        page_no = 1;
                    }
                }
            } else if (total != null) continue;
            Class<?> clazz = flds.get(key);
            String slavekey = (String)this.getMasterSlaveField(clazz).get(null);
            Field slavefld = AbstractEntityBean.fetchDeclaredField(objClass, key);
            slavefld.setAccessible(true);
            for (Object obj : masterList) {
                StringBuffer sbtotal = null;
                JSONObject json = new JSONObject();
                if (page_no > 0 && page_size > 0) {
                    json.put("page_no", (Object)page_no);
                    json.put("page_size", (Object)page_size);
                    sbtotal = new StringBuffer();
                }
                json.put("order_field", (Object)this.getIdKey(clazz));
                if (!StringUtils.isEmpty((Object)slaveField)) {
                    json.put("fields", (Object)slaveField);
                }
                if (obj instanceof AbstractEntityBean) {
                    List<Map<String, Object>> lst;
                    AbstractEntityBean bean = (AbstractEntityBean)obj;
                    Object masterval = masterFld.get(bean);
                    json.put("ent_id", (Object)bean.getEnt_id());
                    json.put(slavekey, masterval);
                    if (!StringUtils.isEmpty((Object)slaveField)) {
                        lst = super.doSearchForMap(json, clazz, sbtotal);
                        if (lst == null) continue;
                        slavefld.set(bean, StorageUtils.toJavaObject(lst, clazz));
                        continue;
                    }
                    lst = super.doSearch(json, clazz, sbtotal);
                    slavefld.set(bean, lst);
                    continue;
                }
                if (!(obj instanceof Map)) continue;
                Map map = (Map)obj;
                json.put("ent_id", map.containsKey("ent_id") ? map.get("ent_id") : jsonparam.get((Object)"ent_id"));
                json.put(slavekey, map.get(masterkey));
                List<Map<String, Object>> lst = super.doSearchForMap(json, clazz, sbtotal);
                map.put(key, lst);
                if (sbtotal == null) continue;
                map.put(key + ":total_results", Long.parseLong(sbtotal.toString()));
            }
        }
        return masterList;
    }

    protected String convertOperator(String s) {
        if ("$in".equalsIgnoreCase(s) || "in".equalsIgnoreCase(s)) {
            return "in";
        }
        if ("$nin".equalsIgnoreCase(s) || "notin".equalsIgnoreCase(s)) {
            return "not in";
        }
        if ("$is".equalsIgnoreCase(s) || "==".equalsIgnoreCase(s) || "=".equalsIgnoreCase(s)) {
            return "=";
        }
        if ("$ne".equalsIgnoreCase(s) || "<>".equalsIgnoreCase(s) || "!=".equalsIgnoreCase(s)) {
            return "<>";
        }
        if ("like".equalsIgnoreCase(s)) {
            return "like";
        }
        if ("$gt".equalsIgnoreCase(s) || ">".equalsIgnoreCase(s)) {
            return ">";
        }
        if ("$gte".equalsIgnoreCase(s) || ">=".equalsIgnoreCase(s)) {
            return ">=";
        }
        if ("$lt".equalsIgnoreCase(s) || "<".equalsIgnoreCase(s)) {
            return "<";
        }
        if ("$lte".equalsIgnoreCase(s) || "<=".equalsIgnoreCase(s)) {
            return "<=";
        }
        return s;
    }

    protected Field getMasterSlaveField(Class<?> cl) {
        return AbstractEntityBean.fetchDeclaredField(cl, "MASTER_SLAVE_KEY");
    }

    protected Map<String, Class<?>> getSlaveFields(Class<?> masterClazz) throws Exception {
        HashMap map = new HashMap();
        Field[] fields = masterClazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String slavekey;
            ParameterizedType parameterizedType;
            Field fld;
            Field field = fields[i];
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType) || (fld = this.getMasterSlaveField((Class)(type = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()[0]))) == null || StringUtils.isEmpty((Object)(slavekey = (String)fld.get(null)))) continue;
            map.put(field.getName(), (Class)type);
        }
        return map;
    }

    @Override
    public <T> List<T> doSearch(JSONObject jsonparam, Class<T> objClass, StringBuffer total) throws Exception {
        jsonparam.remove((Object)"fields");
        return this.doGet(jsonparam, objClass, total);
    }
}

