/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.rest;

import com.alibaba.fastjson.JSON;
import com.efuture.omd.common.entity.FileImportObject;
import com.efuture.omd.common.entity.ServiceResponse;
import com.efuture.omd.common.entity.ServiceSession;
import com.efuture.omd.common.rest.ServiceMethodReflect;
import com.efuture.omd.common.util.Utils;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.springframework.util.StringUtils;

@Path(value="/")
public class ServiceRestReflect {
    @Context
    protected HttpServletRequest request;
    @Context
    protected HttpServletResponse response;
    private static ServiceMethodReflect rcm = new ServiceMethodReflect();

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/")
    public String test() {
        return this.request.getRequestURI() + " success";
    }

    @GET
    @Produces(value={"text/html;charset=UTF-8"})
    @Path(value="/getversion")
    public String getVersion() throws IOException {
        String filename = this.request.getSession().getServletContext().getRealPath("/WEB-INF");
        if (!StringUtils.isEmpty((Object)filename)) {
            filename = filename + "/classes/version.dat";
        } else {
            filename = Thread.currentThread().getContextClassLoader().getResource("").toString();
            if (StringUtils.isEmpty((Object)filename)) {
                return "\u83b7\u53d6\u7248\u672c\u6587\u4ef6\u8def\u5f84\u5931\u8d25!";
            }
            filename = filename.replace("file:", "");
            filename = filename.substring(1);
            filename = filename + "version.dat";
        }
        String versionData = String.format("\u672a\u627e\u5230\u7248\u672c\u6587\u4ef6:\u3010%1$s\u3011", filename);
        File file = new File(filename);
        if (file.exists() && file.isFile()) {
            FileReader reader = new FileReader(file);
            BufferedReader bufferReader = new BufferedReader(reader);
            versionData = bufferReader.readLine();
            bufferReader.close();
        }
        return String.format("\u5f53\u524d\u5e94\u7528\u7248\u672c:%1$s", versionData);
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale) {
        try {
            Object retdata;
            if (StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)ent_id)) {
                ServiceSession ss = new ServiceSession();
                if (!StringUtils.isEmpty((Object)ent_id)) {
                    ss.setEnt_id(Long.parseLong(ent_id));
                }
                if (!StringUtils.isEmpty((Object)user_id)) {
                    ss.setUser_id(Long.parseLong(user_id));
                }
                ss.setUser_name(user_name);
                ss.setLocale(locale);
                session = JSON.toJSONString((Object)ss);
            }
            if ((retdata = rcm.executeClassMethod(method, session, param)) == null) {
                return "";
            }
            if (retdata instanceof String) {
                return (String)retdata;
            }
            return JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", Utils.getLastExceptionMessage(ex), new Object[0]));
        }
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest")
    public String callRestServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale) {
        return this.callRestService(method, session, param, ent_id, user_id, user_name, locale);
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/rest/js")
    public String callRestServiceByPost(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale) {
        return this.callRestService(method, session, param, ent_id, user_id, user_name, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/import")
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"multipart/form-data"})
    public String callImportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, FormDataMultiPart form, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale) {
        String string;
        Object retdata;
        ArrayList<FileImportObject> list;
        block23: {
            block22: {
                list = new ArrayList<FileImportObject>();
                Map mapFormData = form.getFields();
                Set sets = mapFormData.keySet();
                if (StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)ent_id)) {
                    ServiceSession ss = new ServiceSession();
                    if (!StringUtils.isEmpty((Object)ent_id)) {
                        ss.setEnt_id(Long.parseLong(ent_id));
                    }
                    if (!StringUtils.isEmpty((Object)user_id)) {
                        ss.setUser_id(Long.parseLong(user_id));
                    }
                    ss.setUser_name(user_name);
                    ss.setLocale(locale);
                    session = JSON.toJSONString((Object)ss);
                }
                for (String key : sets) {
                    List parts = (List)mapFormData.get(key);
                    for (int i = 0; i < parts.size(); ++i) {
                        FormDataBodyPart part = (FormDataBodyPart)parts.get(i);
                        String filename = part.getContentDisposition().getFileName();
                        System.out.println(key + ":" + filename);
                        if (StringUtils.isEmpty((Object)filename)) continue;
                        FileImportObject fio = new FileImportObject();
                        fio.setFilename(filename);
                        fio.setStream((InputStream)part.getValueAs(InputStream.class));
                        fio.setServletrequest(this.request);
                        list.add(fio);
                    }
                }
                retdata = rcm.executeClassMethodForListParam(method, session, param, list);
                if (retdata != null) break block22;
                string = "";
                Object var20_20 = null;
                for (FileImportObject fio : list) {
                    try {
                        InputStream in = fio.getStream();
                        if (in == null) continue;
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                return string;
            }
            if (!(retdata instanceof String)) break block23;
            string = (String)retdata;
            Object var20_21 = null;
            for (FileImportObject fio : list) {
                try {
                    InputStream in = fio.getStream();
                    if (in == null) continue;
                    in.close();
                }
                catch (Exception exception) {}
            }
            return string;
        }
        try {
            string = JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            Object var20_22 = null;
        }
        catch (Exception ex) {
            String string2;
            try {
                ex.printStackTrace();
                string2 = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", Utils.getLastExceptionMessage(ex), new Object[0]));
                Object var20_23 = null;
            }
            catch (Throwable throwable) {
                Object var20_24 = null;
                for (FileImportObject fio : list) {
                    try {
                        InputStream in = fio.getStream();
                        if (in == null) continue;
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            for (FileImportObject fio : list) {
                try {
                    InputStream in = fio.getStream();
                    if (in == null) continue;
                    in.close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }
        for (FileImportObject fio : list) {
            try {
                InputStream in = fio.getStream();
                if (in == null) continue;
                in.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public String callExportServiceByGET(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        return this.callExportService(method, session, param, ent_id, user_id, user_name, locale, filename, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @GET
    @Path(value="/export/csv")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/octet-stream"})
    public Response callExportServiceByGET2(@QueryParam(value="method") String method, @QueryParam(value="session") String session, @QueryParam(value="param") String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        Object retdata;
        Response.ResponseBuilder builder;
        ByteArrayOutputStream os;
        block28: {
            block26: {
                os = null;
                builder = null;
                if (StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)ent_id)) {
                    ServiceSession ss = new ServiceSession();
                    if (!StringUtils.isEmpty((Object)ent_id)) {
                        ss.setEnt_id(Long.parseLong(ent_id));
                    }
                    if (!StringUtils.isEmpty((Object)user_id)) {
                        ss.setUser_id(Long.parseLong(user_id));
                    }
                    ss.setUser_name(user_name);
                    ss.setLocale(locale);
                    session = JSON.toJSONString((Object)ss);
                }
                if ((retdata = rcm.executeClassMethod(method, session, param)) != null) break block26;
                Response response = null;
                Object var16_19 = null;
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return response;
            }
            if (!(retdata instanceof ByteArrayOutputStream)) break block28;
            os = (ByteArrayOutputStream)retdata;
            ByteArrayInputStream in = new ByteArrayInputStream(os.toByteArray());
            builder = Response.ok((Object)in);
            if (filename == null) {
                filename = "export.csv";
            } else if (filename.toLowerCase().endsWith(".csv")) {
                filename = filename + ".csv";
            }
            builder.header("Content-Disposition", (Object)("attachment; filename=" + filename));
            builder.type("application/octet-stream");
            Response response = builder.build();
            Object var16_20 = null;
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return response;
        }
        Response response = Response.ok((Object)retdata.toString()).build();
        Object var16_21 = null;
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return response;
        catch (Exception e) {
            block31: {
                Response response2;
                try {
                    e.printStackTrace();
                    if (builder == null) break block31;
                    Response.ok();
                    response2 = builder.build();
                    Object var16_22 = null;
                }
                catch (Throwable throwable) {
                    Object var16_24 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return response2;
            }
            Response response3 = null;
            Object var16_23 = null;
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return response3;
        }
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="/export")
    public String callExportService(@QueryParam(value="method") String method, @QueryParam(value="session") String session, String param, @QueryParam(value="ent_id") String ent_id, @QueryParam(value="user_id") String user_id, @QueryParam(value="user_name") String user_name, @QueryParam(value="locale") String locale, @QueryParam(value="filename") String filename, @Context HttpHeaders headers) {
        try {
            String data = this.callRestService(method, session, param, ent_id, user_id, user_name, locale);
            if (!StringUtils.isEmpty((Object)data)) {
                this.response.setHeader("Pragma", "No-cache");
                this.response.setHeader("Cache-Control", "No-cache");
                this.response.setDateHeader("Expires", 0L);
                this.response.setCharacterEncoding("UTF-8");
                this.response.setContentType("application/ms-excel");
                if (StringUtils.isEmpty((Object)filename)) {
                    filename = "export.xls";
                }
                this.response.setHeader("Content-Disposition", Utils.builderContentDispositionFileName(headers, filename));
            }
            return data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", Utils.getLastExceptionMessage(ex), new Object[0]));
        }
    }
}

