/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.omd.common.entity.AbstractEntityBean;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.annotation.Transient;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseStorageUtils {
    private boolean useStringRegex = true;
    private boolean useAndExpress = true;

    public BaseStorageUtils() {
        this(true);
    }

    public BaseStorageUtils(boolean useStringRegex) {
        this(useStringRegex, true);
    }

    public BaseStorageUtils(boolean useStringRegex, boolean useAndExpress) {
        this.setUseStringRegex(useStringRegex);
        this.setUseAndExpress(useAndExpress);
    }

    public boolean isUseStringRegex() {
        return this.useStringRegex;
    }

    public void setUseStringRegex(boolean useStringRegex) {
        this.useStringRegex = useStringRegex;
    }

    public boolean isUseAndExpress() {
        return this.useAndExpress;
    }

    public void setUseAndExpress(boolean useAndExpress) {
        this.useAndExpress = useAndExpress;
    }

    public Update baseCreateUpdateFormJSON(JSONObject json) throws IllegalArgumentException, IllegalAccessException {
        Update upt = new Update();
        Set keys = json.keySet();
        for (String key : keys) {
            upt.set(key, json.get((Object)key));
        }
        return upt;
    }

    public Update baseCreateUpdateFormBean(Object bean, Set<String> keys) throws IllegalArgumentException, IllegalAccessException {
        Update upt = new Update();
        for (String key : keys) {
            Field fld = AbstractEntityBean.fetchDeclaredField(bean.getClass(), key);
            if (fld == null || fld.getAnnotation(Transient.class) != null) continue;
            upt.set(key, fld.get(bean));
        }
        return upt;
    }

    public Query baseCreateQueryFormJson(JSONObject json, Class<?> cl) {
        return this.baseCreateQueryFormJson(json, cl, true, true);
    }

    public Query baseCreateQueryFormJson(JSONObject json, Class<?> cl, boolean mustpage) {
        return this.baseCreateQueryFormJson(json, cl, mustpage, true);
    }

    public Query baseCreateQueryFormJson(JSONObject json, Class<?> cl, boolean mustpage, boolean mustlimit) {
        if (cl != null) {
            this.convertBeanJSON(json, cl, false);
        }
        ArrayList<Criteria> criteria = new ArrayList<Criteria>();
        Set keys = json.keySet();
        for (String key : keys) {
            if (this.isSpecialParamKey(key)) continue;
            Object o = json.get((Object)key);
            if ("$or".equalsIgnoreCase(key)) {
                ArrayList<Criteria> clst = new ArrayList<Criteria>();
                if (o instanceof JSONObject) {
                    JSONObject jo = (JSONObject)o;
                    Set ks = jo.keySet();
                    for (String k : ks) {
                        Criteria c = this.baseBuildCriteria(k, jo.get((Object)k), cl);
                        if (c == null) continue;
                        clst.add(c);
                    }
                } else if (o instanceof JSONArray) {
                    JSONArray ja = (JSONArray)o;
                    for (int i = 0; i < ja.size(); ++i) {
                        Object oo = ja.get(i);
                        if (!(oo instanceof JSONObject)) continue;
                        JSONObject jo = (JSONObject)oo;
                        Set ks = jo.keySet();
                        for (String k : ks) {
                            Criteria c = this.baseBuildCriteria(k, jo.get((Object)k), cl);
                            if (c == null) continue;
                            clst.add(c);
                        }
                    }
                }
                if (clst.size() <= 0) continue;
                Criteria[] c = new Criteria[clst.size()];
                criteria.add(new Criteria().orOperator(clst.toArray(c)));
                continue;
            }
            Criteria c = this.baseBuildCriteria(key, o, cl);
            if (c == null) continue;
            criteria.add(c);
        }
        Query quy = new Query();
        if (criteria.size() > 0) {
            Criteria c = (Criteria)criteria.get(0);
            if (criteria.size() > 1) {
                if (this.isUseAndExpress()) {
                    Criteria[] cc = new Criteria[criteria.size() - 1];
                    for (int i = 1; i < criteria.size(); ++i) {
                        cc[i - 1] = (Criteria)criteria.get(i);
                    }
                    c.andOperator(cc);
                } else {
                    for (int i = 1; i < criteria.size(); ++i) {
                        quy.addCriteria((CriteriaDefinition)criteria.get(i));
                    }
                }
            }
            quy.addCriteria((CriteriaDefinition)c);
        }
        return this.baseBuildQueryFormJson(quy, json, mustpage, mustlimit);
    }

    public Criteria baseBuildCriteria(String key, Object o, Class<?> cl) {
        List<Criteria> response = this.baseBuildCriteriaList(key, o, cl);
        if (response == null) {
            return null;
        }
        if (response.size() > 1) {
            Criteria[] c = new Criteria[response.size()];
            return new Criteria().andOperator(response.toArray(c));
        }
        return response.get(0);
    }

    public List<Criteria> baseBuildCriteriaList(String key, Object o, Class<?> cl) {
        ArrayList<Criteria> response = new ArrayList<Criteria>();
        if (StringUtils.isEmpty((Object)o)) {
            Criteria c = Criteria.where((String)key).in(new Object[]{null, ""});
            response.add(c);
            return response;
        }
        if (o instanceof String && !StringUtils.isEmpty((Object)o)) {
            if (this.isExactMatchKey(key)) {
                String[] ss = ((String)o).split(",");
                if (ss.length > 1) {
                    Criteria c = Criteria.where((String)key).in((Object[])ss);
                    response.add(c);
                } else {
                    Criteria c = Criteria.where((String)key).is((Object)ss[0]);
                    response.add(c);
                }
                return response;
            }
            if (this.isUseStringRegex()) {
                Criteria c = Criteria.where((String)key).regex(String.valueOf(o));
                response.add(c);
                return response;
            }
            Criteria c = Criteria.where((String)key).is((Object)String.valueOf(o));
            response.add(c);
            return response;
        }
        if (o instanceof JSONArray) {
            JSONArray ja = (JSONArray)o;
            Object[] oos = new Object[ja.size()];
            for (int i = 0; i < ja.size(); ++i) {
                Object oo = ja.get(i);
                if (cl != null) {
                    oo = this.convertBeanField(oo, cl, key);
                }
                oos[i] = oo;
            }
            Criteria c = Criteria.where((String)key).in(oos);
            response.add(c);
            return response;
        }
        if (o instanceof JSONObject || o instanceof Map) {
            if (o instanceof Map) {
                o = JSONObject.toJSON((Object)o);
            }
            ArrayList<Criteria> criteria = new ArrayList<Criteria>();
            Set sets = ((JSONObject)o).keySet();
            for (String s : sets) {
                Object oo = ((JSONObject)o).get((Object)s);
                if ("$in".equalsIgnoreCase(s) || "in".equalsIgnoreCase(s) || "$nin".equalsIgnoreCase(s) || "notin".equalsIgnoreCase(s)) {
                    Object[] oos = null;
                    if (oo instanceof JSONArray) {
                        JSONArray ja = (JSONArray)oo;
                        oos = new Object[ja.size()];
                        for (int i = 0; i < ja.size(); ++i) {
                            Object obj = ja.get(i);
                            if (cl != null) {
                                obj = this.convertBeanField(obj, cl, key);
                            }
                            oos[i] = obj;
                        }
                    } else {
                        oos = oo.toString().split(",");
                    }
                    if ("$in".equalsIgnoreCase(s) || "in".equalsIgnoreCase(s)) {
                        criteria.add(Criteria.where((String)key).in(oos));
                        continue;
                    }
                    criteria.add(Criteria.where((String)key).nin(oos));
                    continue;
                }
                if (cl != null) {
                    oo = this.convertBeanField(oo, cl, key);
                }
                if ("$is".equalsIgnoreCase(s) || "==".equalsIgnoreCase(s) || "=".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).is(oo));
                    continue;
                }
                if ("$ne".equalsIgnoreCase(s) || "<>".equalsIgnoreCase(s) || "!=".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).ne(oo));
                    continue;
                }
                if ("like".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).regex(String.valueOf(oo)));
                    continue;
                }
                if ("$gt".equalsIgnoreCase(s) || ">".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).gt(oo));
                    continue;
                }
                if ("$gte".equalsIgnoreCase(s) || ">=".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).gte(oo));
                    continue;
                }
                if ("$lt".equalsIgnoreCase(s) || "<".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).lt(oo));
                    continue;
                }
                if (!"$lte".equalsIgnoreCase(s) && !"<=".equalsIgnoreCase(s)) continue;
                criteria.add(Criteria.where((String)key).lte(oo));
            }
            if (criteria.size() > 0) {
                return criteria;
            }
        } else {
            Criteria c = Criteria.where((String)key).is(o);
            response.add(c);
            return response;
        }
        return null;
    }

    public Query baseBuildQueryFormJson(Query quy, JSONObject json, boolean mustpage) {
        return this.baseBuildQueryFormJson(quy, json, mustpage, true);
    }

    public Query baseBuildQueryFormJson(Query quy, JSONObject json, boolean mustpage, boolean mustlimit) {
        if (json.containsKey((Object)"fields") && !StringUtils.isEmpty((Object)json.get((Object)"fields"))) {
            org.springframework.data.mongodb.core.query.Field flds = quy.fields();
            String[] ss = json.getString("fields").split(",");
            for (int i = 0; i < ss.length; ++i) {
                if (StringUtils.isEmpty((Object)ss[i].trim())) continue;
                flds.include(ss[i].trim());
            }
        }
        int pageno = -1;
        int pagesize = 40;
        Sort order = null;
        if (mustpage) {
            pageno = 1;
        }
        if (json.containsKey((Object)"page_no") && !StringUtils.isEmpty((Object)json.get((Object)"page_no")) && (pageno = json.getInteger("page_no").intValue()) <= 0) {
            pageno = 1;
        }
        if (json.containsKey((Object)"page_size") && !StringUtils.isEmpty((Object)json.get((Object)"page_size")) && (pagesize = json.getInteger("page_size").intValue()) <= 0) {
            pagesize = 40;
        }
        if (json.containsKey((Object)"order_field") && !StringUtils.isEmpty((Object)json.get((Object)"order_field"))) {
            if (json.containsKey((Object)"order_direction") && !StringUtils.isEmpty((Object)json.get((Object)"order_direction"))) {
                String[] dirs = json.getString("order_direction").split(",");
                String[] flds = json.getString("order_field").split(",");
                ArrayList<Sort.Order> lst = new ArrayList<Sort.Order>();
                for (int i = 0; i < flds.length; ++i) {
                    if (i < dirs.length) {
                        lst.add(new Sort.Order(Sort.Direction.fromString((String)dirs[i]), flds[i].trim()));
                        continue;
                    }
                    lst.add(new Sort.Order(flds[i].trim()));
                }
                order = new Sort(lst);
            } else {
                order = new Sort(json.getString("order_field").split(","));
            }
        }
        if (pageno >= 1) {
            quy.with((Pageable)new PageRequest(pageno - 1, pagesize, order));
        } else if (order != null) {
            quy.with(order);
        }
        return quy;
    }

    private boolean isExactMatchKey(String key) {
        if (key.endsWith("code")) {
            return true;
        }
        if (key.endsWith("status")) {
            return true;
        }
        return key.endsWith("order_status.center");
    }

    private boolean isSpecialParamKey(String key) {
        if (key.equalsIgnoreCase("fields")) {
            return true;
        }
        if (key.equalsIgnoreCase("page_no")) {
            return true;
        }
        if (key.equalsIgnoreCase("page_size")) {
            return true;
        }
        if (key.equalsIgnoreCase("order_field")) {
            return true;
        }
        if (key.equalsIgnoreCase("order_direction")) {
            return true;
        }
        return key.indexOf(":") > 0;
    }

    public String baseParseChildParamKeyFields(String param, String key) {
        int startp = param.indexOf(key + ":");
        if (startp < 0) {
            return null;
        }
        String s = null;
        int endp = param.indexOf(",", startp += (key + ":").length());
        s = endp > 0 ? param.substring(startp, endp) : param.substring(startp);
        return s.replace("|", ",");
    }

    public Map<String, Object> baseParseChildParamKey(JSONObject json, String key) {
        HashMap<String, Object> map = null;
        Set sets = json.keySet();
        for (String param : sets) {
            int startp;
            if (!param.startsWith(key + ":")) continue;
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            if ((startp = param.indexOf(key + ":")) < 0) {
                return null;
            }
            String s = null;
            int endp = param.indexOf(",", startp += (key + ":").length());
            s = endp > 0 ? param.substring(startp, endp) : param.substring(startp);
            map.put(s, json.get((Object)param));
        }
        return map;
    }

    public JSONArray baseConvertBeanJSON(JSONArray jsonarray, Class<?> cl, boolean needConvertKey) {
        for (int i = 0; i < jsonarray.size(); ++i) {
            Object value = jsonarray.get(i);
            if (!(value instanceof JSONObject)) continue;
            jsonarray.set(i, (Object)this.convertBeanJSON((JSONObject)value, cl, needConvertKey));
        }
        return jsonarray;
    }

    public <T> T baseParseBeanObject(String text, Class<T> clazz, StringBuffer newParam, boolean needConvertKey) {
        JSONObject json = JSON.parseObject((String)text);
        return this.baseParseBeanObject(json, clazz, newParam, needConvertKey);
    }

    public <T> T baseParseBeanObject(JSONObject json, Class<T> clazz, StringBuffer newParam, boolean needConvertKey) {
        json = this.convertBeanJSON(json, clazz, needConvertKey);
        if (newParam != null) {
            newParam.append(json.toJSONString());
        }
        return (T)JSON.toJavaObject((JSON)json, clazz);
    }

    private JSONObject convertBeanJSON(JSONObject jsonparam, Class<?> cl, boolean needConvertKey) {
        try {
            Set keys = jsonparam.keySet();
            ArrayList<String> needRemove = new ArrayList<String>();
            ArrayList needAddObjList = new ArrayList();
            for (String string : keys) {
                Object oo;
                if (this.isSpecialParamKey(string)) continue;
                if (string.contains(".")) {
                    int pointIndex = string.indexOf(".");
                    String parentKey = string.substring(0, pointIndex);
                    String childKey = string.substring(pointIndex + 1);
                    if (string.substring(pointIndex + 1).contains(".")) continue;
                    HashMap<String, JSONObject> parentKeyMap = new HashMap<String, JSONObject>();
                    Field parentKeyField = cl.getDeclaredField(parentKey);
                    parentKeyField.setAccessible(true);
                    Class<?> childClass = parentKeyField.getType();
                    Object formatedValue = this.convertBeanField(jsonparam.get((Object)string), childClass, childKey);
                    JSONObject tempJSONObject = new JSONObject();
                    tempJSONObject.put(childKey, formatedValue);
                    if (needConvertKey) {
                        parentKeyMap.put(parentKey, tempJSONObject);
                        needAddObjList.add(parentKeyMap);
                        needRemove.add(string);
                        continue;
                    }
                    jsonparam.put(string, formatedValue);
                    continue;
                }
                Object o = jsonparam.get((Object)string);
                if (o == null || o.equals(oo = this.convertBeanField(o, cl, string)) || o instanceof Map) continue;
                jsonparam.put(string, oo);
            }
            for (Map map : needAddObjList) {
                for (Map.Entry entry : map.entrySet()) {
                    String parentKey = (String)entry.getKey();
                    JSONObject childObject = (JSONObject)entry.getValue();
                    if (jsonparam.get((Object)parentKey) != null) {
                        Set childKeys = childObject.keySet();
                        for (String childKey : childKeys) {
                            Object o = childObject.get((Object)childKey);
                            ((JSONObject)jsonparam.get((Object)parentKey)).put(childKey, o);
                        }
                        continue;
                    }
                    jsonparam.put(parentKey, (Object)childObject);
                }
            }
            for (String string : needRemove) {
                jsonparam.remove((Object)string);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jsonparam;
    }

    private Object convertBeanField(Object obj, Class<?> cl, String key) {
        String type2;
        Field fld = AbstractEntityBean.fetchDeclaredField(cl, key);
        if (fld == null) {
            return obj;
        }
        if (!this.isSimpleType(obj)) {
            return obj;
        }
        Object o = obj;
        String type1 = o.getClass().getName().toLowerCase();
        if (type1.lastIndexOf(".") > 0) {
            type1 = type1.substring(type1.lastIndexOf(".") + 1);
        }
        if ((type2 = fld.getType().getName().toLowerCase()).lastIndexOf(".") > 0) {
            type2 = type2.substring(type2.lastIndexOf(".") + 1);
        }
        if (!type1.startsWith(type2)) {
            try {
                if (type2.contains("long")) {
                    o = StringUtils.isEmpty((Object)o) ? 0L : Long.parseLong(o.toString());
                } else if (type2.contains("int")) {
                    o = StringUtils.isEmpty((Object)o) ? 0 : Integer.parseInt(o.toString());
                } else if (type2.contains("float")) {
                    o = Float.valueOf(StringUtils.isEmpty((Object)o) ? 0.0f : Float.parseFloat(o.toString()));
                } else if (type2.contains("double")) {
                    o = StringUtils.isEmpty((Object)o) ? 0.0 : Double.parseDouble(o.toString());
                } else if (type2.contains("short")) {
                    o = StringUtils.isEmpty((Object)o) ? (short)0 : Short.parseShort(o.toString());
                }
                if (type2.contains("boolean")) {
                    if (!(o instanceof Boolean)) {
                        o = StringUtils.isEmpty((Object)o) ? Boolean.valueOf(false) : Boolean.valueOf("true".equalsIgnoreCase(o.toString()) || "Y".equalsIgnoreCase(o.toString()));
                    }
                } else if (type2.contains("date")) {
                    if (StringUtils.isEmpty((Object)o)) {
                        o = 0;
                    } else {
                        String s = o.toString();
                        if (s.indexOf("-") > 0 || s.indexOf("/") > 0) {
                            if (s.endsWith("Z")) {
                                s = s.replace("T", " ").replace("Z", "");
                            }
                            s = s.replace("/", "-");
                            SimpleDateFormat format = null;
                            format = s.length() <= 10 ? new SimpleDateFormat("yyyy-MM-dd") : (s.length() <= 19 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                            o = format.parse(s);
                        } else {
                            o = new Date(Long.parseLong(s));
                        }
                    }
                } else if (type2.contains("string")) {
                    o = String.valueOf(o);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o;
    }

    private boolean isSimpleType(Object o) {
        if (o instanceof JSONObject) {
            return false;
        }
        return !(o instanceof JSONArray);
    }
}

