/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util;

import com.efuture.omd.common.component.BasicComponent;
import com.efuture.omd.common.util.MD5Utils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.NoSuchElementException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public abstract class BaseWebRequester
extends BasicComponent {
    protected Logger logger = null;
    protected String authenticationURL = "";

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.getClass().getName());
        }
        return this.logger;
    }

    public String queryServiceURI(String method, HttpServletRequest request, ServletContext sc) {
        String servicePath = "";
        String curservice = method;
        while (!curservice.equals("")) {
            int n;
            String url = sc.getInitParameter(curservice);
            if (url != null && !url.equals("")) {
                servicePath = url;
                break;
            }
            if (curservice.equals("*")) break;
            if (curservice.endsWith(".*")) {
                curservice = curservice.substring(0, curservice.lastIndexOf("."));
            }
            if ((n = curservice.lastIndexOf(".")) > 0) {
                curservice = curservice.substring(0, n) + ".*";
                continue;
            }
            curservice = "*";
        }
        if (servicePath == null || servicePath.equals("")) {
            return request.getRequestURL().toString();
        }
        return this.makeFullUrl(servicePath, request);
    }

    public String makeFullUrl(String url, HttpServletRequest request) {
        if (url.startsWith("//")) {
            url = request.getScheme() + ":" + url;
        } else if (url.startsWith("/")) {
            url = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + url;
        }
        return url;
    }

    public void initContext(HttpServletRequest request, ServletContext servletContext) {
        String remoteURL = servletContext.getInitParameter("authURL");
        this.authenticationURL = this.makeFullUrl(remoteURL, request);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)String.format("Component:[%1$s] initContext:{AuthenticationURL:%2$s}", this.getClass().getCanonicalName(), this.authenticationURL));
        }
    }

    public abstract Client getClient() throws NoSuchElementException, IllegalStateException, Exception;

    public abstract void releaseClient(Client var1);

    public void checkValid(String serviceURL, String method, String token, String appKey, String version, String signMethod, String sign, String params) throws Exception {
        if (!StringUtils.isEmpty((Object)sign) && !StringUtils.isEmpty((Object)params)) {
            String encryptKey = MD5Utils.MD5(params);
            System.out.println(encryptKey);
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            if (!StringUtils.isEmpty((Object)serviceURL)) {
                builder.append(String.format(" RemoteURL:%1$s\r\n", serviceURL));
            }
            if (!StringUtils.isEmpty((Object)method)) {
                builder.append(String.format("    Method:%1$s\r\n", method));
            }
            if (!StringUtils.isEmpty((Object)token)) {
                builder.append(String.format("     Token:%1$s\r\n", token));
            }
            if (!StringUtils.isEmpty((Object)appKey)) {
                builder.append(String.format("    AppKey:%1$s\r\n", appKey));
            }
            if (!StringUtils.isEmpty((Object)version)) {
                builder.append(String.format("   Version:%1$s\r\n", version));
            }
            if (!StringUtils.isEmpty((Object)signMethod)) {
                builder.append(String.format("SignMethod:%1$s\r\n", signMethod));
            }
            if (!StringUtils.isEmpty((Object)sign)) {
                builder.append(String.format("      Sign:%1$s\r\n", sign));
            }
            if (!StringUtils.isEmpty((Object)params)) {
                builder.append(String.format("    Params:%1$s\r\n", params));
            }
            this.getLogger().debug((Object)String.format("Component:[%1$s] checkValid:{\r\n%2$s}", this.getClass().getCanonicalName(), builder.toString()));
        }
    }

    public String get(String serviceURL, String method, String tokenID, String appKey, String version, String signMethod, String params) throws Exception {
        return this.submit("GET", serviceURL, method, tokenID, appKey, version, signMethod, params);
    }

    public String post(String serviceURL, String method, String tokenID, String appKey, String version, String signMethod, String params) throws Exception {
        return this.submit("POST", serviceURL, method, tokenID, appKey, version, signMethod, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String submit(String httpMethod, String serviceURL, String method, String token, String appKey, String version, String signMethod, String params) throws Exception {
        String responseData = "";
        Client client = this.getClient();
        try {
            if (StringUtils.isEmpty((Object)token)) {
                token = "none";
            }
            MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
            if (!StringUtils.isEmpty((Object)method)) {
                queryParams.add((Object)"method", (Object)method);
            }
            if (!StringUtils.isEmpty((Object)token)) {
                queryParams.add((Object)"token", (Object)token);
            }
            queryParams.add((Object)"timestamp", (Object)String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", System.currentTimeMillis()));
            queryParams.add((Object)"format", (Object)"json");
            queryParams.add((Object)"app_key", (Object)appKey);
            queryParams.add((Object)"ver", (Object)version);
            queryParams.add((Object)"sign_method", (Object)signMethod);
            if (!StringUtils.isEmpty((Object)params)) {
                queryParams.add((Object)"sign", (Object)MD5Utils.MD5(params));
            }
            WebResource webResource = client.resource(serviceURL);
            if ("POST".equalsIgnoreCase(httpMethod)) {
                webResource = webResource.queryParams((MultivaluedMap)queryParams);
                responseData = (String)webResource.post(String.class, (Object)params);
            } else if ("GET".equalsIgnoreCase(httpMethod)) {
                queryParams.add((Object)"param", (Object)params);
                webResource = webResource.queryParams((MultivaluedMap)queryParams);
                responseData = (String)webResource.get(String.class);
            } else {
                throw new Exception("\u8bf7\u6c42\u7c7b\u578b\u9519\u8bef:" + (httpMethod == null ? "\u8bf7\u6c42\u7c7b\u578b\u4e3a\u7a7a" : httpMethod));
            }
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("  Request:%1$s\r\n", httpMethod));
            builder.append(String.format("RemoteURI:%1$s\r\n", webResource.getURI()));
            builder.append(String.format(" PostData:%1$s\r\n", params));
            builder.append(String.format(" Response:%1$s\r\n", responseData));
            System.out.println(builder.toString());
            Object var15_14 = null;
            this.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            this.releaseClient(client);
            throw throwable;
        }
        return responseData;
    }
}

