/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class IniReader {
    protected Map<String, Properties> sections = new HashMap<String, Properties>();
    private transient String currentSecion;
    private transient Properties current;

    public IniReader(String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        this.read(reader);
        reader.close();
    }

    protected void read(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            this.parseLine(line);
        }
    }

    protected void parseLine(String line) {
        if ((line = line.trim()).matches("\\[.*\\]")) {
            this.currentSecion = line.replaceFirst("\\[(.*)\\]", "$1");
            this.current = new Properties();
            this.sections.put(this.currentSecion, this.current);
        } else if (line.matches(".*=.*") && this.current != null) {
            int i = line.indexOf(61);
            String name = line.substring(0, i);
            String value = line.substring(i + 1);
            this.current.setProperty(name, value);
        }
    }

    public String getValue(String section, String name) {
        Properties p = this.sections.get(section);
        if (p == null) {
            return null;
        }
        String value = p.getProperty(name);
        return value;
    }
}

