/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.omd.common.exception.BeanValidateException;
import com.efuture.omd.common.util.SimplePropertyFilter;
import com.efuture.omd.common.util.ValidatorUtils;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtils {
    private static QueryUtils instance = null;
    protected Logger logger = null;

    private static synchronized void init() {
        if (instance == null) {
            instance = new QueryUtils();
        }
    }

    public static QueryUtils getInstance() {
        if (instance == null) {
            QueryUtils.init();
        }
        return instance;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.getClass().getName());
        }
        return this.logger;
    }

    private static String formatValidateMessage(ConstraintViolation<?> cv) {
        StringBuffer msg = new StringBuffer();
        String type = cv.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName();
        System.out.println("Validate: " + type);
        msg.append(cv.getPropertyPath().toString());
        msg.append(" is [" + cv.getInvalidValue() + "],");
        msg.append(cv.getMessage());
        return msg.toString();
    }

    public void validateBeanForSpecified(Object object, String ... specflds) throws BeanValidateException {
        Set<ConstraintViolation<Object>> msgs = ValidatorUtils.validate(object, new Class[0]);
        if (msgs != null && msgs.size() > 0) {
            for (ConstraintViolation<Object> cv : msgs) {
                String key = cv.getPropertyPath().toString();
                boolean exist = false;
                for (int i = 0; specflds != null && i < specflds.length; ++i) {
                    if (!key.equalsIgnoreCase(specflds[i])) continue;
                    exist = true;
                    break;
                }
                if (!exist) continue;
                throw new BeanValidateException(key, QueryUtils.formatValidateMessage(cv));
            }
        }
    }

    public String getQuery(Object object, String filterFields) {
        return this.getQuery(object, null, filterFields);
    }

    public String getQuery(Object object, String listFields, String filterFields) {
        return this.getQuery(object, listFields, null, 1, 1, filterFields);
    }

    public String getQuery(Object object, String listFields, String orderFields, int pageNo, int pageSize, String filterFields) {
        String jsonParam = "";
        if (StringUtils.isEmpty((Object)filterFields)) {
            jsonParam = JSON.toJSONString((Object)object);
        } else {
            String[] filters = filterFields.split(",");
            SimplePropertyFilter filter = new SimplePropertyFilter(filters);
            jsonParam = JSON.toJSONString((Object)object, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
        }
        JSONObject query = JSON.parseObject((String)jsonParam);
        if (!StringUtils.isEmpty((Object)listFields)) {
            query.put("fields", (Object)listFields);
        }
        if (!StringUtils.isEmpty((Object)orderFields)) {
            String fields = "";
            String direct = "";
            String[] orders = filterFields.split(";");
            for (int i = 0; i < orders.length; ++i) {
                String[] orderSet = orders[i].split(",");
                if (orderSet.length > 1) {
                    fields = fields + "," + orderSet[0];
                    direct = direct + "," + orderSet[1];
                    continue;
                }
                fields = fields + "," + orderSet[0];
                direct = direct + ",asc";
            }
            if (!StringUtils.isEmpty((Object)fields)) {
                query.put("order_field", (Object)fields.substring(1));
            }
            if (!StringUtils.isEmpty((Object)direct)) {
                query.put("order_direction", (Object)direct.substring(1));
            }
        }
        query.put("page_no", (Object)pageNo);
        query.put("page_size", (Object)pageSize);
        String response = query.toJSONString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)String.format("Component:[%1$s] getQuery:%2$s", this.getClass().getCanonicalName(), response));
        }
        return response;
    }

    public String getInsert(Object object, String ... fields) {
        String response = "";
        if (fields == null || fields.length < 1) {
            response = JSON.toJSONString((Object)object);
        } else {
            SimplePropertyFilter filter = new SimplePropertyFilter(fields);
            response = JSON.toJSONString((Object)object, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)String.format("Component:[%1$s] getInsert:%2$s", this.getClass().getCanonicalName(), response));
        }
        return response;
    }

    public String getUpdate(Object object, String fields) {
        String response = "";
        if (StringUtils.isEmpty((Object)fields)) {
            response = JSON.toJSONString((Object)object);
        } else {
            String[] filters = fields.split(",");
            SimplePropertyFilter filter = new SimplePropertyFilter(filters);
            response = JSON.toJSONString((Object)object, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)String.format("Component:[%1$s] getUpdate:%2$s", this.getClass().getCanonicalName(), response));
        }
        return response;
    }

    public String getDelete(Object object, String filterFields) {
        String response = "";
        if (StringUtils.isEmpty((Object)filterFields)) {
            response = JSON.toJSONString((Object)object);
        } else {
            String[] filters = filterFields.split(",");
            SimplePropertyFilter filter = new SimplePropertyFilter(filters);
            response = JSON.toJSONString((Object)object, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)String.format("Component:[%1$s] getDelete:%2$s", this.getClass().getCanonicalName(), response));
        }
        return response;
    }
}

