/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanFactory {
    static ApplicationContext context = null;
    static String[] ContextXml = null;
    static boolean isWebMode = true;

    SpringBeanFactory() {
    }

    public static Object getBean(String name) {
        return SpringBeanFactory.getContext().getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)SpringBeanFactory.getContext().getBean(name, clazz);
    }

    private static synchronized void getInstance() {
        if (context == null) {
            context = SpringBeanFactory.getWebApplicationContext();
        }
        if (context == null) {
            context = SpringBeanFactory.getApplicationContext();
        }
    }

    public static ApplicationContext getContext() {
        if (context != null) {
            return context;
        }
        SpringBeanFactory.getInstance();
        return context;
    }

    private static void afterInitNotify(ApplicationContext cont) {
        System.out.println("start spring afterInitNotify.");
        try {
            ApplicationEvent event = (ApplicationEvent)cont.getBean("afterInitNotify");
            cont.publishEvent(event);
        }
        catch (Exception e) {
            System.out.println("bean [afterInitNotify] not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationContext getTemporaryContext(String contextFile) {
        ClassPathXmlApplicationContext cont = null;
        try {
            cont = new ClassPathXmlApplicationContext(contextFile);
            Object var3_2 = null;
            if (cont == null) return cont;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (cont == null) throw throwable;
            SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
            throw throwable;
        }
        SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
        return cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ApplicationContext getWebApplicationContext() {
        WebApplicationContext cont = null;
        try {
            cont = ContextLoader.getCurrentWebApplicationContext();
            Object var2_1 = null;
            if (cont == null) return cont;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (cont == null) throw throwable;
            SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
            throw throwable;
        }
        SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
        return cont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationContext getApplicationContext() {
        ClassPathXmlApplicationContext cont = null;
        try {
            cont = ContextXml == null ? new ClassPathXmlApplicationContext(new String[]{"classpath*:**/applicationContext-*.xml", "classpath*:**/componentContext-*.xml"}) : new ClassPathXmlApplicationContext(ContextXml);
            Object var2_1 = null;
            if (cont == null) return cont;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (cont == null) throw throwable;
            SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
            throw throwable;
        }
        SpringBeanFactory.afterInitNotify((ApplicationContext)cont);
        return cont;
    }

    public static void setApplicationContextXml(String[] contextFile) {
        ContextXml = contextFile;
    }

    public static void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
        isWebMode = false;
    }

    public static boolean isWebApplication() {
        return isWebMode;
    }
}

