/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.omd.common.entity.AbstractEntityBean;
import com.efuture.omd.common.util.BaseStorageUtils;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageUtils
extends BaseStorageUtils {
    private static StorageUtils instanceRegex;
    private static StorageUtils instanceNoReg;

    public StorageUtils(boolean useStringRegex) {
        super(useStringRegex);
    }

    public static StorageUtils getInstance() {
        if (instanceRegex == null) {
            StorageUtils.initInstance(true);
        }
        return instanceRegex;
    }

    private static synchronized void initInstance(boolean useStringRegex) {
        if (useStringRegex) {
            if (instanceRegex == null) {
                instanceRegex = new StorageUtils(true);
            }
        } else if (instanceNoReg == null) {
            instanceNoReg = new StorageUtils(false);
        }
    }

    public static StorageUtils getInstance(boolean useStringRegex) {
        if (useStringRegex) {
            if (instanceRegex == null) {
                StorageUtils.initInstance(useStringRegex);
            }
            return instanceRegex;
        }
        if (instanceNoReg == null) {
            StorageUtils.initInstance(useStringRegex);
        }
        return instanceNoReg;
    }

    public static Update createUpdateFormJSON(JSONObject json) throws IllegalArgumentException, IllegalAccessException {
        return StorageUtils.getInstance().baseCreateUpdateFormJSON(json);
    }

    public static Update createUpdateFormBean(Object bean, Set<String> keys) throws IllegalArgumentException, IllegalAccessException {
        return StorageUtils.getInstance().baseCreateUpdateFormBean(bean, keys);
    }

    public static Query createQueryFormJson(JSONObject json, Class<?> cl, boolean useStringRegex) {
        return StorageUtils.getInstance(useStringRegex).baseCreateQueryFormJson(json, cl);
    }

    public static Query createQueryFormJson(JSONObject json, Class<?> cl, boolean mustpage, boolean useStringRegex) {
        return StorageUtils.getInstance(useStringRegex).baseCreateQueryFormJson(json, cl, mustpage);
    }

    public static Criteria buildCriteria(String key, Object o, Class<?> cl) {
        return StorageUtils.getInstance().baseBuildCriteria(key, o, cl);
    }

    public static Query buildQueryFormJson(Query quy, JSONObject json, boolean mustpage) {
        return StorageUtils.getInstance().baseBuildQueryFormJson(quy, json, mustpage);
    }

    public static String parseChildParamKeyFields(String param, String key) {
        return StorageUtils.getInstance().baseParseChildParamKeyFields(param, key);
    }

    public static Map<String, Object> parseChildParamKey(JSONObject json, String key) {
        return StorageUtils.getInstance().baseParseChildParamKey(json, key);
    }

    public static JSONArray convertBeanJSON(JSONArray jsonarray, Class<?> cl, boolean needConvertKey) {
        return StorageUtils.getInstance().baseConvertBeanJSON(jsonarray, cl, needConvertKey);
    }

    public static <T> T parseBeanObject(String text, Class<T> clazz, StringBuffer newParam, boolean needConvertKey) {
        return StorageUtils.getInstance().baseParseBeanObject(text, clazz, newParam, needConvertKey);
    }

    public static <T> T parseBeanObject(JSONObject json, Class<T> clazz, StringBuffer newParam, boolean needConvertKey) {
        return StorageUtils.getInstance().baseParseBeanObject(json, clazz, newParam, needConvertKey);
    }

    public static <T> T parseBeanObject(JSONObject json, Class<T> clazz) {
        json = StorageUtils.convertBeanJSON(json, clazz);
        return (T)JSON.toJavaObject((JSON)json, clazz);
    }

    private static JSONObject convertBeanJSON(JSONObject jsonparam, Class<?> cl) {
        try {
            Set keys = jsonparam.keySet();
            for (String key : keys) {
                Object oo;
                Object o;
                if (StorageUtils.isSpecialParamKey(key) || (o = jsonparam.get((Object)key)).equals(oo = StorageUtils.convertBeanField(o, cl, key))) continue;
                jsonparam.put(key, oo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonparam;
    }

    private static boolean isSpecialParamKey(String key) {
        if (key.equalsIgnoreCase("fields")) {
            return true;
        }
        if (key.equalsIgnoreCase("page_no")) {
            return true;
        }
        if (key.equalsIgnoreCase("page_size")) {
            return true;
        }
        if (key.equalsIgnoreCase("order_field")) {
            return true;
        }
        if (key.equalsIgnoreCase("order_direction")) {
            return true;
        }
        return key.indexOf(":") > 0;
    }

    private static Object convertBeanField(Object obj, Class<?> cl, String key) {
        String type2;
        Field fld = AbstractEntityBean.fetchDeclaredField(cl, key);
        if (fld == null) {
            return obj;
        }
        if (!StorageUtils.isSimpleType(obj)) {
            return obj;
        }
        Object o = obj;
        String type1 = o.getClass().getName().toLowerCase();
        if (type1.lastIndexOf(".") > 0) {
            type1 = type1.substring(type1.lastIndexOf(".") + 1);
        }
        if ((type2 = fld.getType().getName().toLowerCase()).lastIndexOf(".") > 0) {
            type2 = type2.substring(type2.lastIndexOf(".") + 1);
        }
        if (!type1.startsWith(type2)) {
            try {
                if (type2.contains("long")) {
                    o = StringUtils.isEmpty((Object)o) ? 0L : Long.parseLong(o.toString());
                } else if (type2.contains("int")) {
                    o = StringUtils.isEmpty((Object)o) ? 0 : Integer.parseInt(o.toString());
                } else if (type2.contains("float")) {
                    o = Float.valueOf(StringUtils.isEmpty((Object)o) ? 0.0f : Float.parseFloat(o.toString()));
                } else if (type2.contains("double")) {
                    o = StringUtils.isEmpty((Object)o) ? 0.0 : Double.parseDouble(o.toString());
                } else if (type2.contains("short")) {
                    o = StringUtils.isEmpty((Object)o) ? (short)0 : Short.parseShort(o.toString());
                } else if (type2.contains("boolean")) {
                    if (!(o instanceof Boolean)) {
                        o = StringUtils.isEmpty((Object)o) ? Boolean.valueOf(false) : Boolean.valueOf("true".equalsIgnoreCase(o.toString()) || "Y".equalsIgnoreCase(o.toString()));
                    }
                } else if (type2.contains("date")) {
                    if (StringUtils.isEmpty((Object)o)) {
                        o = null;
                    } else {
                        String s = o.toString();
                        if (s.indexOf("-") > 0 || s.indexOf("/") > 0) {
                            if (s.endsWith("Z")) {
                                s = s.replace("T", " ").replace("Z", "");
                            }
                            s = s.replace("/", "-");
                            SimpleDateFormat format = null;
                            format = s.length() <= 10 ? new SimpleDateFormat("yyyy-MM-dd") : (s.length() <= 19 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                            o = format.parse(s);
                        } else {
                            o = new Date(Long.parseLong(s));
                        }
                    }
                } else if (type2.contains("string")) {
                    o = String.valueOf(o);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o;
    }

    public static <T> T toJavaObject(Object obj, Class<T> entityClass) {
        return (T)TypeUtils.cast((Object)obj, entityClass, (ParserConfig)ParserConfig.getGlobalInstance());
    }

    private static boolean isSimpleType(Object o) {
        if (o instanceof JSONObject) {
            return false;
        }
        return !(o instanceof JSONArray);
    }
}

