/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util;

import com.efuture.omd.common.util.SpringBeanFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.Random;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueID {
    private static Integer number = new Integer(0);
    private String hostId = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getId() {
        Class<UniqueID> clazz = UniqueID.class;
        synchronized (UniqueID.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.createId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getIdArray(int number) {
        ArrayList<Long> retArray = new ArrayList<Long>();
        Class<UniqueID> clazz = UniqueID.class;
        synchronized (UniqueID.class) {
            for (int i = 0; i < number; ++i) {
                retArray.add(this.createId());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return retArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNoArray(int number, int len) {
        ArrayList<String> retArray = new ArrayList<String>();
        Class<UniqueID> clazz = UniqueID.class;
        synchronized (UniqueID.class) {
            StringBuffer sb = new StringBuffer();
            String fmt = "%0" + (len -= 13) + "d";
            for (int i = 0; i < len; ++i) {
                sb.append("9");
            }
            int sed = Integer.parseInt(sb.toString());
            int sedmod = sed + 1;
            SecureRandom rand = new SecureRandom();
            for (int i = 0; i < number; ++i) {
                long uid = 0L;
                Date dt = new Date();
                uid = dt.getTime();
                String suff = new Formatter().format(fmt, rand.nextInt(sed) % sedmod).toString();
                retArray.add(String.valueOf(uid) + suff);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return retArray;
        }
    }

    private long createId() {
        long uid = 0L;
        Date dt = new Date();
        uid = dt.getTime() / 1000L;
        uid <<= 20;
        uid += (long)number.intValue();
        number = (number + 1) % 1000000;
        int n = new Random().nextInt(999) % 1000;
        String suff = new Formatter().format("%03d", n).toString();
        return Long.parseLong(String.valueOf(uid) + suff);
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
        if (!StringUtils.isEmpty((Object)hostId) && hostId.length() < 3) {
            String ip = UniqueID.getHostIP();
            if (ip == null) {
                ip = ".000";
            }
            String suff = new Formatter().format("%03d", Integer.parseInt(ip.substring(ip.lastIndexOf(".") + 1))).toString();
            this.hostId = this.hostId + suff.substring(hostId.length());
        }
    }

    public static String getHostIP() {
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface nif = netInterfaces.nextElement();
                Enumeration<InetAddress> iparray = nif.getInetAddresses();
                while (iparray.hasMoreElements()) {
                    String localip;
                    InetAddress ip = iparray.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || "127.0.0.1".equals(localip = ip.getHostAddress())) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static UniqueID getInstance() {
        UniqueID uniqueID = SpringBeanFactory.getBean("UniqueID", UniqueID.class);
        return uniqueID;
    }

    public static long getUniqueID() {
        return UniqueID.getInstance().getId();
    }

    public static List<Long> getUniqueIDArray(int size) {
        return UniqueID.getInstance().getIdArray(size);
    }

    public static List<String> getUniqueNoArray(int size, int len) {
        return UniqueID.getInstance().getNoArray(size, len);
    }
}

