/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util.db;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.omd.common.util.JSONPaser;
import com.efuture.omd.common.util.SimplePropertyFilter;
import com.efuture.omd.common.util.db.DBUtils;
import com.efuture.omd.common.util.result.ResultLimit;
import com.efuture.omd.common.util.result.ResultSort;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBTableJoin<X, T> {
    private Class<X> beanCondition = null;
    private Class<T> beanResponse = null;
    private String firstTableName;
    private String[] firstConditionFields;
    private String secondTableName;
    private String[] secondConditionFields;

    public DBTableJoin(Class<X> classCondition, Class<T> classResponse, String firstTableName, String firstConditionFields, String secondTableName, String secondConditionFields) {
        this.beanCondition = classCondition;
        this.beanResponse = classResponse;
        this.firstTableName = firstTableName;
        this.firstConditionFields = firstConditionFields.split(",");
        this.secondTableName = secondTableName;
        this.secondConditionFields = secondConditionFields.split(",");
    }

    protected abstract void onSetNLCondition(Map<String, Object> var1, X var2);

    protected void onRowMerged(Map<String, Object> rowItem) {
    }

    protected void onRowJoinParams(String params) {
    }

    public List<T> getResult(Long entID, String params, StringBuffer buffer) {
        return this.getResult(entID, params, null, buffer);
    }

    public List<T> getResult(Long entID, String params, ResultSort<T> sort, StringBuffer buffer) {
        return this.getResult(entID, (X)params, sort, 0, 0, buffer);
    }

    public List<T> getResult(Long entID, String params, ResultSort<T> sort, int pageIndex, int pageSize, StringBuffer buffer) {
        if (StringUtils.isEmpty((Object)params)) {
            params = "{}";
        }
        Object inParams = JSON.parseObject((String)params, this.beanCondition);
        return this.getResult(entID, inParams, sort, pageIndex, pageSize, buffer);
    }

    public List<T> getResult(Long entID, X inParams, ResultSort<T> sort, int pageIndex, int pageSize, StringBuffer buffer) {
        ArrayList<Object> response = new ArrayList<Object>();
        SimplePropertyFilter filter = new SimplePropertyFilter(this.firstConditionFields);
        String jsonParams = JSON.toJSONString(inParams, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
        List<Map<String, Object>> data = DBUtils.getInstance().getResult(entID, this.firstTableName, null, JSONPaser.parseObject(jsonParams, this.beanCondition));
        for (Map<String, Object> row : data) {
            this.onSetNLCondition(row, inParams);
            filter = new SimplePropertyFilter(this.secondConditionFields);
            jsonParams = JSON.toJSONString(inParams, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
            this.onRowJoinParams(jsonParams);
            List<Map<String, Object>> dataItem = DBUtils.getInstance().getResult(1L, this.secondTableName, null, JSONPaser.parseObject(jsonParams, this.beanCondition));
            for (Map<String, Object> rowItem : dataItem) {
                rowItem.putAll(row);
                this.onRowMerged(rowItem);
                String itemData = JSON.toJSONString(rowItem);
                Object outBean = JSON.parseObject((String)itemData, this.beanResponse);
                response.add(outBean);
            }
        }
        if (sort != null) {
            sort.doSort(response);
        }
        return new ResultLimit<Object>().getDataLimit(response, pageIndex, pageSize, buffer);
    }
}

