/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util.db;

import com.alibaba.fastjson.JSONObject;
import com.efuture.omd.common.component.BasicComponentService;
import com.efuture.omd.common.entity.AbstractEntityBean;
import com.efuture.omd.common.util.BaseStorageUtils;
import com.efuture.omd.storage.FStorageOperations;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtils
extends BasicComponentService<AbstractEntityBean> {
    private static DBUtils instance = null;
    private BaseStorageUtils utils = null;

    private static synchronized void initInstance() {
        if (instance == null) {
            instance = new DBUtils();
        }
    }

    public static DBUtils getInstance() {
        if (instance == null) {
            DBUtils.initInstance();
        }
        return instance;
    }

    public DBUtils() {
        this.utils = new BaseStorageUtils(false);
    }

    public DBUtils(boolean useStringRegex) {
        this.utils = new BaseStorageUtils(useStringRegex);
    }

    public long getRowCount(long entID, String tableName) {
        return this.getRowCount(entID, tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRowCount(long entID, String tableName, JSONObject jsonParams) {
        long l;
        block7: {
            FStorageOperations storage = null;
            try {
                storage = this.getStorageOperations();
                Criteria criteria = Criteria.where((String)"ent_id").is((Object)entID);
                Query query = new Query((CriteriaDefinition)criteria);
                if (jsonParams != null) {
                    for (String keyCode : jsonParams.keySet()) {
                        Object keyData = jsonParams.get((Object)keyCode);
                        List<Criteria> criteriaChilds = this.utils.baseBuildCriteriaList(keyCode, keyData, null);
                        try {
                            for (Criteria current : criteriaChilds) {
                                query.addCriteria((CriteriaDefinition)current);
                            }
                        }
                        catch (InvalidMongoDbApiUsageException imdaue) {
                            System.out.println(String.format("\u6dfb\u52a0\u6761\u4ef6[%1$s]\u65f6\u53d1\u751f\u5f02\u5e38:%2$s", keyCode, imdaue.getMessage()));
                        }
                    }
                }
                l = storage.count(query, tableName);
                Object var15_15 = null;
                if (storage == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var15_16 = null;
                    if (storage == null) break block8;
                    storage.destroy();
                }
                throw throwable;
            }
            storage.destroy();
        }
        return l;
    }

    public List<?> getDistinct(long entID, String tableName, String fieldName) {
        return this.getDistinct(entID, tableName, fieldName, null);
    }

    public List<?> getDistinct(long entID, String tableName, String fieldName, JSONObject jsonParams) {
        block8: {
            List list;
            block9: {
                FStorageOperations storage = null;
                try {
                    storage = this.getStorageOperations();
                    Criteria criteria = Criteria.where((String)"ent_id").is((Object)entID);
                    Query query = new Query((CriteriaDefinition)criteria);
                    if (jsonParams != null) {
                        for (String keyCode : jsonParams.keySet()) {
                            Object keyData = jsonParams.get((Object)keyCode);
                            List<Criteria> criteriaChilds = this.utils.baseBuildCriteriaList(keyCode, keyData, null);
                            try {
                                for (Criteria current : criteriaChilds) {
                                    query.addCriteria((CriteriaDefinition)current);
                                }
                            }
                            catch (InvalidMongoDbApiUsageException imdaue) {
                                System.out.println(String.format("\u6dfb\u52a0\u6761\u4ef6[%1$s]\u65f6\u53d1\u751f\u5f02\u5e38:%2$s", keyCode, imdaue.getMessage()));
                            }
                        }
                    }
                    if (!(storage instanceof MongoTemplate)) break block8;
                    MongoTemplate template = (MongoTemplate)storage;
                    list = template.getCollection(tableName).distinct(fieldName, query.getQueryObject());
                    Object var16_15 = null;
                    if (storage == null) break block9;
                }
                catch (Throwable throwable) {
                    block10: {
                        Object var16_16 = null;
                        if (storage == null) break block10;
                        storage.destroy();
                    }
                    throw throwable;
                }
                storage.destroy();
            }
            return list;
        }
        throw new RuntimeException("storage \u672a\u5b9e\u73b0 MongoTemplate \u7684\u7ee7\u627f!");
    }

    public List<Map<String, Object>> getResult(long entID, String tableName, String fieldList) {
        return this.getResult(entID, tableName, fieldList, null);
    }

    public List<Map<String, Object>> getResult(long entID, String tableName, String fieldList, JSONObject jsonParams) {
        return this.getResult(entID, tableName, fieldList, null, null, null, jsonParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getResult(long entID, String tableName, String fieldList, String orderList, String fieldName, List<?> paraList, JSONObject jsonParams) {
        List list;
        block13: {
            FStorageOperations storage = null;
            try {
                storage = this.getStorageOperations();
                Criteria criteria = Criteria.where((String)"ent_id").is((Object)entID);
                Query query = new Query((CriteriaDefinition)criteria);
                if (!StringUtils.isEmpty((Object)fieldName) && paraList != null && paraList.size() > 0) {
                    Criteria criteriaInList = Criteria.where((String)fieldName).in(paraList.toArray(new Object[paraList.size()]));
                    query.addCriteria((CriteriaDefinition)criteriaInList);
                }
                if (jsonParams != null) {
                    for (String keyCode : jsonParams.keySet()) {
                        Object keyData = jsonParams.get((Object)keyCode);
                        List<Criteria> criteriaChilds = this.utils.baseBuildCriteriaList(keyCode, keyData, null);
                        try {
                            for (Criteria current : criteriaChilds) {
                                query.addCriteria((CriteriaDefinition)current);
                            }
                        }
                        catch (InvalidMongoDbApiUsageException imdaue) {
                            System.out.println(String.format("\u6dfb\u52a0\u6761\u4ef6[%1$s]\u65f6\u53d1\u751f\u5f02\u5e38:%2$s", keyCode, imdaue.getMessage()));
                        }
                    }
                }
                if (!StringUtils.isEmpty((Object)fieldList)) {
                    String[] fields;
                    for (String field : fields = fieldList.split(",")) {
                        if (StringUtils.isEmpty((Object)field)) continue;
                        query.fields().include(field);
                    }
                }
                if (!StringUtils.isEmpty((Object)orderList)) {
                    String[] orderFields = orderList.split(";");
                    ArrayList<Sort.Order> lst = new ArrayList<Sort.Order>();
                    for (int i = 0; i < orderFields.length; ++i) {
                        String[] strs = orderFields[i].split(",");
                        if (strs.length > 1) {
                            lst.add(new Sort.Order(Sort.Direction.fromString((String)strs[1]), strs[0]));
                            continue;
                        }
                        lst.add(new Sort.Order(strs[0]));
                    }
                    Sort order = new Sort(lst);
                    query.with(order);
                }
                list = storage.select(query, tableName);
                Object var19_23 = null;
                if (storage == null) break block13;
            }
            catch (Throwable throwable) {
                block14: {
                    Object var19_24 = null;
                    if (storage == null) break block14;
                    storage.destroy();
                }
                throw throwable;
            }
            storage.destroy();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertData(Object data, String tableName) {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            storage.insert(data, tableName);
            Object var5_4 = null;
            if (storage == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (storage == null) throw throwable;
            storage.destroy();
            throw throwable;
        }
        storage.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateData(JSONObject queryParams, JSONObject updateParams, String tableName) throws Exception {
        FStorageOperations storage = null;
        int updateCount = 0;
        try {
            storage = this.getStorageOperations();
            if (updateParams == null || updateParams.isEmpty()) {
                throw new Exception("\u66f4\u65b0\u5b57\u6bb5\u5fc5\u987b\u6709\u8bbe\u7f6e");
            }
            Query query = new Query();
            if (queryParams != null && !queryParams.isEmpty()) {
                for (String keyCode : queryParams.keySet()) {
                    Object keyData = queryParams.get((Object)keyCode);
                    List<Criteria> criteriaChilds = this.utils.baseBuildCriteriaList(keyCode, keyData, null);
                    try {
                        for (Criteria current : criteriaChilds) {
                            query.addCriteria((CriteriaDefinition)current);
                        }
                    }
                    catch (InvalidMongoDbApiUsageException imdaue) {
                        System.out.println(String.format("\u6dfb\u52a0\u6761\u4ef6[%1$s]\u65f6\u53d1\u751f\u5f02\u5e38:%2$s", keyCode, imdaue.getMessage()));
                    }
                }
            }
            Update update = new Update();
            for (String keyCode : updateParams.keySet()) {
                Object keyData = updateParams.get((Object)keyCode);
                update.set(keyCode, keyData);
            }
            updateCount = storage.update(query, update, tableName);
            Object var14_14 = null;
            if (storage == null) return updateCount;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (storage == null) throw throwable;
            storage.destroy();
            throw throwable;
        }
        storage.destroy();
        return updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteData(JSONObject params, String tableName) {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            Query query = new Query();
            if (params != null && !params.isEmpty()) {
                for (String keyCode : params.keySet()) {
                    Object keyData = params.get((Object)keyCode);
                    List<Criteria> criteriaChilds = this.utils.baseBuildCriteriaList(keyCode, keyData, null);
                    try {
                        for (Criteria current : criteriaChilds) {
                            query.addCriteria((CriteriaDefinition)current);
                        }
                    }
                    catch (InvalidMongoDbApiUsageException imdaue) {
                        System.out.println(String.format("\u6dfb\u52a0\u6761\u4ef6[%1$s]\u65f6\u53d1\u751f\u5f02\u5e38:%2$s", keyCode, imdaue.getMessage()));
                    }
                }
            }
            storage.delete(query, tableName);
            Object var12_12 = null;
            if (storage == null) return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (storage == null) throw throwable;
            storage.destroy();
            throw throwable;
        }
        storage.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveData(JSONObject jsonParams, String keyList, String tableName) {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            String[] keys = keyList.split(",");
            Query query = new Query();
            boolean flagDelete = true;
            for (String field : keys) {
                if (jsonParams.containsKey((Object)field)) {
                    List<Criteria> criteriaChilds = this.utils.baseBuildCriteriaList(field, jsonParams.get((Object)field), null);
                    try {
                        for (Criteria current : criteriaChilds) {
                            query.addCriteria((CriteriaDefinition)current);
                        }
                        continue;
                    }
                    catch (InvalidMongoDbApiUsageException imdaue) {
                        System.out.println(String.format("\u6dfb\u52a0\u6761\u4ef6[%1$s]\u65f6\u53d1\u751f\u5f02\u5e38:%2$s", field, imdaue.getMessage()));
                        continue;
                    }
                }
                flagDelete = false;
            }
            if (flagDelete) {
                storage.delete(query, tableName);
            }
            jsonParams.put("timestamp", (Object)new Date());
            jsonParams.put("processed", (Object)false);
            storage.insert((Object)jsonParams, tableName);
            Object var16_16 = null;
            if (storage == null) return;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (storage == null) throw throwable;
            storage.destroy();
            throw throwable;
        }
        storage.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveData(List<Map<String, Object>> data, String keyList, String tableName) {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            String[] keys = keyList.split(",");
            for (Map<String, Object> current : data) {
                Query query = new Query();
                boolean flagDelete = true;
                for (String field : keys) {
                    if (current.containsKey(field)) {
                        Criteria criteria = Criteria.where((String)field).is(current.get(field));
                        query.addCriteria((CriteriaDefinition)criteria);
                        continue;
                    }
                    flagDelete = false;
                }
                if (flagDelete) {
                    storage.delete(query, tableName);
                }
                current.put("timestamp", new Date());
                storage.insert(current, tableName);
            }
            Object var16_15 = null;
            if (storage == null) return;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (storage == null) throw throwable;
            storage.destroy();
            throw throwable;
        }
        storage.destroy();
    }
}

