/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util.result;

import com.efuture.omd.common.util.result.ResultMapper;
import com.efuture.omd.common.util.result.ResultMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultJoin<X, Y, T> {
    private ResultMode mode = ResultMode.INNER_JOIN;

    public ResultJoin(ResultMode mode) {
        this.mode = mode;
    }

    protected abstract T onMerge(X var1, Y var2);

    private List<T> onInnerJoin(Map<String, List<X>> source, Map<String, List<Y>> target) {
        ArrayList<T> response = new ArrayList<T>();
        for (String keyCode : source.keySet()) {
            if (!source.containsKey(keyCode) || !target.containsKey(keyCode)) continue;
            List<X> xValue = source.get(keyCode);
            List<Y> yValue = target.get(keyCode);
            for (X rowSource : xValue) {
                for (Y rowTarget : yValue) {
                    T outerRow = this.onMerge(rowSource, rowTarget);
                    if (outerRow == null) continue;
                    response.add(outerRow);
                }
            }
        }
        return response;
    }

    private List<T> onLeftJoin(Map<String, List<X>> source, Map<String, List<Y>> target) {
        ArrayList<T> response = new ArrayList<T>();
        for (String keyCode : source.keySet()) {
            if (!source.containsKey(keyCode) || !source.containsKey(keyCode)) continue;
            List<X> xValue = source.get(keyCode);
            List<Y> yValue = target.get(keyCode);
            for (X rowSource : xValue) {
                for (Y rowTarget : yValue) {
                    T outerRow = this.onMerge(rowSource, rowTarget);
                    response.add(outerRow);
                }
            }
        }
        return response;
    }

    private List<T> onRightJoin(Map<String, List<X>> source, Map<String, List<Y>> target) {
        ArrayList<T> response = new ArrayList<T>();
        for (String keyCode : source.keySet()) {
            if (!source.containsKey(keyCode) || !source.containsKey(keyCode)) continue;
            List<X> xValue = source.get(keyCode);
            List<Y> yValue = target.get(keyCode);
            for (X rowSource : xValue) {
                for (Y rowTarget : yValue) {
                    T outerRow = this.onMerge(rowSource, rowTarget);
                    response.add(outerRow);
                }
            }
        }
        return response;
    }

    private List<T> onFullJoin(Map<String, List<X>> source, Map<String, List<Y>> target) {
        ArrayList<T> response = new ArrayList<T>();
        for (String keyCode : source.keySet()) {
            if (!source.containsKey(keyCode) || !source.containsKey(keyCode)) continue;
            List<X> xValue = source.get(keyCode);
            List<Y> yValue = target.get(keyCode);
            for (X rowSource : xValue) {
                for (Y rowTarget : yValue) {
                    T outerRow = this.onMerge(rowSource, rowTarget);
                    response.add(outerRow);
                }
            }
        }
        return response;
    }

    public List<T> doJoin(ResultMapper<X> joinSource, ResultMapper<Y> joinTarget) {
        List<T> response = null;
        Map<String, List<X>> source = joinSource.getMapper();
        Map<String, List<Y>> target = joinTarget.getMapper();
        switch (this.mode) {
            case INNER_JOIN: {
                response = this.onInnerJoin(source, target);
                break;
            }
            case LEFT_JOIN: {
                response = this.onLeftJoin(source, target);
                break;
            }
            case RIGHT_JOIN: {
                response = this.onRightJoin(source, target);
                break;
            }
            default: {
                response = this.onFullJoin(source, target);
            }
        }
        return response;
    }
}

