/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.common.util.result;

import com.efuture.omd.common.util.result.ResultJoin;
import com.efuture.omd.common.util.result.ResultLimit;
import com.efuture.omd.common.util.result.ResultMapper;
import com.efuture.omd.common.util.result.ResultMode;
import com.efuture.omd.common.util.result.ResultSort;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultUtils<X, Y, T> {
    private ResultMapper<X> sourceMapper = null;
    private ResultMapper<Y> targetMapper = null;
    private ResultJoin<X, Y, T> reduce = null;
    private ResultSort<T> sortHandle = null;
    private ResultMode mode = ResultMode.INNER_JOIN;

    public abstract String getSourceJoinKey(X var1);

    public abstract String getTargetJoinKey(Y var1);

    public abstract T onRowMerge(X var1, Y var2);

    public ResultUtils(ResultMode mode, ResultSort<T> sortHandle) {
        this.mode = mode;
        this.sortHandle = sortHandle;
        this.sourceMapper = new ResultMapper<X>(){

            @Override
            protected String getJoinKey(X row) {
                return ResultUtils.this.getSourceJoinKey(row);
            }
        };
        this.targetMapper = new ResultMapper<Y>(){

            @Override
            protected String getJoinKey(Y row) {
                return ResultUtils.this.getTargetJoinKey(row);
            }
        };
        this.reduce = new ResultJoin<X, Y, T>(this.mode){

            @Override
            protected T onMerge(X rowSource, Y rowTarget) {
                return ResultUtils.this.onRowMerge(rowSource, rowTarget);
            }
        };
    }

    public void addRowSource(X row) {
        this.sourceMapper.add(row);
    }

    public void addRowTarget(Y row) {
        this.targetMapper.add(row);
    }

    public List<T> getResult() {
        return this.getResult(0, 0, null);
    }

    public List<T> getResult(int pageIndex, int pageSize, StringBuffer buffer) {
        List<T> list = this.reduce.doJoin(this.sourceMapper, this.targetMapper);
        if (this.sortHandle != null) {
            this.sortHandle.doSort(list);
        }
        return new ResultLimit<T>().getDataLimit(list, pageIndex, pageSize, buffer);
    }
}

