/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.storage.mybatis;

import com.alibaba.druid.pool.DruidDataSource;
import com.efuture.omd.storage.mybatis.ReflectUtil;
import com.efuture.omd.storage.mybatis.dialect.Dialect;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.executor.statement.PreparedStatementHandler;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class})})
public class DiclectStatementHandlerInterceptor
implements Interceptor {
    Dialect dialect;

    public Object intercept(Invocation invocation) throws Throwable {
        PreparedStatementHandler handler;
        RowBounds rowBounds;
        RoutingStatementHandler statement = (RoutingStatementHandler)invocation.getTarget();
        Object delegate = ReflectUtil.getFieldValue(statement, "delegate");
        if (delegate instanceof PreparedStatementHandler && (rowBounds = (RowBounds)ReflectUtil.getFieldValue(handler = (PreparedStatementHandler)delegate, "rowBounds")) != null && rowBounds.getLimit() > 0 && rowBounds.getLimit() < Integer.MAX_VALUE) {
            BoundSql boundSql = statement.getBoundSql();
            String sql = boundSql.getSql();
            this.createDialect(handler);
            String pagesql = this.dialect.getLimitString(sql, rowBounds.getOffset(), rowBounds.getLimit());
            ReflectUtil.setFieldValue(boundSql, "sql", pagesql);
        }
        return invocation.proceed();
    }

    private void createDialect(PreparedStatementHandler handler) {
        Configuration configuration = (Configuration)ReflectUtil.getFieldValue(handler, "configuration");
        Environment environment = (Environment)ReflectUtil.getFieldValue(configuration, "environment");
        String url = "";
        DataSource dataSource = environment.getDataSource();
        url = dataSource instanceof DruidDataSource ? ((String)ReflectUtil.getFieldValue(dataSource, "jdbcUrl")).toLowerCase() : ((String)ReflectUtil.getFieldValue(dataSource, "url")).toLowerCase();
        String dialectClass = "";
        if (url.indexOf("jdbc:db2") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.DB2Dialect";
        } else if (url.indexOf("jdbc:derby") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.DerbyDialect";
        } else if (url.indexOf("jdbc:h2") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.H2Dialect";
        } else if (url.indexOf("jdbc:hsql") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.HSQLDialect";
        } else if (url.indexOf("jdbc:mysql") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.MySQLDialect";
        } else if (url.indexOf("jdbc:oracle") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.OracleDialect";
        } else if (url.indexOf("jdbc:postgresql") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.PostgreSQLDialect";
        } else if (url.indexOf("jdbc:sqlserver2005") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.SQLServer2005Dialect";
        } else if (url.indexOf("jdbc:sqlserver") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.SQLServerDialect";
        } else if (url.indexOf("jdbc:sybase") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.SybaseDialect";
        } else if (url.indexOf("jdbc:sqlite") > -1) {
            dialectClass = "com.efuture.omd.storage.mybatis.dialect.SQLiteDialect";
        }
        try {
            if ("".equals(dialectClass)) {
                throw new RuntimeException("\u65e0\u6cd5\u5f97\u5230Dialect\u7c7b\u540d\u3002");
            }
            this.dialect = (Dialect)Class.forName(dialectClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u521b\u5efaDialect\u7c7b:" + dialectClass, e);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

