/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONObject;
import com.efuture.batch.DataComplete;
import com.efuture.batch.DataInitor;
import com.efuture.batch.DataProcessor;
import com.efuture.batch.DataReader;
import com.efuture.batch.DataWriter;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public class AbstractExecutor {
    public DataInitor getDataIniter(JSONObject params) {
        String objName = "dbDataInitor";
        return this.getObjFromSpring(objName, DataInitor.class);
    }

    public DataComplete getDataComplete(JSONObject params) {
        String objName = "dbDataComplete";
        return this.getObjFromSpring(objName, DataComplete.class);
    }

    public DataWriter getDataWriter(JSONObject params) {
        String objName = params.getString("writer_objname");
        return this.getObjFromSpring(objName, DataWriter.class);
    }

    public List<DataProcessor> getDataProcessor(JSONObject params) {
        String objName = params.getString("process_objname");
        ArrayList<DataProcessor> rtn = new ArrayList<DataProcessor>();
        if (StringUtils.isEmpty((Object)objName)) {
            FutureJobLog.log("\u5bf9\u8c61[process_objname]\u672a\u914d\u7f6e", new Object[0]);
            return rtn;
        }
        String[] objArray = objName.split(",");
        for (int i = 0; i < objArray.length; ++i) {
            DataProcessor p = this.getObjFromSpring(objName, DataProcessor.class);
            if (p == null) continue;
            rtn.add(p);
        }
        return rtn;
    }

    public DataReader getDataReader(JSONObject params) {
        String objName = params.getString("read_objname");
        return this.getObjFromSpring(objName, DataReader.class);
    }

    public <T> T getObjFromSpring(String objName, Class<T> cls) {
        if (StringUtils.isEmpty((Object)objName)) {
            FutureJobLog.log("\u5bf9\u8c61{}[{}]\u672a\u914d\u7f6e", cls.toString(), objName);
            return null;
        }
        if (!SpringBeanFactory.containsBean((String)objName)) {
            FutureJobLog.log("\u5bf9\u8c61{}[{}]\u4e0d\u5b58\u5728", cls.toString(), objName);
            return null;
        }
        return (T)SpringBeanFactory.getBean((String)objName, cls);
    }
}

