/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONObject;
import com.efuture.appconfig.DatabaseContextHolder;
import com.efuture.batch.DataComplete;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.ocp.common.exception.ServiceException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dbDataComplete")
public class DBDataComplete
implements DataComplete {
    @Autowired
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void success(List<Map<String, Object>> items, JSONObject config, String complete_type) {
        String db = config.getString("complete_db");
        String sqlStr = config.getString("complete_success_sql");
        for (Map<String, Object> item : items) {
            JSONObject para = (JSONObject)config.clone();
            para.fluentPutAll(item);
            this.execsql(db, sqlStr, para);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void fail(List<Map<String, Object>> items, JSONObject config, String complete_type, String errmsg) {
        String db = config.getString("complete_db");
        String sqlStr = config.getString("complete_fail_sql");
        for (Map<String, Object> item : items) {
            JSONObject para = (JSONObject)config.clone();
            para.fluentPutAll(item);
            para.put("errmsg", (Object)errmsg);
            this.execsql(db, sqlStr, para);
        }
    }

    private void execsql(String db, String sqlStr, JSONObject config) {
        if (db == null || db.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u7ed3\u675f\u5904\u7406\u7684\u6570\u636e\u6e90\u4ee3\u7801", new Object[0]);
            return;
        }
        if (sqlStr == null || sqlStr.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u7ed3\u675f\u5904\u7406\u7684SQL\u8bed\u53e5", new Object[0]);
            return;
        }
        if (!DatabaseContextHolder.contains(db)) {
            FutureJobLog.log("\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", db);
            throw new ServiceException("30001", "\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", new Object[]{db});
        }
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},db:{},sql:{},para:{}", "DataComplete", db, sqlStr, config);
        DatabaseContextHolder.setDatabaseType(db);
        this.namedParameterJdbcTemplate.update(sqlStr, (Map)config);
    }
}

