/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONObject;
import com.efuture.appconfig.DatabaseContextHolder;
import com.efuture.batch.DataInitor;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.job.utils.SqlUtils;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dbDataInitor")
public class DBDataInitor
implements DataInitor {
    @Autowired
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Override
    public void init(JSONObject conifg) throws Exception {
        JSONObject initConfig = conifg;
        String db = initConfig.getString("init_db");
        String sqlStr = initConfig.getString("init_sqlstr");
        initConfig.remove((Object)"init_db");
        initConfig.remove((Object)"init_sqlstr");
        DatabaseContextHolder.setDatabaseType(db);
        ((DBDataInitor)SpringBeanFactory.getBean((String)"dbDataInitor", DBDataInitor.class)).execsql(db, sqlStr, initConfig);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    private void execsql(String db, String sqlStr, JSONObject conifg) {
        if (db == null || db.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u521d\u59cb\u5316\u6570\u636e\u7684\u6570\u636e\u6e90\u4ee3\u7801", new Object[0]);
            return;
        }
        if (sqlStr == null || sqlStr.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u521d\u59cb\u5316\u6570\u636e\u7684SQL\u8bed\u53e5", new Object[0]);
            return;
        }
        if (!DatabaseContextHolder.contains(db)) {
            FutureJobLog.log("\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", db);
            throw new ServiceException("30001", "\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", new Object[]{db});
        }
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},db:{},para:{}", "initData", db, conifg);
        DatabaseContextHolder.setDatabaseType(db);
        sqlStr = SqlUtils.ReplaceSqlParam(sqlStr, (Map<String, Object>)conifg);
        sqlStr = SqlUtils.ReplaceSqlFunctionForDB(sqlStr);
        this.namedParameterJdbcTemplate.update(sqlStr, (Map)conifg);
    }
}

