/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONObject;
import com.efuture.appconfig.DatabaseContextHolder;
import com.efuture.batch.DataReader;
import com.efuture.job.utils.ColumnMapCaseRowMapper;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.job.utils.SqlUtils;
import com.efuture.ocp.common.exception.ServiceException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="dbDataReader")
public class DBDataReader
implements DataReader {
    @Autowired
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Override
    public List<Map<String, Object>> read(JSONObject conifg) throws Exception {
        JSONObject readConfig = conifg;
        int pageSize = 0;
        int pageNo = 0;
        if (readConfig.containsKey((Object)"page_read") && "Y".equalsIgnoreCase(readConfig.getString("page_read"))) {
            pageSize = (Integer)readConfig.getOrDefault((Object)"page_size", (Object)50000);
            pageNo = (Integer)readConfig.getOrDefault((Object)"page_no", (Object)1);
            readConfig.put("page_size", (Object)pageSize);
            readConfig.put("page_no", (Object)pageNo);
        }
        String db = readConfig.getString("read_db");
        String sqlStr = readConfig.getString("read_sqlstr");
        return this.execsql(db, sqlStr, readConfig, pageSize, pageNo);
    }

    private List<Map<String, Object>> execsql(String db, String sqlStr, JSONObject conifg, int pageSize, int pageNo) {
        if (db == null || db.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u8bfb\u6570\u636e\u7684\u6570\u636e\u6e90\u4ee3\u7801", new Object[0]);
            throw new RuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u8bfb\u6570\u636e\u7684\u6570\u636e\u6e90\u4ee3\u7801");
        }
        if (sqlStr == null || sqlStr.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u8bfb\u6570\u636e\u7684SQL\u8bed\u53e5", new Object[0]);
            throw new RuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u8bfb\u6570\u636e\u7684SQL\u8bed\u53e5");
        }
        if (!DatabaseContextHolder.contains(db)) {
            FutureJobLog.log("\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", db);
            throw new ServiceException("30001", "\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", new Object[]{db});
        }
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},db:{},para:{}", "readData", db, conifg);
        DatabaseContextHolder.setDatabaseType(db);
        sqlStr = SqlUtils.ReplaceSqlParam(sqlStr, (Map<String, Object>)conifg);
        sqlStr = SqlUtils.ReplaceSqlFunctionForDB(sqlStr);
        if (pageSize != 0) {
            sqlStr = SqlUtils.getPageSql(sqlStr, pageNo, pageSize);
        }
        List listdata = this.namedParameterJdbcTemplate.query(sqlStr, (Map)conifg, (RowMapper)new ColumnMapCaseRowMapper());
        FutureJobLog.log("\u67e5\u8be2\u672a\u53d1\u9001\u6d88\u606f{}\u6761", listdata.size());
        return listdata;
    }
}

