/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONObject;
import com.efuture.appconfig.DatabaseContextHolder;
import com.efuture.batch.DataWriter;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.job.utils.SqlUtils;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="dbDataWriter")
public class DBDataWriter
implements DataWriter {
    @Autowired
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Override
    public Map<String, Object> write(List<Map<String, Object>> items, JSONObject conifg, boolean ibBatch) throws Exception {
        String db = conifg.getString("writer_db");
        String sqlStr = conifg.getString("writer_sqlstr");
        DatabaseContextHolder.setDatabaseType(db);
        ((DBDataWriter)SpringBeanFactory.getBean((String)"dbDataWriter", DBDataWriter.class)).doWrite(db, sqlStr, items, conifg, ibBatch);
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    private void doWrite(String db, String sqlStr, List<Map<String, Object>> items, JSONObject conifg, boolean ibBatch) {
        for (Map<String, Object> item : items) {
            JSONObject readConfig = (JSONObject)conifg.clone();
            readConfig.remove((Object)"writer_db");
            readConfig.remove((Object)"writer_sqlstr");
            readConfig.putAll(item);
            readConfig.put("ph_key", (Object)UniqueID.getUniqueID());
            this.execsql(db, sqlStr, readConfig);
        }
    }

    private void execsql(String db, String sqlStr, JSONObject config) {
        if (db == null || db.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u5199\u6570\u636e\u7684\u6570\u636e\u6e90\u4ee3\u7801", new Object[0]);
            throw new RuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u5199\u6570\u636e\u7684\u6570\u636e\u6e90\u4ee3\u7801");
        }
        if (sqlStr == null || sqlStr.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u5199\u6570\u636e\u7684SQL\u8bed\u53e5", new Object[0]);
            throw new RuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u5199\u6570\u636e\u7684SQL\u8bed\u53e5");
        }
        if (!DatabaseContextHolder.contains(db)) {
            FutureJobLog.log("\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", db);
            throw new ServiceException("30001", "\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", new Object[]{db});
        }
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},db:{},para:{}", "WriterData", db, config);
        sqlStr = SqlUtils.ReplaceSqlParam(sqlStr, (Map<String, Object>)config);
        sqlStr = SqlUtils.ReplaceSqlFunctionForDB(sqlStr);
        this.namedParameterJdbcTemplate.update(sqlStr, (Map)config);
    }
}

