/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONObject;
import com.efuture.appconfig.DatabaseContextHolder;
import com.efuture.batch.DataExecutor;
import com.efuture.batch.DataProcessor;
import com.efuture.batch.DataWriter;
import com.efuture.batchhandle.AbstractExecutor;
import com.efuture.biz.model.ReturnBiz;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.ocp.common.exception.ServiceException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="datacompare")
public class DataCompareExecutor
extends AbstractExecutor
implements DataExecutor {
    @Autowired
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Override
    public ReturnBiz<String> execute(JSONObject params) throws Exception {
        return this.execute(params, null);
    }

    @Override
    public ReturnBiz<String> execute(JSONObject params, DataProcessor custProcessor) throws Exception {
        String jobname = params.getString("jobname");
        String init_db = params.getString("init_db");
        String init_sqlstr = params.getString("init_sqlstr");
        Map<String, Object> src_data = this.getData(init_db, init_sqlstr, params, null, null);
        String read_db = params.getString("read_db");
        String read_sqlstr = params.getString("read_sqlstr");
        ArrayList<Map<String, Object>> dataCompareList = new ArrayList<Map<String, Object>>();
        Map<String, Object> trg_data = this.getData(read_db, read_sqlstr, params, src_data, dataCompareList);
        this.compare(src_data, trg_data, dataCompareList);
        DataWriter writer = this.getDataWriter(params);
        writer.write(dataCompareList, params, true);
        if (dataCompareList.size() > 0) {
            return new ReturnBiz<String>(500, jobname + ":\u6570\u636e\u7a3d\u6838\u4e0d\u901a\u8fc7!");
        }
        return ReturnBiz.SUCCESS;
    }

    private void compare(Map<String, Object> src_data, Map<String, Object> trg_data, List<Map<String, Object>> dataCompareList) {
        for (String key : src_data.keySet()) {
            if (trg_data.containsKey(key)) continue;
            HashMap<String, Object> rtn = new HashMap<String, Object>();
            rtn.put("ckey", key);
            rtn.put("cvalue", src_data.get(key));
            rtn.put("srcvalue", "null");
            rtn.put("msg", "src\u4e0d\u5728\u6570\u636etrg\u4e2d");
            rtn.put("ctype", "1");
            FutureJobLog.log("{}", rtn);
            dataCompareList.add(rtn);
        }
    }

    public Map<String, Object> getData(String db, String sqlStr, JSONObject conifg, Map<String, Object> src_data, List<Map<String, Object>> dataCompareList) {
        if (db == null || db.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u8bfb\u6570\u636e\u7684\u6570\u636e\u6e90\u4ee3\u7801", new Object[0]);
            throw new RuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u8bfb\u6570\u636e\u7684\u6570\u636e\u6e90\u4ee3\u7801");
        }
        if (sqlStr == null || sqlStr.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u8bfb\u6570\u636e\u7684SQL\u8bed\u53e5", new Object[0]);
            throw new RuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u8bfb\u6570\u636e\u7684SQL\u8bed\u53e5");
        }
        if (!DatabaseContextHolder.contains(db)) {
            FutureJobLog.log("\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", db);
            throw new ServiceException("30001", "\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", new Object[]{db});
        }
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},db:{},para:{}", "readData", db, conifg);
        DatabaseContextHolder.setDatabaseType(db);
        MapHandle compare = new MapHandle(src_data);
        this.namedParameterJdbcTemplate.query(sqlStr, (Map)conifg, (RowCallbackHandler)compare);
        if (dataCompareList == null) {
            dataCompareList = compare.dataCompareList;
        } else {
            dataCompareList.addAll(compare.dataCompareList);
        }
        FutureJobLog.log("\u67e5\u8be2\u6570\u636e{}\u6761", compare.this_result.size());
        return compare.this_result;
    }

    private class MapHandle
    implements RowCallbackHandler {
        public Map<String, Object> this_result = new HashMap<String, Object>();
        public List<Map<String, Object>> dataCompareList = new ArrayList<Map<String, Object>>();
        public Map<String, Object> src_result;

        public MapHandle(Map<String, Object> src_result) {
            this.src_result = src_result;
        }

        public void processRow(ResultSet rs) throws SQLException {
            String ckey = rs.getObject("ckey").toString();
            Object cvalue = rs.getObject("cvalue") == null ? "null" : rs.getObject("cvalue");
            this.this_result.put(ckey, cvalue);
            if (this.src_result != null) {
                if (this.src_result.containsKey(ckey)) {
                    if (!this.src_result.get(ckey).equals(cvalue)) {
                        HashMap<String, Object> rtn = new HashMap<String, Object>();
                        rtn.put("ckey", ckey);
                        rtn.put("cvalue", cvalue);
                        rtn.put("srcvalue", this.src_result.get(ckey));
                        rtn.put("msg", "\u6570\u636etrg\u548c\u6570\u636esrc\u4e0d\u4e00\u81f4");
                        rtn.put("ctype", "3");
                        FutureJobLog.log("{}", rtn);
                        this.dataCompareList.add(rtn);
                    }
                } else {
                    HashMap<String, Object> rtn = new HashMap<String, Object>();
                    rtn.put("ckey", ckey);
                    rtn.put("cvalue", cvalue);
                    rtn.put("srcvalue", "null");
                    rtn.put("msg", "trg\u4e0d\u5728\u6570\u636esrc\u4e2d");
                    rtn.put("ctype", "2");
                    FutureJobLog.log("{}", rtn);
                    this.dataCompareList.add(rtn);
                }
            }
        }
    }
}

