/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.batch.DataReader;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.RestClientUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="httpDataReader")
public class HttpDataReader
implements DataReader {
    @Override
    public List<Map<String, Object>> read(JSONObject config) throws Exception {
        String url = config.getString("read_db");
        if (url == null || url.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6e\u8bfb\u53d6\u6570\u636e\u7684url", new Object[0]);
            throw new RuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u8bfb\u53d6\u6570\u636e\u7684url");
        }
        JSONObject postpara = this.getPostParaData(config);
        ServiceResponse res = this.doPostData(postpara, url);
        if (res.getData() == null) {
            FutureJobLog.log("\u6ca1\u6709\u4eceurl[{}],\u53c2\u6570[{}]\u4e2d\u8bfb\u5230\u7684\u6570\u636e\u4e3a\u7a7a", url, postpara);
            throw new RuntimeException("\u8bfb\u5230\u7684\u6570\u636e\u4e3a\u7a7a");
        }
        JSONObject ResponseData = (JSONObject)JSONObject.parse((String)res.getData().toString());
        return this.getResponseData(ResponseData, config);
    }

    private List<Map<String, Object>> getResponseData(JSONObject responseData, JSONObject config) {
        String dataKey = config.getString("datakey");
        if (dataKey == null) {
            FutureJobLog.log("\u53c2\u6570[{}]\u4e2d datakey \u672a\u5b9a\u4e49", config);
            throw new RuntimeException("datakey \u672a\u5b9a\u4e49");
        }
        Object data = responseData.get((Object)dataKey);
        if (!(data instanceof JSONObject)) {
            if (data instanceof JSONArray) {
                return (List)data;
            }
            FutureJobLog.log("\u8bfb\u53d6\u8fd4\u56de\u6570\u636e\u9519\u8bef,\u683c\u5f0f\u4e0d\u6b63\u786e:[{}]", data);
            throw new RuntimeException("\u8bfb\u53d6\u8fd4\u56de\u6570\u636e\u9519\u8bef,\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        ArrayList<Map> rtn = new ArrayList<Map>();
        rtn.add((Map)data);
        return null;
    }

    private ServiceResponse doPostData(JSONObject postpara, String post_url) throws Exception {
        ServiceSession session = new ServiceSession();
        if (postpara.containsKey((Object)"ent_id")) {
            session.setEnt_id(postpara.getLongValue("ent_id"));
        } else {
            session.setEnt_id(0L);
        }
        String restobj = "RestUtils";
        if (postpara.containsKey((Object)"restobj") && !StringUtils.isEmpty((Object)postpara.getString("restobj"))) {
            restobj = postpara.getString("restobj");
        }
        ServiceResponse res = RestClientUtils.getRestUtils((String)restobj).sendRequest((Object)session, post_url, (Object)postpara.toString());
        return res;
    }

    private JSONObject getPostParaData(JSONObject config) {
        String read_para = config.getString("read_para");
        if (read_para == null) {
            return config;
        }
        return JSONObject.parseObject((String)read_para);
    }
}

