/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONObject;
import com.efuture.batch.DataWriter;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.UniqueID;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="HttpDataWriter")
public class HttpDataWriter
implements DataWriter {
    @Override
    public Map<String, Object> write(List<Map<String, Object>> items, JSONObject config, boolean ibBatch) throws Exception {
        String post_url = config.getString("writer_db");
        if (post_url == null || post_url.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6epostdata\u7684url", new Object[0]);
            throw new RuntimeException("\u6ca1\u6709\u8bbe\u7f6epostdata\u7684url");
        }
        for (Map<String, Object> item : items) {
            JSONObject postpara = this.getPostParaData(item, config);
            this.doPostData(postpara, post_url);
        }
        return null;
    }

    private JSONObject getPostParaData(Map<String, Object> map, JSONObject conifg) {
        conifg.put("uuid", (Object)UniqueID.getUniqueID());
        String writer_para = conifg.getString("writer_para");
        JSONObject para = (JSONObject)conifg.clone();
        para.putAll(map);
        if (writer_para != null && !writer_para.isEmpty()) {
            for (String key : para.keySet()) {
                if (key.equalsIgnoreCase("writer_para")) continue;
                String replaceKey = "#" + key;
                writer_para = writer_para.replaceAll(replaceKey, para.getString(key));
            }
            return JSONObject.parseObject((String)writer_para);
        }
        return para;
    }

    private ServiceResponse doPostData(JSONObject postpara, String post_url) throws Exception {
        ServiceSession session = new ServiceSession();
        if (postpara.containsKey((Object)"ent_id")) {
            session.setEnt_id(postpara.getLongValue("ent_id"));
        } else {
            session.setEnt_id(0L);
        }
        String restobj = "RestUtils";
        if (postpara.containsKey((Object)"restobj") && !StringUtils.isEmpty((Object)postpara.getString("restobj"))) {
            restobj = postpara.getString("restobj");
        }
        ServiceResponse res = RestClientUtils.getRestUtils((String)restobj).sendRequest((Object)session, post_url, (Object)postpara.toString());
        FutureJobLog.log("\u8017\u65f6:{},\u8fd4\u56de\u4fe1\u606f:{}", res.getElapsed(), res.getData());
        return res;
    }
}

