/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONObject;
import com.efuture.batch.DataWriter;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.taskcore.service.TaskProducer;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="MqDataWriter")
public class MqDataWriter
implements DataWriter {
    @Override
    public Map<String, Object> write(List<Map<String, Object>> items, JSONObject config, boolean ibBatch) throws Exception {
        String topic = config.getString("writer_db");
        if (topic == null || topic.equals("")) {
            FutureJobLog.log("\u6ca1\u6709\u8bbe\u7f6epostdata\u7684topic", new Object[0]);
            throw new RuntimeException("\u6ca1\u6709\u8bbe\u7f6epostdata\u7684topic");
        }
        for (Map<String, Object> item : items) {
            JSONObject postpara = this.getPostParaData(item, config);
            this.doPostData(postpara, topic);
        }
        return null;
    }

    private String getConfig(JSONObject config, String key, String defVal) {
        if (config == null) {
            return defVal;
        }
        if (!config.containsKey((Object)key)) {
            return defVal;
        }
        if (config.getString(key) == null) {
            return defVal;
        }
        return config.getString(key);
    }

    private void doPostData(JSONObject postpara, String topic) {
        String keyCol;
        String keyValue;
        String ent_id = postpara.getString("ent_id");
        if (StringUtils.isEmpty((Object)ent_id)) {
            ent_id = "0";
        }
        if (StringUtils.isEmpty((Object)(keyValue = postpara.getString(keyCol = this.getConfig(postpara, "keycol", "keyvalue"))))) {
            keyValue = String.valueOf(UniqueID.getUniqueID());
        }
        FutureJobLog.log("\u53d1\u9001\u6d88\u606f-->topic:[{}],msg:[{}]", topic, postpara);
        int rtn = TaskProducer.produce((long)Long.valueOf(ent_id), (String)topic, (String)"jobs", (String)keyValue, (JSONObject)postpara);
        FutureJobLog.log("\u53d1\u9001\u6d88\u606f-->topic:[{}],rtn[{}],msg:[{}]", topic, rtn, postpara);
    }

    private JSONObject getPostParaData(Map<String, Object> item, JSONObject config) {
        String writer_para = config.getString("writer_para");
        JSONObject para = (JSONObject)config.clone();
        para.putAll(item);
        if (!StringUtils.isEmpty((Object)writer_para)) {
            for (String key : para.keySet()) {
                if (key.equalsIgnoreCase("writer_para")) continue;
                String replaceKey = "#" + key;
                writer_para = writer_para.replaceAll(replaceKey, para.getString(key));
            }
            return JSONObject.parseObject((String)writer_para);
        }
        return para;
    }
}

