/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.efuture.batch.DataProcessor;
import com.efuture.job.utils.JobPara;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="multiLevelDataProcessor")
public class MultiLevelDataProcessor
implements DataProcessor {
    @Autowired
    JobPara jobPara;
    String CODE_COL = "tag_code";
    String NAME_COL = "tag_name";

    private String getConfig(JSONObject multilevel_config_json, String key, String defVal) {
        if (multilevel_config_json == null) {
            return defVal;
        }
        if (!multilevel_config_json.containsKey((Object)key)) {
            return defVal;
        }
        if (multilevel_config_json.getString(key) == null) {
            return defVal;
        }
        return multilevel_config_json.getString(key);
    }

    private String getString(Map<String, Object> item, String key) {
        if (item.get(key) == null) {
            return null;
        }
        return item.get(key).toString();
    }

    private String getColName(int level, boolean ibName) {
        if (ibName) {
            return "L" + level + "_name";
        }
        return "L" + level + "_code";
    }

    @Override
    public Map<String, Object> process(List<Map<String, Object>> allData, Map<String, Object> item, JSONObject conifg) throws Exception {
        JSONObject process_para = JSONObject.parseObject((String)this.jobPara.getStepParaStr(conifg, "process", "process_para", ""));
        String multilevel_config = "";
        multilevel_config = process_para != null ? process_para.getString("multilevel") : conifg.getString("multilevel");
        JSONObject multilevel_config_json = JSONObject.parseObject((String)multilevel_config);
        String noParentThenContinue = multilevel_config_json.getString("no_parent_then_continue");
        if (noParentThenContinue == null) {
            noParentThenContinue = "Y";
        }
        String codeCol = this.getConfig(multilevel_config_json, "code_col", "code");
        String nameCol = this.getConfig(multilevel_config_json, "name_col", "name");
        String parentCol = this.getConfig(multilevel_config_json, "parent_col", "parent_id");
        String jygsCol = this.getConfig(multilevel_config_json, "jygs_col", "jygs");
        if (this.getBoolean(item.get("is_parent")).booleanValue()) {
            if ("Y".equalsIgnoreCase(noParentThenContinue)) {
                return null;
            }
            return item;
        }
        String code = this.getString(item, codeCol);
        String name = this.getString(item, nameCol);
        String parent = this.getString(item, parentCol);
        String corp_id = this.getString(item, jygsCol);
        StringBuffer LevelColNames = new StringBuffer(this.CODE_COL + "," + this.NAME_COL);
        StringBuffer LevelValues = new StringBuffer("'" + code + "','" + name);
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        this.initReturn(rtn, item);
        rtn.put("jygs", corp_id);
        int i = 1;
        while (!StringUtils.isEmpty((Object)parent) && !"0".equals(parent)) {
            boolean exist = false;
            for (int j = 0; j < allData.size(); ++j) {
                Map<String, Object> row = allData.get(j);
                if (!parent.equalsIgnoreCase(this.getString(row, codeCol)) || !corp_id.equalsIgnoreCase(this.getString(row, jygsCol))) continue;
                String thisCode = this.getString(row, codeCol);
                String thisCodeColName = this.getColName(i, false);
                String thisName = this.getString(row, nameCol);
                String thisNameColname = this.getColName(i, true);
                LevelColNames.append("," + thisCodeColName);
                LevelValues.append("','" + thisCode);
                LevelColNames.append("," + thisNameColname);
                LevelValues.append("','" + thisName);
                exist = true;
                parent = this.getString(row, parentCol);
                ++i;
                break;
            }
            if (exist) continue;
            break;
        }
        LevelValues.append("'");
        rtn.put("levelcolnames", LevelColNames);
        rtn.put("levelvalues", LevelValues);
        String keyVal = rtn.get("ent_id").toString() + "." + corp_id + "." + code;
        rtn.put("tagkey", keyVal);
        return rtn;
    }

    private void initReturn(Map<String, Object> rtn, Map<String, Object> item) {
        rtn.put("ph_timestamp", new Date());
        if (item.containsKey("ent_id")) {
            rtn.put("ent_id", item.get("ent_id"));
        } else {
            rtn.put("ent_id", 0);
        }
    }

    private Boolean getBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0) {
                return null;
            }
            if ("true".equals(str)) {
                return Boolean.TRUE;
            }
            if ("false".equals(str)) {
                return Boolean.FALSE;
            }
            if ("1".equals(str)) {
                return Boolean.TRUE;
            }
            if ("0".equals(str)) {
                return Boolean.FALSE;
            }
            if ("Y".equalsIgnoreCase(str)) {
                return Boolean.TRUE;
            }
            if ("N".equalsIgnoreCase(str)) {
                return Boolean.FALSE;
            }
        }
        throw new JSONException("can not cast to int, value : " + value);
    }
}

