/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONObject;
import com.efuture.appconfig.DatabaseContextHolder;
import com.efuture.batch.DataComplete;
import com.efuture.batch.DataExecutor;
import com.efuture.batch.DataInitor;
import com.efuture.batch.DataProcessor;
import com.efuture.batch.DataReader;
import com.efuture.batch.DataWriter;
import com.efuture.batchhandle.AbstractExecutor;
import com.efuture.batchhandle.ProcessRow;
import com.efuture.biz.model.ReturnBiz;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.job.utils.JobPara;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="onebyone")
public class OneByOneExecuter
extends AbstractExecutor
implements DataExecutor,
ProcessRow {
    @Autowired
    public JobPara jobpara;

    public void processPageData(String jobname, List<Map<String, Object>> datas, JSONObject params, DataWriter writer, List<DataProcessor> processlist, DataComplete complete) throws Exception {
        String skiperr = params.getString("skiperr");
        if (StringUtils.isEmpty((Object)skiperr)) {
            skiperr = "Y";
        }
        long start_time = System.currentTimeMillis();
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},obj:{},\r\n para:{}", "\u8f6c\u6362\u5e76\u5199\u5165\u6570\u636e", writer.getClass().toString(), params);
        ArrayList<Map<String, Object>> writerdatas = new ArrayList<Map<String, Object>>();
        int succ_num = 0;
        int fail_num = 0;
        int skip_num = 0;
        String biztimecol = params.getString("biztimecol");
        String bizutctimecol = params.getString("bizutctimecol");
        String asyncexec = params.getString("asyncexec");
        if (asyncexec == null || asyncexec.isEmpty()) {
            asyncexec = "Y";
        }
        Date biztime = null;
        long bizutctime = 0L;
        for (Map<String, Object> data : datas) {
            ProcessRow exec = (ProcessRow)SpringBeanFactory.getBean((String)"onebyone", ProcessRow.class);
            int rtn = 1;
            if (asyncexec.equalsIgnoreCase("Y")) {
                exec.AsyncProcessRow(datas, data, params, writerdatas, processlist, writer, complete, skiperr);
            } else {
                rtn = exec.processRow(datas, data, params, writerdatas, processlist, writer, complete, skiperr);
            }
            if (rtn == 0) {
                ++skip_num;
                continue;
            }
            if (rtn == 1) {
                if (biztimecol != null && data.get(biztimecol) != null) {
                    biztime = (Date)data.get(biztimecol);
                }
                if (bizutctimecol != null && data.get(bizutctimecol) != null) {
                    bizutctime = (Long)data.get(bizutctimecol);
                }
                ++succ_num;
                continue;
            }
            if (rtn != -1) continue;
            ++fail_num;
        }
        DatabaseContextHolder.setDatabaseType("ompconfig");
        this.jobpara.uptJobsLasttime(jobname, biztime, bizutctime);
        long end_time = System.currentTimeMillis();
        FutureJobLog.log("\u6267\u884c:{}\u5b8c\u6bd5,\u8017\u65f6{},\u603b\u6761\u6570{},\u6210\u529f\u6761\u6570{},\u5931\u8d25\u6761\u6570{},\u8df3\u8fc7\u6761\u6570", "\u8f6c\u6362\u5e76\u5199\u5165\u6570\u636e", end_time - start_time, datas.size(), succ_num, fail_num, skip_num);
    }

    @Override
    public ReturnBiz<String> execute(JSONObject params, DataProcessor custProcessor) throws Exception {
        String jobname = params.getString("jobname");
        DataReader read = this.getDataReader(params);
        List<DataProcessor> processlist = this.getDataProcessor(params);
        if (custProcessor != null) {
            processlist.add(custProcessor);
        }
        DataWriter writer = this.getDataWriter(params);
        DataInitor initor = this.getDataIniter(params);
        DataComplete complete = this.getDataComplete(params);
        long start_time = System.currentTimeMillis();
        JSONObject initpara = this.jobpara.getStepPara(params, "init");
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},obj:{},\r\n para:{}", "\u5f00\u59cb\u6267\u884c\u521d\u59cb\u5316", initor.getClass().toString(), initpara);
        initor.init(initpara);
        long end_time = System.currentTimeMillis();
        FutureJobLog.log("\u6267\u884c{}\u5b8c\u6bd5:\u8017\u65f6{}", "\u521d\u59cb\u5316", end_time - start_time);
        if (read == null) {
            FutureJobLog.log("\u6b64\u6d41\u7a0b\u5fc5\u987b\u5b9a\u4e49read\u7ec4\u4ef6", new Object[0]);
            return ReturnBiz.FAIL;
        }
        start_time = System.currentTimeMillis();
        JSONObject readpara = this.jobpara.getStepPara(params, "read");
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},obj:{},\r\n para:{}", "\u83b7\u53d6\u6570\u636e", read.getClass().toString(), params);
        List<Map<String, Object>> datas = read.read(readpara);
        end_time = System.currentTimeMillis();
        FutureJobLog.log("\u6267\u884c{}\u5b8c\u6bd5:\u8017\u65f6{},\u6761\u6570{}", "\u83b7\u53d6\u6570\u636e", end_time - start_time, datas.size());
        if (datas.size() <= 0) {
            return new ReturnBiz<String>("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
        }
        if (readpara.containsKey((Object)"page_read") && "Y".equalsIgnoreCase(readpara.getString("page_read"))) {
            boolean ibReadOver = false;
            int pageno = readpara.getIntValue("page_no");
            do {
                this.processPageData(jobname, datas, params, writer, processlist, complete);
                readpara.put("page_no", (Object)(++pageno));
                start_time = System.currentTimeMillis();
                datas = read.read(readpara);
                end_time = System.currentTimeMillis();
                FutureJobLog.log("\u5206\u9875\u8bfb\u53d6\u7b2c{}\u9875:\u8017\u65f6{},\u6761\u6570{}", pageno, end_time - start_time, datas.size());
                if (datas != null && datas.size() > 0) continue;
                ibReadOver = true;
                return ReturnBiz.SUCCESS;
            } while (!ibReadOver);
        } else {
            this.processPageData(jobname, datas, params, writer, processlist, complete);
        }
        return ReturnBiz.SUCCESS;
    }

    @Override
    public ReturnBiz<String> execute(JSONObject params) throws Exception {
        return this.execute(params, null);
    }

    @Override
    @Async(value="dayinittaskExecutor")
    public void AsyncProcessRow(List<Map<String, Object>> allData, Map<String, Object> data, JSONObject params, List<Map<String, Object>> writerdatas, List<DataProcessor> processlist, DataWriter writer, DataComplete complete, String skiperr) throws Exception {
        this.processRow(allData, data, params, writerdatas, processlist, writer, complete, skiperr);
    }

    @Override
    public int processRow(List<Map<String, Object>> allData, Map<String, Object> data, JSONObject params, List<Map<String, Object>> writerdatas_no, List<DataProcessor> processlist, DataWriter writer, DataComplete complete, String skiperr) throws Exception {
        ArrayList<Map<String, Object>> writerdatas = new ArrayList<Map<String, Object>>();
        Map<String, Object> o_data = data;
        JSONObject processpara = this.jobpara.getStepPara(params, "process");
        for (DataProcessor dp : processlist) {
            try {
                o_data = dp.process(allData, o_data, processpara);
            }
            catch (Exception e) {
                complete.fail(writerdatas, params, "row", "process:" + e.getMessage());
                FutureJobLog.log("process\u9519\u8bef:\r\n , \r\n para:{}, \r\n data:{}, \r\n error:{}", params, data, e.getMessage());
                if (!skiperr.equalsIgnoreCase("Y")) {
                    throw e;
                }
                return -1;
            }
        }
        JSONObject writerpara = this.jobpara.getStepPara(params, "write");
        if (o_data != null) {
            try {
                writerdatas.add(o_data);
                writer.write(writerdatas, writerpara, false);
                String db = params.getString("complete_db");
                DatabaseContextHolder.setDatabaseType(db);
                complete.success(writerdatas, params, "row");
                return 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                String db = params.getString("complete_db");
                DatabaseContextHolder.setDatabaseType(db);
                complete.fail(writerdatas, params, "row", "write:" + e.getMessage());
                FutureJobLog.log("writer\u9519\u8bef:\r\n , \r\n para:{}, \r\n data:{}, \r\n error:{}", params, o_data, e.getMessage());
                if (!skiperr.equalsIgnoreCase("Y")) {
                    throw e;
                }
                return -1;
            }
        }
        writerdatas.add(data);
        complete.fail(writerdatas, params, "row", "skip");
        FutureJobLog.log("process\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,\u8df3\u8fc7\u6b64\u6761\u8bb0\u5f55:\r\n , \r\n para:{}, \r\n data:{}", params, data);
        return 0;
    }
}

