/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.batchhandle;

import com.alibaba.fastjson.JSONObject;
import com.efuture.appconfig.DatabaseContextHolder;
import com.efuture.batch.DataComplete;
import com.efuture.batch.DataExecutor;
import com.efuture.batch.DataInitor;
import com.efuture.batch.DataProcessor;
import com.efuture.batch.DataReader;
import com.efuture.batch.DataWriter;
import com.efuture.batchhandle.AbstractExecutor;
import com.efuture.biz.model.ReturnBiz;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.job.utils.JobPara;
import com.efuture.ocp.common.util.SpringBeanFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component(value="processonewritebatch")
public class ProcessOneWriteBatchExecuter
extends AbstractExecutor
implements DataExecutor {
    @Autowired
    public JobPara jobpara;

    @Override
    public ReturnBiz<String> execute(JSONObject params) throws Exception {
        return this.execute(params, null);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ReturnBiz<String> execute(JSONObject params, DataProcessor custProcessor) throws Exception {
        String jobname = params.getString("jobname");
        DataReader read = this.getDataReader(params);
        List<DataProcessor> processlist = this.getDataProcessor(params);
        if (custProcessor != null) {
            processlist.add(custProcessor);
        }
        DataWriter writer = this.getDataWriter(params);
        DataInitor initor = this.getDataIniter(params);
        DataComplete complete = this.getDataComplete(params);
        String skiperr = params.getString("skiperr");
        if (StringUtils.isEmpty((Object)skiperr)) {
            skiperr = "Y";
        }
        long start_time = System.currentTimeMillis();
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},obj:{},\r\n para:{}", "\u5f00\u59cb\u6267\u884c\u521d\u59cb\u5316", initor.getClass().toString(), params);
        initor.init(params);
        long end_time = System.currentTimeMillis();
        FutureJobLog.log("\u6267\u884c{}\u5b8c\u6bd5:\u8017\u65f6{}", "\u521d\u59cb\u5316", end_time - start_time);
        start_time = System.currentTimeMillis();
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},obj:{},\r\n para:{}", "\u83b7\u53d6\u6570\u636e", read.getClass().toString(), params);
        List<Map<String, Object>> datas = read.read(params);
        end_time = System.currentTimeMillis();
        FutureJobLog.log("\u6267\u884c{}\u5b8c\u6bd5:\u8017\u65f6{},\u6761\u6570{}", "\u83b7\u53d6\u6570\u636e", end_time - start_time, datas.size());
        String biztimecol = params.getString("biztimecol");
        String bizutctimecol = params.getString("bizutctimecol");
        Date biztime = null;
        long bizutctime = 0L;
        start_time = System.currentTimeMillis();
        FutureJobLog.log("\u5f00\u59cb\u6267\u884c:{},obj:{},\r\n para:{}", "\u8f6c\u6362\u5e76\u5199\u5165\u6570\u636e", writer.getClass().toString(), params);
        ArrayList<Map<String, Object>> writerdatas = new ArrayList<Map<String, Object>>();
        int succ_num = 0;
        int fail_num = 0;
        int skip_num = 0;
        for (Map<String, Object> data : datas) {
            ProcessOneWriteBatchExecuter exec = (ProcessOneWriteBatchExecuter)SpringBeanFactory.getBean((String)"processonewritebatch", ProcessOneWriteBatchExecuter.class);
            int rtn = exec.processRow(datas, data, params, writerdatas, processlist, writer, complete, skiperr);
            if (rtn == 0) {
                ++skip_num;
                continue;
            }
            if (rtn == 1) {
                ++succ_num;
                if (biztimecol != null && data.get(biztimecol) != null) {
                    biztime = (Date)data.get(biztimecol);
                }
                if (bizutctimecol == null || data.get(bizutctimecol) == null) continue;
                bizutctime = (Long)data.get(bizutctimecol);
                continue;
            }
            if (rtn != -1) continue;
            ++fail_num;
        }
        end_time = System.currentTimeMillis();
        FutureJobLog.log("\u6267\u884c:{}\u5b8c\u6bd5,\u8017\u65f6{},\u603b\u6761\u6570{},\u6210\u529f\u6761\u6570{},\u5931\u8d25\u6761\u6570{},\u8df3\u8fc7\u6761\u6570", "\u8f6c\u6362\u6570\u636e", end_time - start_time, datas.size(), succ_num, fail_num, skip_num);
        this.batchIns(writerdatas, params, writer);
        DatabaseContextHolder.setDatabaseType("ompconfig");
        this.jobpara.uptJobsLasttime(jobname, biztime, bizutctime);
        return ReturnBiz.SUCCESS;
    }

    private void batchIns(List<Map<String, Object>> writerdatas, JSONObject params, DataWriter writer) throws Exception {
        long start_time = System.currentTimeMillis();
        writer.write(writerdatas, params, true);
        long end_time = System.currentTimeMillis();
        FutureJobLog.log("\u6267\u884c:{}\u5b8c\u6bd5,\u8017\u65f6{},\u6761\u6570{}", "\u5199\u5165\u6570\u636e", end_time - start_time, writerdatas.size());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public int processRow(List<Map<String, Object>> allData, Map<String, Object> data, JSONObject params, List<Map<String, Object>> writerdatas, List<DataProcessor> processlist, DataWriter writer, DataComplete complete, String skiperr) throws Exception {
        Map<String, Object> o_data = data;
        for (DataProcessor dp : processlist) {
            try {
                o_data = dp.process(allData, data, params);
            }
            catch (Exception e) {
                complete.fail(writerdatas, params, "row", "process:" + e.getMessage());
                FutureJobLog.log("process\u9519\u8bef:\r\n , \r\n para:{}, \r\n data:{}, \r\n error:{}", params, data, e.getMessage());
                if (!skiperr.equalsIgnoreCase("Y")) {
                    throw e;
                }
                return -1;
            }
        }
        if (o_data != null) {
            try {
                writerdatas.add(o_data);
                return 1;
            }
            catch (Exception e) {
                complete.fail(writerdatas, params, "row", "write:" + e.getMessage());
                FutureJobLog.log("writer\u9519\u8bef:\r\n , \r\n para:{}, \r\n data:{}, \r\n error:{}", params, o_data, e.getMessage());
                if (!skiperr.equalsIgnoreCase("Y")) {
                    throw e;
                }
                return -1;
            }
        }
        complete.fail(writerdatas, params, "row", "skip");
        FutureJobLog.log("process\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,\u8df3\u8fc7\u6b64\u6761\u8bb0\u5f55:\r\n , \r\n para:{}, \r\n data:{}", params, data);
        return 0;
    }
}

