/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.job.utils;

import com.alibaba.fastjson.JSONObject;
import com.efuture.appconfig.DatabaseContextHolder;
import com.efuture.job.utils.ColumnMapCaseRowMapper;
import com.efuture.job.utils.FutureJobLog;
import com.efuture.ocp.common.util.DateUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component(value="jobpara")
public class JobPara {
    public String PREFIX = "efuture.job.";
    public static final String DEFALT_DATE_PATTERN = "yyyy-MM-dd";
    public static final String DEFALT_MONTH_PATTERN = "yyyyMM";
    public static final String DEFALT_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    @Value(value="${efuture.omp.jobs.configdb:ompconfig}")
    public String configdb = "ompconfig";
    @Autowired
    private Environment env;
    @Autowired
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public Environment getEnv() {
        return this.env;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public Map<String, Object> getConfigFromDB(String jobName) {
        if (!DatabaseContextHolder.contains(this.configdb)) {
            FutureJobLog.log("\u6570\u636e\u6e90{}\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e", this.configdb);
            throw new RuntimeException("\u6570\u636e\u6e90" + this.configdb + "\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e");
        }
        DatabaseContextHolder.setDatabaseType(this.configdb);
        Map rtn = null;
        String sql = "select * from jobconfig where jobname= :jobname";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("jobname", jobName);
        List pararow = this.namedParameterJdbcTemplate.query(sql, paramMap, (RowMapper)new ColumnMapCaseRowMapper());
        if (pararow != null && pararow.size() > 0) {
            rtn = (Map)pararow.get(0);
        }
        return rtn;
    }

    public String getFromDb(String jobName, String paraCode) throws Exception {
        Map<String, Object> config = this.getConfigFromDB(jobName);
        String rtn = null;
        if (config.get(paraCode) != null) {
            rtn = config.get(paraCode).toString();
        }
        return rtn;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void uptJobsLasttime(String jobname, Date biztime, long bizutctime) {
        DatabaseContextHolder.setDatabaseType("ompconfig");
        String sql = "update jobconfig set lastexectime = :lastexectime,lastbiztime=:biztime,lastbizutctime=:bizutctime where jobname =:jobname";
        JSONObject para = new JSONObject();
        para.put("jobname", (Object)jobname);
        para.put("lastexectime", (Object)new Date());
        para.put("biztime", (Object)biztime);
        para.put("bizutctime", (Object)bizutctime);
        this.namedParameterJdbcTemplate.update(sql, (Map)para);
    }

    public JSONObject initGlobPara(JSONObject para) throws ParseException {
        JSONObject config_para_json;
        String jobname;
        Map<String, Object> config;
        JSONObject json_config;
        String config_para;
        Date curday;
        if (!para.containsKey((Object)"curday")) {
            String curdate = DateFormatUtils.format((Date)new Date(), (String)DEFALT_DATE_PATTERN);
            para.put("curday", (Object)curdate);
        }
        if (!para.containsKey((Object)"nextday")) {
            curday = DateUtils.parseDate((String)para.getString("curday"), (String[])new String[]{DEFALT_DATE_PATTERN});
            String nextday = DateFormatUtils.format((Date)DateUtils.addDays((Date)curday, (int)1), (String)DEFALT_DATE_PATTERN);
            para.put("nextday", (Object)nextday);
        }
        if (!para.containsKey((Object)"curdatetime")) {
            String curdatetime = DateFormatUtils.format((Date)new Date(), (String)DEFALT_DATETIME_PATTERN);
            para.put("curdatetime", (Object)curdatetime);
        }
        if (!para.containsKey((Object)"execmonth")) {
            curday = DateUtils.parseDate((String)para.getString("curday"), (String[])new String[]{DEFALT_DATE_PATTERN});
            String curdate = DateFormatUtils.format((Date)curday, (String)DEFALT_MONTH_PATTERN);
            para.put("execmonth", (Object)curdate);
        }
        if (!StringUtils.isEmpty((Object)(config_para = (json_config = (JSONObject)JSONObject.toJSON(config = this.getConfigFromDB(jobname = para.get((Object)"jobname").toString()))).getString("config_para"))) && (config_para_json = JSONObject.parseObject((String)config_para)) != null && config_para_json.size() > 0) {
            json_config.putAll((Map)config_para_json);
        }
        if (json_config != null) {
            para = this.getLastParaValue(para, (Map<String, Object>)json_config);
        }
        return para;
    }

    public JSONObject getLastParaValue(JSONObject inputPara, Map<String, Object> dbPara) {
        for (String key : dbPara.keySet()) {
            if (inputPara.containsKey((Object)key)) continue;
            String envkey = this.PREFIX + key;
            String envvalue = this.env.getProperty(envkey);
            if (envvalue != null && !StringUtils.isEmpty((Object)envvalue)) {
                inputPara.put(key, (Object)envvalue);
                continue;
            }
            inputPara.put(key, dbPara.get(key));
        }
        return inputPara;
    }

    public String getStepParaStr(JSONObject para, String step, String key, String defaultVal) {
        JSONObject step_json;
        String step_para = para.getString(step + "_para");
        if (para.containsKey((Object)key)) {
            return para.getString(key);
        }
        if (step_para != null && (step_json = JSONObject.parseObject((String)step_para)).containsKey((Object)key)) {
            return step_json.getString(key);
        }
        return defaultVal;
    }

    public JSONObject getStepPara(JSONObject para, String step) {
        JSONObject rtn = (JSONObject)para.clone();
        for (Map.Entry entry : para.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equalsIgnoreCase(step + "_para")) {
                String step_para = rtn.getString(step + "_para");
                if (step_para != null) {
                    for (Map.Entry entry_replace : para.entrySet()) {
                        String replace_key = (String)entry_replace.getKey();
                        String replace_value = para.getString(key);
                        step_para.replaceAll("#" + replace_key, replace_value);
                    }
                    rtn.put(step + "_para", (Object)step_para);
                } else {
                    FutureJobLog.log("\u6ca1\u6709\u53c2\u6570{}\u7684\u5b9a\u4e49", step + "_para");
                }
            }
            if ("init".equalsIgnoreCase(step)) {
                if (!key.startsWith("read_") && !key.startsWith("writer_") && !key.startsWith("complete_") && !key.startsWith("process_")) continue;
                rtn.remove((Object)key);
                continue;
            }
            if ("read".equalsIgnoreCase(step)) {
                if (!key.startsWith("init_") && !key.startsWith("writer_") && !key.startsWith("complete_") && !key.startsWith("process_")) continue;
                rtn.remove((Object)key);
                continue;
            }
            if ("process".equalsIgnoreCase(step)) {
                if (!key.startsWith("read_") && !key.startsWith("init_") && !key.startsWith("writer_") && !key.startsWith("complete_")) continue;
                rtn.remove((Object)key);
                continue;
            }
            if ("write".equalsIgnoreCase(step)) {
                if (!key.startsWith("init_") && !key.startsWith("read_") && !key.startsWith("complete_") && !key.startsWith("process_")) continue;
                rtn.remove((Object)key);
                continue;
            }
            if (!"complete".equalsIgnoreCase(step) || !key.startsWith("init_") && !key.startsWith("read_") && !key.startsWith("writer_") && !key.startsWith("process_")) continue;
            rtn.remove((Object)key);
        }
        return rtn;
    }

    public static interface STEP_TYPE {
        public static final String INIT = "init";
        public static final String READ = "read";
        public static final String PROCESSOR = "process";
        public static final String WRITE = "write";
        public static final String COMPLETE = "complete";
    }
}

