/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.job.utils;

import com.efuture.appconfig.DatabaseContextHolder;
import com.efuture.ocp.common.util.EnvironmentParaUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class SqlUtils {
    static boolean ibInit = false;
    public static Map<String, Map<String, String>> dbFunConfig = new HashMap<String, Map<String, String>>();

    public static String getDbtype() {
        return SqlUtils.getDbtype(DatabaseContextHolder.getDatabaseType());
    }

    public static String getDbtype(String dbkey) {
        String parakey = "efuture.dataSource." + dbkey + ".dbtype";
        return EnvironmentParaUtils.getEnvPra((String)parakey, (String)"mysql");
    }

    public static String getLimitSql(String sql, int limit) {
        String dbtype = SqlUtils.getDbtype();
        if (StringUtils.isEmpty((Object)dbtype)) {
            return sql;
        }
        if (dbtype.startsWith("mysql")) {
            return sql + " limit " + limit;
        }
        if (dbtype.startsWith("oracle")) {
            return "select * from ( " + sql + " ) where rownum <=" + limit;
        }
        return sql;
    }

    public static String getPageSql(String sql, int pageNo, int pageSize) {
        String dbtype = SqlUtils.getDbtype();
        if (StringUtils.isEmpty((Object)dbtype)) {
            return sql;
        }
        long startRowNO = pageSize * (pageNo - 1);
        long endRowNo = pageSize * pageNo;
        if (dbtype.startsWith("mysql")) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 14);
            sqlBuilder.append(sql);
            sqlBuilder.append(" limit " + startRowNO + "," + pageSize);
            return sqlBuilder.toString();
        }
        if (dbtype.startsWith("oracle")) {
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 120);
            sqlBuilder.append("select * from ( select tmp_page.*, rownum row_id from ( ");
            sqlBuilder.append(sql);
            sqlBuilder.append(" ) tmp_page where rownum <= " + endRowNo + " ) where row_id > " + startRowNO);
            return sqlBuilder.toString();
        }
        return sql;
    }

    public static String ReplaceSqlParam(String sqlStr, Map<String, Object> param) {
        for (String key : param.keySet()) {
            String replaceKey = "#" + key;
            if (param.get(key) == null) continue;
            sqlStr = sqlStr.replaceAll(replaceKey, param.get(key).toString());
        }
        return sqlStr;
    }

    public static String ReplaceSqlFunctionForDB(String sql) {
        String dbtype = SqlUtils.getDbtype();
        return SqlUtils.ReplaceSqlFunctionForDB(sql, dbtype);
    }

    public static String ReplaceSqlFunctionForDB(String sql, String dbtype) {
        Map<String, String> dbfun;
        if (!ibInit) {
            SqlUtils.init();
        }
        if ((dbfun = dbFunConfig.get(dbtype)) == null) {
            return sql;
        }
        for (String key : dbfun.keySet()) {
            if (dbfun.get(key) == null) continue;
            String value = dbfun.get(key).toString();
            sql = sql.replaceAll(key, value);
        }
        return sql;
    }

    private static void processProperties(Properties props, String dbkey) throws BeansException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (Object key : props.keySet()) {
            String keyStr = "#" + key.toString();
            try {
                propertiesMap.put(keyStr, new String(props.getProperty(key.toString()).getBytes("ISO-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dbFunConfig.put(dbkey, propertiesMap);
    }

    private static synchronized void init() {
        if (!ibInit) {
            try {
                Properties mysqlproperties = PropertiesLoaderUtils.loadAllProperties((String)"sqlfunc_mysql.properties");
                SqlUtils.processProperties(mysqlproperties, "mysql");
                Properties oracleproperties = PropertiesLoaderUtils.loadAllProperties((String)"sqlfunc_oracle.properties");
                SqlUtils.processProperties(oracleproperties, "oracle");
                ibInit = true;
            }
            catch (IOException e) {
                ibInit = false;
            }
        }
    }
}

