/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omp.event.model.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.annotation.CheckRepeatAnnotation;
import com.efuture.ocp.common.component.BaseService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.slice.filter.SliceBase;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.HttpUtils;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.PrecisionUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.parser.QueryExtractor;
import com.efuture.omp.event.model.component.PopModelSliceBase;
import com.efuture.omp.event.model.intf.CallbackStatis;
import com.xxl.job.core.log.XxlJobLogger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.time.DateUtils;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="efuture.omp.event.popmodel.statis")
public class ModelEventStatis
extends PopModelSliceBase {
    protected static ExecutorService executor = Executors.newFixedThreadPool(20);
    final String parentsvr = "omp.coupongain.chkexchange";

    public static ModelEventStatis getInstance() {
        return (ModelEventStatis)((Object)SpringBeanFactory.getBean((String)"efuture.omp.event.popmodel.statis", ModelEventStatis.class));
    }

    private boolean containsMapValue(List<Map<String, Object>> list, String key) {
        for (Map<String, Object> row : list) {
            if (!row.containsValue(key)) continue;
            return true;
        }
        return false;
    }

    private String isMatch(String sys, String ver, String cnt) {
        if (sys.startsWith("today") || sys.startsWith("event")) {
            return ver.trim().equalsIgnoreCase(cnt.trim()) ? "Y" : "N";
        }
        if (sys.startsWith("m$")) {
            return ver.trim().equalsIgnoreCase(cnt.trim()) ? "Y" : "N";
        }
        if (sys.startsWith("nosend")) {
            return ver.equals("0") ? "Y" : "N";
        }
        return "";
    }

    private String isMatchFormat(String sys, String ver, String cnt) {
        String match = this.isMatch(sys, ver, cnt);
        if (!StringUtils.isEmpty((Object)match)) {
            return "  " + match + "  ";
        }
        return "     ";
    }

    private String getEventVersion() throws Exception {
        String url = RestClientUtils.getRestUtils().queryServiceURI("omp.event.version");
        if (StringUtils.isEmpty((Object)url)) {
            return "";
        }
        String fullVer = HttpUtils.getRequest((String)url);
        return fullVer;
    }

    private String BreakLine(int[] colWidth) {
        String result = " +";
        for (int width : colWidth) {
            result = result.concat(DataUtils.lpad((String)"+", (int)(width + 3), (char)'-'));
        }
        return result.concat("\r\n");
    }

    private String splitMarket(long ent_id, String marketAndNode) {
        if (this.isReadSlice()) {
            String slice = marketAndNode.substring(marketAndNode.indexOf("-") + 1, marketAndNode.length());
            List<String> list_org = this.getOrgCodesBySlice(ent_id, slice);
            if (list_org == null || list_org.size() <= 0) {
                return "''";
            }
            StringJoiner joiner = new StringJoiner(",");
            for (String org : list_org) {
                joiner.add("'".concat(org).concat("'"));
            }
            return joiner.toString();
        }
        if (marketAndNode.indexOf("-") > 0) {
            return "'".concat(marketAndNode.substring(0, marketAndNode.indexOf("-"))).concat("'");
        }
        return "'".concat(marketAndNode).concat("'");
    }

    @AutoCache(Service="OMP", KeyArgIndex=99, KeyName="1,2", TimeOut=1800)
    public Map<String, Object> queryModelStatis(FMybatisTemplate storage, String statement, Map<String, Object> para) {
        return (Map)storage.getSqlSessionTemplate().selectOne(statement, para);
    }

    @AutoCache(Service="OMP", KeyArgIndex=99, KeyName="0,1", TimeOut=300)
    public Map<String, Object> queryModelStatisBatch(String statement, Map<String, Object> para) {
        return (Map)((FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class)).getSqlSessionTemplate().selectOne(statement, para);
    }

    @AutoCache(Service="OMP", KeyArgIndex=99, KeyName="1,2", TimeOut=1800)
    public Map<String, Object> queryModelStatis(FMybatisTemplate storage, String statement, String para) {
        return (Map)storage.getSqlSessionTemplate().selectOne(statement, (Object)para);
    }

    @CheckRepeatAnnotation(KeyArgIndex=1)
    public String get(ServiceSession session, JSONObject jsonparam) throws Exception {
        Map row;
        Iterator iterator;
        Object dbstatus;
        int[] colWidth = new int[]{12, 24, 32, 24, 12, 5};
        long start = System.currentTimeMillis();
        SimpleDateFormat dateful = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sb = new StringBuffer();
        sb.append("\r\n");
        JSONObject data = this.doGet(session, jsonparam);
        int marketCnt = 0;
        if (data.containsKey((Object)"model")) {
            dbstatus = (Map)data.get((Object)"model");
            if (dbstatus != null && dbstatus.size() > 0) {
                sb.append(" \u524d\u7f6e\u548cIDC\u6a21\u578b\u5bf9\u6bd4\u60c5\u51b5(\u6628\u65e5+\u4eca\u65e5)\uff1a\r\n");
                sb.append(this.BreakLine(colWidth));
                sb.append(" | ").append(DataUtils.rpad((String)"Market", (int)colWidth[0], (char)' '));
                sb.append(" | ").append(DataUtils.rpad((String)"Key", (int)colWidth[1], (char)' '));
                sb.append(" | ").append(DataUtils.rpad((String)"Value", (int)colWidth[2], (char)' '));
                sb.append(" | ").append(DataUtils.rpad((String)"UpdateDate", (int)colWidth[3], (char)' '));
                sb.append(" | ").append(DataUtils.rpad((String)"IDC", (int)colWidth[4], (char)' '));
                sb.append(" | ").append(DataUtils.rpad((String)"Match", (int)colWidth[5], (char)' '));
                sb.append(" | ").append("\r\n");
                sb.append(this.BreakLine(colWidth));
                for (Map.Entry entry : dbstatus.entrySet()) {
                    String market = (String)entry.getKey();
                    JSONArray value = (JSONArray)entry.getValue();
                    for (int i = 0; i < value.size(); ++i) {
                        Map row2 = (Map)value.get(i);
                        sb.append(" | ").append(DataUtils.rpad((String)MapUtils.getString((Map)row2, (String)"market", (String)""), (int)colWidth[0], (char)' '));
                        sb.append(" | ").append(DataUtils.rpad((String)MapUtils.getString((Map)row2, (String)"sys", (String)""), (int)colWidth[1], (char)' '));
                        sb.append(" | ").append(DataUtils.lpad((String)MapUtils.getString((Map)row2, (String)"ver", (String)""), (int)colWidth[2], (char)' '));
                        sb.append(" | ").append(DataUtils.rpad((String)MapUtils.getString((Map)row2, (String)"senddate", (String)""), (int)colWidth[3], (char)' '));
                        sb.append(" | ").append(DataUtils.lpad((String)MapUtils.getString((Map)row2, (String)"cnt", (String)""), (int)colWidth[4], (char)' '));
                        sb.append(" | ").append(this.isMatchFormat(MapUtils.getString((Map)row2, (String)"sys", (String)""), MapUtils.getString((Map)row2, (String)"ver", (String)""), MapUtils.getString((Map)row2, (String)"cnt", (String)"")));
                        sb.append(" | ").append("\r\n");
                    }
                    sb.append(this.BreakLine(colWidth));
                }
            }
            marketCnt = dbstatus.size();
        }
        if (data.containsKey((Object)"version") && (dbstatus = (List)data.get((Object)"version")) != null && dbstatus.size() > 0) {
            sb.append(" \u524d\u7f6e\u673a\u670d\u52a1\u7248\u672c(IDC: " + MapUtils.getString((Map)((Map)dbstatus.get(0)), (String)"cnt", (String)"") + " )\uff1a\r\n");
            sb.append(this.BreakLine(colWidth));
            sb.append(" | ").append(DataUtils.rpad((String)"Market", (int)colWidth[0], (char)' '));
            sb.append(" | ").append(DataUtils.rpad((String)"Key", (int)colWidth[1], (char)' '));
            sb.append(" | ").append(DataUtils.rpad((String)"Value", (int)colWidth[2], (char)' '));
            sb.append(" | ").append(DataUtils.rpad((String)"UpdateDate", (int)colWidth[3], (char)' '));
            sb.append(" | ").append(DataUtils.rpad((String)"IDC", (int)colWidth[4], (char)' '));
            sb.append(" | ").append(DataUtils.rpad((String)"Match", (int)colWidth[5], (char)' '));
            sb.append(" | ").append("\r\n");
            sb.append(this.BreakLine(colWidth));
            iterator = dbstatus.iterator();
            while (iterator.hasNext()) {
                row = (Map)((Object)iterator.next());
                sb.append(" | ").append(DataUtils.rpad((String)MapUtils.getString((Map)row, (String)"market", (String)""), (int)colWidth[0], (char)' '));
                sb.append(" | ").append(DataUtils.rpad((String)MapUtils.getString((Map)row, (String)"sys", (String)""), (int)colWidth[1], (char)' '));
                sb.append(" | ").append(DataUtils.lpad((String)MapUtils.getString((Map)row, (String)"ver", (String)""), (int)colWidth[2], (char)' '));
                sb.append(" | ").append(DataUtils.rpad((String)MapUtils.getString((Map)row, (String)"senddate", (String)""), (int)colWidth[3], (char)' '));
                sb.append(" | ").append(DataUtils.lpad((String)" ", (int)colWidth[4], (char)' '));
                sb.append(" | ").append(this.isMatchFormat(MapUtils.getString((Map)row, (String)"sys", (String)""), MapUtils.getString((Map)row, (String)"ver", (String)""), MapUtils.getString((Map)row, (String)"cnt", (String)"")));
                sb.append(" | ").append("\r\n");
            }
            sb.append(this.BreakLine(colWidth));
        }
        if (data.containsKey((Object)"nosend") && (dbstatus = (List)data.get((Object)"nosend")) != null && dbstatus.size() > 0) {
            sb.append(" \u672a\u53d1\u9001\u8ba2\u5355\uff1a\r\n");
            sb.append(this.BreakLine(colWidth));
            sb.append(" | ").append(DataUtils.rpad((String)"Market", (int)colWidth[0], (char)' '));
            sb.append(" | ").append(DataUtils.rpad((String)"Key", (int)colWidth[1], (char)' '));
            sb.append(" | ").append(DataUtils.rpad((String)"Value", (int)colWidth[2], (char)' '));
            sb.append(" | ").append(DataUtils.rpad((String)"UpdateDate", (int)colWidth[3], (char)' '));
            sb.append(" | ").append(DataUtils.rpad((String)"IDC", (int)colWidth[4], (char)' '));
            sb.append(" | ").append(DataUtils.rpad((String)"Match", (int)colWidth[5], (char)' '));
            sb.append(" | ").append("\r\n");
            sb.append(this.BreakLine(colWidth));
            iterator = dbstatus.iterator();
            while (iterator.hasNext()) {
                row = (Map)((Object)iterator.next());
                sb.append(" | ").append(DataUtils.rpad((String)MapUtils.getString((Map)row, (String)"market", (String)""), (int)colWidth[0], (char)' '));
                sb.append(" | ").append(DataUtils.rpad((String)MapUtils.getString((Map)row, (String)"sys", (String)""), (int)colWidth[1], (char)' '));
                sb.append(" | ").append(DataUtils.lpad((String)MapUtils.getString((Map)row, (String)"ver", (String)""), (int)colWidth[2], (char)' '));
                sb.append(" | ").append(DataUtils.rpad((String)MapUtils.getString((Map)row, (String)"senddate", (String)""), (int)colWidth[3], (char)' '));
                sb.append(" | ").append(DataUtils.lpad((String)" ", (int)colWidth[4], (char)' '));
                sb.append(" | ").append(this.isMatchFormat(MapUtils.getString((Map)row, (String)"sys", (String)""), MapUtils.getString((Map)row, (String)"ver", (String)""), ""));
                sb.append(" | ").append("\r\n");
            }
            sb.append(this.BreakLine(colWidth));
        }
        Double elapsed = PrecisionUtils.doubleConvert((double)PrecisionUtils.div((double)(System.currentTimeMillis() - start), (double)1000.0), (int)3);
        sb.append("\r\n").append(" \u68c0\u67e5\u95e8\u5e97\uff1a").append(String.valueOf(marketCnt));
        sb.append("\r\n").append(" \u6267\u884c\u65f6\u95f4\uff1a").append(dateful.format(new Date()));
        sb.append("\r\n").append("     \u8017\u65f6\uff1a").append(String.valueOf(elapsed));
        sb.append("\r\n\r\n");
        return sb.toString();
    }

    public ServiceResponse getstatis(ServiceSession session, JSONObject jsonparam) throws Exception {
        return ServiceResponse.buildSuccess((Object)this.doGet(session, jsonparam));
    }

    public ServiceResponse getFrontNodes(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject json = new JSONObject();
        HashMap<String, Object> param = new HashMap<String, Object>();
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        if (jsonparam.containsKey((Object)"market_name")) {
            param.put("marketname", "%" + jsonparam.get((Object)"market_name") + "%");
        }
        if (jsonparam.containsKey((Object)"front_id")) {
            param.put("market", jsonparam.get((Object)"front_id"));
        }
        if (jsonparam.containsKey((Object)"market")) {
            param.put("market", jsonparam.get((Object)"market"));
        }
        List dbconfig = storage.getSqlSessionTemplate().selectList("mybatis.model.select_dbconfig", param);
        json.put("idcFront", (Object)dbconfig);
        return ServiceResponse.buildSuccess((Object)json);
    }

    public ServiceResponse compare(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject node;
        String front_id;
        JSONObject row;
        int i;
        this.checkPara(session, jsonparam);
        String marketList = null;
        JSONObject jsonData = new JSONObject();
        if (jsonparam.containsKey((Object)"front_id") && jsonparam.get((Object)"front_id") instanceof JSONArray) {
            JSONArray list = jsonparam.getJSONArray("front_id");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String front = list.getString(i2);
                marketList = StringUtils.isEmpty(marketList) ? "'" + front + "'" : marketList + ",'" + front + "'";
            }
            if (!StringUtils.isEmpty(marketList)) {
                marketList = "(" + marketList + ")";
                jsonparam.put("marketlist", (Object)marketList);
            }
        } else if (jsonparam.containsKey((Object)"front_id") && !StringUtils.isEmpty((Object)jsonparam.get((Object)"front_id"))) {
            String[] frontIdArr;
            for (String front : frontIdArr = jsonparam.getString("front_id").split(",")) {
                marketList = StringUtils.isEmpty((Object)marketList) ? "'" + front + "'" : marketList + ",'" + front + "'";
            }
            if (!StringUtils.isEmpty(marketList)) {
                marketList = "(" + marketList + ")";
                jsonparam.put("marketlist", (Object)marketList);
            }
        }
        JSONObject json = this.doGet(session, jsonparam);
        HashMap<String, JSONObject> compare = new HashMap<String, JSONObject>();
        if (json.containsKey((Object)"version")) {
            JSONArray versions = json.getJSONArray("version");
            for (i = 0; i < versions.size(); ++i) {
                row = versions.getJSONObject(i);
                front_id = DataUtils.getJsonData((JSONObject)row, (String)"market", (boolean)true, (String)"");
                if (compare.containsKey(front_id)) {
                    ((JSONObject)compare.get(front_id)).put("application", (Object)DataUtils.getJsonData((JSONObject)row, (String)"ver", (boolean)false, (String)""));
                    ((JSONObject)compare.get(front_id)).put("application_is_match", (Object)DataUtils.getJsonData((JSONObject)row, (String)"match", (boolean)true, (String)""));
                    continue;
                }
                node = new JSONObject();
                node.put("ip", (Object)DataUtils.getJsonData((JSONObject)row, (String)"ip", (boolean)true, (String)""));
                node.put("front_id", (Object)DataUtils.getJsonData((JSONObject)row, (String)"market", (boolean)true, (String)""));
                node.put("front_name", (Object)DataUtils.getJsonData((JSONObject)row, (String)"market_name", (boolean)false, (String)""));
                node.put("senddate", (Object)DataUtils.getJsonData((JSONObject)row, (String)"senddate", (boolean)true, (String)""));
                node.put("application", (Object)DataUtils.getJsonData((JSONObject)row, (String)"ver", (boolean)false, (String)""));
                node.put("application_is_match", (Object)DataUtils.getJsonData((JSONObject)row, (String)"match", (boolean)true, (String)""));
                compare.put(front_id, node);
            }
        }
        if (json.containsKey((Object)"nosend")) {
            JSONArray nosends = json.getJSONArray("nosend");
            for (i = 0; i < nosends.size(); ++i) {
                row = nosends.getJSONObject(i);
                front_id = DataUtils.getJsonData((JSONObject)row, (String)"market", (boolean)true, (String)"");
                if (compare.containsKey(front_id)) {
                    ((JSONObject)compare.get(front_id)).put("nosend_orders", (Object)DataUtils.getJsonData((JSONObject)row, (String)"ver", (boolean)true, (String)""));
                    continue;
                }
                node = new JSONObject();
                node.put("ip", (Object)DataUtils.getJsonData((JSONObject)row, (String)"ip", (boolean)true, (String)""));
                node.put("front_id", (Object)DataUtils.getJsonData((JSONObject)row, (String)"market", (boolean)true, (String)""));
                node.put("front_name", (Object)DataUtils.getJsonData((JSONObject)row, (String)"market_name", (boolean)false, (String)""));
                node.put("senddate", (Object)DataUtils.getJsonData((JSONObject)row, (String)"senddate", (boolean)true, (String)""));
                node.put("nosend_orders", (Object)DataUtils.getJsonData((JSONObject)row, (String)"ver", (boolean)true, (String)""));
                compare.put(front_id, node);
            }
        }
        if (json.containsKey((Object)"model")) {
            Map models = (Map)json.get((Object)"model");
            for (Map.Entry entry : models.entrySet()) {
                if (!compare.containsKey(entry.getKey())) {
                    JSONObject node2 = new JSONObject();
                    node2.put("ip", (Object)DataUtils.getJsonData((JSONObject)((JSONArray)entry.getValue()).getJSONObject(0), (String)"ip", (boolean)true, (String)""));
                    node2.put("front_id", (Object)DataUtils.getJsonData((JSONObject)((JSONArray)entry.getValue()).getJSONObject(0), (String)"market", (boolean)true, (String)""));
                    node2.put("front_name", (Object)DataUtils.getJsonData((JSONObject)((JSONArray)entry.getValue()).getJSONObject(0), (String)"market_name", (boolean)false, (String)""));
                    compare.put((String)entry.getKey(), node2);
                }
                HashMap<String, String> colMap = new HashMap<String, String>();
                colMap.put("compare_key", "sys");
                colMap.put("qty_front", "ver");
                colMap.put("qty_idc", "cnt");
                colMap.put("model_is_match", "match");
                JSONArray rows = DataUtils.copyArray((JSONArray)((JSONArray)entry.getValue()), colMap);
                ((JSONObject)compare.get(entry.getKey())).put("model", (Object)rows);
            }
        }
        JSONArray result = new JSONArray();
        for (Map.Entry entry : compare.entrySet()) {
            result.add(entry.getValue());
        }
        jsonData.put("idcFront", (Object)result);
        return ServiceResponse.buildSuccess((Object)jsonData);
    }

    private JSONObject doGet(ServiceSession session, JSONObject jsonparam) throws Exception {
        if ("Y".equalsIgnoreCase(DataUtils.getJsonData((JSONObject)jsonparam, (String)"batch", (boolean)false, (String)"Y"))) {
            return this.doGetStatisBatch(session, jsonparam);
        }
        return this.doGetStatis(session, jsonparam);
    }

    private JSONObject doGetStatis(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject result = new JSONObject();
        String paraMarket = DataUtils.getJsonData((JSONObject)jsonparam, (String)"market", (boolean)false, (String)"");
        SimpleDateFormat datefmt = new SimpleDateFormat("yyyy-MM-dd");
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("saledate", datefmt.format(DateUtils.addDays((Date)new Date(), (int)-1)));
        param.put("filedate", datefmt.format(new Date()));
        if (!StringUtils.isEmpty((Object)paraMarket)) {
            param.put("market", paraMarket);
        }
        if (!StringUtils.isEmpty((Object)jsonparam)) {
            if (jsonparam.containsKey((Object)"marketlist")) {
                param.put("marketlist", jsonparam.getString("marketlist"));
            }
            if (jsonparam.containsKey((Object)"front_name")) {
                param.put("marketname", "%" + jsonparam.get((Object)"front_name") + "%");
            }
        }
        param.put("searchkey", "%m$%");
        List dbstatus = storage.getSqlSessionTemplate().selectList("mybatis.model.select_dbstatus", param);
        if (dbstatus != null && dbstatus.size() > 0) {
            HashMap<String, JSONArray> model = new HashMap<String, JSONArray>();
            for (Object row : dbstatus) {
                String market = MapUtils.getString((Map)row, (String)"market");
                String table = MapUtils.getString((Map)row, (String)"sys");
                HashMap<String, Object> para = new HashMap<String, Object>();
                para.put("ent_id", session.getEnt_id());
                para.put("market", this.splitMarket(session.getEnt_id(), market));
                para.put("saledate", datefmt.format(new Date()));
                para.put("prevdate", datefmt.format(DateUtils.addDays((Date)new Date(), (int)-1)));
                Map<Object, Object> res = new HashMap();
                if ("m$events".equalsIgnoreCase(table)) {
                    res = ModelEventStatis.getInstance().queryModelStatis(storage, "mybatis.model.select_cnts_event", para);
                } else if ("m$eventscopeitem".equalsIgnoreCase(table)) {
                    res = ModelEventStatis.getInstance().queryModelStatis(storage, "mybatis.model.select_cnts_items", para);
                } else if ("today_m$events".equalsIgnoreCase(table)) {
                    res = ModelEventStatis.getInstance().queryModelStatis(storage, "mybatis.model.select_cnts_event_today", para);
                } else if ("today_m$eventscopeitem".equalsIgnoreCase(table)) {
                    res = ModelEventStatis.getInstance().queryModelStatis(storage, "mybatis.model.select_cnts_items_today", para);
                } else if ("m$eventpolicynopay".equalsIgnoreCase(table)) {
                    res = ModelEventStatis.getInstance().queryModelStatis(storage, "mybatis.sql.select", "select count(*) cnt from m$eventpolicynopay");
                } else if ("m$tagrely".equalsIgnoreCase(table)) {
                    res = ModelEventStatis.getInstance().queryModelStatis(storage, "mybatis.sql.select", "select count(*) cnt from m$tagrely");
                } else if ("m$eventscopeorg".equalsIgnoreCase(table)) {
                    res = ModelEventStatis.getInstance().queryModelStatis(storage, "mybatis.model.select_cnts_orgs", para);
                } else {
                    para.put("table_name", table);
                    res = ModelEventStatis.getInstance().queryModelStatis(storage, "mybatis.model.select_cnts_others", para);
                }
                row.put("cnt", MapUtils.getString(res, (String)"cnt", (String)""));
                row.put("match", this.isMatch(MapUtils.getString((Map)row, (String)"sys", (String)""), MapUtils.getString((Map)row, (String)"ver", (String)""), MapUtils.getString(res, (String)"cnt", (String)"")));
                if (model.containsKey(market)) {
                    ((JSONArray)model.get(market)).add(row);
                    continue;
                }
                JSONArray dummy = new JSONArray();
                dummy.add(row);
                model.put(market, dummy);
            }
            if (model.size() > 0) {
                result.put("model", model);
            }
        }
        param.put("searchkey", "event%");
        dbstatus = storage.getSqlSessionTemplate().selectList("mybatis.model.select_dbstatus", param);
        if (dbstatus != null && dbstatus.size() > 0) {
            JSONArray version = new JSONArray();
            String idc = this.getEventVersion();
            for (Map row : dbstatus) {
                row.put("cnt", idc);
                row.put("match", this.isMatch(MapUtils.getString((Map)row, (String)"sys", (String)""), MapUtils.getString((Map)row, (String)"ver", (String)""), idc));
                version.add((Object)row);
            }
            if (version.size() > 0) {
                result.put("version", (Object)version);
            }
        }
        param.put("searchkey", "nosend%");
        dbstatus = storage.getSqlSessionTemplate().selectList("mybatis.model.select_dbstatus", param);
        if (dbstatus != null && dbstatus.size() > 0) {
            JSONArray nosend = new JSONArray();
            for (Object row : dbstatus) {
                row.put("cnt", 0);
                row.put("match", this.isMatch(MapUtils.getString((Map)row, (String)"sys", (String)""), MapUtils.getString((Map)row, (String)"ver", (String)""), "0"));
                nosend.add(row);
            }
            if (nosend.size() > 0) {
                result.put("nosend", (Object)nosend);
            }
        }
        return result;
    }

    private JSONObject doGetStatisBatch(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject result = new JSONObject();
        String paraMarket = DataUtils.getJsonData((JSONObject)jsonparam, (String)"market", (boolean)false, (String)"");
        SimpleDateFormat datefmt = new SimpleDateFormat("yyyy-MM-dd");
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("saledate", datefmt.format(DateUtils.addDays((Date)new Date(), (int)-1)));
        param.put("filedate", datefmt.format(new Date()));
        if (!StringUtils.isEmpty((Object)paraMarket)) {
            param.put("market", paraMarket);
        }
        if (!StringUtils.isEmpty((Object)jsonparam)) {
            if (jsonparam.containsKey((Object)"marketlist")) {
                param.put("marketlist", jsonparam.getString("marketlist"));
            }
            if (jsonparam.containsKey((Object)"front_name")) {
                param.put("marketname", "%" + jsonparam.get((Object)"front_name") + "%");
            }
        }
        param.put("searchkey", "%m$%");
        List dbstatus = storage.getSqlSessionTemplate().selectList("mybatis.model.select_dbstatus", param);
        if (dbstatus != null && dbstatus.size() > 0) {
            String table;
            String market;
            Map<String, String> mkt_evts = new HashMap<String, String>();
            for (Object row : dbstatus) {
                if (!"m$events".equalsIgnoreCase(MapUtils.getString((Map)row, (String)"sys"))) continue;
                mkt_evts.put(this.splitMarket(session.getEnt_id(), MapUtils.getString((Map)row, (String)"market")), null);
            }
            mkt_evts = this.preProcessEventList(session.getEnt_id(), datefmt.format(new Date()), mkt_evts);
            HashMap<String, JSONArray> model = new HashMap<String, JSONArray>();
            for (Map row : dbstatus) {
                market = MapUtils.getString((Map)row, (String)"market");
                table = MapUtils.getString((Map)row, (String)"sys");
                String realmkt = this.splitMarket(session.getEnt_id(), market);
                HashMap<String, Object> para = new HashMap<String, Object>();
                para.put("ent_id", session.getEnt_id());
                para.put("market", realmkt);
                para.put("saledate", datefmt.format(new Date()));
                para.put("prevdate", datefmt.format(DateUtils.addDays((Date)new Date(), (int)-1)));
                if (mkt_evts != null && mkt_evts.containsKey(realmkt)) {
                    para.put("event_list", mkt_evts.get(realmkt));
                }
                HashMap res = new HashMap();
                String statement = "mybatis.model.batch.";
                if ("m$events".equalsIgnoreCase(table)) {
                    statement = statement.concat("select_cnts_event");
                } else if ("m$eventscopeitem".equalsIgnoreCase(table)) {
                    statement = statement.concat("select_cnts_items");
                } else if ("today_m$events".equalsIgnoreCase(table)) {
                    statement = statement.concat("select_cnts_event_today");
                } else if ("today_m$eventscopeitem".equalsIgnoreCase(table)) {
                    statement = statement.concat("select_cnts_items_today");
                } else if ("m$eventpolicynopay".equalsIgnoreCase(table)) {
                    statement = statement.concat("select");
                    para.put("sql", "select count(*) cnt from m$eventpolicynopay");
                } else if ("m$tagrely".equalsIgnoreCase(table)) {
                    statement = statement.concat("select");
                    para.put("sql", "select count(*) cnt from m$tagrely");
                } else if ("m$eventscopeorg".equalsIgnoreCase(table)) {
                    statement = statement.concat("select_cnts_orgs");
                } else {
                    statement = statement.concat("select_cnts_others");
                    para.put("table_name", table);
                }
                row.put("task", this.addToTask(statement, para, new CallbackStatis(){

                    @Override
                    public Map<String, Object> execute(String statement, Map<String, Object> para) throws Exception {
                        return ModelEventStatis.getInstance().queryModelStatisBatch(statement, para);
                    }
                }));
            }
            for (Map row : dbstatus) {
                market = MapUtils.getString((Map)row, (String)"market");
                table = MapUtils.getString((Map)row, (String)"sys");
                Map res = (Map)((FutureTask)row.get("task")).get();
                row.put("cnt", MapUtils.getString((Map)res, (String)"cnt", (String)""));
                row.put("match", this.isMatch(MapUtils.getString((Map)row, (String)"sys", (String)""), MapUtils.getString((Map)row, (String)"ver", (String)""), MapUtils.getString((Map)res, (String)"cnt", (String)"")));
                if (model.containsKey(market)) {
                    ((JSONArray)model.get(market)).add((Object)row);
                    continue;
                }
                model.put(market, DataUtils.AddToArray((Object)row));
            }
            if (model.size() > 0) {
                result.put("model", model);
            }
        }
        param.put("searchkey", "event%");
        dbstatus = storage.getSqlSessionTemplate().selectList("mybatis.model.select_dbstatus", param);
        if (dbstatus != null && dbstatus.size() > 0) {
            JSONArray version = new JSONArray();
            String idc = this.getEventVersion();
            for (Map row : dbstatus) {
                row.put("cnt", idc);
                row.put("match", this.isMatch(MapUtils.getString((Map)row, (String)"sys", (String)""), MapUtils.getString((Map)row, (String)"ver", (String)""), idc));
                version.add((Object)row);
            }
            if (version.size() > 0) {
                result.put("version", (Object)version);
            }
        }
        param.put("searchkey", "nosend%");
        dbstatus = storage.getSqlSessionTemplate().selectList("mybatis.model.select_dbstatus", param);
        if (dbstatus != null && dbstatus.size() > 0) {
            JSONArray nosend = new JSONArray();
            for (Object row : dbstatus) {
                row.put("cnt", 0);
                row.put("match", this.isMatch(MapUtils.getString((Map)row, (String)"sys", (String)""), MapUtils.getString((Map)row, (String)"ver", (String)""), "0"));
                nosend.add(row);
            }
            if (nosend.size() > 0) {
                result.put("nosend", (Object)nosend);
            }
        }
        return result;
    }

    public String selectEventList(Map<String, Object> para) {
        List list = ((FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class)).getSqlSessionTemplate().selectList("mybatis.model.batch.select_event_ids", para);
        if (list == null || list.size() <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Map map : list) {
            sb.append(String.valueOf(map.get("eid"))).append(",");
        }
        return sb.toString().substring(0, sb.toString().length() - 1).concat(")");
    }

    private FutureTask<Map<String, Object>> addToTask(String statement, Map<String, Object> para, CallbackStatis callback) {
        TaskThread run = new TaskThread(callback, statement, para);
        FutureTask<Map<String, Object>> futureTask = new FutureTask<Map<String, Object>>(run);
        executor.submit(futureTask);
        return futureTask;
    }

    private Map<String, String> preProcessEventList(long ent_id, String saleDate, Map<String, String> mkt_evts) throws Exception {
        HashMap<String, FutureTask<String>> map_Task = new HashMap<String, FutureTask<String>>();
        for (Map.Entry<String, String> entry : mkt_evts.entrySet()) {
            CalcThread run = new CalcThread(ent_id, saleDate, entry.getKey());
            FutureTask<String> futureTask = new FutureTask<String>(run);
            executor.submit(futureTask);
            map_Task.put(entry.getKey(), futureTask);
        }
        for (Map.Entry<String, String> entry : map_Task.entrySet()) {
            mkt_evts.put(entry.getKey(), (String)((FutureTask)((Object)entry.getValue())).get());
        }
        return mkt_evts;
    }

    public void send(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (this.isWriteSlice()) {
            String current = SliceBase.getCurrentSlice();
            Set slice_list = SliceBase.getAllSlice();
            if (slice_list == null || slice_list.size() <= 0) {
                return;
            }
            for (String slice : slice_list) {
                try {
                    XxlJobLogger.log((String)"\u5f00\u59cb\u5904\u7406\u5207\u7247\u6570\u636e\uff1a{}", (Object[])new Object[]{slice});
                    SliceBase.setCurrentSlice((String)slice);
                    jsonparam.put("node", (Object)slice);
                    this.sendCore(session, jsonparam);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            SliceBase.setCurrentSlice((String)current);
        } else {
            this.sendCore(session, jsonparam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCore(ServiceSession session, JSONObject jsonparam) throws Exception {
        long ent_id = DataUtils.getJsonData((JSONObject)jsonparam, (String)"ent_id", (boolean)false, (int)0);
        String market = Utils.getEnvValue((String)DataUtils.getJsonData((JSONObject)jsonparam, (String)"store", (boolean)true, (String)""));
        String svr = DataUtils.getJsonData((JSONObject)jsonparam, (String)"sendUrl", (boolean)false, (String)"omp.coupongain.chkexchange");
        String node = DataUtils.getJsonData((JSONObject)jsonparam, (String)"node", (boolean)false, (String)"");
        int checkLevel = DataUtils.getJsonData((JSONObject)jsonparam, (String)"checkLevel", (boolean)false, (int)5);
        if (!svr.startsWith("http") && StringUtils.isEmpty((Object)RestClientUtils.getRestUtils().queryServiceURI(svr))) {
            XxlJobLogger.log((String)"\u670d\u52a1\u5730\u5740\u672a\u914d\u7f6e\uff0c\u4e0d\u542f\u52a8\uff01", (Object[])new Object[0]);
            return;
        }
        FMybatisTemplate storage = null;
        try {
            storage = (FMybatisTemplate)this.getStorageOperations();
            JSONObject calc_order = new JSONObject();
            calc_order.put("billno", (Object)UniqueID.getHostIP());
            if (StringUtils.isEmpty((Object)node)) {
                calc_order.put("market", (Object)market);
            } else {
                calc_order.put("market", (Object)market.concat("-").concat(node));
            }
            JSONArray sell_details = new JSONArray();
            if (!"0".equalsIgnoreCase(market)) {
                JSONObject self = new JSONObject();
                self.put("itemcode", (Object)"event");
                self.put("barcode", (Object)this.getEventVersion());
                self.put("itemname", (Object)UniqueID.getInstance().getHostId());
                sell_details.add((Object)self);
            }
            SimpleDateFormat datefmt = new SimpleDateFormat("yyyy-MM-dd");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ent_id", ent_id);
            map.put("saledate", datefmt.format(new Date()));
            map.put("prevdate", datefmt.format(DateUtils.addDays((Date)new Date(), (int)-1)));
            map.put("market", market);
            map.put("level", checkLevel);
            SqlSessionTemplate db = storage.getSqlSessionTemplate();
            List list = new ArrayList();
            if (storage.getDBType() == QueryExtractor.DBTYPE.SQLSERVER) {
                StringBuffer sql = new StringBuffer();
                sql.append("select 'm$eventscopeitem' as sys,count(*) as num from m$eventscopeitem ");
                sql.append("where sta_date <= '" + map.get("saledate") + "' and end_date >= '" + map.get("saledate") + "' ");
                sql.append("and nsta = 2021 ");
                sql.append("UNION ");
                sql.append("select 'm$events' as sys,count(*) as num from m$events ");
                sql.append("where eid in (select evt_id from (");
                sql.append("select distinct evt_id from m$eventscopeitem ");
                sql.append("where sta_date <= '" + map.get("saledate") + "' and end_date >= '" + map.get("saledate") + "' ");
                sql.append("and nsta = 2021 ");
                sql.append(") ta)");
                list = db.selectList("mybatis.sql.select", (Object)sql.toString());
            } else if (!"0".equalsIgnoreCase(market)) {
                list = db.selectList("mybatis.model.select_ValidEvent", map);
            } else {
                String event_list = this.getEventListSlice(map);
                if (!StringUtils.isEmpty((Object)event_list)) {
                    map.put("event_list", event_list);
                    list = db.selectList("mybatis.model.select_ValidEvent_Slice", map);
                }
            }
            if (list != null && list.size() > 0) {
                for (Map mp : list) {
                    JSONObject dbver = new JSONObject();
                    dbver.put("itemcode", (Object)((String)mp.get("sys")));
                    dbver.put("barcode", (Object)String.valueOf(mp.get("num")));
                    dbver.put("itemname", (Object)((String)mp.get("memo")));
                    sell_details.add((Object)dbver);
                }
            }
            calc_order.put("sell_details", (Object)sell_details);
            JSONObject param = new JSONObject();
            param.put("calc_mode", (Object)"VERSION");
            param.put("calc_billid", (Object)"SYNC");
            param.put("bill_detail", (Object)calc_order);
            String paramstr = param.toJSONString();
            XxlJobLogger.log((String)"\u53d1\u9001\u7edf\u8ba1\u4fe1\u606f: {}", (Object[])new Object[]{svr});
            XxlJobLogger.log((String)"\u53d1\u9001\u7edf\u8ba1\u4fe1\u606f:\n {}", (Object[])new Object[]{JSON.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat})});
            RestClientUtils.getRestUtils().sendRequest((Object)session, svr, (Object)paramstr);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    private String getEventListSlice(Map<String, Object> map) {
        List list = ((FMybatisTemplate)this.getStorageOperations()).getSqlSessionTemplate().selectList("mybatis.model.select_event_ids_slice", map);
        if (list == null || list.size() <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Map row : list) {
            sb.append(MapUtils.getString((Map)row, (String)"eid")).append(",");
        }
        return sb.toString().substring(0, sb.toString().length() - 1).concat(")");
    }

    public ServiceResponse sendbymkt(ServiceSession session, JSONObject jsonparam) throws Exception {
        this.checkPara(session, jsonparam);
        String mktid = DataUtils.getJsonData((JSONObject)jsonparam, (String)"mktid", (boolean)true, (String)"");
        List<String> mkt_list = Arrays.asList(mktid.split(","));
        return ServiceResponse.buildSuccess((Object)this.doSendByMultiMarket(session.getEnt_id(), mkt_list));
    }

    public ServiceResponse sendbyslice(ServiceSession session, JSONObject jsonparam) throws Exception {
        this.checkPara(session, jsonparam);
        String slice = DataUtils.getJsonData((JSONObject)jsonparam, (String)"slice", (boolean)true, (String)"");
        List<String> mkt_list = this.getOrgCodesBySlice(session.getEnt_id(), slice);
        return ServiceResponse.buildSuccess((Object)this.doSendByMultiMarket(session.getEnt_id(), mkt_list));
    }

    private Object doSendByMultiMarket(long ent_id, List<String> mkt_list) {
        JSONObject result = new JSONObject();
        if (mkt_list == null || mkt_list.size() <= 0) {
            return DataUtils.newJSONObject((String)"market", (Object)0);
        }
        result.put("market", (Object)mkt_list.size());
        SimpleDateFormat datefmt = new SimpleDateFormat("yyyy-MM-dd");
        StringJoiner joiner = new StringJoiner(",");
        for (String org : mkt_list) {
            joiner.add("'".concat(org).concat("'"));
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("ent_id", ent_id);
        para.put("market", joiner.toString());
        para.put("saledate", datefmt.format(new Date()));
        List list = ((FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class)).getSqlSessionTemplate().selectList("mybatis.model.batch.select_all_event_ids", para);
        if (list == null || list.size() <= 0) {
            result.put("event", (Object)0);
            return result;
        }
        result.put("event", (Object)list.size());
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Map map : list) {
            sb.append(String.valueOf(map.get("eid"))).append(",");
        }
        para.put("event_list", sb.toString().substring(0, sb.toString().length() - 1).concat(")"));
        para.put("tmdd", System.currentTimeMillis() / 1000L);
        ((FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class)).getSqlSessionTemplate().update("mybatis.model.batch.update_event_tmdd", para);
        return result;
    }

    class TaskThread
    extends BaseService
    implements Callable<Map<String, Object>> {
        CallbackStatis callback;
        String statement;
        Map<String, Object> para;

        public TaskThread(CallbackStatis callback, String statement, Map<String, Object> para) {
            this.callback = callback;
            this.statement = statement;
            this.para = DataUtils.cloneMap(para);
        }

        @Override
        public Map<String, Object> call() {
            try {
                Map<String, Object> map = this.callback.execute(this.statement, this.para);
                return map;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    class CalcThread
    extends BaseService
    implements Callable<String> {
        long ent_id;
        String saledate;
        String market;

        public CalcThread(long ent_id, String saledate, String market) {
            this.ent_id = ent_id;
            this.saledate = saledate;
            this.market = market;
        }

        @Override
        public String call() {
            try {
                HashMap<String, Object> para = new HashMap<String, Object>();
                para.put("ent_id", this.ent_id);
                para.put("saledate", this.saledate);
                para.put("market", this.market);
                String string = ModelEventStatis.getInstance().selectEventList(para);
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

