/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omp.event.model.component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.slice.filter.SliceBase;
import com.efuture.ocp.common.trans.TransactionManager;
import com.efuture.ocp.common.util.BatchInsService;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import com.efuture.omd.storage.parser.QueryExtractor;
import com.efuture.omp.event.model.component.ModelSearchServiceImpl;
import com.efuture.omp.event.model.component.PopModelServiceBase;
import com.efuture.omp.event.model.entity.EvtBaseBean;
import com.efuture.omp.event.model.entity.EvtMainBean;
import com.efuture.omp.event.model.entity.EvtPolicyBean;
import com.efuture.omp.event.model.entity.EvtPolicyLadderBean;
import com.efuture.omp.event.model.entity.EvtPolicyLimitBean;
import com.efuture.omp.event.model.entity.EvtPolicyNopayBean;
import com.efuture.omp.event.model.entity.EvtResultCouponBean;
import com.efuture.omp.event.model.entity.EvtResultGiftBean;
import com.efuture.omp.event.model.entity.EvtScopeConsBean;
import com.efuture.omp.event.model.entity.EvtScopeItemBean;
import com.efuture.omp.event.model.entity.EvtScopeItemHisBean;
import com.efuture.omp.event.model.entity.EvtScopeOrgBean;
import com.efuture.omp.event.model.entity.EvtScopePayBean;
import com.efuture.omp.event.model.entity.EvtScopeTagBean;
import com.efuture.omp.event.model.entity.order.OrderMainBean;
import com.xxl.job.core.log.XxlJobLogger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class ModelMaintServiceImpl
extends PopModelServiceBase {
    DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    public int ClearDays;
    public int MoveDays;
    public int InvalidDays;
    public int HisOrderDays;
    public long OrderEnts;
    private BatchInsService batchInsService = new BatchInsService();
    private AtomicBoolean RUNJOB = new AtomicBoolean(true);

    public long getOrderEnts() {
        return this.OrderEnts;
    }

    public void setOrderEnts(long orderEnts) {
        this.OrderEnts = orderEnts;
    }

    public int getMoveDays() {
        return this.MoveDays;
    }

    public void setMoveDays(int moveDays) {
        this.MoveDays = moveDays;
    }

    public int getInvalidDays() {
        return this.InvalidDays;
    }

    public void setInvalidDays(int invalidDays) {
        this.InvalidDays = invalidDays;
    }

    public int getClearDays() {
        return this.ClearDays;
    }

    public void setClearDays(int clearDays) {
        this.ClearDays = clearDays;
    }

    public int getHisOrderDays() {
        return this.HisOrderDays;
    }

    public void setHisOrderDays(int hisOrderDays) {
        this.HisOrderDays = hisOrderDays;
    }

    @Override
    protected EvtMainBean createBeanFromJSON(ServiceSession session, JSONObject jsonparam) {
        return super.createBeanFromJSON(session, jsonparam);
    }

    public static ModelMaintServiceImpl getInstance() {
        return (ModelMaintServiceImpl)((Object)SpringBeanFactory.getBean((String)"ModelMaint", ModelMaintServiceImpl.class));
    }

    public void start() {
        this.RUNJOB.set(true);
    }

    public void stop() {
        this.RUNJOB.set(false);
    }

    public Isolation getDBIsolation(FMybatisTemplate storage) {
        Map result;
        if (storage.getDBType() == QueryExtractor.DBTYPE.MYSQL && (result = (Map)storage.getSqlSessionTemplate().selectOne("mybatis.sql.select", (Object)"select @@tx_isolation iso")) != null) {
            if ("READ-COMMITTED".equalsIgnoreCase(MapUtils.getString((Map)result, (String)"iso"))) {
                return Isolation.READ_COMMITTED;
            }
            return Isolation.REPEATABLE_READ;
        }
        return Isolation.READ_COMMITTED;
    }

    public ServiceResponse MoveModel(ServiceSession session, JSONObject jsonparam) throws Exception {
        this.setMoveDays(Integer.parseInt(this.getParamWithCheck(jsonparam, "days", true, "")));
        this.MoveToHis();
        return ServiceResponse.buildSuccess(null);
    }

    public ServiceResponse ClearModel(ServiceSession session, JSONObject jsonparam) throws Exception {
        this.setClearDays(Integer.parseInt(this.getParamWithCheck(jsonparam, "days", true, "")));
        this.ClearModel();
        return ServiceResponse.buildSuccess(null);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, isolation=Isolation.READ_COMMITTED)
    public List<EvtScopeItemBean> getMoveToHis(FMybatisTemplate storage, Query query) {
        return ((FMybatisTemplate)this.getStorageOperations()).select(query, EvtScopeItemBean.class);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Long MoveToHis(FMybatisTemplate storage, EvtScopeItemBean item, List<EvtScopeItemHisBean> list_his) {
        this.getLogger().info((Object)"MoveToHis:".concat(String.valueOf(item.getEvt_id())).concat(":").concat(String.valueOf(item.getSeqno())));
        EvtScopeItemHisBean his = new EvtScopeItemHisBean();
        BeanUtils.copyProperties((Object)item, (Object)his);
        list_his.add(his);
        return item.getSeqno();
    }

    public void MoveToHis() throws Exception {
        if (this.isWriteSlice()) {
            String current = SliceBase.getCurrentSlice();
            Set slice_list = SliceBase.getAllSlice();
            if (slice_list == null || slice_list.size() <= 0) {
                return;
            }
            for (String slice : slice_list) {
                try {
                    XxlJobLogger.log((String)"\u5f00\u59cb\u5904\u7406\u5207\u7247\u6570\u636e\uff1a{}", (Object[])new Object[]{slice});
                    SliceBase.setCurrentSlice((String)slice);
                    this.MoveToHisCore();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            SliceBase.setCurrentSlice((String)current);
        } else {
            this.MoveToHisCore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void MoveToHisCore() throws Exception {
        long first_time;
        long tot_rows;
        block8: {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            int page_no = 1;
            int page_size = 1000;
            Criteria criteria = Criteria.where((String)"end_date").lt((Object)sdf.format(DateUtils.addDays((Date)new Date(), (int)(-1 * this.getMoveDays()))));
            Query query = new Query((CriteriaDefinition)criteria);
            query.limit(page_size);
            long tot_fail = 0L;
            tot_rows = 0L;
            first_time = System.currentTimeMillis();
            FMybatisTemplate storage = null;
            try {
                while (this.RUNJOB.get()) {
                    if (tot_fail > 10L) {
                        XxlJobLogger.log((String)"\u8f6c\u79fb\u6a21\u578b\u6570\u636e\u5230\u5386\u53f2\u8868: \u9519\u8bef\u8d85\u8fc7 {} \u6b21\uff0c\u672c\u6b21\u6267\u884c\u7ec8\u6b62", (Object[])new Object[]{tot_fail});
                        break;
                    }
                    long this_time = System.currentTimeMillis();
                    query.skip((page_no - 1) * page_size);
                    List<EvtScopeItemBean> items = ModelMaintServiceImpl.getInstance().getMoveToHis(storage, query);
                    if (StringUtils.isEmpty(items) || items.size() <= 0) break;
                    TransactionStatus transStatus = TransactionManager.newTransaction((String[])new String[0]);
                    storage = (FMybatisTemplate)this.getStorageOperations();
                    try {
                        ArrayList<EvtScopeItemHisBean> list_his = new ArrayList<EvtScopeItemHisBean>();
                        ArrayList<Long> list_cur = new ArrayList<Long>();
                        for (EvtScopeItemBean item : items) {
                            list_cur.add(this.MoveToHis(storage, item, list_his));
                        }
                        this.batchInsService.batchInsert(storage, EvtScopeItemHisBean.class, list_his);
                        this.batchDelete(storage, EvtScopeItemBean.class, list_cur);
                        TransactionManager.commit((TransactionStatus)transStatus, (String[])new String[0]);
                        list_his = null;
                        list_cur = null;
                    }
                    catch (Exception e) {
                        TransactionManager.rollback((TransactionStatus)transStatus, (String[])new String[0]);
                        ++tot_fail;
                    }
                    tot_rows += (long)items.size();
                    XxlJobLogger.log((String)"\u8f6c\u79fb\u6a21\u578b\u6570\u636e\u5230\u5386\u53f2\u8868: {} , \u672c\u6b21\u5904\u7406 {} \u884c, \u8017\u65f6 {} ms", (Object[])new Object[]{page_no, String.valueOf(items.size()), System.currentTimeMillis() - this_time});
                }
                if (storage == null) break block8;
            }
            catch (Throwable throwable) {
                if (storage != null) {
                    storage.destroy();
                }
                XxlJobLogger.log((String)"\u8f6c\u79fb\u6a21\u578b\u6570\u636e\u5230\u5386\u53f2\u8868: \u7d2f\u8ba1\u5904\u7406 {} \u884c\uff0c \u7d2f\u8ba1\u8017\u65f6 {} ms", (Object[])new Object[]{String.valueOf(tot_rows), System.currentTimeMillis() - first_time});
                throw throwable;
            }
            storage.destroy();
        }
        XxlJobLogger.log((String)"\u8f6c\u79fb\u6a21\u578b\u6570\u636e\u5230\u5386\u53f2\u8868: \u7d2f\u8ba1\u5904\u7406 {} \u884c\uff0c \u7d2f\u8ba1\u8017\u65f6 {} ms", (Object[])new Object[]{String.valueOf(tot_rows), System.currentTimeMillis() - first_time});
    }

    private int batchDelete(FMybatisTemplate storage, Class<?> objClass, List<Long> list_cur) {
        Criteria criteria = Criteria.where((String)"seqno").in(list_cur);
        Query query = new Query((CriteriaDefinition)criteria);
        return storage.delete(query, objClass);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public <T> List<T> doSearch(JSONObject jsonparam, Class<T> objClass, StringBuffer total) throws Exception {
        return super.doSearch(jsonparam, objClass, total);
    }

    public void ClearModel() throws Exception {
        if (this.isWriteSlice()) {
            String current = SliceBase.getCurrentSlice();
            Set slice_list = SliceBase.getAllSlice();
            if (slice_list == null || slice_list.size() <= 0) {
                return;
            }
            for (String slice : slice_list) {
                try {
                    XxlJobLogger.log((String)"\u5f00\u59cb\u5904\u7406\u5207\u7247\u6570\u636e\uff1a{}", (Object[])new Object[]{slice});
                    SliceBase.setCurrentSlice((String)slice);
                    this.ClearModelCore();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            SliceBase.setCurrentSlice((String)current);
        } else {
            this.ClearModelCore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void ClearModelCore() throws Exception {
        block20: {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            long tot_rows = 0L;
            long tot_fail = 0L;
            long first_time = System.currentTimeMillis();
            FStorageOperations storage = null;
            try {
                TransactionStatus txStatus;
                List<EvtBaseBean> evts_invalid;
                long start_time;
                storage = this.getStorageOperations();
                StringBuffer total = null;
                JSONObject param1 = new JSONObject();
                JSONObject param2 = new JSONObject();
                JSONObject dt = new JSONObject();
                if (this.getClearDays() > 0) {
                    dt.put("$lt", (Object)sdf.format(DateUtils.addDays((Date)new Date(), (int)(-1 * this.getClearDays()))));
                    param1.put("end_date", (Object)dt);
                    param1.put("page_size", (Object)1000);
                    while (this.RUNJOB.get()) {
                        if (tot_fail > 10L) {
                            XxlJobLogger.log((String)"\u6e05\u7406\u5df2\u8fc7\u671f {} \u5929\u7684\u6570\u636e: \u9519\u8bef\u8d85\u8fc7 {} \u6b21\uff0c\u672c\u6b21\u6267\u884c\u7ec8\u6b62", (Object[])new Object[]{this.getClearDays(), tot_fail});
                            break;
                        }
                        long start_time2 = System.currentTimeMillis();
                        List<EvtMainBean> evts_exceed = ModelMaintServiceImpl.getInstance().doSearch(param1, EvtMainBean.class, total);
                        this.getLogger().info((Object)"ClearModel1:".concat(param1.toJSONString()).concat("-> size:").concat(String.valueOf(evts_exceed.size())));
                        if (StringUtils.isEmpty(evts_exceed) || evts_exceed.size() <= 0) break;
                        TransactionStatus txStatus2 = TransactionManager.newTransaction((String[])new String[0]);
                        try {
                            ArrayList<Long> list_eid = new ArrayList<Long>();
                            for (EvtMainBean evtMainBean : evts_exceed) {
                                this.getLogger().info((Object)"ClearModel1:".concat(String.valueOf(evtMainBean.getEid())));
                                list_eid.add(evtMainBean.getEid());
                            }
                            this.ClearModelByBatch(storage, list_eid);
                            TransactionManager.commit((TransactionStatus)txStatus2, (String[])new String[0]);
                        }
                        catch (Exception ex) {
                            TransactionManager.rollback((TransactionStatus)txStatus2, (String[])new String[0]);
                            ex.printStackTrace();
                            ++tot_fail;
                        }
                        tot_rows += (long)evts_exceed.size();
                        XxlJobLogger.log((String)"\u6e05\u7406\u5df2\u8fc7\u671f {} \u5929\u7684\u6570\u636e: \u5171 {} \u6761\uff0c \u8017\u65f6 {} ms", (Object[])new Object[]{this.getClearDays(), evts_exceed.size(), System.currentTimeMillis() - start_time2});
                    }
                    XxlJobLogger.log((String)"\u6e05\u7406\u5df2\u8fc7\u671f {} \u5929\u7684\u6570\u636e: \u7d2f\u8ba1 {} \u6761\uff0c \u8017\u65f6 {} ms", (Object[])new Object[]{this.getClearDays(), tot_rows, System.currentTimeMillis() - first_time});
                }
                first_time = System.currentTimeMillis();
                tot_rows = 0L;
                tot_fail = 0L;
                if (this.getInvalidDays() <= 0) break block20;
                JSONObject and = new JSONObject();
                dt.put("$lt", (Object)(this.getTimestamp(storage) - (long)(86400 * this.getInvalidDays())));
                and.put("tmdd", (Object)dt);
                and.put("nsta", (Object)2022L);
                param2.put("$and", (Object)and);
                param2.put("page_size", (Object)1000);
                while (this.RUNJOB.get()) {
                    if (tot_fail > 10L) {
                        XxlJobLogger.log((String)"\u6e05\u7406\u5df2\u5931\u6548 {} \u5929\u7684\u6570\u636e1: \u9519\u8bef\u8d85\u8fc7 {} \u6b21\uff0c\u672c\u6b21\u6267\u884c\u7ec8\u6b62", (Object[])new Object[]{this.getInvalidDays(), tot_fail});
                        break;
                    }
                    start_time = System.currentTimeMillis();
                    evts_invalid = ModelMaintServiceImpl.getInstance().doSearch(param2, EvtMainBean.class, total);
                    this.getLogger().info((Object)"ClearModel2:".concat(param2.toJSONString()).concat("-> size:").concat(String.valueOf(evts_invalid.size())));
                    if (StringUtils.isEmpty(evts_invalid) || evts_invalid.size() <= 0) break;
                    txStatus = TransactionManager.newTransaction((String[])new String[0]);
                    try {
                        ArrayList<Long> list_eid = new ArrayList<Long>();
                        for (EvtMainBean evtMainBean : evts_invalid) {
                            this.getLogger().info((Object)"ClearModel2:".concat(String.valueOf(evtMainBean.getEid())));
                            list_eid.add(evtMainBean.getEid());
                        }
                        this.ClearModelByBatch(storage, list_eid);
                        TransactionManager.commit((TransactionStatus)txStatus, (String[])new String[0]);
                    }
                    catch (Exception ex) {
                        TransactionManager.rollback((TransactionStatus)txStatus, (String[])new String[0]);
                        ex.printStackTrace();
                        ++tot_fail;
                    }
                    tot_rows += (long)evts_invalid.size();
                    XxlJobLogger.log((String)"\u6e05\u7406\u5df2\u5931\u6548 {} \u5929\u7684\u6570\u636e1: \u5171 {} \u6761\uff0c \u8017\u65f6 {} ms", (Object[])new Object[]{this.getInvalidDays(), evts_invalid.size(), System.currentTimeMillis() - start_time});
                }
                while (this.RUNJOB.get()) {
                    if (tot_fail > 10L) {
                        XxlJobLogger.log((String)"\u6e05\u7406\u5df2\u5931\u6548 {} \u5929\u7684\u6570\u636e2: \u9519\u8bef\u8d85\u8fc7 {} \u6b21\uff0c\u672c\u6b21\u6267\u884c\u7ec8\u6b62", (Object[])new Object[]{this.getInvalidDays(), tot_fail});
                        break;
                    }
                    start_time = System.currentTimeMillis();
                    evts_invalid = ModelMaintServiceImpl.getInstance().doSearch(param2, EvtPolicyNopayBean.class, total);
                    this.getLogger().info((Object)"ClearModel3:".concat(param2.toJSONString()).concat("-> size:").concat(String.valueOf(evts_invalid.size())));
                    if (StringUtils.isEmpty(evts_invalid) || evts_invalid.size() <= 0) break;
                    txStatus = TransactionManager.newTransaction((String[])new String[0]);
                    try {
                        for (EvtPolicyNopayBean evtPolicyNopayBean : evts_invalid) {
                            this.getLogger().info((Object)"ClearModel3:".concat(String.valueOf(evtPolicyNopayBean.getSeqno())));
                            this.ClearNoPay(storage, evtPolicyNopayBean.getSeqno());
                        }
                        TransactionManager.commit((TransactionStatus)txStatus, (String[])new String[0]);
                    }
                    catch (Exception ex) {
                        TransactionManager.rollback((TransactionStatus)txStatus, (String[])new String[0]);
                        ex.printStackTrace();
                        ++tot_fail;
                    }
                    tot_rows += (long)evts_invalid.size();
                    XxlJobLogger.log((String)"\u6e05\u7406\u5df2\u5931\u6548 {} \u5929\u7684\u6570\u636e2: \u5171 {} \u6761\uff0c \u8017\u65f6 {} ms", (Object[])new Object[]{this.getInvalidDays(), evts_invalid.size(), System.currentTimeMillis() - start_time});
                }
                XxlJobLogger.log((String)"\u6e05\u7406\u5df2\u5931\u6548 {} \u5929\u7684\u6570\u636e: \u7d2f\u8ba1 {} \u6761\uff0c \u8017\u65f6 {} ms", (Object[])new Object[]{this.getInvalidDays(), tot_rows, System.currentTimeMillis() - first_time});
            }
            finally {
                if (storage != null) {
                    storage.destroy();
                }
                this.getLogger().info((Object)"ClearModel: End");
            }
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void ClearModelByEvent(FStorageOperations storage, EvtMainBean evt) {
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)evt.getEnt_id()).and("evt_id").is((Object)evt.getEid());
        Query query = new Query((CriteriaDefinition)criteria);
        storage.delete(query, EvtScopeItemBean.class);
        storage.delete(query, EvtScopeItemHisBean.class);
        storage.delete(query, EvtPolicyBean.class);
        storage.delete(query, EvtPolicyLadderBean.class);
        storage.delete(query, EvtPolicyLimitBean.class);
        storage.delete(query, EvtResultCouponBean.class);
        storage.delete(query, EvtResultGiftBean.class);
        storage.delete(query, EvtScopeConsBean.class);
        storage.delete(query, EvtScopeOrgBean.class);
        storage.delete(query, EvtScopePayBean.class);
        storage.delete((Object)evt);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void ClearModelByBatch(FStorageOperations storage, List<Long> list_eid) {
        Criteria criteria = Criteria.where((String)"evt_id").in(list_eid);
        Query query = new Query((CriteriaDefinition)criteria);
        storage.delete(query, EvtScopeItemBean.class);
        storage.delete(query, EvtScopeItemHisBean.class);
        storage.delete(query, EvtPolicyBean.class);
        storage.delete(query, EvtPolicyLadderBean.class);
        storage.delete(query, EvtPolicyLimitBean.class);
        storage.delete(query, EvtResultCouponBean.class);
        storage.delete(query, EvtResultGiftBean.class);
        storage.delete(query, EvtScopeConsBean.class);
        storage.delete(query, EvtScopeOrgBean.class);
        storage.delete(query, EvtScopePayBean.class);
        criteria = Criteria.where((String)"eid").in(list_eid);
        storage.delete(new Query((CriteriaDefinition)criteria), EvtMainBean.class);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void ClearNoPay(FStorageOperations storage, long seqno) {
        Criteria criteria = Criteria.where((String)"seqno").in(new Object[]{seqno});
        Query query = new Query((CriteriaDefinition)criteria);
        storage.delete(query, EvtPolicyNopayBean.class);
    }

    private String getTableName(Class<?> clazz) {
        return AbstractEntityBean.fetchAnnotationTableName(clazz);
    }

    private List<Map<String, Object>> getTableData(FStorageOperations storage, Query query, Class<?> clazz) {
        return storage.select(query, this.getTableName(clazz));
    }

    private void putSubTableData(JSONObject result, JSONObject metadata, String metacol, FStorageOperations storage, Query query, Class<?> clazz) {
        List<Map<String, Object>> list = this.fullFillSlice(this.getTableData(storage, query, clazz));
        if (list != null && list.size() > 0) {
            result.put(this.getTableName(clazz), list);
            metadata.put(this.getTableName(clazz), (Object)metacol);
        }
    }

    public ServiceResponse geteventlist(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject rtnobj = new JSONObject();
        JSONObject metadata = new JSONObject();
        long tmdd = this.getParamWithCheck(jsonparam, "tmdd", true, 0L);
        long maxtmdd = this.getParamWithCheck(jsonparam, "maxtmdd", true, 0L);
        int pageno = this.getParamWithCheck(jsonparam, "page_no", false, 1);
        int pagesize = this.getParamWithCheck(jsonparam, "page_size", false, 50);
        String billid = this.getParamWithCheck(jsonparam, "billid", false, "");
        FStorageOperations fso = this.getStorageOperations();
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("tmdd").gt((Object)tmdd).lte((Object)maxtmdd);
        if (!StringUtils.isEmpty((Object)billid)) {
            criteria = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("billid").is((Object)billid);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        Sort order = new Sort("tmdd,eid".split(","));
        if (pageno >= 1) {
            query.with((Pageable)new PageRequest(pageno - 1, pagesize, order));
        } else if (order != null) {
            query.with(order);
        }
        List evts = fso.select(query, "m$events");
        if (evts.size() <= 0) {
            return ServiceResponse.buildSuccess((Object)rtnobj);
        }
        rtnobj.put(this.getTableName(EvtMainBean.class), (Object)evts);
        metadata.put(this.getTableName(EvtMainBean.class), (Object)"eid");
        ArrayList<Long> lst = new ArrayList<Long>();
        for (Map evt : evts) {
            lst.add(Long.parseLong(evt.get("eid").toString()));
        }
        Criteria criteria_det = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("evt_id").in(lst);
        Query query_det = new Query((CriteriaDefinition)criteria_det);
        this.putSubTableData(rtnobj, metadata, "evt_id", fso, query_det, EvtPolicyBean.class);
        this.putSubTableData(rtnobj, metadata, "evt_id", fso, query_det, EvtPolicyLadderBean.class);
        this.putSubTableData(rtnobj, metadata, "evt_id", fso, query_det, EvtPolicyLimitBean.class);
        this.putSubTableData(rtnobj, metadata, "evt_id", fso, query_det, EvtResultCouponBean.class);
        this.putSubTableData(rtnobj, metadata, "evt_id", fso, query_det, EvtResultGiftBean.class);
        this.putSubTableData(rtnobj, metadata, "evt_id", fso, query_det, EvtScopeConsBean.class);
        this.putSubTableData(rtnobj, metadata, "evt_id", fso, query_det, EvtScopePayBean.class);
        this.putSubTableData(rtnobj, metadata, "evt_id", fso, query_det, EvtScopeItemBean.class);
        this.putSubTableData(rtnobj, metadata, "evt_id", fso, query_det, EvtScopeOrgBean.class);
        if (this.isReadSlice()) {
            metadata.put("slice", this.getSliceList(rtnobj));
        }
        rtnobj.put("metadata", (Object)metadata);
        return ServiceResponse.buildSuccess((Object)rtnobj);
    }

    private String getEventCacheKey(Map<String, Object> para) {
        return MapUtils.getString(para, (String)"ent_id", (String)"0").concat("-").concat(MapUtils.getString(para, (String)"store")).concat("-").concat(MapUtils.getString(para, (String)"tmdd")).concat("-").concat(MapUtils.getString(para, (String)"maxtmdd"));
    }

    public List<Map<String, Object>> getPageEvents(FMybatisTemplate fso, Map<String, Object> para, RowBounds row) {
        String key = this.getEventCacheKey(para);
        if (row.getOffset() <= 0) {
            List result = fso.getSqlSessionTemplate().selectList("mybatis.model.select_events", para);
            if (result.size() > row.getLimit()) {
                CacheUtils.getCacheUtils().putData(key, (Object)result, 86400);
                return result.subList(0, row.getLimit());
            }
            return result;
        }
        Object data = CacheUtils.getCacheUtils().getData(key);
        if (data == null) {
            return fso.getSqlSessionTemplate().selectList("mybatis.model.select_events", para, row);
        }
        List result = (List)data;
        if (result.size() <= 0) {
            return null;
        }
        if (result.size() > row.getOffset() + row.getLimit()) {
            return result.subList(row.getOffset(), row.getOffset() + row.getLimit());
        }
        CacheUtils.getCacheUtils().deleteData(key);
        return result.subList(row.getOffset(), result.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse getstoreeventlist(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject rtnobj = new JSONObject();
        JSONObject metadata = new JSONObject();
        int pageno = this.getParamWithCheck(jsonparam, "page_no", false, 1);
        int pagesize = this.getParamWithCheck(jsonparam, "page_size", false, 50);
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("ent_id", session.getEnt_id());
        para.put("store", this.getParamWithCheck(jsonparam, "store", false, "ALL"));
        para.put("tmdd", this.getParamWithCheck(jsonparam, "tmdd", true, 0L));
        para.put("maxtmdd", this.getParamWithCheck(jsonparam, "maxtmdd", true, 0L));
        if (jsonparam.containsKey((Object)"billid")) {
            para.put("billid", this.getParamWithCheck(jsonparam, "billid", false, ""));
        }
        int subPageSize = this.getParamWithCheck(jsonparam, "sub_pagesize", false, 10000);
        int subPageNo = this.getParamWithCheck(jsonparam, "sub_pageno", false, 1);
        List<Object> list_evts = new ArrayList();
        if (jsonparam.containsKey((Object)"evt_list")) {
            list_evts = Arrays.asList(this.getParamWithCheck(jsonparam, "evt_list", false, "").split(","));
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            FMybatisTemplate fso = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
            List<Object> lst = new ArrayList();
            if (list_evts == null || list_evts.size() <= 0) {
                RowBounds row = new RowBounds((pageno - 1) * pagesize, pagesize);
                List<Map<String, Object>> evts = this.getPageEvents(fso, para, row);
                if (evts == null || evts.size() <= 0) {
                    return ServiceResponse.buildSuccess((Object)rtnobj);
                }
                rtnobj.put(EvtMainBean.fetchAnnotationTableName(EvtMainBean.class), evts);
                metadata.put(EvtMainBean.fetchAnnotationTableName(EvtMainBean.class), (Object)"eid");
                for (Map<String, Object> evt : evts) {
                    lst.add(MapUtils.getLongValue(evt, (String)"eid"));
                }
            } else {
                lst = list_evts.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            }
            Criteria criteria_det = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("evt_id").in(lst);
            Query query_det = new Query((CriteriaDefinition)criteria_det);
            query_det.skip((subPageNo - 1) * subPageSize);
            query_det.limit(subPageSize);
            this.putSubTableData(rtnobj, metadata, "evt_id", (FStorageOperations)fso, query_det, EvtPolicyBean.class);
            this.putSubTableData(rtnobj, metadata, "evt_id", (FStorageOperations)fso, query_det, EvtPolicyLadderBean.class);
            this.putSubTableData(rtnobj, metadata, "evt_id", (FStorageOperations)fso, query_det, EvtPolicyLimitBean.class);
            this.putSubTableData(rtnobj, metadata, "evt_id", (FStorageOperations)fso, query_det, EvtResultCouponBean.class);
            this.putSubTableData(rtnobj, metadata, "evt_id", (FStorageOperations)fso, query_det, EvtResultGiftBean.class);
            this.putSubTableData(rtnobj, metadata, "evt_id", (FStorageOperations)fso, query_det, EvtScopeConsBean.class);
            this.putSubTableData(rtnobj, metadata, "evt_id", (FStorageOperations)fso, query_det, EvtScopePayBean.class);
            ArrayList<String> orgs = new ArrayList<String>();
            orgs.add(this.getParamWithCheck(jsonparam, "store", false, "ALL"));
            orgs.add("%");
            orgs.add("ALL");
            criteria_det = criteria_det.andOperator(new Criteria[]{Criteria.where((String)"org_code").in(orgs).orOperator(new Criteria[]{Criteria.where((String)"org_code").exists(false)})});
            query_det = new Query((CriteriaDefinition)criteria_det);
            query_det.skip((subPageNo - 1) * subPageSize);
            query_det.limit(subPageSize);
            query_det.with(new Sort(new String[]{"seqno"}));
            this.putSubTableData(rtnobj, metadata, "evt_id", (FStorageOperations)fso, query_det, EvtScopeItemBean.class);
            this.putSubTableData(rtnobj, metadata, "evt_id", (FStorageOperations)fso, query_det, EvtScopeOrgBean.class);
            metadata.put("next_page", (Object)this.checkNextPages(subPageSize, rtnobj, metadata));
            rtnobj.put("metadata", (Object)metadata);
        }
        return ServiceResponse.buildSuccess((Object)rtnobj);
    }

    public String checkNextPages(int subPageSize, JSONObject dataObject, JSONObject metadata) {
        for (String key : metadata.keySet()) {
            if (!dataObject.containsKey((Object)key) || ((List)dataObject.get((Object)key)).size() < subPageSize) continue;
            return "Y";
        }
        return "N";
    }

    public ServiceResponse gettagrelylist(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject rtnobj = new JSONObject();
        JSONObject metadata = new JSONObject();
        long tmdd = this.getParamWithCheck(jsonparam, "tmdd", true, 0L);
        long maxtmdd = this.getParamWithCheck(jsonparam, "maxtmdd", true, 0L);
        int pageno = this.getParamWithCheck(jsonparam, "page_no", false, 1);
        int pagesize = this.getParamWithCheck(jsonparam, "page_size", false, 50);
        FStorageOperations fso = this.getStorageOperations();
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("tmdd").gt((Object)tmdd).lte((Object)maxtmdd);
        Query query = new Query((CriteriaDefinition)criteria);
        Sort order = new Sort(new String[]{"tmdd"});
        if (pageno >= 1) {
            query.with((Pageable)new PageRequest(pageno - 1, pagesize, order));
        } else if (order != null) {
            query.with(order);
        }
        List evts = fso.select(query, "m$tagrely");
        if (evts.size() <= 0) {
            return ServiceResponse.buildSuccess((Object)rtnobj);
        }
        rtnobj.put(EvtScopeTagBean.fetchAnnotationTableName(EvtScopeTagBean.class), (Object)evts);
        metadata.put(EvtScopeTagBean.fetchAnnotationTableName(EvtScopeTagBean.class), (Object)"tag_key");
        rtnobj.put("metadata", (Object)metadata);
        return ServiceResponse.buildSuccess((Object)rtnobj);
    }

    public ServiceResponse getnopaylist(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject rtnobj = new JSONObject();
        JSONObject metadata = new JSONObject();
        long tmdd = this.getParamWithCheck(jsonparam, "tmdd", true, 0L);
        long maxtmdd = this.getParamWithCheck(jsonparam, "maxtmdd", true, 0L);
        int pageno = this.getParamWithCheck(jsonparam, "page_no", false, 1);
        int pagesize = this.getParamWithCheck(jsonparam, "page_size", false, 50);
        FStorageOperations fso = this.getStorageOperations();
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("tmdd").gt((Object)tmdd).lte((Object)maxtmdd);
        Query query = new Query((CriteriaDefinition)criteria);
        Sort order = new Sort(new String[]{"tmdd"});
        if (pageno >= 1) {
            query.with((Pageable)new PageRequest(pageno - 1, pagesize, order));
        } else if (order != null) {
            query.with(order);
        }
        List evts = fso.select(query, "m$eventpolicynopay");
        if (evts.size() <= 0) {
            return ServiceResponse.buildSuccess((Object)rtnobj);
        }
        rtnobj.put(EvtPolicyNopayBean.fetchAnnotationTableName(EvtPolicyNopayBean.class), (Object)evts);
        metadata.put(EvtPolicyNopayBean.fetchAnnotationTableName(EvtPolicyNopayBean.class), (Object)"seqno");
        rtnobj.put("metadata", (Object)metadata);
        return ServiceResponse.buildSuccess((Object)rtnobj);
    }

    public ServiceResponse search(ServiceSession session, JSONObject jsonparam) throws Exception {
        return ModelSearchServiceImpl.getInstance().search(session, jsonparam);
    }

    public ServiceResponse queryDetail(ServiceSession session, JSONObject jsonparam) throws Exception {
        return ModelSearchServiceImpl.getInstance().queryDetail(session, jsonparam);
    }

    public ServiceResponse ClearHisOrders(ServiceSession session, JSONObject jsonparam) throws Exception {
        this.setHisOrderDays(Integer.parseInt(this.getParamWithCheck(jsonparam, "clear_days", true, "")));
        this.ClearHisOrders();
        return ServiceResponse.buildSuccess(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void ClearHisOrders() throws Exception {
        if (this.getHisOrderDays() <= 0) {
            XxlJobLogger.log((String)"\u5220\u9664\u8fc7\u671f\u8ba2\u5355\uff1a\u65e5\u671f\u65e0\u6548\uff01", (Object[])new Object[0]);
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        long FirstTime = System.currentTimeMillis();
        long tot_rows = 0L;
        long tot_fail = 0L;
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            StringBuffer total = null;
            JSONObject param1 = new JSONObject();
            JSONObject param2 = new JSONObject();
            JSONObject dt = new JSONObject();
            dt.put("$lt", (Object)sdf.format(DateUtils.addDays((Date)new Date(), (int)(-1 * this.getHisOrderDays()))));
            param1.put("sale_date", (Object)dt);
            param1.put("page_size", (Object)1000);
            while (true) {
                if (tot_fail > 10L) {
                    XxlJobLogger.log((String)"\u5220\u9664\u8fc7\u671f {} \u5929\u7684\u8ba2\u5355:: \u9519\u8bef\u8d85\u8fc7 {} \u6b21\uff0c\u672c\u6b21\u6267\u884c\u7ec8\u6b62", (Object[])new Object[]{this.getHisOrderDays(), tot_fail});
                    break;
                }
                long StartTime = System.currentTimeMillis();
                List<OrderMainBean> orders = ModelMaintServiceImpl.getInstance().doSearch(param1, OrderMainBean.class, total);
                this.getLogger().info((Object)"ClearHisorder:".concat(param1.toJSONString()).concat("-> size:").concat(String.valueOf(orders.size())));
                if (StringUtils.isEmpty(orders) || orders.size() <= 0) break;
                TransactionStatus txStatus = TransactionManager.newTransaction((String[])new String[0]);
                try {
                    ArrayList<String> list_billno = new ArrayList<String>();
                    for (OrderMainBean order : orders) {
                        this.getLogger().info((Object)"ClearHisorder:".concat(String.valueOf(order.getBillno())));
                        if (this.getOrderEnts() < 0L) {
                            this.ClearHisOrderByBillno(storage, order);
                            XxlJobLogger.log((String)"\u5220\u9664\u8fc7\u671f\u8ba2\u5355\uff1a {}", (Object[])new Object[]{order.getBillno()});
                            continue;
                        }
                        list_billno.add(order.getBillno());
                    }
                    if (this.getOrderEnts() >= 0L) {
                        this.ClearHisOrderByBatch(storage, this.getOrderEnts(), list_billno);
                    }
                    TransactionManager.commit((TransactionStatus)txStatus, (String[])new String[0]);
                }
                catch (Exception ex) {
                    TransactionManager.rollback((TransactionStatus)txStatus, (String[])new String[0]);
                    ex.printStackTrace();
                    ++tot_fail;
                }
                tot_rows += (long)orders.size();
                XxlJobLogger.log((String)"\u5220\u9664\u8fc7\u671f {} \u5929\u7684\u8ba2\u5355: \u672c\u6b21 {} \u6761, \u8017\u65f6 {} ms", (Object[])new Object[]{this.getHisOrderDays(), orders.size(), System.currentTimeMillis() - StartTime});
            }
            XxlJobLogger.log((String)"\u5220\u9664\u8fc7\u671f {} \u5929\u7684\u8ba2\u5355: \u7d2f\u8ba1 {} \u6761, \u8017\u65f6 {} ms", (Object[])new Object[]{this.getHisOrderDays(), tot_rows, System.currentTimeMillis() - FirstTime});
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
            this.getLogger().info((Object)"ClearHisorder: End");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void ClearHisOrderByBillno(FStorageOperations storage, OrderMainBean order) {
        String delSql = "delete from %s where ent_id = %d and billno = '%s'";
        SqlSessionTemplate db = ((FMybatisTemplate)storage).getSqlSessionTemplate();
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleorderdetail", order.getEnt_id(), order.getBillno()));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleorderpay", order.getEnt_id(), order.getBillno()));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleordergains", order.getEnt_id(), order.getBillno()));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleorderpop", order.getEnt_id(), order.getBillno()));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleorderusecoupon", order.getEnt_id(), order.getBillno()));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleordergaincoupon", order.getEnt_id(), order.getBillno()));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleorders", order.getEnt_id(), order.getBillno()));
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void ClearHisOrderByBatch(FStorageOperations storage, long ent_id, List<String> billnos) {
        StringBuilder sb = new StringBuilder();
        for (String bill : billnos) {
            sb.append("'").append(bill).append("'").append(",");
        }
        String billSql = sb.substring(0, sb.length() - 1).toString();
        String delSql = "delete from %s where ent_id = %d and billno in (%s)";
        SqlSessionTemplate db = ((FMybatisTemplate)storage).getSqlSessionTemplate();
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleorderdetail", ent_id, billSql));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleorderpay", ent_id, billSql));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleordergains", ent_id, billSql));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleorderpop", ent_id, billSql));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleorderusecoupon", ent_id, billSql));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleordergaincoupon", ent_id, billSql));
        db.delete("mybatis.sql.delete", (Object)String.format(delSql, "saleorders", ent_id, billSql));
    }
}

