/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omp.event.model.component;

import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FStorageOperations;
import com.efuture.omp.event.model.entity.PopDefineBean;
import com.efuture.omp.event.model.intf.PopDefineService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class PopDefineServiceImpl
extends BasicComponentService<PopDefineBean>
implements PopDefineService {
    private boolean loadPaymentMap;
    private final Map<String, PopDefineBean> MODEL_DEFINE = new HashMap<String, PopDefineBean>();
    private final Map<String, Object> PAYMODE_MAP = new HashMap<String, Object>();

    public static PopDefineServiceImpl getInstance() {
        return (PopDefineServiceImpl)SpringBeanFactory.getBean((String)"efuture.omp.event.popdefine", PopDefineServiceImpl.class);
    }

    public boolean isLoadPaymentMap() {
        return this.loadPaymentMap;
    }

    public void setLoadPaymentMap(boolean loadPaymentMap) {
        this.loadPaymentMap = loadPaymentMap;
    }

    @Override
    public PopDefineBean findPopDefine(String moduleid) throws Exception {
        if (this.MODEL_DEFINE == null || !this.MODEL_DEFINE.containsKey(moduleid)) {
            PopDefineBean result = PopDefineServiceImpl.getInstance().loadFromDB(moduleid);
            if (result == null) {
                throw new ServiceException("10000", "POPDEFINE[{0}]\u672a\u5b9a\u4e49\uff01", new Object[]{moduleid});
            }
            return result;
        }
        return this.MODEL_DEFINE.get(moduleid);
    }

    public PopDefineBean findPopDefine(String moduleid, String defaultModuleid) throws Exception {
        PopDefineBean bean = null;
        if (!StringUtils.isEmpty((Object)moduleid)) {
            bean = this.findPopDefine(moduleid);
        }
        if (bean == null && !StringUtils.isEmpty((Object)defaultModuleid)) {
            bean = this.findPopDefine(defaultModuleid);
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PopDefineBean loadFromDB(String moduleid) {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations("GlobalStorageOperation");
            Criteria criteria = Criteria.where((String)"moduleid").is((Object)moduleid);
            Query query = new Query((CriteriaDefinition)criteria);
            PopDefineBean popDefineBean = (PopDefineBean)((Object)storage.selectOne(query, PopDefineBean.class));
            return popDefineBean;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PopDefineBean> loadAllDefine() {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations("GlobalStorageOperation");
            Query query = new Query((CriteriaDefinition)new Criteria());
            List list = storage.select(query, PopDefineBean.class);
            return list;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    @PostConstruct
    public int initPopDefine() {
        List<PopDefineBean> list_define = this.loadAllDefine();
        if (list_define != null && list_define.size() > 0) {
            this.MODEL_DEFINE.clear();
            for (PopDefineBean define : list_define) {
                this.MODEL_DEFINE.put(define.getModuleid(), define);
            }
            this.getLogger().info((Object)("init popdefine : " + String.valueOf(list_define.size())));
        }
        return list_define.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> loadPaymentMap() {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperationConfig("GlobalStorageOperation");
            Query query = new Query();
            List list = storage.select(query, "paymentmethodref_view_to_omp");
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return null;
    }

    @PostConstruct
    public int initPaymentMap() {
        if (!this.isLoadPaymentMap()) {
            return 0;
        }
        List<Map<String, Object>> list = this.loadPaymentMap();
        if (list != null && list.size() > 0) {
            this.PAYMODE_MAP.clear();
            for (int i = 0; i < list.size(); ++i) {
                String corpId = MapUtils.getString(list.get(i), (String)"erpcode", (String)"", (boolean)true);
                String erpPay = MapUtils.getString(list.get(i), (String)"erppaycode", (String)"", (boolean)true);
                String key = corpId.concat("-").concat(erpPay);
                if (this.PAYMODE_MAP.containsKey(key)) {
                    if (",".concat(this.PAYMODE_MAP.get(key).toString()).concat(",").indexOf(",".concat(MapUtils.getString(list.get(i), (String)"paycode", (String)"", (boolean)true)).concat(",")) >= 0) continue;
                    this.PAYMODE_MAP.put(key, this.PAYMODE_MAP.get(key).toString().concat(",").concat(MapUtils.getString(list.get(i), (String)"paycode", (String)"", (boolean)true)));
                    continue;
                }
                this.PAYMODE_MAP.put(key, MapUtils.getString(list.get(i), (String)"paycode", (String)"", (boolean)true));
            }
            this.getLogger().info((Object)("init paymentmap : " + String.valueOf(list.size())));
        }
        return list.size();
    }

    public String getPaymentMap(long ent_id, String corpid, String paycode) {
        if (this.PAYMODE_MAP == null || this.PAYMODE_MAP.size() <= 0) {
            this.initPaymentMap();
        }
        if (this.PAYMODE_MAP == null || this.PAYMODE_MAP.size() <= 0) {
            return paycode;
        }
        String key = corpid.concat("-").concat(paycode.substring(0, 3));
        return MapUtils.getString(this.PAYMODE_MAP, (String)key, (String)paycode);
    }

    public String refresh() {
        String result = "Refresh Memory: \n";
        result = result.concat("PopDefine : " + String.valueOf(this.initPopDefine())).concat("\n");
        if (this.isLoadPaymentMap()) {
            result = result.concat("PaymentMap: " + String.valueOf(this.initPaymentMap())).concat("\n");
        }
        return result;
    }
}

