/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omp.event.model.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.slice.filter.SliceBase;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import com.efuture.omp.event.model.common.CalcConfig;
import com.efuture.omp.event.model.component.PopDefineServiceImpl;
import com.efuture.omp.event.model.component.PopModelSliceBase;
import com.efuture.omp.event.model.entity.DictDetailBean;
import com.efuture.omp.event.model.entity.EvtBaseBean;
import com.efuture.omp.event.model.entity.EvtMainBean;
import com.efuture.omp.event.model.entity.EvtPolicyBean;
import com.efuture.omp.event.model.entity.EvtPolicyLadderBean;
import com.efuture.omp.event.model.entity.EvtPolicyLimitBean;
import com.efuture.omp.event.model.entity.EvtResultCouponBean;
import com.efuture.omp.event.model.entity.EvtResultGiftBean;
import com.efuture.omp.event.model.entity.EvtScopeConsBean;
import com.efuture.omp.event.model.entity.EvtScopeItemBean;
import com.efuture.omp.event.model.entity.EvtScopeOrgBean;
import com.efuture.omp.event.model.entity.EvtScopePayBean;
import com.efuture.omp.event.model.entity.EvtTimePeriod;
import com.efuture.omp.event.model.entity.ExtGoodsBean;
import com.efuture.omp.event.model.entity.PopDefineBean;
import com.efuture.omp.event.model.intf.Callback;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class PopModelServiceBase
extends PopModelSliceBase {
    private static Map<String, Object> dictdetailVal = new HashMap<String, Object>();
    private static Map<String, Object> dictdetailUnif = new HashMap<String, Object>();
    private static Map<String, Object> dictdetailRVal = new HashMap<String, Object>();
    public static final String SYSENDDATE = "2099-12-31";
    protected final String[] mapDimension = new String[]{"tag_code5", "tag_code4", "tag_code3", "tag_code2", "tag_code1", "cate_code", "brand_code", "gz_code", "counter_code", "goods_code"};
    @Autowired
    CalcConfig calcConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadExtGoods(String corpid, String mktid) {
        FStorageOperations storage = null;
        String eid = "";
        try {
            ArrayList eidList = new ArrayList();
            storage = this.getStorageOperationConfig("GlobalStorageOperation");
            Criteria criteria = Criteria.where((String)"corpid").is((Object)corpid);
            Query query = new Query((CriteriaDefinition)criteria);
            List exts = storage.select(query, ExtGoodsBean.class);
            if (exts == null || exts.size() == 0) {
                String string = eid;
                return string;
            }
            for (ExtGoodsBean ext : exts) {
                if ("%".equals(ext.getMktid())) {
                    eid = ext.getEid();
                    break;
                }
                if (!mktid.equals(ext.getMktid())) continue;
                eid = ext.getEid();
                break;
            }
            String string = eid;
            return string;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadPostzsz(ServiceSession session, String corpid, String moduleid) {
        FStorageOperations storage = null;
        String eid = "";
        try {
            ArrayList eidList = new ArrayList();
            storage = this.getStorageOperationConfig("GlobalStorageOperation");
            Criteria criteria = Criteria.where((String)"corpid").is((Object)corpid).and("moduleid").is((Object)moduleid).and("ent_id").is((Object)session.getEnt_id());
            Query query = new Query((CriteriaDefinition)criteria);
            List exts = storage.select(query, "poszsz");
            if (exts != null && exts.size() > 0) {
                eid = ((Map)exts.get(0)).get("flag").toString();
            }
            String string = eid;
            return string;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDictFromDB() {
        FStorageOperations storage = null;
        Map<String, Object> map = dictdetailVal;
        synchronized (map) {
            if (dictdetailVal.isEmpty()) {
                try {
                    storage = this.getStorageOperationConfig("GlobalStorageOperation");
                    Criteria criteria = Criteria.where((String)"dtcode").is((Object)"popdimension");
                    Query query = new Query((CriteriaDefinition)criteria);
                    List dicts = storage.select(query, DictDetailBean.class);
                    for (int i = 0; i < dicts.size(); ++i) {
                        DictDetailBean dict = (DictDetailBean)((Object)dicts.get(i));
                        dictdetailVal.put(dict.getDdcode(), dict.getDdorderno());
                        dictdetailUnif.put(dict.getDdvalue(), dict.getDdorderno());
                        dictdetailRVal.put(dict.getDdvalue(), dict.getDdcode());
                    }
                }
                finally {
                    if (storage != null) {
                        storage.destroy();
                    }
                }
            }
        }
    }

    public PopDefineBean getPopDefine(JSONObject jsonparam, String defBilltype) throws Exception {
        PopDefineBean p = PopDefineServiceImpl.getInstance().findPopDefine(DataUtils.nvl((String)jsonparam.getString("billtype"), (String[])new String[]{defBilltype}));
        if (p == null && jsonparam.containsKey((Object)"billtype") && StringUtils.isEmpty((Object)jsonparam.getString("billtype"))) {
            p = PopDefineServiceImpl.getInstance().findPopDefine(defBilltype);
        }
        return p;
    }

    public long getEventId(long ent_id) {
        return UniqueID.getUniqueID();
    }

    public long getTimestamp(FStorageOperations storage) {
        return System.currentTimeMillis() / 1000L;
    }

    public String getStrCurrDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    protected ServiceResponse checkParms(ServiceSession session, JSONObject jsonparam) {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        return null;
    }

    public CalcConfig getCalcConfig() {
        return this.calcConfig;
    }

    public void setCalcConfig(CalcConfig calcConfig) {
        this.calcConfig = calcConfig;
    }

    protected int doUpdateByPrimaryKey(FStorageOperations storage, Query query, Update upt, Class<?> clazz) throws IllegalArgumentException, IllegalAccessException {
        String idkey = (String)AbstractEntityBean.fetchDeclaredField(clazz, (String)"ID_KEY").get(null);
        query.fields().include(idkey);
        List list_objects = storage.select(query, clazz);
        if (list_objects == null || list_objects.size() <= 0) {
            return 0;
        }
        ArrayList<Long> list_keys = new ArrayList<Long>();
        for (Object obj : list_objects) {
            Long key = AbstractEntityBean.fetchDeclaredField(clazz, (String)idkey).getLong(obj);
            if (StringUtils.isEmpty((Object)key)) continue;
            list_keys.add(key);
        }
        if (list_keys == null || list_keys.size() <= 0) {
            return 0;
        }
        Criteria criteria = Criteria.where((String)idkey).in(list_keys);
        Query query_key = new Query((CriteriaDefinition)criteria);
        return storage.update(query_key, upt, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doUpdateEventModel(long ent_id, String billid, Update upt) throws Exception {
        boolean result = false;
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            long utctime = this.getTimestamp(storage);
            upt.set("tmdd", (Object)utctime);
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("billid").is((Object)billid).and("nsta").is((Object)2021L);
            Query query = new Query((CriteriaDefinition)criteria);
            if (storage.count(query, EvtScopeItemBean.class) > 0L) {
                storage.update(query, upt, EvtScopeItemBean.class);
            }
            if (storage.count(query, EvtPolicyBean.class) > 0L) {
                storage.update(query, upt, EvtPolicyBean.class);
            }
            if (storage.count(query, EvtPolicyLadderBean.class) > 0L) {
                storage.update(query, upt, EvtPolicyLadderBean.class);
            }
            if (storage.count(query, EvtPolicyLimitBean.class) > 0L) {
                storage.update(query, upt, EvtPolicyLimitBean.class);
            }
            if (storage.count(query, EvtResultCouponBean.class) > 0L) {
                storage.update(query, upt, EvtResultCouponBean.class);
            }
            if (storage.count(query, EvtResultGiftBean.class) > 0L) {
                storage.update(query, upt, EvtResultGiftBean.class);
            }
            if (storage.count(query, EvtScopeConsBean.class) > 0L) {
                storage.update(query, upt, EvtScopeConsBean.class);
            }
            if (storage.count(query, EvtScopeOrgBean.class) > 0L) {
                storage.update(query, upt, EvtScopeOrgBean.class);
            }
            if (storage.count(query, EvtScopePayBean.class) > 0L) {
                storage.update(query, upt, EvtScopePayBean.class);
            }
            if (storage.count(query, EvtMainBean.class) > 0L) {
                result = storage.update(query, upt, EvtMainBean.class) > 0;
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return result;
    }

    protected boolean doCancelEvent(long ent_id, String billid) throws Exception {
        Update upt = new Update();
        upt.set("nsta", (Object)2022L);
        return this.doUpdateEventModel(ent_id, billid, upt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doDelayEventModel(long ent_id, String billid, String sta_date, String end_date, String sta_time, String end_time) throws Exception {
        FStorageOperations storage = null;
        try {
            Criteria criteria;
            Query query;
            storage = this.getStorageOperations();
            int tot_rows = 0;
            long utctime = this.getTimestamp(storage);
            Update upt = new Update();
            Update uptItem = new Update();
            if (!StringUtils.isEmpty((Object)sta_date)) {
                upt.set("sta_date", (Object)sta_date);
            }
            upt.set("end_date", (Object)end_date);
            upt.set("tmdd", (Object)utctime);
            if (!StringUtils.isEmpty((Object)sta_date)) {
                uptItem.set("sta_date", (Object)sta_date);
            }
            uptItem.set("end_date", (Object)end_date);
            uptItem.set("tmdd", (Object)utctime);
            if (!StringUtils.isEmpty((Object)sta_time)) {
                uptItem.set("sta_time", (Object)sta_time);
            }
            if (!StringUtils.isEmpty((Object)end_time)) {
                uptItem.set("end_time", (Object)end_time);
            }
            if (storage.count(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("billid").is((Object)billid).and("nsta").is((Object)2021L))), EvtScopeItemBean.class) > 0L) {
                tot_rows = storage.update(query, uptItem, EvtScopeItemBean.class);
            }
            if (storage.count(query, EvtMainBean.class) > 0L) {
                storage.update(query, upt, EvtMainBean.class);
            }
            int n = tot_rows;
            return n;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doCancelModelSingle(Query query) throws Exception {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            long utctime = this.getTimestamp(storage);
            Update upt = new Update();
            upt.set("nsta", (Object)2022L);
            upt.set("tmdd", (Object)utctime);
            if (storage.count(query, EvtScopeItemBean.class) > 0L) {
                int n = storage.update(query, upt, EvtScopeItemBean.class);
                return n;
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doCancelModelSingle(EvtScopeItemBean bean) throws Exception {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and("seqno").is((Object)bean.getSeqno()));
            long utctime = this.getTimestamp(storage);
            Update upt = new Update();
            upt.set("nsta", (Object)2022L);
            upt.set("tmdd", (Object)utctime);
            if (storage.count(query, EvtScopeItemBean.class) > 0L) {
                int n = storage.update(query, upt, EvtScopeItemBean.class);
                return n;
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doCancelModelBatch(long ent_id, HashSet<Long> list_seq) throws Exception {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"ent_id").is((Object)ent_id).and("seqno").in(list_seq));
            long utctime = this.getTimestamp(storage);
            Update upt = new Update();
            upt.set("nsta", (Object)2022L);
            upt.set("tmdd", (Object)utctime);
            if (storage.count(query, EvtScopeItemBean.class) > 0L) {
                int n = storage.update(query, upt, EvtScopeItemBean.class);
                return n;
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doDelayModelSingle(Query query, EvtScopeItemBean item) throws Exception {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            long utctime = this.getTimestamp(storage);
            Update upt = new Update();
            if (!StringUtils.isEmpty((Object)item.getSta_date())) {
                upt.set("sta_date", (Object)item.getSta_date());
            }
            if (!StringUtils.isEmpty((Object)item.getEnd_date())) {
                upt.set("end_date", (Object)item.getEnd_date());
            }
            if (!StringUtils.isEmpty((Object)item.getSta_time())) {
                upt.set("sta_time", (Object)item.getSta_time());
            }
            if (!StringUtils.isEmpty((Object)item.getEnd_time())) {
                upt.set("end_time", (Object)item.getEnd_time());
            }
            if (!StringUtils.isEmpty((Object)item.getWeeklist())) {
                upt.set("weeklist", (Object)item.getWeeklist());
            }
            upt.set("tmdd", (Object)utctime);
            if (storage.count(query, EvtScopeItemBean.class) > 0L) {
                int n = storage.update(query, upt, EvtScopeItemBean.class);
                return n;
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doDelayModelSingle(Query query, List<EvtTimePeriod> periods) throws Exception {
        if (StringUtils.isEmpty(periods) || periods.size() <= 0) {
            return 0;
        }
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            long utctime = this.getTimestamp(storage);
            Update upt = new Update();
            upt.set("nsta", (Object)2023L);
            upt.set("tmdd", (Object)utctime);
            storage.update(query, upt, EvtScopeItemBean.class);
            query.limit(1);
            EvtScopeItemBean itemOne = (EvtScopeItemBean)storage.selectOne(query, EvtScopeItemBean.class);
            if (StringUtils.isEmpty((Object)itemOne)) {
                int n = 0;
                return n;
            }
            for (int i = 0; i < periods.size(); ++i) {
                EvtScopeItemBean itemNew = itemOne.clone();
                itemNew.setSta_date(periods.get(i).getSta_date());
                itemNew.setEnd_date(periods.get(i).getEnd_date());
                itemNew.setSta_time(periods.get(i).getSta_time());
                itemNew.setEnd_time(periods.get(i).getEnd_time());
                itemNew.setWeeklist(periods.get(i).getWeeklist());
                itemNew.setSeqno(UniqueID.getUniqueID());
                itemNew.setTmdd(utctime);
                storage.insert((Object)itemNew);
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return periods.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRefreshEventTime(long ent_id, String billid) throws Exception {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            long utctime = this.getTimestamp(storage);
            Update upt = new Update();
            upt.set("tmdd", (Object)utctime);
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("billid").is((Object)billid).and("nsta").is((Object)2021L);
            Query query = new Query((CriteriaDefinition)criteria);
            if (storage.count(query, EvtMainBean.class) > 0L) {
                storage.update(query, upt, EvtMainBean.class);
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRefreshEventTime(long ent_id, long evt_id) throws Exception {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            long utctime = this.getTimestamp(storage);
            Update upt = new Update();
            upt.set("tmdd", (Object)utctime);
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("eid").is((Object)evt_id).and("nsta").is((Object)2021L);
            Query query = new Query((CriteriaDefinition)criteria);
            if (storage.count(query, EvtMainBean.class) > 0L) {
                storage.update(query, upt, EvtMainBean.class);
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRefreshEventTimeBatch(long ent_id, HashSet<Long> list_eid) throws Exception {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            long utctime = this.getTimestamp(storage);
            Update upt = new Update();
            upt.set("tmdd", (Object)utctime);
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("eid").in(list_eid).and("nsta").is((Object)2021L);
            Query query = new Query((CriteriaDefinition)criteria);
            if (storage.count(query, EvtMainBean.class) > 0L) {
                storage.update(query, upt, EvtMainBean.class);
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    protected String createDimenKey(EvtScopeItemBean itemscope) throws Exception {
        if ("0".equals(itemscope.getCodemode())) {
            return "0";
        }
        if (this.calcConfig != null && this.calcConfig.getMatchDimen() != null) {
            boolean exist = false;
            for (String str : this.calcConfig.getMatchDimen()) {
                if (!itemscope.getCodemode().equalsIgnoreCase(str)) continue;
                exist = true;
                break;
            }
            if (!exist) {
                return "%";
            }
        }
        String dimenkey = itemscope.getCodemode();
        JSONObject json = (JSONObject)JSON.toJSON((Object)itemscope);
        for (int i = 0; i < itemscope.getCodemode().length(); ++i) {
            char flag = itemscope.getCodemode().charAt(i);
            if (flag == '0') continue;
            String key = this.mapDimension[i];
            Object obj = json.get((Object)key);
            if (StringUtils.isEmpty((Object)obj)) {
                obj = "%";
            }
            dimenkey = dimenkey + "-" + obj;
        }
        if (dimenkey.equalsIgnoreCase(dimenkey + "-%")) {
            dimenkey = "0";
        }
        return dimenkey;
    }

    protected String createDupKey(EvtScopeItemBean itemscope) throws Exception {
        int len;
        String DimKey = null;
        String codemode = itemscope.getCodemode();
        StringBuilder str = new StringBuilder();
        for (int i = len = codemode.length() - 1; i >= 0; --i) {
            String sky;
            block5: {
                char flag = codemode.charAt(i);
                if (flag == '0') continue;
                sky = this.mapDimension[i];
                try {
                    Field itemfld = AbstractEntityBean.fetchDeclaredField(EvtScopeItemBean.class, (String)sky);
                    Object value = itemfld.get((Object)this);
                    if (value == null) break block5;
                    if (i != len) {
                        str.append('-');
                    }
                    str.append(i);
                    str.append('-');
                    str.append(value);
                }
                catch (Exception ex) {
                    break;
                }
            }
            if (sky.equalsIgnoreCase("goods_code")) break;
        }
        if (StringUtils.isEmpty((Object)(DimKey = str.toString()))) {
            DimKey = "F";
        }
        return DimKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED)
    protected void InsertEvent(EvtMainBean event) throws Exception {
        FStorageOperations storage = null;
        try {
            EvtBaseBean thisobj;
            int i;
            storage = this.getStorageOperations();
            long eid = this.getEventId(event.getEnt_id());
            String billid = event.getBillid();
            long utctime = this.getTimestamp(storage);
            long policy_id = 0L;
            event.setEid(eid);
            event.setTmdd(utctime);
            event.setTcrd(utctime);
            event.setSta_date(DataUtils.nvl((String)event.getSta_date(), (String[])new String[]{"1900-01-01"}));
            event.setEnd_date(DataUtils.nvl((String)event.getEnd_date(), (String[])new String[]{SYSENDDATE}));
            event.setElevel(DataUtils.nvl((int)event.getElevel(), (int[])new int[]{0}));
            ArrayList<EvtScopeOrgBean> list_orgs = new ArrayList<EvtScopeOrgBean>();
            ArrayList<EvtBaseBean> list_cons = new ArrayList<EvtBaseBean>();
            ArrayList<EvtBaseBean> list_pays = new ArrayList<EvtBaseBean>();
            ArrayList<EvtBaseBean> list_limit = new ArrayList<EvtBaseBean>();
            ArrayList<EvtScopeItemBean> list_items = new ArrayList<EvtScopeItemBean>();
            ArrayList<EvtBaseBean> list_policy = new ArrayList<EvtBaseBean>();
            ArrayList<EvtPolicyLadderBean> list_ladder = new ArrayList<EvtPolicyLadderBean>();
            ArrayList<EvtBaseBean> list_gifts = new ArrayList<EvtBaseBean>();
            ArrayList<EvtBaseBean> list_result = new ArrayList<EvtBaseBean>();
            if (!StringUtils.isEmpty(event.getOrgs())) {
                this.CheckOrgs(event);
                for (i = 0; i < event.getOrgs().size(); ++i) {
                    thisobj = event.getOrgs().get(i);
                    ((EvtScopeOrgBean)thisobj).setSeqno(UniqueID.getUniqueID());
                    ((EvtScopeOrgBean)thisobj).setEvt_id(eid);
                    thisobj.setEnt_id(event.getEnt_id());
                    ((EvtScopeOrgBean)thisobj).setEvt_scd(event.getEvt_scd());
                    ((EvtScopeOrgBean)thisobj).setCorp_id(event.getCorp_id());
                    ((EvtScopeOrgBean)thisobj).setOrg_code(DataUtils.nvl((String)((EvtScopeOrgBean)thisobj).getOrg_code(), (String[])new String[]{"%"}));
                    ((EvtScopeOrgBean)thisobj).setChl_code(DataUtils.nvl((String)((EvtScopeOrgBean)thisobj).getChl_code(), (String[])new String[]{"%"}));
                    ((EvtScopeOrgBean)thisobj).setJoinmode(DataUtils.nvl((String)((EvtScopeOrgBean)thisobj).getJoinmode(), (String[])new String[]{"Y"}));
                    thisobj.setBillid(billid);
                    thisobj.setTcrd(utctime);
                    thisobj.setTmdd(utctime);
                    list_orgs.add((EvtScopeOrgBean)thisobj);
                }
            }
            if (!StringUtils.isEmpty(event.getCons())) {
                for (i = 0; i < event.getCons().size(); ++i) {
                    thisobj = event.getCons().get(i);
                    ((EvtScopeConsBean)thisobj).setSeqno(UniqueID.getUniqueID());
                    ((EvtScopeConsBean)thisobj).setEvt_id(eid);
                    thisobj.setEnt_id(event.getEnt_id());
                    ((EvtScopeConsBean)thisobj).setEvt_scd(event.getEvt_scd());
                    ((EvtScopeConsBean)thisobj).setCorp_id(event.getCorp_id());
                    ((EvtScopeConsBean)thisobj).setCons_mode(DataUtils.nvl((String)((EvtScopeConsBean)thisobj).getCons_mode(), (String[])new String[]{"100"}));
                    ((EvtScopeConsBean)thisobj).setCons_rak(DataUtils.nvl((String)((EvtScopeConsBean)thisobj).getCons_rak(), (String[])new String[]{"ALL"}));
                    ((EvtScopeConsBean)thisobj).setCons_grp(DataUtils.nvl((String)((EvtScopeConsBean)thisobj).getCons_grp(), (String[])new String[]{"%"}));
                    ((EvtScopeConsBean)thisobj).setJoinmode(DataUtils.nvl((String)((EvtScopeConsBean)thisobj).getJoinmode(), (String[])new String[]{"Y"}));
                    thisobj.setBillid(billid);
                    thisobj.setTcrd(utctime);
                    thisobj.setTmdd(utctime);
                    list_cons.add(thisobj);
                }
            }
            if (!StringUtils.isEmpty(event.getPays())) {
                for (i = 0; i < event.getPays().size(); ++i) {
                    thisobj = event.getPays().get(i);
                    ((EvtScopePayBean)thisobj).setSeqno(UniqueID.getUniqueID());
                    ((EvtScopePayBean)thisobj).setEvt_id(eid);
                    thisobj.setEnt_id(event.getEnt_id());
                    ((EvtScopePayBean)thisobj).setEvt_scd(event.getEvt_scd());
                    ((EvtScopePayBean)thisobj).setCorp_id(event.getCorp_id());
                    thisobj.setBillid(billid);
                    thisobj.setTcrd(utctime);
                    thisobj.setTmdd(utctime);
                    list_pays.add(thisobj);
                }
            }
            if (!StringUtils.isEmpty(event.getPolicy())) {
                for (i = 0; i < event.getPolicy().size(); ++i) {
                    thisobj = event.getPolicy().get(i);
                    policy_id = DataUtils.nvl((long)((EvtPolicyBean)thisobj).getPid(), (long[])new long[]{UniqueID.getUniqueID()});
                    ((EvtPolicyBean)thisobj).setPid(policy_id);
                    ((EvtPolicyBean)thisobj).setEvt_id(eid);
                    thisobj.setEnt_id(event.getEnt_id());
                    ((EvtPolicyBean)thisobj).setEvt_scd(event.getEvt_scd());
                    ((EvtPolicyBean)thisobj).setCorp_id(event.getCorp_id());
                    thisobj.setBillid(billid);
                    thisobj.setTcrd(utctime);
                    thisobj.setTmdd(utctime);
                    boolean maxfb = false;
                    if ("6".equalsIgnoreCase(((EvtPolicyBean)thisobj).getCondtype())) {
                        ((EvtPolicyBean)thisobj).setCondtype("1");
                        maxfb = true;
                    }
                    list_policy.add(thisobj);
                    if (StringUtils.isEmpty(((EvtPolicyBean)thisobj).getLadder())) continue;
                    for (int j = 0; j < ((EvtPolicyBean)thisobj).getLadder().size(); ++j) {
                        EvtBaseBean thisladdetail;
                        int k;
                        EvtPolicyLadderBean thisladder = ((EvtPolicyBean)thisobj).getLadder().get(j);
                        long ladder_id = StringUtils.isEmpty((Object)thisladder.getLid()) || thisladder.getLid() == 0L ? UniqueID.getUniqueID() : (thisladder.getLid() == -1L ? 0L : thisladder.getLid());
                        thisladder.setLid(ladder_id);
                        thisladder.setPolicy_id(policy_id);
                        thisladder.setEvt_id(eid);
                        thisladder.setEnt_id(event.getEnt_id());
                        thisladder.setEvt_scd(event.getEvt_scd());
                        thisladder.setCorp_id(event.getCorp_id());
                        thisladder.setBillid(billid);
                        thisladder.setTcrd(utctime);
                        thisladder.setTmdd(utctime);
                        if (maxfb) {
                            thisladder.setMaxfb(1);
                        }
                        if (ladder_id > 0L) {
                            list_ladder.add(thisladder);
                        }
                        if (!StringUtils.isEmpty(thisladder.getGifts())) {
                            for (k = 0; k < thisladder.getGifts().size(); ++k) {
                                thisladdetail = thisladder.getGifts().get(k);
                                ((EvtResultGiftBean)thisladdetail).setSeqno(UniqueID.getUniqueID());
                                ((EvtResultGiftBean)thisladdetail).setEvt_id(eid);
                                thisladdetail.setEnt_id(event.getEnt_id());
                                ((EvtResultGiftBean)thisladdetail).setEvt_scd(event.getEvt_scd());
                                ((EvtResultGiftBean)thisladdetail).setCorp_id(event.getCorp_id());
                                ((EvtResultGiftBean)thisladdetail).setPolicy_id(policy_id);
                                ((EvtResultGiftBean)thisladdetail).setLadder_id(ladder_id);
                                thisladdetail.setBillid(billid);
                                thisladdetail.setTcrd(utctime);
                                thisladdetail.setTmdd(utctime);
                                list_gifts.add(thisladdetail);
                            }
                        }
                        if (!StringUtils.isEmpty(thisladder.getResults())) {
                            for (k = 0; k < thisladder.getResults().size(); ++k) {
                                thisladdetail = thisladder.getResults().get(k);
                                ((EvtResultCouponBean)thisladdetail).setSeqno(UniqueID.getUniqueID());
                                ((EvtResultCouponBean)thisladdetail).setEvt_id(eid);
                                thisladdetail.setEnt_id(event.getEnt_id());
                                ((EvtResultCouponBean)thisladdetail).setEvt_scd(event.getEvt_scd());
                                ((EvtResultCouponBean)thisladdetail).setCorp_id(event.getCorp_id());
                                ((EvtResultCouponBean)thisladdetail).setPolicy_id(policy_id);
                                ((EvtResultCouponBean)thisladdetail).setLadder_id(ladder_id);
                                thisladdetail.setBillid(billid);
                                thisladdetail.setTcrd(utctime);
                                thisladdetail.setTmdd(utctime);
                                list_result.add(thisladdetail);
                            }
                        }
                        if (StringUtils.isEmpty(thisladder.getLimits())) continue;
                        for (k = 0; k < thisladder.getLimits().size(); ++k) {
                            thisladdetail = thisladder.getLimits().get(k);
                            ((EvtPolicyLimitBean)thisladdetail).setSeqno(UniqueID.getUniqueID());
                            ((EvtPolicyLimitBean)thisladdetail).setEvt_id(eid);
                            thisladdetail.setEnt_id(event.getEnt_id());
                            ((EvtPolicyLimitBean)thisladdetail).setEvt_scd(event.getEvt_scd());
                            ((EvtPolicyLimitBean)thisladdetail).setCorp_id(event.getCorp_id());
                            ((EvtPolicyLimitBean)thisladdetail).setPolicy_id(policy_id);
                            ((EvtPolicyLimitBean)thisladdetail).setLadder_id(ladder_id);
                            thisladdetail.setBillid(billid);
                            thisladdetail.setTcrd(utctime);
                            thisladdetail.setTmdd(utctime);
                            list_limit.add(thisladdetail);
                        }
                    }
                }
            }
            if (!StringUtils.isEmpty(event.getItems())) {
                for (i = 0; i < event.getItems().size(); ++i) {
                    EvtBaseBean item;
                    thisobj = event.getItems().get(i);
                    ((EvtScopeItemBean)thisobj).setSeqno(UniqueID.getUniqueID());
                    ((EvtScopeItemBean)thisobj).setEvt_id(eid);
                    thisobj.setEnt_id(event.getEnt_id());
                    ((EvtScopeItemBean)thisobj).setEvt_scd(event.getEvt_scd());
                    if (StringUtils.isEmpty((Object)((EvtScopeItemBean)thisobj).getOrg_code())) {
                        ((EvtScopeItemBean)thisobj).setOrg_code(null);
                    }
                    ((EvtScopeItemBean)thisobj).setCorp_id(event.getCorp_id());
                    ((EvtScopeItemBean)thisobj).setPolicy_id(policy_id);
                    thisobj.setBillid(billid);
                    thisobj.setTcrd(utctime);
                    thisobj.setTmdd(utctime);
                    ((EvtScopeItemBean)thisobj).setCstr2(this.createDimenKey((EvtScopeItemBean)thisobj));
                    list_items.add((EvtScopeItemBean)thisobj);
                    if (!event.getEgroup().equalsIgnoreCase("PREFE") && !event.getEgroup().equalsIgnoreCase("VIP") || !(((EvtScopeItemBean)(item = thisobj)).getPopmax_cons_day() > 0.0 || ((EvtScopeItemBean)item).getPopmax_cons_tot() > 0.0 || ((EvtScopeItemBean)item).getPopmax_day() > 0.0) && !(((EvtScopeItemBean)item).getPopmax_tot() > 0.0)) continue;
                    EvtPolicyLimitBean limits = new EvtPolicyLimitBean();
                    limits.setSeqno(UniqueID.getUniqueID());
                    limits.setEvt_id(eid);
                    limits.setEnt_id(event.getEnt_id());
                    limits.setEvt_scd(event.getEvt_scd());
                    limits.setCorp_id(event.getCorp_id());
                    limits.setLimit_mode("ITEM");
                    limits.setPolicy_id(policy_id);
                    limits.setLadder_id(0L);
                    limits.setBillid(billid);
                    limits.setCop_type(String.valueOf(((EvtScopeItemBean)item).getSeqno()));
                    limits.setCons_day_popsl(((EvtScopeItemBean)item).getPopmax_cons_day());
                    limits.setCons_popsl(((EvtScopeItemBean)item).getPopmax_cons_tot());
                    limits.setDay_popsl(((EvtScopeItemBean)item).getPopmax_day());
                    limits.setTot_popsl(((EvtScopeItemBean)item).getPopmax_tot());
                    limits.setTcrd(utctime);
                    limits.setTmdd(utctime);
                    list_limit.add(limits);
                }
            }
            Set<String> slices = this.getSliceList(list_orgs);
            for (String slice : slices) {
                if (!"N/A".equalsIgnoreCase(slice)) {
                    SliceBase.setCurrentSlice((String)slice);
                }
                this.batchInsert((FMybatisTemplate)storage, EvtScopeItemBean.class, this.filterItemsSliceData(list_items, slice));
                this.batchInsert((FMybatisTemplate)storage, EvtPolicyBean.class, list_policy);
                this.batchInsert((FMybatisTemplate)storage, EvtPolicyLadderBean.class, list_ladder);
                this.batchInsert((FMybatisTemplate)storage, EvtPolicyLimitBean.class, list_limit);
                this.batchInsert((FMybatisTemplate)storage, EvtResultCouponBean.class, list_result);
                this.batchInsert((FMybatisTemplate)storage, EvtResultGiftBean.class, list_gifts);
                this.batchInsert((FMybatisTemplate)storage, EvtScopeOrgBean.class, this.filterOrgsSliceData(list_orgs, slice));
                this.batchInsert((FMybatisTemplate)storage, EvtScopeConsBean.class, list_cons);
                this.batchInsert((FMybatisTemplate)storage, EvtScopePayBean.class, list_pays);
                storage.insert((Object)event);
            }
            SliceBase.setCurrentSlice(null);
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    protected EvtMainBean createBeanFromJSON(ServiceSession session, JSONObject jsonparam) {
        EvtMainBean event = (EvtMainBean)JSONObject.parseObject((String)jsonparam.toJSONString(), EvtMainBean.class);
        if (StringUtils.isEmpty((Object)event.getEnt_id())) {
            event.setEnt_id(session.getEnt_id());
        }
        return event;
    }

    protected void preProcessModel(EvtMainBean event) throws Exception {
        if (event.getBillid().indexOf("-") < 0) {
            this.doCancelEvent(event.getEnt_id(), event.getBillid());
        } else {
            String[] str_list = event.getBillid().split("-");
            if (str_list[1].equals("1")) {
                this.doCancelEvent(event.getEnt_id(), str_list[0]);
            }
            event.setBillid(str_list[0]);
        }
    }

    protected void preProcessDimension(EvtMainBean event, PopDefineBean popDefine, Callback callback) throws Exception {
        HashSet<String> hvexec = new HashSet<String>();
        List<EvtScopeItemBean> itemsList = event.getItems();
        ArrayList<EvtScopeItemBean> exec = null;
        List<EvtScopeItemBean> items = event.getItems();
        ArrayList<EvtScopeItemBean> exceps = new ArrayList<EvtScopeItemBean>();
        boolean execed = false;
        if (!StringUtils.isEmpty(items)) {
            int i;
            for (i = 0; i < items.size(); ++i) {
                if (items.get(i).getJoinmode().equalsIgnoreCase("Y")) continue;
                exceps.add(items.get(i));
            }
            for (i = 0; i < items.size(); ++i) {
                int j;
                EvtScopeItemBean item = items.get(i);
                if (!item.getJoinmode().equalsIgnoreCase("Y")) continue;
                String codemode = item.getCodemode();
                execed = false;
                if (hvexec.contains(codemode)) {
                    execed = true;
                }
                if (execed) continue;
                hvexec.add(codemode);
                exec = new ArrayList<EvtScopeItemBean>();
                exec.add(item);
                for (j = i + 1; j < items.size(); ++j) {
                    EvtScopeItemBean itemj = items.get(j);
                    if (!itemj.getJoinmode().equalsIgnoreCase("Y") || !codemode.equals(itemj.getCodemode())) continue;
                    exec.add(itemj);
                }
                for (j = 0; j < exceps.size(); ++j) {
                    exec.add(((EvtScopeItemBean)exceps.get(j)).clone());
                }
                event.setItems(exec);
                this.InitEventMain(event, popDefine, codemode);
                callback.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doCheckExists(long ent_id, String billid) {
        boolean result = false;
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("billid").is((Object)billid).and("nsta").is((Object)2021L);
            Query query = new Query((CriteriaDefinition)criteria);
            long l = storage.count(query, EvtMainBean.class);
            return l;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    protected void CheckPeriod(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        this.CheckPeriod(event.getItems(), event.getPeriod(), popDefine);
    }

    protected void CheckPeriod(List<EvtScopeItemBean> items, List<EvtTimePeriod> periods, PopDefineBean popDefine) throws Exception {
        ArrayList<EvtScopeItemBean> newitems = new ArrayList<EvtScopeItemBean>();
        List<EvtTimePeriod> periodss = this.getmergeperiod(periods, popDefine);
        for (int i = 0; i < items.size(); ++i) {
            EvtScopeItemBean item = items.get(i);
            if (StringUtils.isEmpty(periodss)) {
                item.setSta_date(DataUtils.nvl((String)item.getSta_date(), (String[])new String[]{"1900-01-01"}));
                item.setEnd_date(DataUtils.nvl((String)item.getEnd_date(), (String[])new String[]{SYSENDDATE}));
                item.setSta_time(DataUtils.nvl((String)item.getSta_time(), (String[])new String[]{"00:00"}));
                item.setEnd_time(DataUtils.nvl((String)item.getEnd_time(), (String[])new String[]{"23:59"}));
                continue;
            }
            for (int j = 0; j < periodss.size(); ++j) {
                if (j != 0) {
                    EvtScopeItemBean newitem = item.clone();
                    newitem.setSta_date(DataUtils.nvl((String)periodss.get(j).getSta_date(), (String[])new String[]{"1900-01-01"}));
                    newitem.setSta_time(DataUtils.nvl((String)periodss.get(j).getSta_time(), (String[])new String[]{"00:00"}));
                    newitem.setEnd_date(DataUtils.nvl((String)periodss.get(j).getEnd_date(), (String[])new String[]{SYSENDDATE}));
                    newitem.setEnd_time(DataUtils.nvl((String)periodss.get(j).getEnd_time(), (String[])new String[]{"23:59"}));
                    newitem.setWeeklist(DataUtils.nvl((String)periodss.get(j).getWeeklist(), (String[])new String[]{"%"}));
                    newitems.add(newitem);
                    continue;
                }
                item.setSta_date(DataUtils.nvl((String)periodss.get(j).getSta_date(), (String[])new String[]{"1900-01-01"}));
                item.setSta_time(DataUtils.nvl((String)periodss.get(j).getSta_time(), (String[])new String[]{"00:00"}));
                item.setEnd_date(DataUtils.nvl((String)periodss.get(j).getEnd_date(), (String[])new String[]{SYSENDDATE}));
                item.setEnd_time(DataUtils.nvl((String)periodss.get(j).getEnd_time(), (String[])new String[]{"23:59"}));
                item.setWeeklist(DataUtils.nvl((String)periodss.get(j).getWeeklist(), (String[])new String[]{"%"}));
            }
        }
        if (newitems.size() > 0) {
            items.addAll(newitems);
        }
    }

    protected void CheckCons(EvtMainBean event, String cons_rak) {
        if (!StringUtils.isEmpty(event.getCons())) {
            for (int i = 0; i < event.getCons().size(); ++i) {
                EvtScopeConsBean cons = event.getCons().get(i);
                cons.setCons_mode(DataUtils.nvl((String)cons.getCons_mode(), (String[])new String[]{"100"}));
                cons.setCons_rak(DataUtils.nvl((String)cons.getCons_rak(), (String[])new String[]{cons_rak}));
                cons.setCons_grp(DataUtils.nvl((String)cons.getCons_grp(), (String[])new String[]{"%"}));
                cons.setCons_id(DataUtils.nvl((String)cons.getCons_id(), (String[])new String[]{"%"}));
                cons.setJoinmode(DataUtils.nvl((String)cons.getJoinmode(), (String[])new String[]{"Y"}));
            }
        } else {
            ArrayList<EvtScopeConsBean> cons_list = new ArrayList<EvtScopeConsBean>();
            EvtScopeConsBean cons = new EvtScopeConsBean();
            cons.setCons_mode("100");
            cons.setCons_rak(cons_rak);
            cons.setCons_grp("%");
            cons.setCons_id("%");
            cons.setJoinmode("Y");
            cons_list.add(cons);
            event.setCons(cons_list);
        }
    }

    protected void CheckOrgs(EvtMainBean event) {
        if (!StringUtils.isEmpty(event.getOrgs())) {
            for (int i = 0; i < event.getOrgs().size(); ++i) {
                EvtScopeOrgBean orgs = event.getOrgs().get(i);
                orgs.setChl_code(DataUtils.nvl((String)orgs.getChl_code(), (String[])new String[]{"%"}));
                orgs.setOrg_code(DataUtils.nvl((String)orgs.getOrg_code(), (String[])new String[]{"%"}));
                if (StringUtils.isEmpty((Object)orgs.getOrg_mode())) {
                    if ("%".equals(orgs.getChl_code()) && "%".equals(orgs.getOrg_code())) {
                        orgs.setOrg_mode("0");
                    } else if ("%".equals(orgs.getChl_code())) {
                        orgs.setOrg_mode("0001");
                    } else if ("%".equals(orgs.getOrg_code())) {
                        orgs.setOrg_mode("0010");
                    } else {
                        orgs.setOrg_mode("0011");
                    }
                }
                orgs.setJoinmode(DataUtils.nvl((String)orgs.getJoinmode(), (String[])new String[]{"Y"}));
            }
        }
    }

    protected void InitEventMain(EvtMainBean event, PopDefineBean popDefine, String dim) throws Exception {
        if (dictdetailVal.size() < 1 || dictdetailVal.isEmpty()) {
            this.loadDictFromDB();
        }
        if (StringUtils.isEmpty((Object)((Object)popDefine))) {
            throw new Exception("\u67e5\u627e\u4fc3\u9500\u9ed8\u8ba4\u5b9a\u4e49\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Object s = dictdetailVal.get(dim);
        if (s == null || dim.length() > 8) {
            s = dictdetailUnif.get(dim);
        }
        if (s == null || StringUtils.isEmpty((Object)s)) {
            s = dictdetailVal.get("COMBO");
        }
        int dem = 0;
        if (s != null && !StringUtils.isEmpty((Object)s)) {
            dem = Integer.parseInt(s.toString());
        }
        if (dim.length() > 8) {
            event.setPri(popDefine.getPri() * 100 + dem);
        } else if (StringUtils.isEmpty((Object)event.getPri()) || 0 == event.getPri()) {
            event.setPri(popDefine.getPri() * 100 + dem);
        }
        event.setEgroup(popDefine.getTypegroup());
        if (StringUtils.isEmpty((Object)event.getEtype())) {
            if (StringUtils.isEmpty((Object)event.getYhcode())) {
                event.setEtype(popDefine.getEtype());
            } else {
                event.setEtype(popDefine.getEtype().concat("_").concat(event.getYhcode()));
            }
        }
        event.setElevel(DataUtils.nvl((int)event.getElevel(), (int[])new int[]{0}));
        if (dim.length() > 8) {
            String ddim = MapUtils.getString(dictdetailRVal, (String)dim, (String)"");
            event.setDimension(StringUtils.isEmpty((Object)ddim) ? "COMBO" : ddim);
        } else {
            event.setDimension(dim);
        }
    }

    protected Map<String, List<EvtScopeItemBean>> splitByLadder(List<EvtScopeItemBean> items) {
        HashMap<String, List<EvtScopeItemBean>> result = new HashMap<String, List<EvtScopeItemBean>>();
        ArrayList<EvtScopeItemBean> except = new ArrayList<EvtScopeItemBean>();
        String laddersl = null;
        String ladderje = null;
        String ladderpop = null;
        String ladderkey = null;
        for (EvtScopeItemBean it : items) {
            laddersl = StringUtils.isEmpty((Object)it.getLaddersl()) || it.getLaddersl() == 0.0 ? "NULL" : String.valueOf(it.getLaddersl());
            ladderje = StringUtils.isEmpty((Object)it.getLadderje()) || it.getLadderje() == 0.0 ? "NULL" : String.valueOf(it.getLadderje());
            ladderpop = StringUtils.isEmpty((Object)it.getLadderpop()) || it.getLadderpop() == 0.0 ? "NULL" : String.valueOf(it.getLadderpop());
            ladderkey = laddersl.concat("-").concat(ladderje).concat("-").concat(ladderpop);
            if (ladderkey.equalsIgnoreCase("NULL-NULL-NULL") && it.getJoinmode().equalsIgnoreCase("N")) {
                except.add(it);
                continue;
            }
            if (result.containsKey(ladderkey)) {
                ((List)result.get(ladderkey)).add(it);
                continue;
            }
            ArrayList<EvtScopeItemBean> list = new ArrayList<EvtScopeItemBean>();
            list.add(it);
            result.put(ladderkey, list);
        }
        if (except != null && except.size() > 0) {
            for (String key : result.keySet()) {
                ((List)result.get(key)).addAll(except);
            }
        }
        return result;
    }

    protected Map<String, List<EvtScopeItemBean>> splitByLadder(List<EvtScopeItemBean> items, String keys) {
        HashMap<String, List<EvtScopeItemBean>> result = new HashMap<String, List<EvtScopeItemBean>>();
        if (StringUtils.isEmpty(items) || !StringUtils.isEmpty(items) && items.size() == 0) {
            return null;
        }
        ArrayList<EvtScopeItemBean> waititems = new ArrayList<EvtScopeItemBean>();
        ArrayList<EvtScopeItemBean> exceptitems = new ArrayList<EvtScopeItemBean>();
        for (EvtScopeItemBean item : items) {
            if (item.getJoinmode().equals("N")) {
                exceptitems.add(item);
                continue;
            }
            waititems.add(item);
        }
        for (EvtScopeItemBean item : waititems) {
            JSONObject json = (JSONObject)Utils.toNormalJSONObject((Object)item);
            if (StringUtils.isEmpty((Object)keys)) {
                result.put("___", items);
                return result;
            }
            String key_row = "";
            for (String keymemo : keys.split(",")) {
                String key = keymemo.split(":")[0];
                String datatype = keymemo.split(":")[1];
                if (datatype.equals("S")) {
                    key_row = key_row + MapUtils.getString((Map)json, (String)key, (String)"") + "_";
                    continue;
                }
                if (!datatype.equals("N")) continue;
                key_row = key_row + MapUtils.getDouble((Map)json, (String)key, (double)0.0) + "_";
            }
            if (result.containsKey(key_row)) {
                ((List)result.get(key_row)).add(item);
                continue;
            }
            ArrayList<EvtScopeItemBean> list = new ArrayList<EvtScopeItemBean>();
            list.add(item);
            result.put(key_row, list);
        }
        for (String key : result.keySet()) {
            ((List)result.get(key)).addAll(exceptitems);
        }
        return result;
    }

    protected String getladderCondMode(String ladderKey) {
        String[] keys = ladderKey.split("-");
        if (keys == null || keys.length != 3) {
            return null;
        }
        double laddersl = 0.0;
        double ladderje = 0.0;
        if (!"NULL".equalsIgnoreCase(keys[0])) {
            laddersl = Double.valueOf(keys[0]);
        }
        if (!"NULL".equalsIgnoreCase(keys[1])) {
            ladderje = Double.valueOf(keys[1]);
        }
        if (laddersl != 0.0 && ladderje != 0.0) {
            return "3";
        }
        if (laddersl != 0.0) {
            return "1";
        }
        if (ladderje != 0.0) {
            return "2";
        }
        return "0";
    }

    public static String getColName(String src) {
        if (src != null) {
            StringBuffer sb = new StringBuffer(src);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            return sb.toString();
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse cancelmodel(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        try {
            long ent_id = this.getParamWithCheck(jsonparam, "ent_id", false, session.getEnt_id());
            String billid = this.getParamWithCheck(jsonparam, "billid", true, "");
            if (this.doCancelEvent(ent_id, billid)) {
                return ServiceResponse.buildSuccess((Object)billid);
            }
            return ServiceResponse.buildSuccess(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    protected String replaceCodeMode(String codemode, int index, char chr) {
        if (codemode.length() <= index) {
            return codemode;
        }
        StringBuilder sb = new StringBuilder(codemode);
        sb.setCharAt(index, chr);
        return sb.toString();
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse cancelmodelsingle(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        try {
            EvtMainBean event_c = this.createBeanFromJSON(session, jsonparam);
            int tot_rows = 0;
            DataUtils.checkNull((Object)event_c.getBillid(), (String)"billid");
            event_c.setEnt_id(DataUtils.nvl((long)event_c.getEnt_id(), (long[])new long[]{session.getEnt_id()}));
            DataUtils.checkNull(event_c.getItems(), (String)"items");
            if (event_c.getItems().size() <= 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u7ef4\u5ea6\u8303\u56f4\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
            }
            for (int i = 0; i < event_c.getItems().size(); ++i) {
                EvtScopeItemBean item = event_c.getItems().get(i);
                Criteria criteria = Criteria.where((String)"ent_id").is((Object)event_c.getEnt_id()).and("billid").is((Object)event_c.getBillid()).and("nsta").is((Object)2021L);
                ArrayList<String> codes = new ArrayList<String>();
                codes.add(item.getCodemode());
                codes.add(this.replaceCodeMode(item.getCodemode(), 2, '1'));
                criteria = criteria.and("codemode").in(codes);
                for (int j = 0; j < item.getCodemode().length(); ++j) {
                    char flag = item.getCodemode().charAt(j);
                    if (flag == '0') continue;
                    String key = this.mapDimension[j];
                    String val = DataUtils.nvl((String)item.getClass().getMethod("get" + PopModelServiceBase.getColName(key), null).invoke((Object)item, null).toString(), (String[])new String[]{"%"});
                    criteria = criteria.and(key).is((Object)val);
                }
                tot_rows += this.doCancelModelSingle(new Query((CriteriaDefinition)criteria));
            }
            if (tot_rows > 0) {
                this.doRefreshEventTime(event_c.getEnt_id(), event_c.getBillid());
            }
            if (tot_rows == 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u672a\u627e\u5230\u6570\u636e", (Object[])new Object[0]);
            }
            return ServiceResponse.buildSuccess((Object)tot_rows);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse cancelmodelbatch(ServiceSession session, JSONArray jsonarray) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonarray)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonarray instanceof JSONArray)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        try {
            JSONObject result = new JSONObject();
            int tot_rows = 0;
            if (jsonarray.size() <= 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u5fc5\u987b\u4f20\u5165\u660e\u7ec6\uff01", (Object[])new Object[0]);
            }
            HashSet<Long> evts = new HashSet<Long>();
            HashSet<Long> seqs = new HashSet<Long>();
            for (int i = 0; i < jsonarray.size(); ++i) {
                JSONObject item = jsonarray.getJSONObject(i);
                item.put("ent_id", (Object)session.getEnt_id());
                item.put("nsta", (Object)2021L);
                List beans = this.doSearch(item, EvtScopeItemBean.class, null);
                for (int j = 0; j < beans.size(); ++j) {
                    ++tot_rows;
                    seqs.add(((EvtScopeItemBean)beans.get(j)).getSeqno());
                    evts.add(((EvtScopeItemBean)beans.get(j)).getEvt_id());
                }
            }
            int cnt = 0;
            HashSet<Long> list_seqs = new HashSet<Long>();
            Iterator it_seq = seqs.iterator();
            while (it_seq.hasNext()) {
                list_seqs.add((Long)it_seq.next());
                if (++cnt <= 100) continue;
                this.doCancelModelBatch(session.getEnt_id(), list_seqs);
                list_seqs.clear();
                cnt = 0;
            }
            HashSet<Long> list_evts = new HashSet<Long>();
            Iterator it_evt = evts.iterator();
            while (it_evt.hasNext()) {
                list_evts.add((Long)it_evt.next());
                if (++cnt <= 100) continue;
                this.doRefreshEventTimeBatch(session.getEnt_id(), list_evts);
                list_evts.clear();
            }
            result.put("items", (Object)seqs.size());
            result.put("evts", (Object)evts.size());
            return ServiceResponse.buildSuccess((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse delaymodel_OLD(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        try {
            long ent_id = this.getParamWithCheck(jsonparam, "ent_id", false, session.getEnt_id());
            String billid = this.getParamWithCheck(jsonparam, "billid", true, "");
            String sta_date = jsonparam.getString("sta_date");
            String end_date = this.getParamWithCheck(jsonparam, "end_date", true, "");
            String sta_time = jsonparam.getString("sta_time");
            String end_time = this.getParamWithCheck(jsonparam, "end_time", false, "");
            int i = this.doDelayEventModel(ent_id, billid, sta_date, end_date, sta_time, end_time);
            if (i == 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u672a\u627e\u5230\u6570\u636e", (Object[])new Object[0]);
            }
            return ServiceResponse.buildSuccess((Object)i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse increaseitem(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        FStorageOperations storage = null;
        try {
            long eid = 0L;
            storage = this.getStorageOperations();
            Update upt = new Update();
            long utctime = this.getTimestamp(storage);
            Criteria criteria = Criteria.where((String)"billid").is(jsonparam.get((Object)"billid")).and("end_date").gte((Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date())).and("ent_id").is((Object)session.getEnt_id()).and("nsta").is((Object)2021L);
            Query query = new Query((CriteriaDefinition)criteria);
            List eventList = storage.select(query, EvtMainBean.class);
            if (StringUtils.isEmpty((Object)eventList) || eventList.size() < 1) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"data not found!", (Object[])new Object[0]);
            }
            Criteria criteria1 = null;
            Query query1 = null;
            for (EvtMainBean srcEvent : eventList) {
                EvtMainBean transEvent = this.createBeanFromJSON(session, jsonparam);
                int i = 1;
                if (!StringUtils.isEmpty((Object)srcEvent)) {
                    eid = srcEvent.getEid();
                    List<EvtScopeItemBean> items = transEvent.getItems();
                    String sql = "select max(end_date) as end_date,min(sta_date) as sta_date,evt_scd,policy_id,policy_type,policy_group from  m$eventscopeitem where ent_id = 0 and ";
                    sql = sql + "evt_id=" + eid;
                    List maps = ((FMybatisTemplate)storage).getSqlSessionTemplate().selectList("mybatis.sql.select", (Object)sql);
                    Map mitem = (Map)maps.get(0);
                    for (EvtScopeItemBean item : items) {
                        item.setSeqno(UniqueID.getUniqueID());
                        item.setEvt_scd(Long.parseLong(mitem.get("evt_scd").toString()));
                        item.setPolicy_id(Long.parseLong(mitem.get("policy_id").toString()));
                        item.setPolicy_type(mitem.get("policy_type").toString());
                        item.setPolicy_group(mitem.get("policy_group").toString());
                        item.setSta_date(mitem.get("sta_date").toString());
                        item.setEnd_date(mitem.get("end_date").toString());
                        item.setRelation("0");
                        item.setJoinmode("N");
                        item.setSta_time("00:00");
                        item.setEnd_time("23:59");
                        item.setEvt_id(eid);
                        item.setItemgroup(i);
                        ++i;
                        item.setEnt_id(srcEvent.getEnt_id());
                        item.setCorp_id(srcEvent.getCorp_id());
                        item.setBillid(srcEvent.getBillid());
                        item.setTmdd(utctime);
                        item.setTcrd(utctime);
                        item.setCstr2(this.createDimenKey(item));
                    }
                }
                this.batchInsert((FMybatisTemplate)storage, EvtScopeItemBean.class, transEvent.getItems());
                upt.set("tmdd", (Object)utctime);
                criteria1 = Criteria.where((String)"eid").is((Object)eid).and("billid").is(jsonparam.get((Object)"billid")).and("nsta").is((Object)2021L).and("ent_id").is((Object)srcEvent.getEnt_id());
                query1 = new Query((CriteriaDefinition)criteria1);
                storage.update(query1, upt, EvtMainBean.class);
            }
            return ServiceResponse.buildSuccess((Object)0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse delaymodelsingle_OLD(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        try {
            EvtMainBean event_c = this.createBeanFromJSON(session, jsonparam);
            DataUtils.checkNull((Object)event_c.getBillid(), (String)"billid");
            event_c.setEnt_id(DataUtils.nvl((long)event_c.getEnt_id(), (long[])new long[]{session.getEnt_id()}));
            DataUtils.checkNull(event_c.getItems(), (String)"items");
            int tot_rows = 0;
            if (event_c.getItems().size() <= 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u7ef4\u5ea6\u8303\u56f4\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
            }
            for (int i = 0; i < event_c.getItems().size(); ++i) {
                EvtScopeItemBean item = event_c.getItems().get(i);
                item.setCodemode(DataUtils.nvl((String)item.getCodemode(), (String[])new String[]{"0000000001"}));
                Criteria criteria = Criteria.where((String)"ent_id").is((Object)event_c.getEnt_id()).and("billid").is((Object)event_c.getBillid()).and("nsta").is((Object)2021L);
                criteria = criteria.and("codemode").is((Object)item.getCodemode());
                for (int j = 0; j < item.getCodemode().length(); ++j) {
                    char flag = item.getCodemode().charAt(j);
                    if (flag == '0') continue;
                    String key = this.mapDimension[j];
                    String val = DataUtils.nvl((String)item.getClass().getMethod("get" + PopModelServiceBase.getColName(key), null).invoke((Object)item, null).toString(), (String[])new String[]{"%"});
                    criteria = criteria.and(key).is((Object)val);
                }
                if (StringUtils.isEmpty(event_c.getPeriod()) || event_c.getPeriod().size() <= 0) {
                    tot_rows += this.doDelayModelSingle(new Query((CriteriaDefinition)criteria), item);
                    continue;
                }
                if (event_c.getPeriod().size() == 1) {
                    item.setSta_date(DataUtils.nvl((String)event_c.getPeriod().get(0).getSta_date(), (String[])new String[]{item.getSta_date()}));
                    item.setEnd_date(DataUtils.nvl((String)event_c.getPeriod().get(0).getEnd_date(), (String[])new String[]{item.getEnd_date()}));
                    item.setSta_time(DataUtils.nvl((String)event_c.getPeriod().get(0).getSta_time(), (String[])new String[]{item.getSta_time()}));
                    item.setEnd_time(DataUtils.nvl((String)event_c.getPeriod().get(0).getEnd_time(), (String[])new String[]{item.getEnd_time()}));
                    item.setWeeklist(DataUtils.nvl((String)event_c.getPeriod().get(0).getWeeklist(), (String[])new String[]{item.getWeeklist()}));
                    tot_rows += this.doDelayModelSingle(new Query((CriteriaDefinition)criteria), item);
                    continue;
                }
                tot_rows += this.doDelayModelSingle(new Query((CriteriaDefinition)criteria), event_c.getPeriod());
            }
            if (tot_rows > 0) {
                this.doRefreshEventTime(event_c.getEnt_id(), event_c.getBillid());
            }
            return ServiceResponse.buildSuccess((Object)tot_rows);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse delaymodel(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        FStorageOperations storage = null;
        boolean isexcute = false;
        try {
            int i2;
            int i1;
            EvtMainBean event_c = this.createBeanFromJSON(session, jsonparam);
            DataUtils.checkNull((Object)event_c.getBillid(), (String)"billid");
            event_c.setEnt_id(DataUtils.nvl((long)event_c.getEnt_id(), (long[])new long[]{session.getEnt_id()}));
            String sdate = jsonparam.getString("sta_date");
            String edate = this.getParamWithCheck(jsonparam, "end_date", true, "");
            String stime = jsonparam.getString("sta_time");
            String etime = this.getParamWithCheck(jsonparam, "end_time", false, "");
            Criteria criteria1 = Criteria.where((String)"ent_id").is((Object)event_c.getEnt_id()).and("billid").is((Object)event_c.getBillid()).and("nsta").is((Object)2021L);
            storage = this.getStorageOperations();
            Query query = new Query((CriteriaDefinition)criteria1);
            List itemList = storage.select(query, EvtScopeItemBean.class);
            if (StringUtils.isEmpty((Object)itemList) || itemList.size() < 1) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"data not found!", (Object[])new Object[0]);
                return serviceResponse;
            }
            long utime = this.getTimestamp(storage);
            HashSet exist_code = new HashSet();
            ArrayList<Long> areaCodes = new ArrayList<Long>();
            Update up = new Update();
            up.set("tmdd", (Object)utime);
            areaCodes = new ArrayList();
            String max_end_date = "";
            for (EvtScopeItemBean item : itemList) {
                String sta_date = item.getSta_date();
                int i12 = edate.compareTo(sta_date);
                if (i12 >= 0) continue;
                up.set("nsta", (Object)2022L);
                up.set("tmdd", (Object)utime);
                long seqno = item.getSeqno();
                if (areaCodes.contains(seqno)) continue;
                areaCodes.add(seqno);
            }
            Criteria c = Criteria.where((String)"seqno").in(areaCodes);
            Query q = new Query((CriteriaDefinition)c);
            if (areaCodes.size() > 0) {
                isexcute = true;
                storage.update(q, up, EvtScopeItemBean.class);
            }
            if (StringUtils.isEmpty((Object)etime)) {
                areaCodes = new ArrayList();
                max_end_date = "";
                for (EvtScopeItemBean item : itemList) {
                    String end_date = item.getEnd_date();
                    String sta_date = item.getSta_date();
                    i1 = sta_date.compareTo(edate);
                    i2 = edate.compareTo(end_date);
                    if ((i1 > 0 || i2 >= 0) && i2 < 0) continue;
                    if (StringUtils.isEmpty((Object)max_end_date)) {
                        max_end_date = end_date;
                        continue;
                    }
                    if (max_end_date.compareTo(end_date) >= 0) continue;
                    max_end_date = end_date;
                }
                up = new Update();
                for (EvtScopeItemBean item : itemList) {
                    String end_date = item.getEnd_date();
                    if (StringUtils.isEmpty((Object)end_date) || !end_date.equals(max_end_date)) continue;
                    up.set("end_date", (Object)edate);
                    up.set("tmdd", (Object)utime);
                    long seqno = item.getSeqno();
                    if (areaCodes.contains(seqno)) continue;
                    areaCodes.add(seqno);
                }
                c = Criteria.where((String)"seqno").in(areaCodes);
                q = new Query((CriteriaDefinition)c);
                if (areaCodes.size() > 0) {
                    isexcute = true;
                    storage.update(q, up, EvtScopeItemBean.class);
                }
            }
            if (!StringUtils.isEmpty((Object)etime)) {
                areaCodes = new ArrayList();
                max_end_date = "";
                up = new Update();
                for (EvtScopeItemBean item : itemList) {
                    String sta_date = item.getSta_date();
                    String sta_time = item.getSta_time();
                    i1 = edate.compareTo(sta_date);
                    i2 = etime.compareTo(sta_time);
                    if (i1 < 0 || i2 >= 0) continue;
                    up.set("nsta", (Object)2022L);
                    up.set("tmdd", (Object)utime);
                    long seqno = item.getSeqno();
                    if (areaCodes.contains(seqno)) continue;
                    areaCodes.add(seqno);
                }
                c = Criteria.where((String)"seqno").in(areaCodes);
                q = new Query((CriteriaDefinition)c);
                if (areaCodes.size() > 0) {
                    isexcute = true;
                    storage.update(q, up, EvtScopeItemBean.class);
                }
                areaCodes = new ArrayList();
                for (EvtScopeItemBean item : itemList) {
                    String end_date = item.getEnd_date();
                    String sta_date = item.getSta_date();
                    String sta_time = item.getSta_time();
                    int i13 = edate.compareTo(sta_date);
                    int i22 = etime.compareTo(sta_time);
                    if (i13 < 0 || i22 < 0) continue;
                    if (StringUtils.isEmpty((Object)max_end_date)) {
                        max_end_date = end_date;
                        continue;
                    }
                    if (max_end_date.compareTo(end_date) >= 0) continue;
                    max_end_date = end_date;
                }
                up = new Update();
                for (EvtScopeItemBean item : itemList) {
                    String end_date = item.getEnd_date();
                    if (StringUtils.isEmpty((Object)end_date) || !end_date.equals(max_end_date)) continue;
                    up.set("end_date", (Object)edate);
                    up.set("end_time", (Object)etime);
                    up.set("tmdd", (Object)utime);
                    long seqno = item.getSeqno();
                    if (areaCodes.contains(seqno)) continue;
                    areaCodes.add(seqno);
                }
                c = Criteria.where((String)"seqno").in(areaCodes);
                q = new Query((CriteriaDefinition)c);
                if (areaCodes.size() > 0) {
                    isexcute = true;
                    storage.update(q, up, EvtScopeItemBean.class);
                }
            }
            criteria1 = Criteria.where((String)"ent_id").is((Object)event_c.getEnt_id()).and("billid").is((Object)event_c.getBillid()).and("nsta").is((Object)2021L);
            q = new Query((CriteriaDefinition)criteria1);
            up = new Update();
            up.set("tmdd", (Object)utime);
            up.set("end_date", (Object)edate);
            if (isexcute) {
                storage.update(q, up, EvtMainBean.class);
            }
            ServiceResponse serviceResponse = ServiceResponse.buildSuccess((Object)0);
            return serviceResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
            return serviceResponse;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse delaymodelsingle(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            EvtMainBean event_c = this.createBeanFromJSON(session, jsonparam);
            DataUtils.checkNull((Object)event_c.getBillid(), (String)"billid");
            event_c.setEnt_id(DataUtils.nvl((long)event_c.getEnt_id(), (long[])new long[]{session.getEnt_id()}));
            DataUtils.checkNull(event_c.getItems(), (String)"items");
            List<Map<String, Object>> delayModelList = this.doGetDelayModelList(session, storage, jsonparam, event_c);
            if (StringUtils.isEmpty(delayModelList) || delayModelList.size() < 1) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u6ca1\u6709\u627e\u5230\u53ef\u5ef6\u671f\u6570\u636e\uff0c\u5ef6\u671f\u5931\u8d25!", (Object[])new Object[0]);
                return serviceResponse;
            }
            long utime = this.getTimestamp(storage);
            boolean isexcute = false;
            JSONArray period = jsonparam.getJSONArray("period");
            isexcute = this.doUpdEdateLtStadate(jsonparam, storage, delayModelList, utime, isexcute);
            isexcute = this.doDelaySingleModel(session, storage, delayModelList, utime, period, isexcute);
            Criteria criteria1 = Criteria.where((String)"ent_id").is((Object)event_c.getEnt_id()).and("billid").is((Object)event_c.getBillid()).and("nsta").is((Object)2021L);
            Query q = new Query((CriteriaDefinition)criteria1);
            Update up = new Update();
            up.set("tmdd", (Object)utime);
            if (isexcute) {
                storage.update(q, up, EvtMainBean.class);
            }
            ServiceResponse serviceResponse = ServiceResponse.buildSuccess((Object)0);
            return serviceResponse;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    private boolean doDelaySingleModel(ServiceSession session, FStorageOperations storage, List<Map<String, Object>> delayModelList, long utime, JSONArray period, boolean isexcute) {
        for (int i = 0; i < period.size(); ++i) {
            JSONObject pi = period.getJSONObject(i);
            String edate = pi.getString("end_date");
            String etime = pi.getString("end_time");
            isexcute = StringUtils.isEmpty((Object)etime) ? this.doDelaySingleModelWithoutEtime(storage, utime, edate, delayModelList, isexcute) : this.doDelaySingleModelWithEtime(storage, utime, etime, edate, delayModelList, isexcute);
        }
        return isexcute;
    }

    private boolean doDelaySingleModelWithEtime(FStorageOperations storage, long utime, String etime, String edate, List<Map<String, Object>> delayModelList, boolean isexcute) {
        ArrayList<Long> areaCodes = new ArrayList<Long>();
        Update up = new Update();
        String max_end_date = "";
        for (Map<String, Object> item : delayModelList) {
            if (StringUtils.isEmpty(item)) continue;
            String sta_date = item.get("sta_date").toString();
            String sta_time = item.get("sta_time").toString();
            int i1 = edate.compareTo(sta_date);
            int i2 = etime.compareTo(sta_time);
            if (i1 < 0 || i2 >= 0) continue;
            up.set("nsta", (Object)2022L);
            up.set("tmdd", (Object)utime);
            long seqno = Long.parseLong(item.get("seqno").toString());
            if (areaCodes.contains(seqno)) continue;
            areaCodes.add(seqno);
        }
        Criteria c = Criteria.where((String)"seqno").in(areaCodes);
        Query q = new Query((CriteriaDefinition)c);
        if (areaCodes.size() > 0) {
            isexcute = true;
            storage.update(q, up, EvtScopeItemBean.class);
        }
        areaCodes = new ArrayList();
        for (Map<String, Object> item : delayModelList) {
            if (StringUtils.isEmpty(item)) continue;
            String end_date = item.get("end_date").toString();
            String sta_date = item.get("sta_date").toString();
            String sta_time = item.get("sta_time").toString();
            int i1 = edate.compareTo(sta_date);
            int i2 = etime.compareTo(sta_time);
            if (i1 < 0 || i2 < 0) continue;
            if (StringUtils.isEmpty((Object)max_end_date)) {
                max_end_date = end_date;
                continue;
            }
            if (max_end_date.compareTo(end_date) >= 0) continue;
            max_end_date = end_date;
        }
        up = new Update();
        for (Map<String, Object> item : delayModelList) {
            String end_date;
            if (StringUtils.isEmpty(item) || StringUtils.isEmpty((Object)(end_date = item.get("end_date").toString())) || end_date.compareTo(max_end_date) > 0) continue;
            up.set("end_date", (Object)edate);
            up.set("end_time", (Object)etime);
            up.set("tmdd", (Object)utime);
            long seqno = Long.parseLong(item.get("seqno").toString());
            if (areaCodes.contains(seqno)) continue;
            areaCodes.add(seqno);
        }
        c = Criteria.where((String)"seqno").in(areaCodes);
        q = new Query((CriteriaDefinition)c);
        if (areaCodes.size() > 0) {
            isexcute = true;
            storage.update(q, up, EvtScopeItemBean.class);
        }
        return isexcute;
    }

    private boolean doDelaySingleModelWithoutEtime(FStorageOperations storage, long utime, String edate, List<Map<String, Object>> delayModelList, boolean isexcute) {
        String end_date;
        ArrayList<Long> areaCodes = new ArrayList<Long>();
        Update up = new Update();
        String max_end_date = "";
        for (Map<String, Object> item : delayModelList) {
            if (StringUtils.isEmpty(item)) continue;
            end_date = item.get("end_date").toString();
            String sta_date = item.get("sta_date").toString();
            int i1 = sta_date.compareTo(edate);
            int i2 = edate.compareTo(end_date);
            if ((i1 > 0 || i2 >= 0) && i2 < 0) continue;
            if (StringUtils.isEmpty((Object)max_end_date)) {
                max_end_date = end_date;
                continue;
            }
            if (max_end_date.compareTo(end_date) >= 0) continue;
            max_end_date = end_date;
        }
        for (Map<String, Object> item : delayModelList) {
            if (StringUtils.isEmpty(item) || StringUtils.isEmpty((Object)(end_date = item.get("end_date").toString())) || end_date.compareTo(max_end_date) > 0) continue;
            up.set("end_date", (Object)edate);
            up.set("tmdd", (Object)utime);
            long seqno = Long.parseLong(item.get("seqno").toString());
            if (areaCodes.contains(seqno)) continue;
            areaCodes.add(seqno);
        }
        Criteria c = Criteria.where((String)"seqno").in(areaCodes);
        Query q = new Query((CriteriaDefinition)c);
        if (areaCodes.size() > 0) {
            isexcute = true;
            storage.update(q, up, EvtScopeItemBean.class);
        }
        return isexcute;
    }

    private boolean doUpdEdateLtStadate(JSONObject jsonparam, FStorageOperations storage, List<Map<String, Object>> delayModelList, long utime, boolean isexcute) {
        ArrayList<Long> areaCodes = new ArrayList<Long>();
        JSONArray period = jsonparam.getJSONArray("period");
        Update up = new Update();
        for (Map<String, Object> item : delayModelList) {
            if (StringUtils.isEmpty(item)) continue;
            String sta_date = item.get("sta_date").toString();
            for (int i = 0; i < period.size(); ++i) {
                JSONObject pi = period.getJSONObject(i);
                String edate = pi.getString("end_date");
                int i1 = edate.compareTo(sta_date);
                if (i1 >= 0) continue;
                up.set("nsta", (Object)2022L);
                up.set("tmdd", (Object)utime);
                long seqno = Long.parseLong(item.get("seqno").toString());
                if (areaCodes.contains(seqno)) continue;
                areaCodes.add(seqno);
            }
        }
        Criteria c = Criteria.where((String)"seqno").in(areaCodes);
        Query q = new Query((CriteriaDefinition)c);
        if (areaCodes.size() > 0) {
            isexcute = true;
            storage.update(q, up, EvtScopeItemBean.class);
        }
        return isexcute;
    }

    private List<Map<String, Object>> doGetDelayModelList(ServiceSession session, FStorageOperations storage, JSONObject jsonparam, EvtMainBean event_c) {
        List<EvtScopeItemBean> items = event_c.getItems();
        String sql = "select  sta_date,end_date,sta_time,end_time,seqno from m$eventscopeitem where ent_id = " + session.getEnt_id() + " and billid = '" + event_c.getBillid() + "' and nsta = " + 2021L;
        if (items.size() <= 0) {
            sql = sql + " and 1=0";
        }
        for (int i = 0; i < items.size(); ++i) {
            EvtScopeItemBean itm = items.get(i);
            if (i == 0) {
                sql = sql + " and (";
                sql = sql + "(codemode = '" + itm.getCodemode() + "'";
            } else {
                sql = sql + " or (codemode = '" + itm.getCodemode() + "'";
            }
            if (!StringUtils.isEmpty((Object)itm.getGz_code())) {
                sql = sql + " and gz_code = '" + itm.getGz_code() + "'";
            }
            if (!StringUtils.isEmpty((Object)itm.getBrand_code())) {
                sql = sql + " and brand_code = '" + itm.getBrand_code() + "'";
            }
            if (!StringUtils.isEmpty((Object)itm.getCate_code())) {
                sql = sql + " and cate_code = '" + itm.getCate_code() + "'";
            }
            if (!StringUtils.isEmpty((Object)itm.getGoods_code())) {
                sql = sql + " and goods_code = '" + itm.getGoods_code() + "'";
            }
            if (!StringUtils.isEmpty((Object)itm.getOrg_code())) {
                sql = sql + " and org_code = '" + itm.getOrg_code() + "'";
            }
            if (!StringUtils.isEmpty((Object)itm.getTag_code1())) {
                sql = sql + " and tag_code1 = '" + itm.getTag_code1() + "'";
            }
            if (!StringUtils.isEmpty((Object)itm.getTag_code2())) {
                sql = sql + " and tag_code2 = '" + itm.getTag_code2() + "'";
            }
            if (!StringUtils.isEmpty((Object)itm.getTag_code3())) {
                sql = sql + " and tag_code3 = '" + itm.getTag_code3() + "'";
            }
            if (!StringUtils.isEmpty((Object)itm.getTag_code4())) {
                sql = sql + " and tag_code4 = '" + itm.getTag_code4() + "'";
            }
            if (!StringUtils.isEmpty((Object)itm.getTag_code5())) {
                sql = sql + " and tag_code5 = '" + itm.getTag_code5() + "'";
            }
            sql = sql + " )";
            if (i != items.size() - 1) continue;
            sql = sql + " )";
        }
        return ((FMybatisTemplate)storage).getSqlSessionTemplate().selectList("mybatis.sql.select", (Object)sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse delaymodelsingleN(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        FStorageOperations storage = null;
        try {
            long seqno;
            int i4;
            int i3;
            int i2;
            int i1;
            String etime;
            int i;
            String sta_time;
            String end_date;
            String sta_date;
            EvtScopeItemBean itm;
            EvtMainBean event_c = this.createBeanFromJSON(session, jsonparam);
            DataUtils.checkNull((Object)event_c.getBillid(), (String)"billid");
            event_c.setEnt_id(DataUtils.nvl((long)event_c.getEnt_id(), (long[])new long[]{session.getEnt_id()}));
            DataUtils.checkNull(event_c.getItems(), (String)"items");
            List<EvtScopeItemBean> items = event_c.getItems();
            String sql = "select  sta_date,end_date,sta_time,end_time,seqno from m$eventscopeitem where ent_id = " + session.getEnt_id() + " and billid = " + event_c.getBillid() + " and nsta = " + 2021L;
            for (int i5 = 0; i5 < items.size(); ++i5) {
                itm = items.get(i5);
                if (i5 == 0) {
                    sql = sql + " and (codemode = " + itm.getCodemode();
                    if (!StringUtils.isEmpty((Object)itm.getGz_code())) {
                        sql = sql + " and gz_code = " + itm.getGz_code();
                    }
                    if (!StringUtils.isEmpty((Object)itm.getBrand_code())) {
                        sql = sql + " and gz_code = " + itm.getGz_code();
                    }
                    if (!StringUtils.isEmpty((Object)itm.getCate_code())) {
                        sql = sql + " and cate_code = " + itm.getCate_code();
                    }
                    if (!StringUtils.isEmpty((Object)itm.getGoods_code())) {
                        sql = sql + " and goods_code = " + itm.getGoods_code();
                    }
                    if (!StringUtils.isEmpty((Object)itm.getOrg_code())) {
                        sql = sql + " and org_code = " + itm.getOrg_code();
                    }
                    if (!StringUtils.isEmpty((Object)itm.getTag_code1())) {
                        sql = sql + " and tag_code1 = " + itm.getTag_code1();
                    }
                    if (!StringUtils.isEmpty((Object)itm.getTag_code3())) {
                        sql = sql + " and tag_code3 = " + itm.getTag_code3();
                    }
                    sql = sql + " ) ";
                    continue;
                }
                sql = sql + " or ( codemode = " + itm.getCodemode();
                if (!StringUtils.isEmpty((Object)itm.getGz_code())) {
                    sql = sql + " and gz_code = " + itm.getGz_code();
                }
                if (!StringUtils.isEmpty((Object)itm.getBrand_code())) {
                    sql = sql + " and gz_code = " + itm.getGz_code();
                }
                if (!StringUtils.isEmpty((Object)itm.getCate_code())) {
                    sql = sql + " and cate_code = " + itm.getCate_code();
                }
                if (!StringUtils.isEmpty((Object)itm.getGoods_code())) {
                    sql = sql + " and goods_code = " + itm.getGoods_code();
                }
                if (!StringUtils.isEmpty((Object)itm.getOrg_code())) {
                    sql = sql + " and org_code = " + itm.getOrg_code();
                }
                if (!StringUtils.isEmpty((Object)itm.getTag_code1())) {
                    sql = sql + " and tag_code1 = " + itm.getTag_code1();
                }
                if (!StringUtils.isEmpty((Object)itm.getTag_code3())) {
                    sql = sql + " and tag_code3 = " + itm.getTag_code3();
                }
                sql = sql + " ) ";
            }
            storage = this.getStorageOperations();
            List itemList = ((FMybatisTemplate)storage).getSqlSessionTemplate().selectList("mybatis.sql.select", (Object)sql);
            if (StringUtils.isEmpty((Object)itemList) || itemList.size() < 1) {
                itm = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"data not found!", (Object[])new Object[0]);
                return itm;
            }
            long utime = this.getTimestamp(storage);
            JSONArray period = jsonparam.getJSONArray("period");
            ArrayList<Long> areaCodes = new ArrayList<Long>();
            for (Map item : itemList) {
                if (StringUtils.isEmpty((Object)item)) continue;
                String sta_date2 = item.get("sta_date").toString();
                String end_date2 = item.get("end_date").toString();
                String sta_time2 = item.get("sta_time").toString();
                for (int i6 = 0; i6 < period.size(); ++i6) {
                    long seqno2;
                    JSONObject pi = period.getJSONObject(i6);
                    String edate = pi.getString("end_date");
                    String etime2 = pi.getString("end_time");
                    int i12 = sta_date2.compareTo(edate);
                    int i22 = end_date2.compareTo(edate);
                    int i32 = sta_time2.compareTo(etime2);
                    if (i12 <= 0 && (i12 > 0 || i22 < 0 || i32 <= 0 || StringUtils.isEmpty((Object)etime2)) || areaCodes.contains(seqno2 = Long.parseLong(item.get("seqno").toString()))) continue;
                    areaCodes.add(seqno2);
                }
            }
            Criteria c = Criteria.where((String)"seqno").in(areaCodes);
            Query q = new Query((CriteriaDefinition)c);
            Update upt = new Update();
            upt.set("tmdd", (Object)utime);
            upt.set("nsta", (Object)2022L);
            if (areaCodes.size() > 0) {
                storage.update(q, upt, EvtScopeItemBean.class);
            }
            Update up = new Update();
            up.set("tmdd", (Object)utime);
            areaCodes = new ArrayList();
            for (Map item : itemList) {
                sta_date = item.get("sta_date").toString();
                end_date = item.get("end_date").toString();
                sta_time = item.get("sta_time").toString();
                String end_time = item.get("end_time").toString();
                for (i = 0; i < period.size(); ++i) {
                    JSONObject pi = period.getJSONObject(i);
                    String edate = pi.getString("end_date");
                    etime = pi.getString("end_time");
                    i1 = sta_date.compareTo(edate);
                    i2 = end_date.compareTo(edate);
                    i3 = sta_time.compareTo(etime);
                    i4 = end_time.compareTo(etime);
                    if (i1 <= 0 || !StringUtils.isEmpty((Object)etime)) continue;
                    up.set("end_date", (Object)edate);
                    seqno = Long.parseLong(item.get("seqno").toString());
                    if (areaCodes.contains(seqno)) continue;
                    areaCodes.add(Long.parseLong(item.get("seqno").toString()));
                }
            }
            c = Criteria.where((String)"seqno").in(areaCodes);
            q = new Query((CriteriaDefinition)c);
            if (areaCodes.size() > 0) {
                storage.update(q, up, EvtScopeItemBean.class);
            }
            up = new Update();
            up.set("tmdd", (Object)utime);
            areaCodes = new ArrayList();
            for (Map item : itemList) {
                sta_date = item.get("sta_date").toString();
                end_date = item.get("end_date").toString();
                sta_time = item.get("sta_time").toString();
                String end_time = item.get("end_time").toString();
                for (i = 0; i < period.size(); ++i) {
                    JSONObject pi = period.getJSONObject(i);
                    String edate = pi.getString("end_date");
                    etime = pi.getString("end_time");
                    i1 = sta_date.compareTo(edate);
                    i2 = end_date.compareTo(edate);
                    i3 = sta_time.compareTo(etime);
                    i4 = end_time.compareTo(etime);
                    if (i1 > 0 || i2 < 0 || i3 > 0 || i4 < 0) continue;
                    up.set("end_date", (Object)edate);
                    up.set("end_time", (Object)etime);
                    seqno = Long.parseLong(item.get("seqno").toString());
                    if (areaCodes.contains(seqno)) continue;
                    areaCodes.add(Long.parseLong(item.get("seqno").toString()));
                }
            }
            c = Criteria.where((String)"seqno").in(areaCodes);
            q = new Query((CriteriaDefinition)c);
            if (areaCodes.size() > 0) {
                storage.update(q, up, EvtScopeItemBean.class);
            }
            c = Criteria.where((String)"ent_id").is((Object)event_c.getEnt_id()).and("billid").is((Object)event_c.getBillid()).and("nsta").is((Object)2021L);
            q = new Query((CriteriaDefinition)c);
            up = new Update();
            up.set("tmdd", (Object)utime);
            storage.update(q, up, EvtMainBean.class);
            ServiceResponse serviceResponse = ServiceResponse.buildSuccess((Object)0);
            return serviceResponse;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
            return serviceResponse;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    public JSONArray geteventscopeorgs(String mktid) throws Exception {
        JSONArray eventscopeorgs = new JSONArray();
        JSONObject eventscopeorg = new JSONObject();
        eventscopeorg.put("org_code", (Object)mktid);
        eventscopeorgs.add((Object)eventscopeorg);
        return eventscopeorgs;
    }

    public List<EvtTimePeriod> getmergeperiod(List<EvtTimePeriod> periods, PopDefineBean popDefine) {
        if (StringUtils.isEmpty(periods)) {
            return null;
        }
        if (periods.size() <= 0) {
            return null;
        }
        if (!StringUtils.isEmpty((Object)((Object)popDefine)) && Utils.nvl((Object)popDefine.getPeriod(), (String)"Y").equals("Y")) {
            boolean ismerge = true;
            String sta_date = "";
            String end_date = "";
            for (EvtTimePeriod period : periods) {
                if (StringUtils.isEmpty((Object)period.getSta_time()) || !period.getSta_time().equals("00:00") || StringUtils.isEmpty((Object)period.getEnd_time()) || !period.getEnd_time().equals("23:59") || StringUtils.isEmpty((Object)period.getSta_date()) || StringUtils.isEmpty((Object)period.getEnd_date())) {
                    ismerge = false;
                    break;
                }
                if (!ismerge) continue;
                if (StringUtils.isEmpty((Object)sta_date)) {
                    sta_date = period.getSta_date();
                }
                if (StringUtils.isEmpty((Object)end_date)) {
                    end_date = period.getEnd_date();
                }
                if (sta_date.compareTo(period.getSta_date()) > 0) {
                    sta_date = period.getSta_date();
                }
                if (end_date.compareTo(period.getEnd_date()) >= 0) continue;
                end_date = period.getEnd_date();
            }
            if (ismerge) {
                EvtTimePeriod mergerow = periods.get(0);
                mergerow.setSta_date(sta_date);
                mergerow.setEnd_date(end_date);
                mergerow.setSta_time("00:00");
                mergerow.setEnd_time("23:59");
                ArrayList<EvtTimePeriod> list = new ArrayList<EvtTimePeriod>();
                list.add(mergerow);
                return list;
            }
        }
        return periods;
    }
}

