/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omp.event.model.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.annotation.AutoCache;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.PrecisionUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import com.efuture.omd.storage.mybatis.HashMapCase;
import com.efuture.omp.event.model.component.PopDefineServiceImpl;
import com.efuture.omp.event.model.component.PopModelServiceBase;
import com.efuture.omp.event.model.entity.EvtMainBean;
import com.efuture.omp.event.model.entity.EvtPolicyBean;
import com.efuture.omp.event.model.entity.EvtPolicyLadderBean;
import com.efuture.omp.event.model.entity.EvtPolicyLimitBean;
import com.efuture.omp.event.model.entity.EvtPolicyNopayBean;
import com.efuture.omp.event.model.entity.EvtResultCouponBean;
import com.efuture.omp.event.model.entity.EvtResultGiftBean;
import com.efuture.omp.event.model.entity.EvtScopeItemBean;
import com.efuture.omp.event.model.entity.EvtScopePayBean;
import com.efuture.omp.event.model.entity.PopDefineBean;
import com.efuture.omp.event.model.intf.Callback;
import com.efuture.omp.event.model.intf.PopModelService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.scheduling.annotation.Async;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class PopModelServiceImpl
extends PopModelServiceBase
implements PopModelService {
    public static PopModelServiceImpl getInstance() {
        return (PopModelServiceImpl)SpringBeanFactory.getBean((String)"efuture.omp.event.popmodel", PopModelServiceImpl.class);
    }

    public ServiceResponse couponpriceoff(ServiceSession session, JSONObject jsonparam) {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        try {
            PopDefineBean popDefine = this.getPopDefine(jsonparam, "6001205");
            EvtMainBean event = this.createBeanFromJSON(session, jsonparam);
            JSONArray policyA = jsonparam.getJSONArray("policy");
            EvtPolicyBean policy = event.getPolicy().get(0);
            policy.setCondtype(DataUtils.nvl((String)policy.getCondtype(), (String[])new String[]{popDefine.getCondtype()}));
            ArrayList<EvtPolicyLadderBean> ladderList = new ArrayList<EvtPolicyLadderBean>();
            EvtPolicyLadderBean ladder = new EvtPolicyLadderBean();
            JSONObject pjson = policyA.getJSONObject(0);
            ladder.setPrcmode(pjson.getString("prcmode"));
            ladder.setCondje(pjson.getDoubleValue("condje"));
            ladder.setLevelje(pjson.getDoubleValue("levelje"));
            ladder.setPopje(pjson.getDoubleValue("popje"));
            event.setEtype(DataUtils.nvl((String)event.getEtype(), (String[])new String[]{popDefine.getEtype()}));
            if (!StringUtils.isEmpty((Object)policyA.getJSONObject(0).get((Object)"cop_type"))) {
                event.setEtype(event.getEtype() + "_coupon_" + policyA.getJSONObject(0).get((Object)"cop_type"));
                event.getPolicy().get(0).setCstr2(policyA.getJSONObject(0).get((Object)"cop_type").toString());
                event.setYhcode("coupon_" + policyA.getJSONObject(0).get((Object)"cop_type"));
                ladder.setCstr1("coupon_" + policyA.getJSONObject(0).get((Object)"cop_type"));
            }
            if ("2".equals(policyA.getJSONObject(0).get((Object)"prcmode")) || "1".equals(policy.getCondtype())) {
                ladder.setMaxfb(1);
            }
            ladderList.add(ladder);
            event.setIspoint(DataUtils.nvl((String)event.getIspoint(), (String[])new String[]{popDefine.getIspoint()}));
            event.setIsexclusive(DataUtils.nvl((String)event.getIsexclusive(), (String[])new String[]{popDefine.getIsexclusive()}));
            policy.setSummode(popDefine.getSummode());
            policy.setLadder(ladderList);
            long eid = this.doPriceOff(event, popDefine);
            return ServiceResponse.buildSuccess((Object)eid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AutoCache(Service="OMP", KeyArgIndex=1, ExpKeys="date", TimeOut=1800)
    public ServiceResponse eventsearch(ServiceSession session, JSONObject jsonparam) {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"cons"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"cons \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        FMybatisTemplate storage = null;
        JSONObject data = new JSONObject();
        try {
            storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
            List<String> billidList = this.getModelBillid(session, jsonparam, storage);
            if (billidList.size() < 1) {
                data.put("data", (Object)"\u672a\u627e\u5230\u6570\u636e");
                ServiceResponse serviceResponse = ServiceResponse.buildSuccess((Object)data);
                return serviceResponse;
            }
            data = this.getModelData(session, billidList, storage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return ServiceResponse.buildSuccess((Object)data);
    }

    private JSONObject getModelData(ServiceSession session, List<String> bidList, FMybatisTemplate storage) {
        JSONObject data = new JSONObject();
        new Criteria();
        Criteria cr = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("billid").in(bidList);
        Query query = new Query((CriteriaDefinition)cr);
        List eventList = storage.select(query, EvtMainBean.class);
        JSONArray eventsArr = new JSONArray();
        if (eventList != null && eventList.size() > 0) {
            List items = null;
            Object ladder = null;
            Object policy = null;
            JSONObject eventJson = null;
            for (EvtMainBean event : eventList) {
                eventJson = new JSONObject();
                new Criteria();
                cr = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("billid").is((Object)event.getBillid());
                query = new Query((CriteriaDefinition)cr);
                items = storage.select(query, EvtScopeItemBean.class);
                List ladderList = storage.select(query, EvtPolicyLadderBean.class);
                List couponList = storage.select(query, EvtResultCouponBean.class);
                List giftList = storage.select(query, EvtResultGiftBean.class);
                List payList = storage.select(query, EvtScopePayBean.class);
                eventJson.put("billid", (Object)event.getBillid());
                eventJson.put("billtype", (Object)event.getBilltype());
                eventJson.put("egroup", (Object)event.getEgroup());
                eventJson.put("etype", (Object)event.getEtype());
                eventJson.put("evt_id", (Object)event.getEid());
                eventJson.put("pname", (Object)event.getPname());
                JSONArray ladderArr = this.renderLadder(ladderList, couponList, giftList);
                eventJson.put("eventpolicyladder", (Object)ladderArr);
                eventJson.put("eventscopeitem", (Object)this.renderItems(items));
                eventJson.put("eventscopepay", (Object)this.renderPay(payList));
                if (ladderArr != null && ladderArr.size() == 0) {
                    this.renderPolicyCoupon(eventJson, couponList);
                }
                if (ladderArr != null && ladderArr.size() == 0) {
                    this.renderPolicyItems(eventJson, giftList);
                }
                eventsArr.add((Object)eventJson);
            }
            data.put("events", (Object)eventsArr);
            data.put("total_results", (Object)eventList.size());
        }
        return data;
    }

    private JSONArray renderPay(List<EvtScopePayBean> payList) {
        JSONArray itemArr = new JSONArray();
        JSONObject json = null;
        for (EvtScopePayBean item : payList) {
            json = new JSONObject();
            json.put("cop_type", (Object)item.getCop_type());
            json.put("pay_code", (Object)item.getPay_code());
            json.put("pay_name", (Object)item.getPay_name());
            json.put("pay_type", (Object)item.getPay_type());
            itemArr.add((Object)json);
        }
        return itemArr;
    }

    private void renderPolicyCoupon(JSONObject event, List<EvtResultCouponBean> couponList) {
        JSONArray couponArrJson = new JSONArray();
        JSONObject couponJSON = null;
        for (EvtResultCouponBean coupon : couponList) {
            couponJSON = new JSONObject();
            couponJSON.put("coupon_amount", (Object)coupon.getCop_je());
            couponJSON.put("coupon_faceval", (Object)coupon.getCop_faceval());
            couponJSON.put("coupon_group", (Object)coupon.getPay_type());
            couponJSON.put("coupon_name", (Object)coupon.getPay_name());
            couponJSON.put("coupon_qty", (Object)coupon.getCop_zs());
            couponJSON.put("coupon_type", (Object)coupon.getCop_type());
            couponArrJson.add((Object)couponJSON);
        }
        event.put("eventresultcoupon", (Object)couponArrJson);
    }

    private void renderPolicyItems(JSONObject event, List<EvtResultGiftBean> giftList) {
        JSONArray giftArrJson = new JSONArray();
        JSONObject giftJSON = null;
        for (EvtResultGiftBean gft : giftList) {
            giftJSON = new JSONObject();
            giftJSON.put("gift_brand_code", (Object)gft.getBrand_code());
            giftJSON.put("gift_cate_code", (Object)gft.getCate_code());
            giftJSON.put("gift_codemode", (Object)gft.getCodemode());
            giftJSON.put("gift_goods_code", (Object)gft.getGoods_code());
            giftJSON.put("gift_group", (Object)gft.getGiftgroup());
            giftJSON.put("gift_grouprow", (Object)gft.getGrouprow());
            giftJSON.put("gift_qty", (Object)gft.getGiftsl());
            giftJSON.put("gift_supplier_code", (Object)gft.getTag_code1());
            giftJSON.put("giftname", (Object)gft.getGiftname());
            giftJSON.put("gifttype", (Object)gft.getGifttype());
            giftArrJson.add((Object)giftJSON);
        }
        event.put("eventresultgift", (Object)giftArrJson);
    }

    private JSONArray renderItems(List<EvtScopeItemBean> itemList) {
        JSONArray itemArr = new JSONArray();
        JSONObject json = null;
        for (EvtScopeItemBean item : itemList) {
            json = new JSONObject();
            json.put("brand_code", (Object)item.getBrand_code());
            json.put("cate_code", (Object)item.getCate_code());
            json.put("codemode", (Object)item.getCodemode());
            json.put("goods_code", (Object)item.getGoods_code());
            json.put("group", (Object)item.getPolicy_group());
            json.put("grouprow", (Object)item.getGrouprow());
            json.put("item_poplsj", (Object)item.getPoplsj());
            json.put("item_prcmode", (Object)item.getPrcmode());
            json.put("joinmode", (Object)item.getJoinmode());
            json.put("mf_code", (Object)item.getGz_code());
            json.put("org_code", (Object)item.getOrg_code());
            json.put("supplier_code", (Object)item.getTag_code1());
            json.put("pophsj", (Object)item.getPophyj());
            json.put("poppfj", (Object)item.getPoppfj());
            itemArr.add((Object)json);
        }
        return itemArr;
    }

    private JSONArray renderLadder(List<EvtPolicyLadderBean> ladderList, List<EvtResultCouponBean> couponList, List<EvtResultGiftBean> giftList) {
        JSONArray laddrArrJson = new JSONArray();
        JSONArray couponArrJson = null;
        JSONArray giftArrJson = null;
        JSONObject ladderJSON = null;
        JSONObject couponJSON = null;
        JSONObject giftJSON = null;
        for (EvtPolicyLadderBean lad : ladderList) {
            ladderJSON = new JSONObject();
            ladderJSON.put("condje", (Object)lad.getCondje());
            ladderJSON.put("condsl", (Object)lad.getCondsl());
            ladderJSON.put("lid", (Object)lad.getLid());
            ladderJSON.put("lname", (Object)lad.getLname());
            ladderJSON.put("popje", (Object)lad.getPopje());
            ladderJSON.put("prcmode", (Object)lad.getPrcmode());
            couponArrJson = new JSONArray();
            for (EvtResultCouponBean coupon : couponList) {
                if (lad.getLid() != coupon.getLadder_id()) continue;
                couponJSON = new JSONObject();
                couponJSON.put("coupon_amount", (Object)coupon.getCop_je());
                couponJSON.put("coupon_faceval", (Object)coupon.getCop_faceval());
                couponJSON.put("coupon_group", (Object)coupon.getPay_type());
                couponJSON.put("coupon_name", (Object)coupon.getPay_name());
                couponJSON.put("coupon_qty", (Object)coupon.getCop_zs());
                couponJSON.put("coupon_type", (Object)coupon.getCop_type());
                couponArrJson.add((Object)couponJSON);
            }
            ladderJSON.put("eventresultcoupon", (Object)couponArrJson);
            giftArrJson = new JSONArray();
            for (EvtResultGiftBean gft : giftList) {
                if (lad.getLid() != gft.getLadder_id()) continue;
                giftJSON = new JSONObject();
                giftJSON.put("gift_brand_code", (Object)gft.getBrand_code());
                giftJSON.put("gift_cate_code", (Object)gft.getCate_code());
                giftJSON.put("gift_codemode", (Object)gft.getCodemode());
                giftJSON.put("gift_goods_code", (Object)gft.getGoods_code());
                giftJSON.put("gift_group", (Object)gft.getGiftgroup());
                giftJSON.put("gift_grouprow", (Object)gft.getGrouprow());
                giftJSON.put("gift_qty", (Object)gft.getGiftsl());
                giftJSON.put("gift_supplier_code", (Object)gft.getTag_code1());
                giftJSON.put("giftname", (Object)gft.getGiftname());
                giftJSON.put("gifttype", (Object)gft.getGifttype());
                giftArrJson.add((Object)giftJSON);
            }
            ladderJSON.put("eventresultgift", (Object)giftArrJson);
            laddrArrJson.add((Object)ladderJSON);
        }
        return laddrArrJson;
    }

    public List<String> getModelBillid(ServiceSession session, JSONObject jsonparam, FMybatisTemplate storage) {
        List mpData;
        JSONArray billtype;
        ArrayList<String> list = new ArrayList<String>();
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        HashMapCase map = new HashMapCase();
        map.put("ent_id", session.getEnt_id());
        if (jsonparam.containsKey((Object)"billid")) {
            map.put("billid", jsonparam.get((Object)"billid"));
        }
        if (jsonparam.containsKey((Object)"evt_id")) {
            map.put("evt_id", jsonparam.get((Object)"evt_id"));
        }
        if (jsonparam.containsKey((Object)"corp_id")) {
            map.put("corp_id", jsonparam.get((Object)"corp_id"));
        }
        if (jsonparam.containsKey((Object)"date")) {
            String jsonDate = jsonparam.getString("date");
            String[] split = jsonDate.split(",");
            if (split.length > 1) {
                map.put("time", split[1]);
            }
            map.put("date", split[0]);
        }
        if (jsonparam.containsKey((Object)"billtype")) {
            billtype = jsonparam.getJSONArray("billtype");
            ArrayList<String> listType = new ArrayList<String>();
            for (Object o : billtype) {
                listType.add(o.toString());
            }
            map.put("billtype", listType);
        }
        if (jsonparam.containsKey((Object)"etype")) {
            map.put("etype", jsonparam.getJSONArray("etype"));
        }
        if (jsonparam.containsKey((Object)"cons")) {
            JSONArray cons = jsonparam.getJSONArray("cons");
            ArrayList<String> consList = new ArrayList<String>();
            for (Object con : cons) {
                JSONObject jsonCon = JSONObject.parseObject((String)con.toString());
                if (StringUtils.isEmpty(con)) continue;
                consList.add(jsonCon.getString("rak"));
            }
            consList.add("HALL");
            consList.add("ALL");
            map.put("cons", consList);
        }
        if (jsonparam.containsKey((Object)"orgs")) {
            billtype = jsonparam.getJSONArray("orgs");
            ArrayList<String> chList = new ArrayList<String>();
            ArrayList<String> orgList = new ArrayList<String>();
            for (int i = 0; i < billtype.size(); ++i) {
                JSONObject json = billtype.getJSONObject(i);
                chList.add(json.get((Object)"chl_code").toString());
                orgList.add(json.get((Object)"org_code").toString());
            }
            map.put("chl_code", chList);
            map.put("org_code", orgList);
        }
        if ((mpData = db.selectList("mybatis.model.getmodelbillids", (Object)map)) != null && mpData.size() > 0) {
            for (Map mp : mpData) {
                list.add(mp.get("billid").toString());
            }
        }
        return list;
    }

    public ServiceResponse resultcoupon(ServiceSession session, JSONObject jsonparam) {
        FMybatisTemplate storage = null;
        JSONObject data = new JSONObject();
        try {
            storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
            HashMapCase map = new HashMapCase();
            if (jsonparam.containsKey((Object)"corp_id")) {
                map.put("corpid", jsonparam.get((Object)"corp_id"));
            }
            if (jsonparam.containsKey((Object)"org_code")) {
                map.put("mktid", jsonparam.get((Object)"org_code"));
            }
            if (jsonparam.containsKey((Object)"cust_type")) {
                map.put("custtype", jsonparam.get((Object)"cust_type"));
            }
            if (jsonparam.containsKey((Object)"chid")) {
                map.put("channel", jsonparam.get((Object)"chid"));
            }
            SqlSessionTemplate db = storage.getSqlSessionTemplate();
            List list = db.selectList("mybatis.model.select_jifenresult", (Object)map);
            data.put("jfresult", list.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ServiceResponse.buildSuccess((Object)data);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse normaldisc(ServiceSession session, JSONObject jsonparam) {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        try {
            PopDefineBean popDefine = this.getPopDefine(jsonparam, "6002203");
            EvtMainBean event = this.createBeanFromJSON(session, jsonparam);
            event.setIspoint(DataUtils.nvl((String)event.getIspoint(), (String[])new String[]{popDefine.getIspoint()}));
            event.setIsexclusive(DataUtils.nvl((String)event.getIsexclusive(), (String[])new String[]{popDefine.getIsexclusive()}));
            long eid = this.doNormalDisc(event, popDefine);
            return ServiceResponse.buildSuccess((Object)eid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse priceoff(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        try {
            PopDefineBean popDefine = this.getPopDefine(jsonparam, "6001205");
            EvtMainBean event = this.createBeanFromJSON(session, jsonparam);
            event.setBilltype(popDefine.getModuleid());
            event.setEtype(DataUtils.nvl((String)event.getEtype(), (String[])new String[]{popDefine.getEtype()}));
            event.setIspoint(DataUtils.nvl((String)event.getIspoint(), (String[])new String[]{popDefine.getIspoint()}));
            event.setIsexclusive(DataUtils.nvl((String)event.getIsexclusive(), (String[])new String[]{popDefine.getIsexclusive()}));
            long eid = this.doPriceOff(event, popDefine);
            return ServiceResponse.buildSuccess((Object)eid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse conddisc(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        try {
            PopDefineBean popDefine = this.getPopDefine(jsonparam, "7005108");
            EvtMainBean event = this.createBeanFromJSON(session, jsonparam);
            event.setIspoint(DataUtils.nvl((String)event.getIspoint(), (String[])new String[]{popDefine.getIspoint()}));
            event.setIsexclusive(DataUtils.nvl((String)event.getIsexclusive(), (String[])new String[]{popDefine.getIsexclusive()}));
            long eid = this.doCondDisc(event, popDefine);
            return ServiceResponse.buildSuccess((Object)eid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse combpopgift(ServiceSession session, JSONObject jsonparam) {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        try {
            PopDefineBean popDefine = this.getPopDefine(jsonparam, "7005108");
            EvtMainBean event = this.createBeanFromJSON(session, jsonparam);
            event.setIspoint(DataUtils.nvl((String)event.getIspoint(), (String[])new String[]{popDefine.getIspoint()}));
            event.setIsexclusive(DataUtils.nvl((String)event.getIsexclusive(), (String[])new String[]{popDefine.getIsexclusive()}));
            long eid = this.doCombPopGifts(event, popDefine);
            return ServiceResponse.buildSuccess((Object)event.getEid());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse paygain(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        try {
            PopDefineBean popDefine = this.getPopDefine(jsonparam, "6001205");
            EvtMainBean event = this.createBeanFromJSON(session, jsonparam);
            event.setBilltype(popDefine.getModuleid());
            event.setEtype(DataUtils.nvl((String)event.getEtype(), (String[])new String[]{popDefine.getEtype()}));
            event.setIspoint(DataUtils.nvl((String)event.getIspoint(), (String[])new String[]{popDefine.getIspoint()}));
            event.setIsexclusive(DataUtils.nvl((String)event.getIsexclusive(), (String[])new String[]{popDefine.getIsexclusive()}));
            long eid = this.doPaygain(event, popDefine);
            return ServiceResponse.buildSuccess((Object)eid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse offset(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        try {
            PopDefineBean popDefine = this.getPopDefine(jsonparam, "6001205");
            EvtMainBean event = this.createBeanFromJSON(session, jsonparam);
            event.setBilltype(popDefine.getModuleid());
            event.setEtype(DataUtils.nvl((String)event.getEtype(), (String[])new String[]{popDefine.getEtype()}));
            event.setIspoint(DataUtils.nvl((String)event.getIspoint(), (String[])new String[]{popDefine.getIspoint()}));
            event.setIsexclusive(DataUtils.nvl((String)event.getIsexclusive(), (String[])new String[]{popDefine.getIsexclusive()}));
            long eid = this.doOffset(event, popDefine);
            return ServiceResponse.buildSuccess((Object)eid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse accnt(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        try {
            String eventType = this.getParamWithCheck(jsonparam, "etype", true, "");
            String moduleID = null;
            DataUtils.checkNull(moduleID, (String)"etype");
            PopDefineBean popDefine = PopDefineServiceImpl.getInstance().findPopDefine(moduleID);
            EvtMainBean event = this.createBeanFromJSON(session, jsonparam);
            long eid = this.doAccntGainUse(event, popDefine);
            return ServiceResponse.buildSuccess((Object)eid);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    @Override
    public ServiceResponse exceptpay(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (jsonparam.containsKey((Object)"ent_id")) {
            session.setEnt_id(jsonparam.getLong("ent_id").longValue());
        }
        this.doExceptpay(session, jsonparam, true);
        return ServiceResponse.buildSuccess((Object)"");
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse createmodel(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (!(jsonparam instanceof JSONObject)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"JSON\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        }
        String ModuleId = this.getParamWithCheck(jsonparam, "moduleid", true, "");
        try {
            PopDefineBean popDefine = PopDefineServiceImpl.getInstance().findPopDefine(ModuleId);
            EvtMainBean event = this.createBeanFromJSON(session, jsonparam);
            this.preProcessModel(event);
            this.InitEventMain(event, popDefine, "COMB");
            this.InsertEvent(event);
            return ServiceResponse.buildSuccess((Object)event.getEid());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    public long doNormalDisc(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        if ("Y".equalsIgnoreCase(event.getAsync())) {
            PopModelServiceImpl.getInstance().doNormalDiscAsync(event, popDefine);
            return 0L;
        }
        return this.doNormalDiscCore(event, popDefine, null);
    }

    @Async
    public void doNormalDiscAsync(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        this.doNormalDiscCore(event, popDefine, null);
    }

    public long doNormalDiscCore(final EvtMainBean event, final PopDefineBean popDefine, String go) throws Exception {
        this.preProcessModel(event);
        this.InitEventMain(event, popDefine, DataUtils.nvl((String)event.getDimension(), (String[])new String[]{event.getItems().get(0).getCodemode(), "COMBO"}));
        this.preProcessDimension(event, popDefine, new Callback(){

            @Override
            public void execute() throws Exception {
                PopModelServiceImpl.getInstance().doNormalDiscCore(event, popDefine);
            }
        });
        return 0L;
    }

    @Override
    public long doNormalDiscCore(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        Boolean isGroupCode = false;
        DataUtils.checkNull((Object)event.getBillid(), (String)"billid");
        DataUtils.checkNull((Object)event.getBilltype(), (String)"billtype");
        if (!StringUtils.isEmpty(event.getItems())) {
            for (int i = 0; i < event.getItems().size(); ++i) {
                EvtScopeItemBean item = event.getItems().get(i);
                item.setPolicy_type(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
                item.setPolicy_group(popDefine.getTypegroup());
                item.setCondsl(DataUtils.nvl((double)item.getCondsl(), (double[])new double[]{0.0}));
                if (PrecisionUtils.doubleCompare((double)item.getCondsl(), (double)0.0, (int)2) > 0) {
                    item.setRelation(DataUtils.nvl((String)item.getRelation(), (String[])new String[]{"0"}));
                    item.setItemgroup(DataUtils.nvl((int)item.getItemgroup(), (int[])new int[]{1}));
                    item.setGrouprow(DataUtils.nvl((int)item.getGrouprow(), (int[])new int[]{1}));
                    item.setCondmode(DataUtils.nvl((String)item.getCondmode(), (String[])new String[]{"1"}));
                    item.setCondje(DataUtils.nvl((double)item.getCondje(), (double[])new double[]{0.0}));
                } else {
                    item.setRelation(DataUtils.nvl((String)item.getRelation(), (String[])new String[]{"0"}));
                    item.setItemgroup(DataUtils.nvl((int)item.getItemgroup(), (int[])new int[]{0}));
                    item.setGrouprow(DataUtils.nvl((int)item.getGrouprow(), (int[])new int[]{0}));
                    item.setCondmode(DataUtils.nvl((String)item.getCondmode(), (String[])new String[]{"0"}));
                    item.setCondje(DataUtils.nvl((double)item.getCondje(), (double[])new double[]{0.0}));
                }
                item.setPopmax(DataUtils.nvl((double)item.getPopmax(), (double[])new double[]{0.0}));
                item.setPopmax_cons_day(DataUtils.nvl((double)item.getPopmax_cons_day(), (double[])new double[]{0.0}));
                item.setPopmax_cons_tot(DataUtils.nvl((double)item.getPopmax_cons_tot(), (double[])new double[]{0.0}));
                item.setPopmax_day(DataUtils.nvl((double)item.getPopmax_day(), (double[])new double[]{0.0}));
                item.setPopmax_tot(DataUtils.nvl((double)item.getPopmax_tot(), (double[])new double[]{0.0}));
                item.setCstr1(event.getYhcode());
                item.setPoszsz(DataUtils.nvl((String)item.getPoszsz(), (String[])new String[]{"Y"}));
                DataUtils.checkNull((Object)item.getCodemode(), (String)"items.codemode");
                DataUtils.checkValid((Object)item.getCondmode(), (String)"items.condmode", (String)"0,1,2,3,4,5,6");
                if ("N".equals(item.getJoinmode())) continue;
                DataUtils.checkValid((Object)item.getPrcmode(), (String)"items.prcmode", (String)"1,2,3,4,5,6");
            }
        } else {
            throw new ServiceException("10000", "\u5546\u54c1\u8303\u56f4\u5fc5\u987b\u4f20\u5165\uff01", new Object[0]);
        }
        this.CheckPeriod(event, popDefine);
        List<EvtPolicyBean> policy = event.getPolicy();
        if (StringUtils.isEmpty(event.getPolicy()) || event.getPolicy().size() <= 0) {
            EvtPolicyBean p = new EvtPolicyBean();
            p.setPrcprecision(DataUtils.nvl((String)p.getPrcprecision(), (String[])new String[]{DataUtils.nvl((String)popDefine.getPrcprecision(), (String[])new String[]{"2"})}));
            p.setPname(DataUtils.nvl((String)p.getPname(), (String[])new String[]{event.getPname(), popDefine.getTypename()}));
            p.setPopmode("0");
            p.setSelmode("2");
            p.setSummode("0");
            p.setSumflag("0");
            p.setCondtype("0");
            p.setCondmode("0");
            p.setPaypopcheck("Y");
            p.setCstr2("ISPOP");
            p.setCstr3("Y");
            p.setPsymbol(DataUtils.nvl((String)p.getPsymbol(), (String[])new String[]{popDefine.getPsymbol()}));
            p.setPayexcpispop(DataUtils.nvl((String)p.getPayexcpispop(), (String[])new String[]{popDefine.getPayexcpispop()}));
            event.setPolicy(p);
        }
        for (int i = 0; i < event.getPolicy().size(); ++i) {
            EvtPolicyBean p = event.getPolicy().get(i);
            p.setPname(DataUtils.nvl((String)p.getPname(), (String[])new String[]{event.getPname(), popDefine.getTypename()}));
            p.setPri(popDefine.getPri() * 100);
            p.setPtype(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
            p.setPgroup(popDefine.getTypegroup());
            p.setSelmode("2");
            p.setSummode("0");
            p.setSumflag("0");
            p.setCondtype("0");
            p.setCondmode(DataUtils.nvl((String)p.getCondmode(), (String[])new String[]{"0"}));
            p.setCalcmaxje(0.0);
            p.setPopmode(DataUtils.nvl((String)p.getPopmode(), (String[])new String[]{"0"}));
            p.setPrcprecision(DataUtils.nvl((String)p.getPrcprecision(), (String[])new String[]{DataUtils.nvl((String)popDefine.getPrcprecision(), (String[])new String[]{"2"})}));
            p.setMaxpopsl(0.0);
            p.setMaxpopje(0.0);
            p.setPaypopcheck("Y");
            p.setCstr2("ISPOP");
            p.setCstr3(DataUtils.nvl((String)p.getCstr3(), (String[])new String[]{"Y"}));
            if (!p.getCondmode().equals("4")) continue;
            isGroupCode = true;
            if (!StringUtils.isEmpty(p.getLadder()) && p.getLadder().size() > 0) continue;
            ArrayList<EvtPolicyLadderBean> ladders = new ArrayList<EvtPolicyLadderBean>();
            EvtPolicyLadderBean ladder = new EvtPolicyLadderBean();
            ladder.setPrcmode("0");
            ladders.add(ladder);
            p.setLadder(ladders);
        }
        this.InsertEvent(event);
        return event.getEid();
    }

    public long doPriceOff(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        if ("Y".equalsIgnoreCase(event.getAsync())) {
            PopModelServiceImpl.getInstance().doPriceOffAsync(event, popDefine);
            return 0L;
        }
        return this.doPriceOffCore(event, popDefine, null);
    }

    @Async
    public void doPriceOffAsync(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        this.doPriceOffCore(event, popDefine, null);
    }

    public long doPriceOffCore(final EvtMainBean event, final PopDefineBean popDefine, String op) throws Exception {
        long eid = 0L;
        this.preProcessModel(event);
        this.preProcessDimension(event, popDefine, new Callback(){

            @Override
            public void execute() throws Exception {
                PopModelServiceImpl.getInstance().doPriceOffCore(event, popDefine);
            }
        });
        return 0L;
    }

    @Override
    public long doPriceOffCore(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        int i;
        DataUtils.checkNull((Object)event.getBillid(), (String)"billid");
        DataUtils.checkNull((Object)event.getBilltype(), (String)"billtype");
        if (!StringUtils.isEmpty(event.getItems())) {
            for (i = 0; i < event.getItems().size(); ++i) {
                EvtScopeItemBean item = event.getItems().get(i);
                item.setPolicy_type(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
                item.setPolicy_group(popDefine.getTypegroup());
                item.setRelation(DataUtils.nvl((String)item.getRelation(), (String[])new String[]{"0"}));
                item.setItemgroup(DataUtils.nvl((int)item.getItemgroup(), (int[])new int[]{1}));
                item.setCodemode(DataUtils.nvl((String)item.getCodemode(), (String[])new String[]{"0"}));
                item.setGrouprow(DataUtils.nvl((int)item.getGrouprow(), (int[])new int[]{0}));
                item.setCondmode(DataUtils.nvl((String)item.getCondmode(), (String[])new String[]{"0"}));
                item.setCondsl(DataUtils.nvl((double)item.getCondsl(), (double[])new double[]{0.0}));
                item.setCondje(DataUtils.nvl((double)item.getCondje(), (double[])new double[]{0.0}));
                item.setPopmax(DataUtils.nvl((double)item.getPopmax(), (double[])new double[]{0.0}));
                item.setPoszsz(DataUtils.nvl((String)item.getPoszsz(), (String[])new String[]{"Y"}));
                DataUtils.checkNull((Object)item.getCodemode(), (String)"items.codemode");
                item.setCstr2(this.createDimenKey(item));
            }
        } else {
            throw new ServiceException("10000", "\u5546\u54c1\u8303\u56f4\u5fc5\u987b\u4f20\u5165\uff01", new Object[0]);
        }
        this.CheckPeriod(event, popDefine);
        DataUtils.checkNull(event.getPolicy(), (String)"policy");
        for (i = 0; i < event.getPolicy().size(); ++i) {
            EvtPolicyBean p = event.getPolicy().get(i);
            p.setPname(DataUtils.nvl((String)p.getPname(), (String[])new String[]{event.getPname(), popDefine.getTypename()}));
            p.setPri(popDefine.getPri() * 100);
            p.setPtype(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
            p.setPgroup(popDefine.getTypegroup());
            p.setPopmode(DataUtils.nvl((String)p.getPopmode(), (String[])new String[]{popDefine.getPopmode()}));
            p.setSelmode("2");
            p.setSummode(DataUtils.nvl((String)p.getSummode(), (String[])new String[]{popDefine.getSummode()}));
            p.setSumflag(DataUtils.nvl((String)p.getSumflag(), (String[])new String[]{popDefine.getSumflag()}));
            p.setCondtype(DataUtils.nvl((String)p.getCondtype(), (String[])new String[]{popDefine.getCondtype()}));
            p.setCondmode(DataUtils.nvl((String)p.getCondmode(), (String[])new String[]{popDefine.getCondmode()}));
            p.setCalcmaxje(0.0);
            p.setMaxpopsl(0.0);
            p.setMaxpopje(0.0);
            p.setPaypopcheck("Y");
            p.setCstr2("ISPOP");
            p.setCstr3(DataUtils.nvl((String)p.getCstr3(), (String[])new String[]{"Y"}));
            p.setPrcprecision(DataUtils.nvl((String)p.getPrcprecision(), (String[])new String[]{DataUtils.nvl((String)popDefine.getPrcprecision(), (String[])new String[]{"2"})}));
            p.setPsymbol(DataUtils.nvl((String)p.getPsymbol(), (String[])new String[]{popDefine.getPsymbol()}));
            p.setPayexcpispop(DataUtils.nvl((String)p.getPayexcpispop(), (String[])new String[]{popDefine.getPayexcpispop()}));
            DataUtils.checkValid((Object)p.getSummode(), (String)"policy.summode", (String)"0,1");
            DataUtils.checkValid((Object)p.getCondmode(), (String)"policy.condmode", (String)"1,2,3");
            DataUtils.checkNull(p.getLadder(), (String)"policy.ladder");
            for (int j = 0; j < p.getLadder().size(); ++j) {
                EvtPolicyLadderBean l = p.getLadder().get(j);
                l.setPri(j + 1);
                l.setLevelsl(DataUtils.nvl((double)l.getLevelsl(), (double[])new double[]{0.0}));
                l.setLevelje(DataUtils.nvl((double)l.getLevelje(), (double[])new double[]{0.0}));
                l.setCondsl(DataUtils.nvl((double)l.getCondsl(), (double[])new double[]{0.0}));
                l.setCondje(DataUtils.nvl((double)l.getCondje(), (double[])new double[]{0.0}));
                l.setCstr2(DataUtils.nvl((String)l.getCstr2(), (String[])new String[]{"2"}));
                DataUtils.checkNull((Object)l.getPrcmode(), (String)"policy.ladder.prcmode");
                DataUtils.checkNull((Object)l.getPopje(), (String)"policy.ladder.popje");
                if (StringUtils.isEmpty(l.getLimits())) continue;
                for (int k = 0; k < l.getLimits().size(); ++k) {
                    EvtPolicyLimitBean m = l.getLimits().get(k);
                    m.setLimit_mode("POLY");
                    m.setCop_type(DataUtils.nvl((String)m.getCop_type(), (String[])new String[]{"%"}));
                    m.setMaxpopsl(DataUtils.nvl((double)m.getMaxpopsl(), (double[])new double[]{0.0}));
                    m.setMaxpopje(DataUtils.nvl((double)m.getMaxpopje(), (double[])new double[]{0.0}));
                    m.setCons_day_popcs(DataUtils.nvl((int)m.getCons_day_popcs(), (int[])new int[]{0}));
                    m.setCons_day_popsl(DataUtils.nvl((double)m.getCons_day_popsl(), (double[])new double[]{0.0}));
                    m.setCons_day_popje(DataUtils.nvl((double)m.getCons_day_popje(), (double[])new double[]{0.0}));
                    m.setCons_popcs(DataUtils.nvl((int)m.getCons_popcs(), (int[])new int[]{0}));
                    m.setCons_popsl(DataUtils.nvl((double)m.getCons_popsl(), (double[])new double[]{0.0}));
                    m.setCons_popje(DataUtils.nvl((double)m.getCons_popje(), (double[])new double[]{0.0}));
                    m.setDay_popcs(DataUtils.nvl((int)m.getDay_popcs(), (int[])new int[]{0}));
                    m.setDay_popsl(DataUtils.nvl((double)m.getDay_popsl(), (double[])new double[]{0.0}));
                    m.setDay_popje(DataUtils.nvl((double)m.getDay_popje(), (double[])new double[]{0.0}));
                    m.setTot_popcs(DataUtils.nvl((int)m.getTot_popcs(), (int[])new int[]{0}));
                    m.setTot_popsl(DataUtils.nvl((double)m.getTot_popsl(), (double[])new double[]{0.0}));
                    m.setTot_popje(DataUtils.nvl((double)m.getTot_popje(), (double[])new double[]{0.0}));
                }
            }
        }
        this.InsertEvent(event);
        return event.getEid();
    }

    public long doCondDisc(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        if ("Y".equalsIgnoreCase(event.getAsync())) {
            PopModelServiceImpl.getInstance().doCondDiscAsync(event, popDefine);
            return 0L;
        }
        return this.doCondDiscCore(event, popDefine, null);
    }

    @Async
    public void doCondDiscAsync(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        this.doCondDiscCore(event, popDefine, null);
    }

    public long doCondDiscCore(final EvtMainBean event, final PopDefineBean popDefine, String op) throws Exception {
        this.preProcessModel(event);
        this.preProcessDimension(event, popDefine, new Callback(){

            @Override
            public void execute() throws Exception {
                PopModelServiceImpl.getInstance().doCondDiscCore(event, popDefine);
            }
        });
        return 0L;
    }

    @Override
    public long doCondDiscCore(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        DataUtils.checkNull((Object)event.getBillid(), (String)"billid");
        DataUtils.checkNull((Object)event.getBilltype(), (String)"billtype");
        event.setIspoint(DataUtils.nvl((String)event.getIspoint(), (String[])new String[]{popDefine.getIspoint()}));
        event.setIsexclusive(DataUtils.nvl((String)event.getIsexclusive(), (String[])new String[]{popDefine.getIsexclusive()}));
        DataUtils.checkNull(event.getItems(), (String)"items");
        Map<String, List<EvtScopeItemBean>> itemsMap = this.splitByLadder(event.getItems());
        for (String key : itemsMap.keySet()) {
            int i;
            String[] keyVals = key.split("-");
            for (i = 0; i < itemsMap.get(key).size(); ++i) {
                EvtScopeItemBean item = itemsMap.get(key).get(i);
                item.setPolicy_type(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
                item.setPolicy_group(popDefine.getTypegroup());
                item.setRelation(DataUtils.nvl((String)item.getRelation(), (String[])new String[]{"0"}));
                item.setItemgroup(DataUtils.nvl((int)item.getItemgroup(), (int[])new int[]{1}));
                item.setGrouprow(DataUtils.nvl((int)item.getGrouprow(), (int[])new int[]{0}));
                item.setCondmode(DataUtils.nvl((String)item.getCondmode(), (String[])new String[]{"1"}));
                item.setCondsl(DataUtils.nvl((double)item.getCondsl(), (double[])new double[]{0.0}));
                item.setCondje(DataUtils.nvl((double)item.getCondje(), (double[])new double[]{0.0}));
                item.setPopmax(DataUtils.nvl((double)item.getPopmax(), (double[])new double[]{0.0}));
                item.setPoszsz(DataUtils.nvl((String)item.getPoszsz(), (String[])new String[]{"Y"}));
                DataUtils.checkNull((Object)item.getCodemode(), (String)"items.codemode");
                item.setCstr2(this.createDimenKey(item));
            }
            this.CheckPeriod(itemsMap.get(key), event.getPeriod(), popDefine);
            event.setItems(itemsMap.get(key));
            DataUtils.checkNull(event.getPolicy(), (String)"policy");
            for (i = 0; i < event.getPolicy().size(); ++i) {
                EvtPolicyBean p = event.getPolicy().get(i);
                p.setPname(DataUtils.nvl((String)p.getPname(), (String[])new String[]{event.getPname(), popDefine.getTypename()}));
                p.setPri(popDefine.getPri());
                p.setPtype(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
                p.setPgroup(popDefine.getTypegroup());
                p.setPopmode(DataUtils.nvl((String)p.getPopmode(), (String[])new String[]{DataUtils.nvl((String)popDefine.getPopmode(), (String[])new String[]{"1"})}));
                p.setSelmode("2");
                p.setSummode(DataUtils.nvl((String)p.getSummode(), (String[])new String[]{DataUtils.nvl((String)popDefine.getSummode(), (String[])new String[]{"1"})}));
                p.setSumflag(DataUtils.nvl((String)p.getSumflag(), (String[])new String[]{DataUtils.nvl((String)popDefine.getSumflag(), (String[])new String[]{"0"})}));
                p.setCondtype(DataUtils.nvl((String)p.getCondtype(), (String[])new String[]{DataUtils.nvl((String)popDefine.getCondtype(), (String[])new String[]{"0"})}));
                p.setCondmode(DataUtils.nvl((String)p.getCondmode(), (String[])new String[]{this.getladderCondMode(key), popDefine.getCondmode(), "1"}));
                p.setPrcprecision(DataUtils.nvl((String)p.getPrcprecision(), (String[])new String[]{DataUtils.nvl((String)popDefine.getPrcprecision(), (String[])new String[]{"2"})}));
                p.setCalcmaxje(0.0);
                p.setMaxpopsl(0.0);
                p.setMaxpopje(0.0);
                p.setPaypopcheck("Y");
                p.setCstr2(DataUtils.nvl((String)p.getCstr2(), (String[])new String[]{"ISPOP"}));
                p.setCstr3(DataUtils.nvl((String)p.getCstr3(), (String[])new String[]{"Y"}));
                p.setPsymbol(DataUtils.nvl((String)p.getPsymbol(), (String[])new String[]{popDefine.getPsymbol()}));
                p.setPayexcpispop(DataUtils.nvl((String)p.getPayexcpispop(), (String[])new String[]{popDefine.getPayexcpispop()}));
                DataUtils.checkNull((Object)p.getCondtype(), (String)"policy.condtype");
                DataUtils.checkValid((Object)p.getCondtype(), (String)"policy.condtype", (String)"0,2,3,4,5");
                DataUtils.checkValid((Object)p.getSummode(), (String)"policy.summode", (String)"0,1");
                DataUtils.checkValid((Object)p.getCondmode(), (String)"policy.condmode", (String)"1,2,3");
                DataUtils.checkNull(p.getLadder(), (String)"policy.ladder");
                for (int j = 0; j < p.getLadder().size(); ++j) {
                    EvtPolicyLadderBean l = p.getLadder().get(j);
                    l.setPri(j + 1);
                    l.setLevelsl(DataUtils.nvl((double)l.getLevelsl(), (double[])new double[]{0.0}));
                    l.setLevelje(DataUtils.nvl((double)l.getLevelje(), (double[])new double[]{0.0}));
                    l.setCondsl(DataUtils.nvl((double)l.getCondsl(), (double[])new double[]{0.0}));
                    l.setCondje(DataUtils.nvl((double)l.getCondje(), (double[])new double[]{0.0}));
                    l.setPopje(DataUtils.nvl((double)l.getPopje(), (double[])new double[]{0.0}));
                    l.setCstr2(DataUtils.nvl((String)l.getCstr2(), (String[])new String[]{"2"}));
                    if (!keyVals[0].equals("NULL")) {
                        l.setLevelsl(Double.valueOf(keyVals[0]));
                        l.setCondsl(Double.valueOf(keyVals[0]));
                    }
                    if (!keyVals[1].equals("NULL")) {
                        l.setLevelje(Double.valueOf(keyVals[1]));
                        l.setCondje(Double.valueOf(keyVals[1]));
                    }
                    if (!keyVals[2].equals("NULL")) {
                        l.setPopje(Double.valueOf(keyVals[2]));
                    }
                    DataUtils.checkNull((Object)l.getPrcmode(), (String)"policy.ladder.prcmode");
                    DataUtils.checkNull((Object)l.getPopje(), (String)"policy.ladder.popje");
                    if (StringUtils.isEmpty(l.getLimits())) continue;
                    for (int k = 0; k < l.getLimits().size(); ++k) {
                        EvtPolicyLimitBean m = l.getLimits().get(k);
                        m.setLimit_mode("POLY");
                        m.setCop_type(DataUtils.nvl((String)m.getCop_type(), (String[])new String[]{"%"}));
                        m.setMaxpopsl(DataUtils.nvl((double)m.getMaxpopsl(), (double[])new double[]{0.0}));
                        m.setMaxpopje(DataUtils.nvl((double)m.getMaxpopje(), (double[])new double[]{0.0}));
                        m.setCons_day_popcs(DataUtils.nvl((int)m.getCons_day_popcs(), (int[])new int[]{0}));
                        m.setCons_day_popsl(DataUtils.nvl((double)m.getCons_day_popsl(), (double[])new double[]{0.0}));
                        m.setCons_day_popje(DataUtils.nvl((double)m.getCons_day_popje(), (double[])new double[]{0.0}));
                        m.setCons_popcs(DataUtils.nvl((int)m.getCons_popcs(), (int[])new int[]{0}));
                        m.setCons_popsl(DataUtils.nvl((double)m.getCons_popsl(), (double[])new double[]{0.0}));
                        m.setCons_popje(DataUtils.nvl((double)m.getCons_popje(), (double[])new double[]{0.0}));
                        m.setDay_popcs(DataUtils.nvl((int)m.getDay_popcs(), (int[])new int[]{0}));
                        m.setDay_popsl(DataUtils.nvl((double)m.getDay_popsl(), (double[])new double[]{0.0}));
                        m.setDay_popje(DataUtils.nvl((double)m.getDay_popje(), (double[])new double[]{0.0}));
                        m.setTot_popcs(DataUtils.nvl((int)m.getTot_popcs(), (int[])new int[]{0}));
                        m.setTot_popsl(DataUtils.nvl((double)m.getTot_popsl(), (double[])new double[]{0.0}));
                        m.setTot_popje(DataUtils.nvl((double)m.getTot_popje(), (double[])new double[]{0.0}));
                    }
                }
            }
            this.InsertEvent(event);
        }
        return event.getEid();
    }

    public long doCombPopGifts(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        if ("Y".equalsIgnoreCase(event.getAsync())) {
            PopModelServiceImpl.getInstance().doCombPopGiftsAsync(event, popDefine);
            return 0L;
        }
        return this.doCombPopGiftsCore(event, popDefine, null);
    }

    @Async
    public void doCombPopGiftsAsync(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        this.doCombPopGiftsCore(event, popDefine, null);
    }

    public long doCombPopGiftsCore(final EvtMainBean event, final PopDefineBean popDefine, String op) throws Exception {
        this.preProcessModel(event);
        this.preProcessDimension(event, popDefine, new Callback(){

            @Override
            public void execute() throws Exception {
                PopModelServiceImpl.getInstance().doCombPopGiftsCore(event, popDefine);
            }
        });
        return 0L;
    }

    @Override
    public long doCombPopGiftsCore(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        DataUtils.checkNull((Object)event.getBillid(), (String)"billid");
        DataUtils.checkNull((Object)event.getBilltype(), (String)"billtype");
        DataUtils.checkNull(event.getItems(), (String)"items");
        Map<String, List<EvtScopeItemBean>> itemsMap = this.splitByLadder(event.getItems());
        for (String key : itemsMap.keySet()) {
            int i;
            String[] keyVals = key.split("-");
            for (i = 0; i < itemsMap.get(key).size(); ++i) {
                EvtScopeItemBean item = itemsMap.get(key).get(i);
                item.setPolicy_type(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
                item.setPolicy_group(popDefine.getTypegroup());
                item.setRelation(DataUtils.nvl((String)item.getRelation(), (String[])new String[]{"0"}));
                item.setItemgroup(DataUtils.nvl((int)item.getItemgroup(), (int[])new int[]{1}));
                item.setGrouprow(DataUtils.nvl((int)item.getGrouprow(), (int[])new int[]{0}));
                item.setCondmode(DataUtils.nvl((String)item.getCondmode(), (String[])new String[]{"1"}));
                item.setCondsl(DataUtils.nvl((double)item.getCondsl(), (double[])new double[]{0.0}));
                item.setCondje(DataUtils.nvl((double)item.getCondje(), (double[])new double[]{0.0}));
                item.setPopmax(DataUtils.nvl((double)item.getPopmax(), (double[])new double[]{0.0}));
                item.setPoszsz(DataUtils.nvl((String)item.getPoszsz(), (String[])new String[]{"Y"}));
                DataUtils.checkNull((Object)item.getCodemode(), (String)"items.codemode");
                item.setCstr2(this.createDimenKey(item));
            }
            this.CheckPeriod(itemsMap.get(key), event.getPeriod(), popDefine);
            event.setItems(itemsMap.get(key));
            event.setIspoint(DataUtils.nvl((String)event.getIspoint(), (String[])new String[]{popDefine.getIspoint()}));
            event.setIsexclusive(DataUtils.nvl((String)event.getIsexclusive(), (String[])new String[]{popDefine.getIsexclusive()}));
            if (StringUtils.isEmpty(event.getPolicy()) || event.getPolicy().size() <= 0) {
                throw new ServiceException("10000", "\u6d3b\u52a8\u7b56\u7565\u5fc5\u987b\u4f20\u5165\uff01", new Object[0]);
            }
            for (i = 0; i < event.getPolicy().size(); ++i) {
                EvtPolicyBean p = event.getPolicy().get(i);
                p.setPname(DataUtils.nvl((String)p.getPname(), (String[])new String[]{event.getPname(), popDefine.getTypename()}));
                p.setPri(popDefine.getPri());
                p.setPtype(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
                p.setPgroup(popDefine.getTypegroup());
                p.setPopmode(DataUtils.nvl((String)p.getPopmode(), (String[])new String[]{popDefine.getPopmode(), "2"}));
                p.setSelmode("2");
                p.setSummode(DataUtils.nvl((String)p.getSummode(), (String[])new String[]{popDefine.getSummode(), "1"}));
                p.setSumflag(DataUtils.nvl((String)p.getSumflag(), (String[])new String[]{popDefine.getSumflag(), "0"}));
                p.setCondtype(DataUtils.nvl((String)p.getCondtype(), (String[])new String[]{popDefine.getCondtype(), "0"}));
                p.setCondmode(DataUtils.nvl((String)p.getCondmode(), (String[])new String[]{this.getladderCondMode(key), popDefine.getCondmode(), "1"}));
                p.setCalcmaxje(0.0);
                p.setMaxpopsl(0.0);
                p.setMaxpopje(0.0);
                p.setPaypopcheck("Y");
                p.setCstr2("ISPOP");
                p.setCstr3(DataUtils.nvl((String)p.getCstr3(), (String[])new String[]{"Y"}));
                p.setPrcprecision(DataUtils.nvl((String)p.getPrcprecision(), (String[])new String[]{DataUtils.nvl((String)popDefine.getPrcprecision(), (String[])new String[]{"2"})}));
                p.setPsymbol(DataUtils.nvl((String)p.getPsymbol(), (String[])new String[]{popDefine.getPsymbol()}));
                p.setPayexcpispop(DataUtils.nvl((String)p.getPayexcpispop(), (String[])new String[]{popDefine.getPayexcpispop()}));
                DataUtils.checkValid((Object)p.getSummode(), (String)"policy.summode", (String)"0,1");
                DataUtils.checkValid((Object)p.getCondmode(), (String)"policy.condmode", (String)"1,2,3");
                DataUtils.checkNull(p.getLadder(), (String)"policy.ladder");
                for (int j = 0; j < p.getLadder().size(); ++j) {
                    int k;
                    EvtPolicyLadderBean l = p.getLadder().get(j);
                    l.setPri(j + 1);
                    l.setLevelsl(DataUtils.nvl((double)l.getLevelsl(), (double[])new double[]{0.0}));
                    l.setLevelje(DataUtils.nvl((double)l.getLevelje(), (double[])new double[]{0.0}));
                    l.setCondsl(DataUtils.nvl((double)l.getCondsl(), (double[])new double[]{0.0}));
                    l.setCondje(DataUtils.nvl((double)l.getCondje(), (double[])new double[]{0.0}));
                    DataUtils.checkNull((Object)l.getPrcmode(), (String)"ladder.prcmode");
                    l.setPopje(DataUtils.nvl((double)l.getPopje(), (double[])new double[]{0.0}));
                    l.setMaxfb(DataUtils.nvl((int)l.getMaxfb(), (int[])new int[]{0}));
                    l.setMaxsl(DataUtils.nvl((double)l.getMaxsl(), (double[])new double[]{0.0}));
                    l.setMaxje(DataUtils.nvl((double)l.getMaxje(), (double[])new double[]{0.0}));
                    l.setCstr2(DataUtils.nvl((String)l.getCstr2(), (String[])new String[]{"2"}));
                    if (!keyVals[0].equals("NULL")) {
                        l.setLevelsl(Double.valueOf(keyVals[0]));
                        l.setCondsl(Double.valueOf(keyVals[0]));
                    }
                    if (!keyVals[1].equals("NULL")) {
                        l.setLevelje(Double.valueOf(keyVals[1]));
                        l.setCondje(Double.valueOf(keyVals[1]));
                    }
                    if (!keyVals[2].equals("NULL")) {
                        l.setPopje(Double.valueOf(keyVals[2]));
                    }
                    DataUtils.checkNull(l.getGifts(), (String)"policy.ladder.gifts");
                    for (k = 0; k < l.getGifts().size(); ++k) {
                        EvtResultGiftBean g = l.getGifts().get(k);
                        g.setRelation(DataUtils.nvl((String)g.getRelation(), (String[])new String[]{"0"}));
                        g.setGiftgroup(DataUtils.nvl((int)g.getGiftgroup(), (int[])new int[]{1}));
                        g.setGrouprow(DataUtils.nvl((int)g.getGrouprow(), (int[])new int[]{k + 1}));
                        g.setGiftsl(DataUtils.nvl((double)g.getGiftsl(), (double[])new double[]{0.0}));
                        g.setGiftmaxsl(DataUtils.nvl((double)g.getGiftmaxsl(), (double[])new double[]{0.0}));
                        g.setPoplsj(DataUtils.nvl((double)g.getPoplsj(), (double[])new double[]{0.0}));
                        g.setCstr1(DataUtils.nvl((String)g.getCstr1(), (String[])new String[]{"N"}));
                        g.setJoinmode(DataUtils.nvl((String)g.getJoinmode(), (String[])new String[]{"Y"}));
                        DataUtils.checkNull((Object)g.getGifttype(), (String)"policy.ladder.gifts.gifttype");
                        DataUtils.checkNull((Object)g.getPrcmode(), (String)"policy.ladder.gifts.prcmode");
                        DataUtils.checkValid((Object)g.getPrcmode(), (String)"policy.ladder.gifts.prcmode", (String)"1,2,3,4,5,6");
                    }
                    if (StringUtils.isEmpty(l.getLimits())) continue;
                    for (k = 0; k < l.getLimits().size(); ++k) {
                        EvtPolicyLimitBean m = l.getLimits().get(k);
                        m.setLimit_mode("GIFT");
                        m.setCop_type(DataUtils.nvl((String)m.getCop_type(), (String[])new String[]{"%"}));
                        m.setMaxpopsl(DataUtils.nvl((double)m.getMaxpopsl(), (double[])new double[]{0.0}));
                        m.setMaxpopje(DataUtils.nvl((double)m.getMaxpopje(), (double[])new double[]{0.0}));
                        m.setCons_day_popcs(DataUtils.nvl((int)m.getCons_day_popcs(), (int[])new int[]{0}));
                        m.setCons_day_popsl(DataUtils.nvl((double)m.getCons_day_popsl(), (double[])new double[]{0.0}));
                        m.setCons_day_popje(DataUtils.nvl((double)m.getCons_day_popje(), (double[])new double[]{0.0}));
                        m.setCons_popcs(DataUtils.nvl((int)m.getCons_popcs(), (int[])new int[]{0}));
                        m.setCons_popsl(DataUtils.nvl((double)m.getCons_popsl(), (double[])new double[]{0.0}));
                        m.setCons_popje(DataUtils.nvl((double)m.getCons_popje(), (double[])new double[]{0.0}));
                        m.setDay_popcs(DataUtils.nvl((int)m.getDay_popcs(), (int[])new int[]{0}));
                        m.setDay_popsl(DataUtils.nvl((double)m.getDay_popsl(), (double[])new double[]{0.0}));
                        m.setDay_popje(DataUtils.nvl((double)m.getDay_popje(), (double[])new double[]{0.0}));
                        m.setTot_popcs(DataUtils.nvl((int)m.getTot_popcs(), (int[])new int[]{0}));
                        m.setTot_popsl(DataUtils.nvl((double)m.getTot_popsl(), (double[])new double[]{0.0}));
                        m.setTot_popje(DataUtils.nvl((double)m.getTot_popje(), (double[])new double[]{0.0}));
                    }
                }
            }
            this.InsertEvent(event);
        }
        return event.getEid();
    }

    public long doPaygain(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        if ("Y".equalsIgnoreCase(event.getAsync())) {
            PopModelServiceImpl.getInstance().doPaygainAsync(event, popDefine);
            return 0L;
        }
        return this.doPaygainCore(event, popDefine, null);
    }

    @Async
    public void doPaygainAsync(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        this.doPaygainCore(event, popDefine, null);
    }

    public long doPaygainCore(final EvtMainBean event, final PopDefineBean popDefine, String op) throws Exception {
        long eid = 0L;
        this.preProcessModel(event);
        this.preProcessDimension(event, popDefine, new Callback(){

            @Override
            public void execute() throws Exception {
                PopModelServiceImpl.getInstance().doPaygainCore(event, popDefine);
            }
        });
        return 0L;
    }

    public long doPaygainCore(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        int i;
        DataUtils.checkNull((Object)event.getBillid(), (String)"billid");
        DataUtils.checkNull((Object)event.getBilltype(), (String)"billtype");
        if (!StringUtils.isEmpty(event.getItems())) {
            for (i = 0; i < event.getItems().size(); ++i) {
                EvtScopeItemBean item = event.getItems().get(i);
                item.setPolicy_type(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
                item.setPolicy_group(popDefine.getTypegroup());
                item.setRelation(DataUtils.nvl((String)item.getRelation(), (String[])new String[]{"0"}));
                item.setItemgroup(DataUtils.nvl((int)item.getItemgroup(), (int[])new int[]{1}));
                item.setGrouprow(DataUtils.nvl((int)item.getGrouprow(), (int[])new int[]{0}));
                item.setCondmode(DataUtils.nvl((String)item.getCondmode(), (String[])new String[]{"0"}));
                item.setCondsl(DataUtils.nvl((double)item.getCondsl(), (double[])new double[]{0.0}));
                item.setCondje(DataUtils.nvl((double)item.getCondje(), (double[])new double[]{0.0}));
                item.setPopmax(DataUtils.nvl((double)item.getPopmax(), (double[])new double[]{0.0}));
                item.setPoszsz(DataUtils.nvl((String)item.getPoszsz(), (String[])new String[]{"Y"}));
                DataUtils.checkNull((Object)item.getCodemode(), (String)"items.codemode");
                item.setCstr2(this.createDimenKey(item));
            }
        } else {
            throw new ServiceException("10000", "\u5546\u54c1\u8303\u56f4\u5fc5\u987b\u4f20\u5165\uff01", new Object[0]);
        }
        this.CheckPeriod(event, popDefine);
        DataUtils.checkNull(event.getPolicy(), (String)"policy");
        for (i = 0; i < event.getPolicy().size(); ++i) {
            EvtPolicyBean p = event.getPolicy().get(i);
            p.setPname(DataUtils.nvl((String)p.getPname(), (String[])new String[]{event.getPname(), popDefine.getTypename()}));
            p.setPri(popDefine.getPri() * 100);
            p.setPtype(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
            p.setPgroup(popDefine.getTypegroup());
            p.setPopmode(DataUtils.nvl((String)p.getPopmode(), (String[])new String[]{popDefine.getPopmode()}));
            p.setSelmode("2");
            p.setSummode(DataUtils.nvl((String)p.getSummode(), (String[])new String[]{popDefine.getSummode()}));
            p.setSumflag(DataUtils.nvl((String)p.getSumflag(), (String[])new String[]{popDefine.getSumflag()}));
            p.setCondtype(DataUtils.nvl((String)p.getCondtype(), (String[])new String[]{popDefine.getCondtype()}));
            p.setCondmode(DataUtils.nvl((String)p.getCondmode(), (String[])new String[]{popDefine.getCondmode()}));
            p.setCalcmaxje(0.0);
            p.setMaxpopsl(0.0);
            p.setMaxpopje(0.0);
            p.setPaypopcheck("Y");
            p.setCstr2("ISPOP");
            p.setCstr3(DataUtils.nvl((String)p.getCstr3(), (String[])new String[]{"Y"}));
            p.setPrcprecision(DataUtils.nvl((String)p.getPrcprecision(), (String[])new String[]{DataUtils.nvl((String)popDefine.getPrcprecision(), (String[])new String[]{"2"})}));
            p.setPsymbol(DataUtils.nvl((String)p.getPsymbol(), (String[])new String[]{popDefine.getPsymbol()}));
            p.setPayexcpispop(DataUtils.nvl((String)p.getPayexcpispop(), (String[])new String[]{popDefine.getPayexcpispop()}));
            DataUtils.checkValid((Object)p.getSummode(), (String)"policy.summode", (String)"0,1");
            DataUtils.checkValid((Object)p.getCondmode(), (String)"policy.condmode", (String)"1,2,3");
            DataUtils.checkNull(p.getLadder(), (String)"policy.ladder");
            for (int j = 0; j < p.getLadder().size(); ++j) {
                EvtResultCouponBean g;
                int k;
                EvtPolicyLadderBean l = p.getLadder().get(j);
                l.setPri(j + 1);
                l.setLevelsl(DataUtils.nvl((double)l.getLevelsl(), (double[])new double[]{0.0}));
                l.setLevelje(DataUtils.nvl((double)l.getLevelje(), (double[])new double[]{0.0}));
                l.setCondsl(DataUtils.nvl((double)l.getCondsl(), (double[])new double[]{0.0}));
                l.setCondje(DataUtils.nvl((double)l.getCondje(), (double[])new double[]{0.0}));
                l.setCstr2(DataUtils.nvl((String)l.getCstr2(), (String[])new String[]{"2"}));
                DataUtils.checkNull((Object)l.getPrcmode(), (String)"policy.ladder.prcmode");
                DataUtils.checkNull((Object)l.getPopje(), (String)"policy.ladder.popje");
                if (!StringUtils.isEmpty(l.getLimits())) {
                    for (k = 0; k < l.getLimits().size(); ++k) {
                        EvtPolicyLimitBean m = l.getLimits().get(k);
                        m.setLimit_mode("POLY");
                        m.setCop_type(DataUtils.nvl((String)m.getCop_type(), (String[])new String[]{"%"}));
                        m.setMaxpopsl(DataUtils.nvl((double)m.getMaxpopsl(), (double[])new double[]{0.0}));
                        m.setMaxpopje(DataUtils.nvl((double)m.getMaxpopje(), (double[])new double[]{0.0}));
                        m.setCons_day_popcs(DataUtils.nvl((int)m.getCons_day_popcs(), (int[])new int[]{0}));
                        m.setCons_day_popsl(DataUtils.nvl((double)m.getCons_day_popsl(), (double[])new double[]{0.0}));
                        m.setCons_day_popje(DataUtils.nvl((double)m.getCons_day_popje(), (double[])new double[]{0.0}));
                        m.setCons_popcs(DataUtils.nvl((int)m.getCons_popcs(), (int[])new int[]{0}));
                        m.setCons_popsl(DataUtils.nvl((double)m.getCons_popsl(), (double[])new double[]{0.0}));
                        m.setCons_popje(DataUtils.nvl((double)m.getCons_popje(), (double[])new double[]{0.0}));
                        m.setDay_popcs(DataUtils.nvl((int)m.getDay_popcs(), (int[])new int[]{0}));
                        m.setDay_popsl(DataUtils.nvl((double)m.getDay_popsl(), (double[])new double[]{0.0}));
                        m.setDay_popje(DataUtils.nvl((double)m.getDay_popje(), (double[])new double[]{0.0}));
                        m.setTot_popcs(DataUtils.nvl((int)m.getTot_popcs(), (int[])new int[]{0}));
                        m.setTot_popsl(DataUtils.nvl((double)m.getTot_popsl(), (double[])new double[]{0.0}));
                        m.setTot_popje(DataUtils.nvl((double)m.getTot_popje(), (double[])new double[]{0.0}));
                    }
                }
                if (StringUtils.isEmpty(l.getResults())) {
                    ArrayList<EvtResultCouponBean> list_result = new ArrayList<EvtResultCouponBean>();
                    g = new EvtResultCouponBean();
                    list_result.add(g);
                    l.setResults(list_result);
                }
                for (k = 0; k < l.getResults().size(); ++k) {
                    g = l.getResults().get(k);
                    g.setPay_name(DataUtils.nvl((String)g.getPay_name(), (String[])new String[]{popDefine.getPayname()}));
                    g.setPay_code(DataUtils.nvl((String)g.getPay_code(), (String[])new String[]{popDefine.getPaycode()}));
                    g.setResulttype(DataUtils.nvl((String)g.getResulttype(), (String[])new String[]{"4"}));
                }
            }
        }
        this.InsertEvent(event);
        return event.getEid();
    }

    public long doOffset(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        if ("Y".equalsIgnoreCase(event.getAsync())) {
            PopModelServiceImpl.getInstance().doOffsetAsync(event, popDefine);
            return 0L;
        }
        return this.doOffsetCore(event, popDefine, null);
    }

    @Async
    public void doOffsetAsync(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        this.doOffsetCore(event, popDefine, null);
    }

    public long doOffsetCore(final EvtMainBean event, final PopDefineBean popDefine, String op) throws Exception {
        long eid = 0L;
        this.preProcessModel(event);
        this.preProcessDimension(event, popDefine, new Callback(){

            @Override
            public void execute() throws Exception {
                PopModelServiceImpl.getInstance().doOffsetCore(event, popDefine);
            }
        });
        return 0L;
    }

    public long doOffsetCore(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        int i;
        DataUtils.checkNull((Object)event.getBillid(), (String)"billid");
        DataUtils.checkNull((Object)event.getBilltype(), (String)"billtype");
        if (!StringUtils.isEmpty(event.getItems())) {
            for (i = 0; i < event.getItems().size(); ++i) {
                EvtScopeItemBean item = event.getItems().get(i);
                item.setPolicy_type(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
                item.setPolicy_group(popDefine.getTypegroup());
                item.setRelation(DataUtils.nvl((String)item.getRelation(), (String[])new String[]{"0"}));
                item.setItemgroup(DataUtils.nvl((int)item.getItemgroup(), (int[])new int[]{1}));
                item.setGrouprow(DataUtils.nvl((int)item.getGrouprow(), (int[])new int[]{0}));
                item.setCondmode(DataUtils.nvl((String)item.getCondmode(), (String[])new String[]{"0"}));
                item.setCondsl(DataUtils.nvl((double)item.getCondsl(), (double[])new double[]{0.0}));
                item.setCondje(DataUtils.nvl((double)item.getCondje(), (double[])new double[]{0.0}));
                item.setPopmax(DataUtils.nvl((double)item.getPopmax(), (double[])new double[]{0.0}));
                item.setPoszsz(DataUtils.nvl((String)item.getPoszsz(), (String[])new String[]{"Y"}));
                DataUtils.checkNull((Object)item.getCodemode(), (String)"items.codemode");
                item.setCstr2(this.createDimenKey(item));
            }
        } else {
            throw new ServiceException("10000", "\u5546\u54c1\u8303\u56f4\u5fc5\u987b\u4f20\u5165\uff01", new Object[0]);
        }
        this.CheckPeriod(event, popDefine);
        DataUtils.checkNull(event.getPolicy(), (String)"policy");
        for (i = 0; i < event.getPolicy().size(); ++i) {
            EvtPolicyBean p = event.getPolicy().get(i);
            p.setPname(DataUtils.nvl((String)p.getPname(), (String[])new String[]{event.getPname(), popDefine.getTypename()}));
            p.setPri(popDefine.getPri() * 100);
            p.setPtype(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
            p.setPgroup(popDefine.getTypegroup());
            p.setPopmode(DataUtils.nvl((String)p.getPopmode(), (String[])new String[]{popDefine.getPopmode()}));
            p.setSelmode("2");
            p.setSummode(DataUtils.nvl((String)p.getSummode(), (String[])new String[]{popDefine.getSummode()}));
            p.setSumflag(DataUtils.nvl((String)p.getSumflag(), (String[])new String[]{popDefine.getSumflag()}));
            p.setCondtype(DataUtils.nvl((String)p.getCondtype(), (String[])new String[]{popDefine.getCondtype()}));
            p.setCondmode(DataUtils.nvl((String)p.getCondmode(), (String[])new String[]{popDefine.getCondmode()}));
            p.setCalcmaxje(0.0);
            p.setMaxpopsl(0.0);
            p.setMaxpopje(0.0);
            p.setPaypopcheck("Y");
            p.setCstr2("ISPOP");
            p.setCstr3(DataUtils.nvl((String)p.getCstr3(), (String[])new String[]{"Y"}));
            p.setPrcprecision(DataUtils.nvl((String)p.getPrcprecision(), (String[])new String[]{DataUtils.nvl((String)popDefine.getPrcprecision(), (String[])new String[]{"2"})}));
            p.setPsymbol(DataUtils.nvl((String)p.getPsymbol(), (String[])new String[]{popDefine.getPsymbol()}));
            p.setPayexcpispop(DataUtils.nvl((String)p.getPayexcpispop(), (String[])new String[]{popDefine.getPayexcpispop()}));
            DataUtils.checkValid((Object)p.getSummode(), (String)"policy.summode", (String)"0,1");
            DataUtils.checkValid((Object)p.getCondmode(), (String)"policy.condmode", (String)"1,2,3");
            DataUtils.checkNull(p.getLadder(), (String)"policy.ladder");
            for (int j = 0; j < p.getLadder().size(); ++j) {
                EvtResultCouponBean g;
                int k;
                EvtPolicyLadderBean l = p.getLadder().get(j);
                l.setPri(j + 1);
                l.setLevelsl(DataUtils.nvl((double)l.getLevelsl(), (double[])new double[]{0.0}));
                l.setLevelje(DataUtils.nvl((double)l.getLevelje(), (double[])new double[]{0.0}));
                l.setCondsl(DataUtils.nvl((double)l.getCondsl(), (double[])new double[]{0.0}));
                l.setCondje(DataUtils.nvl((double)l.getCondje(), (double[])new double[]{0.0}));
                l.setCstr2(DataUtils.nvl((String)l.getCstr2(), (String[])new String[]{"2"}));
                DataUtils.checkNull((Object)l.getPrcmode(), (String)"policy.ladder.prcmode");
                DataUtils.checkNull((Object)l.getPopje(), (String)"policy.ladder.popje");
                if (!StringUtils.isEmpty(l.getLimits())) {
                    for (k = 0; k < l.getLimits().size(); ++k) {
                        EvtPolicyLimitBean m = l.getLimits().get(k);
                        m.setLimit_mode("POLY");
                        m.setCop_type(DataUtils.nvl((String)m.getCop_type(), (String[])new String[]{"%"}));
                        m.setMaxpopsl(DataUtils.nvl((double)m.getMaxpopsl(), (double[])new double[]{0.0}));
                        m.setMaxpopje(DataUtils.nvl((double)m.getMaxpopje(), (double[])new double[]{0.0}));
                        m.setCons_day_popcs(DataUtils.nvl((int)m.getCons_day_popcs(), (int[])new int[]{0}));
                        m.setCons_day_popsl(DataUtils.nvl((double)m.getCons_day_popsl(), (double[])new double[]{0.0}));
                        m.setCons_day_popje(DataUtils.nvl((double)m.getCons_day_popje(), (double[])new double[]{0.0}));
                        m.setCons_popcs(DataUtils.nvl((int)m.getCons_popcs(), (int[])new int[]{0}));
                        m.setCons_popsl(DataUtils.nvl((double)m.getCons_popsl(), (double[])new double[]{0.0}));
                        m.setCons_popje(DataUtils.nvl((double)m.getCons_popje(), (double[])new double[]{0.0}));
                        m.setDay_popcs(DataUtils.nvl((int)m.getDay_popcs(), (int[])new int[]{0}));
                        m.setDay_popsl(DataUtils.nvl((double)m.getDay_popsl(), (double[])new double[]{0.0}));
                        m.setDay_popje(DataUtils.nvl((double)m.getDay_popje(), (double[])new double[]{0.0}));
                        m.setTot_popcs(DataUtils.nvl((int)m.getTot_popcs(), (int[])new int[]{0}));
                        m.setTot_popsl(DataUtils.nvl((double)m.getTot_popsl(), (double[])new double[]{0.0}));
                        m.setTot_popje(DataUtils.nvl((double)m.getTot_popje(), (double[])new double[]{0.0}));
                    }
                }
                if (StringUtils.isEmpty(l.getResults())) {
                    ArrayList<EvtResultCouponBean> list_result = new ArrayList<EvtResultCouponBean>();
                    g = new EvtResultCouponBean();
                    list_result.add(g);
                    l.setResults(list_result);
                }
                for (k = 0; k < l.getResults().size(); ++k) {
                    g = l.getResults().get(k);
                    g.setPay_name(DataUtils.nvl((String)g.getPay_name(), (String[])new String[]{popDefine.getPayname()}));
                    g.setPay_code(DataUtils.nvl((String)g.getPay_code(), (String[])new String[]{popDefine.getPaycode()}));
                    g.setResulttype(DataUtils.nvl((String)g.getResulttype(), (String[])new String[]{"3"}));
                }
            }
        }
        this.InsertEvent(event);
        return event.getEid();
    }

    public long doAccntGainUse(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        if ("Y".equalsIgnoreCase(event.getAsync())) {
            PopModelServiceImpl.getInstance().doAccntGainUseAsync(event, popDefine);
            return 0L;
        }
        return this.doAccntGainUseCore(event, popDefine, "");
    }

    public long doAccntGainUse(EvtMainBean event, PopDefineBean popDefine, String dim) throws Exception {
        if ("Y".equalsIgnoreCase(event.getAsync())) {
            PopModelServiceImpl.getInstance().doAccntGainUseAsync(event, popDefine, dim);
            return 0L;
        }
        return this.doAccntGainUseCore(event, popDefine, "");
    }

    @Async
    public void doAccntGainUseAsync(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        this.doAccntGainUseCore(event, popDefine, "");
    }

    @Async
    public void doAccntGainUseAsync(EvtMainBean event, PopDefineBean popDefine, String dim) throws Exception {
        this.doAccntGainUseCore(event, popDefine, dim);
    }

    public long doAccntGainUseCore(final EvtMainBean event, final PopDefineBean popDefine, String dim) throws Exception {
        this.preProcessModel(event);
        this.preProcessDimension(event, popDefine, new Callback(){

            @Override
            public void execute() throws Exception {
                PopModelServiceImpl.getInstance().doAccntGainUseCore(event, popDefine);
            }
        });
        return 0L;
    }

    @Override
    public long doAccntGainUseCore(EvtMainBean event, PopDefineBean popDefine) throws Exception {
        int i;
        Boolean isGroupCode = false;
        DataUtils.checkNull((Object)event.getBillid(), (String)"billid");
        DataUtils.checkNull((Object)event.getBilltype(), (String)"billtype");
        if (!StringUtils.isEmpty(event.getItems())) {
            for (i = 0; i < event.getItems().size(); ++i) {
                EvtScopeItemBean item = event.getItems().get(i);
                item.setPolicy_type(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
                item.setPolicy_group(popDefine.getTypegroup());
                item.setRelation(DataUtils.nvl((String)item.getRelation(), (String[])new String[]{"0"}));
                item.setItemgroup(DataUtils.nvl((int)item.getItemgroup(), (int[])new int[]{1}));
                item.setGrouprow(DataUtils.nvl((int)item.getGrouprow(), (int[])new int[]{0}));
                item.setCondmode(DataUtils.nvl((String)item.getCondmode(), (String[])new String[]{"0"}));
                item.setCondsl(DataUtils.nvl((double)item.getCondsl(), (double[])new double[]{0.0}));
                item.setCondje(DataUtils.nvl((double)item.getCondje(), (double[])new double[]{0.0}));
                item.setPopmax(DataUtils.nvl((double)item.getPopmax(), (double[])new double[]{0.0}));
                item.setPoszsz(DataUtils.nvl((String)item.getPoszsz(), (String[])new String[]{"Y"}));
                DataUtils.checkNull((Object)item.getCodemode(), (String)"items.codemode");
                String cdk = this.createDimenKey(item);
                item.setCstr2("0".equals(cdk) ? "%" : cdk);
            }
        } else {
            throw new ServiceException("10000", "\u5546\u54c1\u8303\u56f4\u5fc5\u987b\u4f20\u5165\uff01", new Object[0]);
        }
        this.CheckPeriod(event, popDefine);
        if (StringUtils.isEmpty(event.getPolicy()) || event.getPolicy().size() <= 0) {
            throw new ServiceException("10000", "\u6d3b\u52a8\u7b56\u7565\u5fc5\u987b\u4f20\u5165\uff01", new Object[0]);
        }
        for (i = 0; i < event.getPolicy().size(); ++i) {
            EvtPolicyBean p = event.getPolicy().get(i);
            p.setPname(DataUtils.nvl((String)p.getPname(), (String[])new String[]{event.getPname(), popDefine.getTypename()}));
            p.setPri(popDefine.getPri());
            p.setPtype(DataUtils.nvl((String)event.getPtype(), (String[])new String[]{popDefine.getTypeid()}));
            p.setPgroup(popDefine.getTypegroup());
            p.setPopmode(popDefine.getPopmode());
            p.setSelmode("2");
            p.setSummode(DataUtils.nvl((String)p.getSummode(), (String[])new String[]{popDefine.getSummode()}));
            p.setSumflag(DataUtils.nvl((String)p.getSumflag(), (String[])new String[]{popDefine.getSumflag()}));
            p.setCondtype(DataUtils.nvl((String)p.getCondtype(), (String[])new String[]{popDefine.getCondtype()}));
            p.setCondmode(DataUtils.nvl((String)p.getCondmode(), (String[])new String[]{popDefine.getCondmode()}));
            p.setPrcprecision(DataUtils.nvl((String)p.getPrcprecision(), (String[])new String[]{DataUtils.nvl((String)popDefine.getPrcprecision(), (String[])new String[]{"2"})}));
            p.setCalcmaxje(0.0);
            p.setMaxpopsl(0.0);
            p.setMaxpopje(0.0);
            p.setPaypopcheck("N");
            p.setCstr2(DataUtils.nvl((String)p.getCstr2(), (String[])new String[]{popDefine.getExcppay()}));
            p.setCstr3(DataUtils.nvl((String)p.getCstr3(), (String[])new String[]{"Y"}));
            p.setPsymbol(DataUtils.nvl((String)p.getPsymbol(), (String[])new String[]{popDefine.getPsymbol()}));
            p.setPayexcpispop(DataUtils.nvl((String)p.getPayexcpispop(), (String[])new String[]{popDefine.getPayexcpispop()}));
            DataUtils.checkValid((Object)p.getSummode(), (String)"policy.summode", (String)"0,1");
            DataUtils.checkValid((Object)p.getCondmode(), (String)"policy.condmode", (String)"0,1,2,3");
            DataUtils.checkNull(p.getLadder(), (String)"policy.ladder");
            for (int j = 0; j < p.getLadder().size(); ++j) {
                int k;
                EvtPolicyLadderBean l = p.getLadder().get(j);
                l.setPri(j + 1);
                l.setLevelsl(DataUtils.nvl((double)l.getLevelsl(), (double[])new double[]{0.0}));
                l.setLevelje(DataUtils.nvl((double)l.getLevelje(), (double[])new double[]{0.0}));
                l.setCondsl(DataUtils.nvl((double)l.getCondsl(), (double[])new double[]{0.0}));
                l.setCondje(DataUtils.nvl((double)l.getCondje(), (double[])new double[]{0.0}));
                l.setPopje(DataUtils.nvl((double)l.getPopje(), (double[])new double[]{0.0}));
                l.setMaxfb(DataUtils.nvl((int)l.getMaxfb(), (int[])new int[]{0}));
                l.setMaxsl(DataUtils.nvl((double)l.getMaxsl(), (double[])new double[]{0.0}));
                l.setMaxje(DataUtils.nvl((double)l.getMaxje(), (double[])new double[]{0.0}));
                l.setCstr2(DataUtils.nvl((String)l.getCstr2(), (String[])new String[]{"2"}));
                l.setPrcmode(DataUtils.nvl((String)l.getPrcmode(), (String[])new String[]{"0"}));
                DataUtils.checkNull(l.getResults(), (String)"policy.ladder.results");
                for (k = 0; k < l.getResults().size(); ++k) {
                    EvtResultCouponBean g = l.getResults().get(k);
                    g.setPay_type(DataUtils.nvl((String)g.getPay_type(), (String[])new String[]{popDefine.getPaytype()}));
                    g.setPay_name(DataUtils.nvl((String)g.getPay_name(), (String[])new String[]{popDefine.getPayname()}));
                    g.setPay_code(DataUtils.nvl((String)g.getPay_code(), (String[])new String[]{popDefine.getPaycode()}));
                    g.setCop_type(DataUtils.nvl((String)g.getCop_type(), (String[])new String[]{popDefine.getCoptype()}));
                    DataUtils.checkNull((Object)g.getResulttype(), (String)"policy.ladder.results.resulttype");
                    DataUtils.checkNull((Object)g.getCalc_mode(), (String)"policy.ladder.results.calc_mode");
                    DataUtils.checkNull((Object)g.getCop_type(), (String)"policy.ladder.results.cop_type");
                    DataUtils.checkValid((Object)g.getCalc_mode(), (String)"policy.ladder.gifresultsts.calc_mode", (String)"1,2,3,4,5,6,7,8,9,A,B");
                }
                if (StringUtils.isEmpty(l.getLimits())) continue;
                for (k = 0; k < l.getLimits().size(); ++k) {
                    EvtPolicyLimitBean m = l.getLimits().get(k);
                    m.setLimit_mode("POLY");
                    m.setCop_type(DataUtils.nvl((String)m.getCop_type(), (String[])new String[]{"%"}));
                    m.setMaxpopsl(DataUtils.nvl((double)m.getMaxpopsl(), (double[])new double[]{0.0}));
                    m.setMaxpopje(DataUtils.nvl((double)m.getMaxpopje(), (double[])new double[]{0.0}));
                    m.setCons_day_popcs(DataUtils.nvl((int)m.getCons_day_popcs(), (int[])new int[]{0}));
                    m.setCons_day_popsl(DataUtils.nvl((double)m.getCons_day_popsl(), (double[])new double[]{0.0}));
                    m.setCons_day_popje(DataUtils.nvl((double)m.getCons_day_popje(), (double[])new double[]{0.0}));
                    m.setCons_popcs(DataUtils.nvl((int)m.getCons_popcs(), (int[])new int[]{0}));
                    m.setCons_popsl(DataUtils.nvl((double)m.getCons_popsl(), (double[])new double[]{0.0}));
                    m.setCons_popje(DataUtils.nvl((double)m.getCons_popje(), (double[])new double[]{0.0}));
                    m.setDay_popcs(DataUtils.nvl((int)m.getDay_popcs(), (int[])new int[]{0}));
                    m.setDay_popsl(DataUtils.nvl((double)m.getDay_popsl(), (double[])new double[]{0.0}));
                    m.setDay_popje(DataUtils.nvl((double)m.getDay_popje(), (double[])new double[]{0.0}));
                    m.setTot_popcs(DataUtils.nvl((int)m.getTot_popcs(), (int[])new int[]{0}));
                    m.setTot_popsl(DataUtils.nvl((double)m.getTot_popsl(), (double[])new double[]{0.0}));
                    m.setTot_popje(DataUtils.nvl((double)m.getTot_popje(), (double[])new double[]{0.0}));
                }
            }
        }
        this.InsertEvent(event);
        return event.getEid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doExceptpay(ServiceSession session, JSONObject jsonparam, boolean valid) throws Exception {
        JSONObject json = (JSONObject)jsonparam.clone();
        if (json.get((Object)"orgs") != null) {
            if (json.get((Object)"orgs") instanceof JSONArray) {
                if (json.getJSONArray("orgs").size() == 0) {
                    json.remove((Object)"orgs");
                }
            } else {
                json.remove((Object)"orgs");
            }
        }
        if (json.get((Object)"orgs") == null) {
            JSONObject rowdefault = new JSONObject();
            rowdefault.put("org_code", (Object)"%");
            rowdefault.put("chl_code", (Object)"%");
            JSONArray jSONArray = new JSONArray();
            jSONArray.add((Object)rowdefault);
            json.put("orgs", (Object)jSONArray);
        }
        if (json.get((Object)"pays") == null) throw new ServiceException("10000", "pays \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        if (!(json.get((Object)"pays") instanceof JSONArray)) throw new ServiceException("10000", "pays \u683c\u5f0f\u9519\u8bef", new Object[0]);
        if (json.getJSONArray("pays").size() == 0) {
            throw new ServiceException("10000", "pays \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        for (Object e : json.getJSONArray("pays")) {
            Map pay = (Map)e;
            if (!StringUtils.isEmpty(pay.get("pay_code"))) continue;
            throw new ServiceException("10000", "pay_code \u5fc5\u987b\u6307\u5b9a", new Object[0]);
        }
        if (json.get((Object)"setmode") == null) throw new ServiceException("10000", "setmode \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        if (!(json.get((Object)"setmode") instanceof JSONArray)) throw new ServiceException("10000", "setmode \u683c\u5f0f\u9519\u8bef", new Object[0]);
        JSONArray setmodes = json.getJSONArray("setmode");
        if (setmodes.size() == 0) {
            throw new ServiceException("10000", "setmode \u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        for (Object setmode : json.getJSONArray("setmode")) {
            if (!StringUtils.isEmpty(setmode)) continue;
            throw new ServiceException("10000", "setmode \u683c\u5f0f\u9519\u8bef", new Object[0]);
        }
        HashMap<String, String> map_setmode = new HashMap<String, String>();
        map_setmode.put("ISPOINT", "O");
        map_setmode.put("ISPOP", "P");
        map_setmode.put("ISCZZ", "C");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PLATFORMDISCOUNT", "P");
        hashMap.put("MERCHANTDISCOUNT", "M");
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            String corp_id = this.getParamWithCheck(jsonparam, "corp_id", true, "");
            Map utcmap = (Map)((FMybatisTemplate)storage).getSqlSessionTemplate().selectOne("mybatis.sql.select_UNIX_TIMESTAMP");
            long utctime = Long.parseLong(utcmap.get("utctime").toString());
            for (Object row_org : json.getJSONArray("orgs")) {
                Map org = (Map)row_org;
                String org_code = Utils.nvl(org.get("org_code"), (String)"%");
                String chl_code = Utils.nvl(org.get("chl_code"), (String)"%");
                for (Object row_pay : json.getJSONArray("pays")) {
                    Map pay = (Map)row_pay;
                    String pay_code = Utils.nvl(pay.get("pay_code"), (String)"");
                    String pay_name = Utils.nvl(pay.get("pay_name"), (String)"");
                    String pay_type = Utils.nvl(pay.get("pay_type"), (String)"");
                    String cop_type = Utils.nvl(pay.get("cop_type"), (String)"");
                    String joinmode = Utils.nvl(pay.get("joinmode"), (String)"Y");
                    JSONArray setmodes2 = json.getJSONArray("setmode");
                    for (Object o_setmode : setmodes2) {
                        String setmode = o_setmode.toString();
                        String billid = MapUtils.getString(map_setmode, (String)setmode, (String)setmode).concat(corp_id).concat(org_code.equals("%") ? "A" : org_code).concat(chl_code.equals("%") ? "A" : chl_code).concat(pay_code).concat(MapUtils.getString(hashMap, (String)cop_type, (String)cop_type));
                        Criteria criteria = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("corp_id").is((Object)corp_id).and("billid").is((Object)billid).and("nsta").is((Object)2021L);
                        Query query = new Query((CriteriaDefinition)criteria);
                        Update upt = new Update();
                        upt.set("nsta", (Object)2022L);
                        upt.set("tmdd", (Object)utctime);
                        storage.update(query, upt, EvtPolicyNopayBean.class);
                        EvtPolicyNopayBean nopay = new EvtPolicyNopayBean();
                        nopay.setSeqno(UniqueID.getUniqueID());
                        nopay.setEnt_id(session.getEnt_id());
                        nopay.setCorp_id(corp_id);
                        nopay.setBillid(billid);
                        nopay.setEvt_scd(0L);
                        nopay.setEvt_id(0L);
                        nopay.setPolicy_id(0L);
                        nopay.setPolicy_group(setmode);
                        nopay.setChl_code(chl_code);
                        nopay.setOrg_code(org_code);
                        if ("ALL".equalsIgnoreCase(nopay.getChl_code())) {
                            nopay.setChl_code("%");
                        }
                        if ("ALL".equalsIgnoreCase(nopay.getOrg_code())) {
                            nopay.setOrg_code("%");
                        }
                        nopay.setJoinmode(joinmode);
                        if ("%".equals(nopay.getChl_code()) && "%".equals(nopay.getOrg_code())) {
                            nopay.setNopay_mode("00100");
                            nopay.setMemo("00100-".concat(setmode));
                        } else if ("%".equals(nopay.getChl_code()) && !"%".equals(nopay.getOrg_code())) {
                            nopay.setNopay_mode("00101");
                            nopay.setMemo("00101-".concat(setmode).concat("-").concat(nopay.getOrg_code()));
                        } else if (!"%".equals(nopay.getChl_code()) && "%".equals(nopay.getOrg_code())) {
                            nopay.setNopay_mode("00110");
                            nopay.setMemo("00110-".concat(setmode).concat("-").concat(nopay.getChl_code()));
                        } else {
                            nopay.setNopay_mode("00111");
                            nopay.setMemo("00111-".concat(setmode).concat("-").concat(nopay.getChl_code()).concat("-").concat(nopay.getOrg_code()));
                        }
                        nopay.setSta_date("1970-01-01");
                        nopay.setEnd_date("2099-12-31");
                        nopay.setPay_type(pay_type);
                        nopay.setPay_code(pay_code);
                        nopay.setPay_name(pay_name);
                        nopay.setCop_type(cop_type);
                        nopay.setTmdd(utctime);
                        storage.insert((Object)nopay);
                    }
                }
            }
            return;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }
}

