/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omp.event.model.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponent;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.DateUtils;
import com.efuture.ocp.common.util.PrecisionUtils;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.mybatis.HashMapCase;
import com.efuture.omp.event.model.intf.PromotionService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="efuture.omp.event.promotion")
public class PromotionImpl
extends BasicComponent
implements PromotionService {
    private String priceTagChannelId;
    private String priceTagBilltype;

    public String getPriceTagChannelId() {
        return this.priceTagChannelId;
    }

    public void setPriceTagChannelId(String priceTagChannelId) {
        this.priceTagChannelId = priceTagChannelId;
    }

    public String getPriceTagBilltype() {
        return this.priceTagBilltype;
    }

    public void setPriceTagBilltype(String priceTagBilltype) {
        this.priceTagBilltype = priceTagBilltype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse getprefelist(ServiceSession session, JSONObject jsonparam) throws Exception {
        FMybatisTemplate storage = null;
        try {
            if (session == null) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
                return serviceResponse;
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
                return serviceResponse;
            }
            if (StringUtils.isEmpty((Object)jsonparam.getString("market"))) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"{0} [{1}] is empty", (Object[])new Object[]{"", "market"});
                return serviceResponse;
            }
            if (StringUtils.isEmpty((Object)jsonparam.getString("channel"))) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"{0} [{1}] is empty", (Object[])new Object[]{"", "channel"});
                return serviceResponse;
            }
            if (StringUtils.isEmpty((Object)jsonparam.getString("mana_unit"))) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"{0} [{1}] is empty", (Object[])new Object[]{"", "mana_unit"});
                return serviceResponse;
            }
            if (StringUtils.isEmpty((Object)jsonparam.getString("sale_date"))) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"{0} [{1}] is empty", (Object[])new Object[]{"", "sale_date"});
                return serviceResponse;
            }
            storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
            SqlSessionTemplate db = storage.getSqlSessionTemplate();
            HashMapCase map = new HashMapCase();
            map.put("ent_id", session.getEnt_id());
            map.put("corp_id", jsonparam.get((Object)"mana_unit"));
            map.put("saledate", ((String)jsonparam.get((Object)"sale_date")).replace("/", "-"));
            map.put("market", jsonparam.get((Object)"market"));
            map.put("channel", jsonparam.get((Object)"channel"));
            List items = db.selectList(FMybatisTemplate.makeFullSqlStatement((String)"event.calc", (String)"select_PrefeEventScopeItem"), (Object)map);
            JSONArray array = new JSONArray();
            if (items != null && items.size() > 0) {
                for (Map item : items) {
                    for (int i = 0; i < array.size(); ++i) {
                        JSONObject json = array.getJSONObject(i);
                        if (!json.getString("itemcode").equals(item.get("goods_code"))) continue;
                        array.remove(i);
                        break;
                    }
                    JSONObject sell = new JSONObject();
                    sell.put("itemcode", item.get("goods_code"));
                    sell.put("sta_date", item.get("sta_date"));
                    sell.put("end_date", item.get("end_date"));
                    sell.put("sale_amount", (Object)PrecisionUtils.doubleConvert((double)Double.parseDouble(item.get("poplsj").toString()), (int)2));
                    array.add((Object)sell);
                }
            }
            ServiceResponse response = ServiceResponse.buildSuccess(null);
            JSONObject json = new JSONObject();
            json.put("sell_details", (Object)array);
            response.setData((Object)json);
            ServiceResponse serviceResponse = response;
            return serviceResponse;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    @Override
    public ServiceResponse getprintpricetag(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"erpcode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"{0} [{1}] is empty", (Object[])new Object[]{"", "erpcode"});
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"shopcode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"{0} [{1}] is empty", (Object[])new Object[]{"", "shopcode"});
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"effectivedate"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"{0} [{1}] is empty", (Object[])new Object[]{"", "effectivedate"});
        }
        if (StringUtils.isEmpty((Object)jsonparam.get((Object)"goodscode")) || jsonparam.getJSONArray("goodscode").size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"{0} [{1}] is empty", (Object[])new Object[]{"", "goodscode"});
        }
        String effectiveDate = jsonparam.getString("effectivedate");
        String week = String.valueOf(DateUtils.getDayOfWeek((Date)DateUtils.parseDate((String)effectiveDate, (String[])new String[]{"yyyy-MM-dd"})));
        SqlSessionTemplate db = ((FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class)).getSqlSessionTemplate();
        HashMapCase map = new HashMapCase();
        map.put("entid", session.getEnt_id());
        map.put("erpcode", jsonparam.get((Object)"erpcode"));
        map.put("shopcode", jsonparam.get((Object)"shopcode"));
        map.put("effectivedate", effectiveDate);
        map.put("week", week);
        if (!StringUtils.isEmpty((Object)this.getPriceTagChannelId())) {
            map.put("channelId", this.getPriceTagChannelId());
        }
        map.put("goodscode", jsonparam.getJSONArray("goodscode"));
        map.put("billtype", (StringUtils.isEmpty((Object)jsonparam.get((Object)"billtype")) ? this.getPriceTagBilltype() : jsonparam.getString("billtype")).split(","));
        List priceTagList = db.selectList("select_printpricetag", (Object)map);
        JSONObject data = new JSONObject();
        data.put("printpricetag", (Object)priceTagList);
        return ServiceResponse.buildSuccess((Object)data);
    }
}

