/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omp.event.model.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.BatchInsService;
import com.efuture.ocp.common.util.BeanField;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omp.event.model.entity.DayPromotionReportBean;
import com.efuture.omp.event.model.entity.EvtMainBean;
import com.efuture.omp.event.model.entity.PromotionReportBean;
import com.efuture.omp.event.model.intf.ModelReportService;
import com.xxl.job.core.log.XxlJobLogger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.RowBounds;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component(value="omp.event.model.report")
public class ReportServiceImpl
extends BasicComponentService<EvtMainBean>
implements ModelReportService {
    boolean isXTS = false;
    int pagesize = 2000;
    int ent_id = 0;
    int exec_size = 500;
    private BatchInsService batchInsService = new BatchInsService();
    private ConcurrentHashMap<String, Set<BeanField>> CACHE_FIELD = new ConcurrentHashMap();

    private void log(String msg) {
        this.log(msg, null);
    }

    private void log(String msg, String type) {
        this.isXTS = true;
        SimpleDateFormat sdf = new SimpleDateFormat(" yyyy-MM-dd HH:mm:ss");
        String sdate = sdf.format(new Date());
        if (this.isXTS) {
            System.out.println(sdate + "--------------------xts out---------------" + msg);
        }
        if (!StringUtils.isEmpty((Object)type)) {
            return;
        }
        this.getLogger().info((Object)(sdate + "--------------------xts info---------------" + msg));
    }

    public static ReportServiceImpl getInstance() {
        return (ReportServiceImpl)SpringBeanFactory.getBean((String)"efuture.omp.event.model.search", ReportServiceImpl.class);
    }

    public void setTmdd(long ent_id, String tablename) throws Exception {
        JSONObject json = new JSONObject();
        json.put("ent_id", (Object)ent_id);
        json.put("tablename", (Object)tablename);
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        int count = storage.getSqlSessionTemplate().update("mybatis.report.uptTmdd", (Object)json);
        if (count <= 0) {
            storage.getSqlSessionTemplate().update("mybatis.report.insertTmdd", (Object)json);
        }
    }

    public long getTmdd(long ent_id, String tablename) throws Exception {
        JSONObject json = new JSONObject();
        json.put("ent_id", (Object)ent_id);
        json.put("tablename", (Object)tablename);
        long tmdd = 0L;
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        Map manapara = (Map)storage.getSqlSessionTemplate().selectOne("mybatis.report.select_tmdd", (Object)json);
        if (manapara != null && !StringUtils.isEmpty(manapara.get("tmdd"))) {
            tmdd = this.tranLong(manapara.get("tmdd"));
        }
        return tmdd;
    }

    @Override
    public ServiceResponse genDaypromotionreport(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"{0} is NULL ", (Object[])new Object[]{"session"});
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"{0} is NULL ", (Object[])new Object[]{"param"});
        }
        if (!(jsonparam instanceof JSONObject)) {
            throw new ServiceException("50005", "{0}  is not  JSONObject ", new Object[]{"param in"});
        }
        if (!jsonparam.containsKey((Object)"execute")) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"{0} is NULL ", (Object[])new Object[]{"execute"});
        }
        if (jsonparam.containsKey((Object)"ent_id")) {
            JSONObject json = (JSONObject)jsonparam.clone();
            json.remove((Object)"ent_id");
            for (int i = 0; i < jsonparam.getString("ent_id").split(",").length; ++i) {
                json.put("ent_id", (Object)jsonparam.getString("ent_id").split(",")[i]);
                session.setEnt_id(Long.parseLong(json.getString("ent_id")));
                this.genDaypromotionreport_byentid(session, json);
            }
        } else {
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            this.genDaypromotionreport_byentid(session, jsonparam);
        }
        return ServiceResponse.buildSuccess((Object)"");
    }

    public ServiceResponse genDaypromotionreport_byentid(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (jsonparam.containsKey((Object)"XTS")) {
            this.isXTS = true;
        }
        long starttime = System.currentTimeMillis();
        long id = UniqueID.getUniqueID();
        this.updateLogFlag(id, "N", "start init data");
        long tmdd = 0L;
        if (!this.getParamWithCheck(jsonparam, "execute", false, "").equals("init")) {
            tmdd = this.getTmdd(session.getEnt_id(), "daypromotionreport");
        }
        this.setTmdd(session.getEnt_id(), "daypromotionreport");
        JSONObject json = (JSONObject)jsonparam.clone();
        json.put("tmdd", (Object)tmdd);
        this.dodeletedaytemp(session, json);
        this.gendayDatas(session, json);
        long result = this.renderdayReport(session, json);
        this.freshDayData(session, json);
        long endtime = System.currentTimeMillis() - starttime;
        this.updateLogFlag(id, "Y", "init data success with " + result + " items in " + endtime / 1000L / 60L + " min");
        this.log("init data success with " + result + " items in " + endtime / 1000L / 60L + " min");
        XxlJobLogger.log((String)("init data success with " + result + " items in " + endtime / 1000L + " s,by ent_id:" + String.valueOf(session.getEnt_id())), (Object[])new Object[0]);
        return ServiceResponse.buildSuccess((Object)("init data success with " + result + " items in " + endtime / 1000L / 60L + " min"));
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void gendayDatas(ServiceSession session, JSONObject json) {
        XxlJobLogger.log((String)("insert into data ,start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        System.out.println(" genDatas single products report ");
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        storage.getSqlSessionTemplate().update("mybatis.report.init_daypromotion_report", (Object)json);
    }

    public void freshDayData(ServiceSession session, JSONObject jsonparam) throws Exception {
        XxlJobLogger.log((String)("fresh data ,start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        JSONObject param = new JSONObject();
        param.put("ent_id", (Object)session.getEnt_id());
        param.put("tmdd", jsonparam.get((Object)"tmdd"));
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        List event_list = storage.getSqlSessionTemplate().selectList("mybatis.report.select_daypopmemo", (Object)param);
        if (event_list == null || event_list.size() <= 0) {
            return;
        }
        for (int i = 0; i < event_list.size(); ++i) {
            String col;
            String[] cols;
            String[] popmemo_arr;
            String fdmode = "";
            double popzkfd = 0.0;
            String fdresult = "";
            Map row = (Map)event_list.get(i);
            if (StringUtils.isEmpty(row.get("popmemo"))) continue;
            String popmemo = row.get("popmemo").toString();
            String[] stringArray = popmemo_arr = popmemo.split(",");
            int n = stringArray.length;
            for (int j = 0; j < n && (cols = (col = stringArray[j]).split("[:]")).length >= 2; ++j) {
                if (cols[0].equals("fdmode")) {
                    fdmode = cols[1];
                    continue;
                }
                if (cols[0].equals("popzkfd")) {
                    popzkfd = Double.parseDouble(cols[1]);
                    continue;
                }
                if (!cols[0].equals("fdresult") || !(fdresult = cols[1]).equals("null")) continue;
                fdresult = "";
            }
            if (fdmode.equals("")) continue;
            param.put("popmemo", (Object)popmemo);
            param.put("fdmode", (Object)fdmode);
            param.put("popzkfd", (Object)popzkfd);
            if (!fdresult.equals("")) {
                param.put("fdresult", (Object)fdresult);
            }
            storage.getSqlSessionTemplate().update("mybatis.report.update_daypromotionreport_popmemo", (Object)param);
        }
        storage.getSqlSessionTemplate().update("mybatis.report.update_promotionreport_disprice_yesterday", (Object)param);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    protected void dodeletedaytemp(ServiceSession session, JSONObject json) {
        XxlJobLogger.log((String)("delete data ,start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        storage.getSqlSessionTemplate().delete("mybatis.report.delete_daypromotionreport", (Object)json);
        this.log("delete promotion report data");
    }

    private long renderdayReport(ServiceSession session, JSONObject jsonparam) throws Exception {
        XxlJobLogger.log((String)("render data , start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        int pageno = 1;
        long rendercount = 0L;
        int pagesize = 1500;
        JSONArray srcgoods = new JSONArray();
        JSONObject param = new JSONObject();
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        ServiceResponse response = null;
        param.put("fields", (Object)"distinct corp_id,mktid,itemcode");
        param.put("ent_id", jsonparam.get((Object)"ent_id"));
        param.put("tmdd", jsonparam.get((Object)"tmdd"));
        long totalsize = this.getTotalNumber(storage, "mybatis.report.select_berenderdaydata", param);
        if (totalsize > 0L) {
            while (true) {
                RowBounds rowBound = new RowBounds((pageno - 1) * pagesize, pagesize);
                List event_list = storage.getSqlSessionTemplate().selectList("mybatis.report.select_berenderdaydata", (Object)param, rowBound);
                if (event_list == null || event_list.size() <= 0) break;
                this.log("initing >>:  update saleprice ->  pagesize: " + pagesize + "    totalresults: " + totalsize + " and totalpage: " + totalsize / (long)pagesize + " and current page " + pageno);
                JSONObject searchgoods = new JSONObject();
                JSONObject temp_searchgoods = new JSONObject();
                for (int i = 0; i < event_list.size(); ++i) {
                    Map row = (Map)event_list.get(i);
                    String barcode = row.get("itemcode").toString();
                    String org_code = row.get("mktid").toString();
                    String jygs = row.get("corp_id").toString();
                    if (temp_searchgoods.containsKey((Object)(jygs + "-" + org_code))) {
                        temp_searchgoods.put(jygs + "-" + org_code, (Object)(temp_searchgoods.getString(jygs + "-" + org_code) + "," + barcode));
                        continue;
                    }
                    temp_searchgoods.put(jygs + "-" + org_code, (Object)barcode);
                }
                for (String col : temp_searchgoods.keySet()) {
                    searchgoods.put("jygs", (Object)col.split("-")[0]);
                    searchgoods.put("org_code", (Object)col.split("-")[1]);
                    searchgoods.put("item_code", temp_searchgoods.get((Object)col));
                    searchgoods.put("page_size", (Object)9999);
                    response = RestClientUtils.getRestUtils().sendRequest((Object)session, "mdm.goods.searchbyall", (Object)searchgoods.toJSONString());
                    JSONObject rtn = (JSONObject)response.getData();
                    JSONArray items = rtn.getJSONArray("item_business");
                    if (items == null || items.size() == 0) continue;
                    srcgoods.addAll((Collection)items);
                }
                ++pageno;
            }
        }
        if (srcgoods != null && srcgoods.size() > 0) {
            JSONObject jsonrender = new JSONObject();
            jsonrender.put("type", (Object)"good");
            jsonrender.put("data", (Object)srcgoods);
            long uptcount = this.renderDayArrayData(session, jsonrender);
            rendercount += uptcount;
            srcgoods.clear();
        }
        this.log("-------------------- reder report finished,totcount:" + String.valueOf(rendercount), "whatever");
        return rendercount;
    }

    private long renderDayArrayData(ServiceSession session, JSONObject jsonparam) throws Exception {
        long totuptcount = 0L;
        String type = this.getParamWithCheck(jsonparam, "type", false, "good");
        if (type.equals("good")) {
            FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
            Criteria criteria = new Criteria();
            Query query = null;
            JSONArray items = jsonparam.getJSONArray("data");
            for (int i = 0; i < items.size(); ++i) {
                JSONObject row = items.getJSONObject(i);
                if (!row.containsKey((Object)"org_code")) continue;
                criteria = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("corp_id").is((Object)row.getString("jygs")).and("barcode").is((Object)row.getString("barcode")).and("itemname").is((Object)"");
                if (row.containsKey((Object)"org_code")) {
                    criteria.and("mktid").is((Object)row.getString("org_code"));
                }
                query = new Query((CriteriaDefinition)criteria);
                Update upt = new Update();
                upt.set("itemname", row.get((Object)"item_name"));
                upt.set("catcode", row.get((Object)"cat_code"));
                upt.set("brand", row.get((Object)"brand_code"));
                upt.set("supid", row.get((Object)"vendor_id"));
                upt.set("mfid", row.get((Object)"gz_code"));
                upt.set("catcode_name", row.get((Object)"cat_name"));
                upt.set("brand_name", row.get((Object)"brand_name"));
                upt.set("supid_name", row.get((Object)"vendor_name"));
                upt.set("mfid_name", row.get((Object)"gz_name"));
                upt.set("purchase_price", (Object)(StringUtils.isEmpty((Object)row.get((Object)"purchase_price")) ? 0.0 : row.getDoubleValue("purchase_price")));
                upt.set("unit", row.get((Object)"unit"));
                upt.set("spec", row.get((Object)"spec"));
                upt.set("saleprice", (Object)(StringUtils.isEmpty((Object)row.get((Object)"sale_price")) ? 0.0 : row.getDoubleValue("sale_price")));
                if (!StringUtils.isEmpty((Object)row.get((Object)"content"))) {
                    upt.set("content", row.get((Object)"content"));
                }
                if (!StringUtils.isEmpty((Object)row.get((Object)"origin"))) {
                    upt.set("origin", row.get((Object)"origin"));
                }
                int uptcount = storage.update(query, upt, DayPromotionReportBean.class);
                totuptcount += (long)uptcount;
                if (uptcount > 0) continue;
                criteria = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("corp_id").is((Object)row.getString("jygs")).and("itemcode").is((Object)row.getString("item_code")).and("itemname").is((Object)"");
                if (row.containsKey((Object)"org_code")) {
                    criteria.and("mktid").is((Object)row.getString("org_code"));
                }
                query = new Query((CriteriaDefinition)criteria);
                uptcount = storage.update(query, upt, DayPromotionReportBean.class);
                totuptcount += (long)uptcount;
            }
        }
        return totuptcount;
    }

    @Override
    public ServiceResponse genTodaypromotion(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (jsonparam.containsKey((Object)"ent_id")) {
            JSONObject json = (JSONObject)jsonparam.clone();
            json.remove((Object)"ent_id");
            for (int i = 0; i < jsonparam.getString("ent_id").split(",").length; ++i) {
                json.put("ent_id", (Object)jsonparam.getString("ent_id").split(",")[i]);
                session.setEnt_id(Long.parseLong(json.getString("ent_id")));
                this.genTodaypromotion_byentid(session, json);
            }
        } else {
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            this.genTodaypromotion_byentid(session, jsonparam);
        }
        return ServiceResponse.buildSuccess((Object)"");
    }

    public ServiceResponse genTodaypromotion_byentid(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (jsonparam.containsKey((Object)"XTS")) {
            this.isXTS = true;
        }
        long starttime = System.currentTimeMillis();
        long id = UniqueID.getUniqueID();
        this.updateLogFlag(id, "N", "start init data");
        this.dodeletetodaytemp(session, jsonparam);
        this.gentodayDatas(session, jsonparam);
        long result = this.rendertodayReport(session, jsonparam);
        this.freshTodayData(session, jsonparam);
        long endtime = System.currentTimeMillis() - starttime;
        this.updateLogFlag(id, "Y", "init data success with " + result + " items in " + endtime / 1000L / 60L + " min");
        this.log("init data success with " + result + " items in " + endtime / 1000L / 60L + " min");
        XxlJobLogger.log((String)("init data success with " + result + " items in " + endtime / 1000L + " s,by ent_id:" + String.valueOf(session.getEnt_id())), (Object[])new Object[0]);
        return ServiceResponse.buildSuccess((Object)("init data success with " + result + " items in " + endtime / 1000L / 60L + " min"));
    }

    @Transactional(propagation=Propagation.REQUIRED)
    protected void dodeletetodaytemp(ServiceSession session, JSONObject json) {
        XxlJobLogger.log((String)("delete data ,start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        storage.getSqlSessionTemplate().delete("mybatis.report.delete_todaypromotionreport", (Object)json);
        this.log("delete promotion report data");
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void gentodayDatas(ServiceSession session, JSONObject json) throws Exception {
        XxlJobLogger.log((String)("insert into data ,start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        System.out.println(" genDatas single products report ");
        long start_time = 0L;
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        List over_all_list = null;
        ArrayList<Map> over_list = new ArrayList<Map>();
        ArrayList need_list = new ArrayList();
        ArrayList<Map> alllist = new ArrayList<Map>();
        JSONObject over_json = (JSONObject)json.clone();
        over_json.put("datatype", (Object)"1");
        over_all_list = storage.getSqlSessionTemplate().selectList("mybatis.report.select_maxeid", (Object)over_json);
        int rowno = 0;
        ArrayList<Map> templist = new ArrayList<Map>();
        for (Map row : over_all_list) {
            ++rowno;
            JSONObject json_row = (JSONObject)json.clone();
            ArrayList<Map> needtemplist = new ArrayList<Map>();
            needtemplist.add(row);
            json_row.put("list", needtemplist);
            json_row.put("datatype", (Object)"2");
            List list = storage.getSqlSessionTemplate().selectList("mybatis.report.select_maxeid", (Object)json_row);
            if (list != null && list.size() > 0) {
                if (rowno != over_all_list.size() || templist.size() <= 0) continue;
                json_row.put("datatype", (Object)"3");
                json_row.put("list", templist);
                List list2 = storage.getSqlSessionTemplate().selectList("mybatis.report.select_maxeid", (Object)json_row);
                templist.clear();
                need_list.addAll(list2);
                continue;
            }
            over_list.add(row);
            templist.add(row);
            if (rowno % this.exec_size != 0 && rowno != over_all_list.size()) continue;
            json_row.put("datatype", (Object)"3");
            json_row.put("list", templist);
            List list3 = storage.getSqlSessionTemplate().selectList("mybatis.report.select_maxeid", (Object)json_row);
            templist.clear();
            need_list.addAll(list3);
        }
        JSONObject valid_json = (JSONObject)json.clone();
        valid_json.put("datatype", (Object)"4");
        List valid_list1 = storage.getSqlSessionTemplate().selectList("mybatis.report.select_maxeid", (Object)valid_json);
        need_list.addAll(valid_list1);
        HashMap map = new HashMap();
        for (Map map2 : need_list) {
            String key = MapUtils.getString((Map)map2, (String)"etype").concat(",").concat(MapUtils.getString((Map)map2, (String)"org_code")).concat(",").concat(MapUtils.getString((Map)map2, (String)"cstr2"));
            if (!map.containsKey(key)) {
                map.put(key, map2.get("evt_id"));
                continue;
            }
            if (Long.parseLong(MapUtils.getString(map, (String)key)) >= Long.parseLong(MapUtils.getString((Map)map2, (String)"evt_id"))) continue;
            map.put(key, map2.get("evt_id"));
        }
        need_list.clear();
        for (String string : map.keySet()) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("etype", string.split(",")[0]);
            row.put("org_code", string.split(",")[1]);
            row.put("cstr2", string.split(",")[2]);
            row.put("evt_id", (String)map.get(string));
            need_list.add(row);
        }
        alllist.addAll(need_list);
        alllist.addAll(over_list);
        rowno = 0;
        templist.clear();
        for (Map map3 : alllist) {
            JSONObject json_row = (JSONObject)json.clone();
            templist.add(map3);
            if (++rowno % this.exec_size != 0 && rowno != alllist.size()) continue;
            json_row.put("list", templist);
            storage.getSqlSessionTemplate().update("mybatis.report.init_todaypromotion_report", (Object)json_row);
            templist.clear();
        }
    }

    private long rendertodayReport(ServiceSession session, JSONObject jsonparam) throws Exception {
        XxlJobLogger.log((String)("render data , start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        int pageno = 1;
        long rendercount = 0L;
        int pagesize = 1500;
        JSONObject param = new JSONObject();
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        ServiceResponse response = null;
        JSONArray srcgoods = new JSONArray();
        param.put("type", (Object)"good");
        param.put("fields", (Object)"distinct corp_id,mktid,itemcode");
        param.put("ent_id", jsonparam.get((Object)"ent_id"));
        long totalsize = this.getTotalNumber(storage, "mybatis.report.select_berendertodaydata", param);
        if (totalsize > 0L) {
            while (true) {
                RowBounds rowBound = new RowBounds((pageno - 1) * pagesize, pagesize);
                List event_list = storage.getSqlSessionTemplate().selectList("mybatis.report.select_berendertodaydata", (Object)param, rowBound);
                if (event_list == null || event_list.size() <= 0) break;
                this.log("initing >>:  update saleprice ->  pagesize: " + pagesize + "    totalresults: " + totalsize + " and totalpage: " + totalsize / (long)pagesize + " and current page " + pageno);
                JSONObject searchgoods = new JSONObject();
                JSONObject temp_searchgoods = new JSONObject();
                for (int i = 0; i < event_list.size(); ++i) {
                    Map row = (Map)event_list.get(i);
                    String barcode = row.get("itemcode").toString();
                    String org_code = row.get("mktid").toString();
                    String jygs = row.get("corp_id").toString();
                    if (temp_searchgoods.containsKey((Object)(jygs + "-" + org_code))) {
                        temp_searchgoods.put(jygs + "-" + org_code, (Object)(temp_searchgoods.getString(jygs + "-" + org_code) + "," + barcode));
                        continue;
                    }
                    temp_searchgoods.put(jygs + "-" + org_code, (Object)barcode);
                }
                for (String col : temp_searchgoods.keySet()) {
                    searchgoods.put("jygs", (Object)col.split("-")[0]);
                    searchgoods.put("org_code", (Object)col.split("-")[1]);
                    searchgoods.put("item_code", temp_searchgoods.get((Object)col));
                    searchgoods.put("page_size", (Object)9999);
                    response = RestClientUtils.getRestUtils().sendRequest((Object)session, "mdm.goods.searchbyall", (Object)searchgoods.toJSONString());
                    JSONObject rtn = (JSONObject)response.getData();
                    JSONArray items = rtn.getJSONArray("item_business");
                    if (items == null || items.size() == 0) continue;
                    srcgoods.addAll((Collection)items);
                }
                ++pageno;
            }
        }
        if (srcgoods != null && srcgoods.size() > 0) {
            JSONObject jsonrender = new JSONObject();
            jsonrender.put("type", (Object)"good");
            jsonrender.put("data", (Object)srcgoods);
            long uptcount = this.renderTodayArrayData(session, jsonrender);
            rendercount += uptcount;
            srcgoods.clear();
        }
        pageno = 1;
        JSONArray srccatleaf = new JSONArray();
        param.put("type", (Object)"catleaf");
        param.put("fields", (Object)"distinct catcode");
        param.put("ent_id", jsonparam.get((Object)"ent_id"));
        totalsize = this.getTotalNumber(storage, "mybatis.report.select_berendertodaydata", param);
        if (totalsize > 0L) {
            while (true) {
                RowBounds rowBound = new RowBounds((pageno - 1) * pagesize, pagesize);
                List event_list = storage.getSqlSessionTemplate().selectList("mybatis.report.select_berendertodaydata", (Object)param, rowBound);
                if (event_list == null || event_list.size() <= 0) break;
                this.log("initing >>:  update saleprice ->  pagesize: " + pagesize + "    totalresults: " + totalsize + " and totalpage: " + totalsize / (long)pagesize + " and current page " + pageno);
                JSONObject searchcatleaf = new JSONObject();
                String catcode = "";
                for (int i = 0; i < event_list.size(); ++i) {
                    Map row = (Map)event_list.get(i);
                    catcode = i == event_list.size() - 1 ? catcode + this.tranString(row.get("catcode")) : catcode + this.tranString(row.get("catcode")) + ",";
                }
                searchcatleaf.put("leaf", (Object)catcode);
                response = RestClientUtils.getRestUtils().sendRequest((Object)session, "mdm.category.searchbyleaf", (Object)searchcatleaf.toJSONString());
                if (!response.getReturncode().equals("0")) break;
                JSONObject rtn = (JSONObject)response.getData();
                JSONArray items = rtn.getJSONArray("categoryref");
                if (items == null || items.size() == 0) {
                    ++pageno;
                    break;
                }
                srccatleaf.addAll((Collection)items);
                ++pageno;
            }
        }
        if (srccatleaf != null && srccatleaf.size() > 0) {
            JSONObject jsonrender = new JSONObject();
            jsonrender.put("type", (Object)"catleaf");
            jsonrender.put("data", (Object)srccatleaf);
            if (jsonparam.containsKey((Object)"tmdd")) {
                jsonrender.put("tmdd", jsonparam.get((Object)"tmdd"));
            }
            long uptcount = this.renderTodayArrayData(session, jsonrender);
            rendercount += uptcount;
            srccatleaf.clear();
        }
        this.log("-------------------- reder report finished,totcount:" + String.valueOf(rendercount), "whatever");
        return rendercount;
    }

    private long renderTodayArrayData(ServiceSession session, JSONObject jsonparam) throws Exception {
        long totuptcount;
        block4: {
            String type;
            block3: {
                totuptcount = 0L;
                type = this.getParamWithCheck(jsonparam, "type", false, "good");
                if (!type.equals("good")) break block3;
                FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
                Criteria criteria = new Criteria();
                Object query = null;
                JSONArray items = jsonparam.getJSONArray("data");
                ArrayList<JSONObject> templist = new ArrayList<JSONObject>();
                for (int i = 0; i < items.size(); ++i) {
                    JSONObject row = items.getJSONObject(i);
                    if (!row.containsKey((Object)"org_code")) continue;
                    JSONObject upt = new JSONObject();
                    upt.put("ent_id", (Object)session.getEnt_id());
                    upt.put("corp_id", (Object)MapUtils.getString((Map)row, (String)"jygs"));
                    upt.put("mktid", (Object)MapUtils.getString((Map)row, (String)"org_code"));
                    upt.put("itemcode", (Object)MapUtils.getString((Map)row, (String)"item_code"));
                    upt.put("barcode", (Object)MapUtils.getString((Map)row, (String)"barcode"));
                    upt.put("itemname", (Object)MapUtils.getString((Map)row, (String)"item_name").replace("?", ","));
                    upt.put("catcode", (Object)MapUtils.getString((Map)row, (String)"cat_code"));
                    upt.put("brand", (Object)MapUtils.getString((Map)row, (String)"brand_code"));
                    upt.put("supid", (Object)MapUtils.getString((Map)row, (String)"vendor_id"));
                    upt.put("mfid", (Object)MapUtils.getString((Map)row, (String)"gz_code"));
                    upt.put("catcode_name", (Object)MapUtils.getString((Map)row, (String)"cat_name").replace("?", ","));
                    upt.put("brand_name", (Object)MapUtils.getString((Map)row, (String)"brand_name").replace("?", ","));
                    upt.put("supid_name", (Object)MapUtils.getString((Map)row, (String)"vendor_name").replace("?", ","));
                    upt.put("mfid_name", (Object)MapUtils.getString((Map)row, (String)"gz_name").replace("?", ","));
                    upt.put("purchase_price", (Object)(StringUtils.isEmpty((Object)row.get((Object)"purchase_price")) ? 0.0 : row.getDoubleValue("purchase_price")));
                    upt.put("unit", (Object)MapUtils.getString((Map)row, (String)"unit").replace("?", ","));
                    upt.put("spec", (Object)MapUtils.getString((Map)row, (String)"spec").replace("?", ","));
                    upt.put("saleprice", (Object)(StringUtils.isEmpty((Object)row.get((Object)"sale_price")) ? 0.0 : row.getDoubleValue("sale_price")));
                    upt.put("section", (Object)MapUtils.getString((Map)row, (String)"section").replace("?", ","));
                    upt.put("article", (Object)MapUtils.getString((Map)row, (String)"article").replace("?", ","));
                    upt.put("content", (Object)MapUtils.getString((Map)row, (String)"content").replace("?", ","));
                    upt.put("origin", (Object)MapUtils.getString((Map)row, (String)"origin").replace("?", ","));
                    templist.add(upt);
                    if ((i + 1) % this.exec_size != 0 && i + 1 != items.size()) continue;
                    JSONObject jsontemp = new JSONObject();
                    jsontemp.put("list", templist);
                    jsontemp.put("ent_id", (Object)session.getEnt_id());
                    totuptcount += (long)storage.getSqlSessionTemplate().update("mybatis.report.update_todaypromotion_bygoods", (Object)jsontemp);
                    templist.clear();
                }
                break block4;
            }
            if (!type.equals("catleaf")) break block4;
            FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
            JSONArray items = jsonparam.getJSONArray("data");
            int rowno = 0;
            ArrayList<JSONObject> templist = new ArrayList<JSONObject>();
            for (int i = 0; i < items.size(); ++i) {
                ++rowno;
                JSONObject row = items.getJSONObject(i);
                JSONObject param = new JSONObject();
                param.put("ent_id", session.getEnt_id());
                if (jsonparam.containsKey((Object)"tmdd")) {
                    param.put("tmdd", jsonparam.get((Object)"tmdd"));
                }
                param.put("catcode", MapUtils.getString((Map)row, (String)"class5_code"));
                param.put("section", MapUtils.getString((Map)row, (String)"class2_code"));
                param.put("article", MapUtils.getString((Map)row, (String)"class4_code"));
                templist.add(param);
                if (rowno % this.exec_size != 0 && rowno != items.size()) continue;
                JSONObject jsontemp = new JSONObject();
                jsontemp.put("list", templist);
                jsontemp.put("ent_id", (Object)session.getEnt_id());
                totuptcount += (long)storage.getSqlSessionTemplate().update("mybatis.report.update_todaypromotion_leaf", (Object)jsontemp);
                templist.clear();
            }
        }
        return totuptcount;
    }

    public void freshTodayData(ServiceSession session, JSONObject jsonparam) throws Exception {
        XxlJobLogger.log((String)("fresh data ,start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        JSONObject param = new JSONObject();
        param.put("ent_id", (Object)session.getEnt_id());
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        List event_list = storage.getSqlSessionTemplate().selectList("mybatis.report.select_todaypopmemo", (Object)param);
        if (event_list == null || event_list.size() <= 0) {
            return;
        }
        for (int i = 0; i < event_list.size(); ++i) {
            String col;
            String[] cols;
            String[] popmemo_arr;
            String fdmode = "";
            double popzkfd = 0.0;
            String fdresult = "";
            Map row = (Map)event_list.get(i);
            if (StringUtils.isEmpty(row.get("popmemo"))) continue;
            String popmemo = row.get("popmemo").toString();
            String[] stringArray = popmemo_arr = popmemo.split(",");
            int n = stringArray.length;
            for (int j = 0; j < n && (cols = (col = stringArray[j]).split("[:]")).length >= 2; ++j) {
                if (cols[0].equals("fdmode")) {
                    fdmode = cols[1];
                    continue;
                }
                if (cols[0].equals("popzkfd")) {
                    popzkfd = Double.parseDouble(cols[1]);
                    continue;
                }
                if (!cols[0].equals("fdresult") || !(fdresult = cols[1]).equals("null")) continue;
                fdresult = "";
            }
            if (fdmode.equals("")) continue;
            param.put("popmemo", (Object)popmemo);
            param.put("fdmode", (Object)fdmode);
            param.put("popzkfd", (Object)popzkfd);
            if (!fdresult.equals("")) {
                param.put("fdresult", (Object)fdresult);
            }
            storage.getSqlSessionTemplate().update("mybatis.report.update_todaypromotion_popmemo", (Object)param);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public ServiceResponse genPromotionreport(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"{0} is NULL ", (Object[])new Object[]{"session"});
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"{0} is NULL ", (Object[])new Object[]{"param"});
        }
        if (!(jsonparam instanceof JSONObject)) {
            throw new ServiceException("50005", "{0} is not JSONObject ", new Object[]{"param in"});
        }
        if (!jsonparam.containsKey((Object)"execute")) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"{0} is NULL ", (Object[])new Object[]{"execute"});
        }
        if (jsonparam.containsKey((Object)"ent_id")) {
            JSONObject json = (JSONObject)jsonparam.clone();
            json.remove((Object)"ent_id");
            for (int i = 0; i < jsonparam.getString("ent_id").split(",").length; ++i) {
                json.put("ent_id", (Object)jsonparam.getString("ent_id").split(",")[i]);
                session.setEnt_id(Long.parseLong(json.getString("ent_id")));
                this.genPromotionreport_byentid(session, json);
            }
        } else {
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            this.genPromotionreport_byentid(session, jsonparam);
        }
        return ServiceResponse.buildSuccess((Object)"");
    }

    public ServiceResponse genPromotionreport_byentid(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (jsonparam.containsKey((Object)"XTS")) {
            this.isXTS = true;
        }
        long starttime = System.currentTimeMillis();
        long id = UniqueID.getUniqueID();
        this.updateLogFlag(id, "N", "start init data");
        long tmdd = 0L;
        if (!this.getParamWithCheck(jsonparam, "execute", false, "").equals("init")) {
            tmdd = jsonparam.containsKey((Object)"tmdd") ? jsonparam.getLong("tmdd").longValue() : this.getTmdd(session.getEnt_id(), "promotionreport");
        }
        this.setTmdd(session.getEnt_id(), "promotionreport");
        JSONObject json = (JSONObject)jsonparam.clone();
        json.put("tmdd", (Object)tmdd);
        if (!"onlyrender".equals(this.getParamWithCheck(jsonparam, "execute", false, ""))) {
            this.dodeletetemp(session, json);
            this.genDatas(session, json);
        }
        long result = this.renderReport(session, json);
        this.freshData(session, json);
        long endtime = System.currentTimeMillis() - starttime;
        this.updateLogFlag(id, "Y", "init data success with " + result + " items in " + endtime / 1000L / 60L + " min");
        this.log("init data success with " + result + " items in " + endtime / 1000L / 60L + " min");
        XxlJobLogger.log((String)("init data success with " + result + " items in " + endtime / 1000L + " s,by ent_id:" + String.valueOf(session.getEnt_id())), (Object[])new Object[0]);
        return ServiceResponse.buildSuccess((Object)("init data success with " + result + " items in " + endtime / 1000L / 60L + " min"));
    }

    @Transactional(propagation=Propagation.REQUIRED)
    protected void dodeletetemp(ServiceSession session, JSONObject json) {
        XxlJobLogger.log((String)("delete data ,start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        int size = storage.getSqlSessionTemplate().delete("mybatis.report.delete_promotionreport", (Object)json);
        XxlJobLogger.log((String)("delete promotion report data: " + size), (Object[])new Object[0]);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void genDatas(ServiceSession session, JSONObject json) {
        XxlJobLogger.log((String)("insert into data ,start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        System.out.println(" genDatas single products report ");
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        int size = storage.getSqlSessionTemplate().update("mybatis.report.init_promotion_report", (Object)json);
        XxlJobLogger.log((String)("insert promotion report data: " + size), (Object[])new Object[0]);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    private long renderReport(ServiceSession session, JSONObject jsonparam) throws Exception {
        XxlJobLogger.log((String)("render data , start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        int pageno = 1;
        long rendercount = 0L;
        int pagesize = 1500;
        int mdmpsize = 1500;
        JSONArray srcgoods = new JSONArray();
        JSONObject param = new JSONObject();
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        ServiceResponse response = null;
        if (jsonparam.containsKey((Object)"page_size")) {
            mdmpsize = pagesize = jsonparam.getInteger("page_size").intValue();
        }
        if (jsonparam.containsKey((Object)"mdmp_size")) {
            mdmpsize = jsonparam.getInteger("mdmp_size");
        }
        param.put("fields", (Object)"distinct corp_id,mktid,itemcode");
        param.put("ent_id", jsonparam.get((Object)"ent_id"));
        param.put("tmdd", jsonparam.get((Object)"tmdd"));
        if (jsonparam.containsKey((Object)"org_code")) {
            param.put("mktid", jsonparam.get((Object)"org_code"));
        }
        long totalsize = this.getTotalNumber(storage, "mybatis.report.select_berenderdata", param);
        XxlJobLogger.log((String)("render data , totalsize: " + totalsize), (Object[])new Object[0]);
        if (totalsize > 0L) {
            long start_times = System.currentTimeMillis();
            XxlJobLogger.log((String)("query mdm , start times:" + String.valueOf(start_times)), (Object[])new Object[0]);
            while (true) {
                RowBounds rowBound = new RowBounds((pageno - 1) * pagesize, pagesize);
                List event_list = storage.getSqlSessionTemplate().selectList("mybatis.report.select_berenderdata", (Object)param, rowBound);
                if (event_list == null || event_list.size() <= 0) break;
                this.log("initing >>:  update saleprice ->  pagesize: " + pagesize + "    totalresults: " + totalsize + " and totalpage: " + totalsize / (long)pagesize + " and current page " + pageno);
                JSONObject searchgoods = new JSONObject();
                JSONObject temp_searchgoods = new JSONObject();
                JSONObject cnum_searchgoods = new JSONObject();
                for (int i = 0; i < event_list.size(); ++i) {
                    Map row = (Map)event_list.get(i);
                    String barcode = row.get("itemcode").toString();
                    String org_code = row.get("mktid").toString();
                    String jygs = row.get("corp_id").toString();
                    String key = jygs + "-" + org_code;
                    if (temp_searchgoods.containsKey((Object)key)) {
                        temp_searchgoods.put(key, (Object)(temp_searchgoods.getString(key) + "," + barcode));
                        cnum_searchgoods.put(key, (Object)(cnum_searchgoods.getInteger(key) + 1));
                        continue;
                    }
                    temp_searchgoods.put(key, (Object)barcode);
                    cnum_searchgoods.put(key, (Object)1);
                }
                for (String col : temp_searchgoods.keySet()) {
                    searchgoods.put("jygs", (Object)col.split("-")[0]);
                    searchgoods.put("org_code", (Object)col.split("-")[1]);
                    searchgoods.put("item_code", temp_searchgoods.get((Object)col));
                    searchgoods.put("page_size", (Object)mdmpsize);
                    int item_count = 0;
                    int page_no = 0;
                    do {
                        searchgoods.put("page_no", (Object)(++page_no));
                        response = RestClientUtils.getRestUtils().sendRequest((Object)session, "mdm.goods.searchbyall", (Object)searchgoods.toJSONString());
                        JSONObject rtn = (JSONObject)response.getData();
                        JSONArray items = rtn.getJSONArray("item_business");
                        if (items == null || items.size() == 0) break;
                        srcgoods.addAll((Collection)items);
                        item_count += items.size();
                    } while (page_no < 5);
                    if (!jsonparam.containsKey((Object)"debug_log")) continue;
                    XxlJobLogger.log((String)"query mdm , jygs: {} , org_code: {} , itemcount: {}, mdmcount: {}", (Object[])new Object[]{searchgoods.get((Object)"jygs"), searchgoods.get((Object)"org_code"), cnum_searchgoods.get((Object)col), item_count});
                }
                ++pageno;
            }
            start_times = System.currentTimeMillis() - start_times;
            XxlJobLogger.log((String)("query mdm , ends  times: " + String.valueOf(System.currentTimeMillis()) + ", elapsed: " + start_times), (Object[])new Object[0]);
        }
        if (srcgoods != null && srcgoods.size() > 0) {
            JSONObject jsonrender = new JSONObject();
            jsonrender.put("type", (Object)"good");
            jsonrender.put("data", (Object)srcgoods);
            if (jsonparam.containsKey((Object)"batch_mode_rows")) {
                jsonrender.put("batch_mode_rows", jsonparam.get((Object)"batch_mode_rows"));
            }
            if (jsonparam.containsKey((Object)"debug_log")) {
                jsonrender.put("debug_log", jsonparam.get((Object)"debug_log"));
            }
            long uptcount = this.renderArrayData(session, jsonrender);
            rendercount += uptcount;
            srcgoods.clear();
        }
        this.log("-------------------- reder report finished,totcount:" + String.valueOf(rendercount), "whatever");
        return rendercount;
    }

    private long renderArrayData(ServiceSession session, JSONObject jsonparam) throws Exception {
        long totuptcount = 0L;
        String type = this.getParamWithCheck(jsonparam, "type", false, "good");
        if (type.equals("good")) {
            FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
            JSONArray items = jsonparam.getJSONArray("data");
            long start_time = System.currentTimeMillis();
            XxlJobLogger.log((String)("render goods start times: " + String.valueOf(start_time) + ", size: " + items.size()), (Object[])new Object[0]);
            if (jsonparam.containsKey((Object)"batch_mode_rows") && jsonparam.getInteger("batch_mode_rows") > 0) {
                int rows = jsonparam.getInteger("batch_mode_rows");
                int i = 0;
                while (i < items.size()) {
                    ArrayList list = new ArrayList();
                    String jygs = "";
                    String mktid = "";
                    for (int j = 0; j < rows && i < items.size(); ++j, ++i) {
                        JSONObject row = items.getJSONObject(i);
                        if (!StringUtils.isEmpty((Object)jygs) && !jygs.equals(row.getString("jygs")) || !StringUtils.isEmpty((Object)mktid) && !mktid.equals(row.getString("org_code"))) break;
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("itemname", row.get((Object)"item_name"));
                        map.put("catcode", row.get((Object)"cat_code"));
                        map.put("brand", row.get((Object)"brand_code"));
                        map.put("supid", row.get((Object)"vendor_id"));
                        map.put("mfid", row.get((Object)"gz_code"));
                        map.put("catcode_name", row.get((Object)"cat_name"));
                        map.put("brand_name", row.get((Object)"brand_name"));
                        map.put("supid_name", row.get((Object)"vendor_name"));
                        map.put("mfid_name", row.get((Object)"gz_name"));
                        map.put("purchase_price", StringUtils.isEmpty((Object)row.get((Object)"purchase_price")) ? 0.0 : row.getDoubleValue("purchase_price"));
                        map.put("unit", row.get((Object)"unit"));
                        map.put("spec", row.get((Object)"spec"));
                        map.put("saleprice", StringUtils.isEmpty((Object)row.get((Object)"sale_price")) ? 0.0 : row.getDoubleValue("sale_price"));
                        if (!StringUtils.isEmpty((Object)row.get((Object)"content"))) {
                            map.put("content", row.get((Object)"content"));
                        }
                        if (!StringUtils.isEmpty((Object)row.get((Object)"origin"))) {
                            map.put("origin", row.get((Object)"origin"));
                        }
                        jygs = row.getString("jygs");
                        if (row.containsKey((Object)"org_code")) {
                            mktid = row.getString("org_code");
                        }
                        map.put("itemcode", row.getString("item_code"));
                        map.put("barcode", row.getString("barcode"));
                        list.add(map);
                    }
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("ent_id", session.getEnt_id());
                    if (!StringUtils.isEmpty((Object)jygs)) {
                        param.put("corp_id", jygs);
                    }
                    if (!StringUtils.isEmpty((Object)mktid)) {
                        param.put("mktid", mktid);
                    }
                    long tm = System.currentTimeMillis();
                    param.put("list", list);
                    int uptcount = storage.getSqlSessionTemplate().update("mybatis.report.update_promotionreport_goodsrender", param);
                    totuptcount += (long)uptcount;
                    if (!jsonparam.containsKey((Object)"debug_log")) continue;
                    tm = System.currentTimeMillis() - tm;
                    XxlJobLogger.log((String)"render goods batch jygs: {}, org_code: {} count: {}, total: {}, elapsed: {}", (Object[])new Object[]{jygs, mktid, uptcount, totuptcount, tm});
                }
            } else {
                Criteria criteria = new Criteria();
                Query query = null;
                for (int i = 0; i < items.size(); ++i) {
                    JSONObject row = items.getJSONObject(i);
                    if (!row.containsKey((Object)"org_code")) continue;
                    criteria = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("corp_id").is((Object)row.getString("jygs")).and("itemcode").is((Object)row.getString("item_code")).and("itemname").is((Object)"");
                    if (row.containsKey((Object)"org_code")) {
                        criteria.and("mktid").is((Object)row.getString("org_code"));
                    }
                    query = new Query((CriteriaDefinition)criteria);
                    Update upt = new Update();
                    upt.set("itemname", row.get((Object)"item_name"));
                    upt.set("catcode", row.get((Object)"cat_code"));
                    upt.set("brand", row.get((Object)"brand_code"));
                    upt.set("supid", row.get((Object)"vendor_id"));
                    upt.set("mfid", row.get((Object)"gz_code"));
                    upt.set("catcode_name", row.get((Object)"cat_name"));
                    upt.set("brand_name", row.get((Object)"brand_name"));
                    upt.set("supid_name", row.get((Object)"vendor_name"));
                    upt.set("mfid_name", row.get((Object)"gz_name"));
                    upt.set("purchase_price", (Object)(StringUtils.isEmpty((Object)row.get((Object)"purchase_price")) ? 0.0 : row.getDoubleValue("purchase_price")));
                    upt.set("unit", row.get((Object)"unit"));
                    upt.set("spec", row.get((Object)"spec"));
                    upt.set("saleprice", (Object)(StringUtils.isEmpty((Object)row.get((Object)"sale_price")) ? 0.0 : row.getDoubleValue("sale_price")));
                    if (!StringUtils.isEmpty((Object)row.get((Object)"content"))) {
                        upt.set("content", row.get((Object)"content"));
                    }
                    if (!StringUtils.isEmpty((Object)row.get((Object)"origin"))) {
                        upt.set("origin", row.get((Object)"origin"));
                    }
                    int uptcount = storage.update(query, upt, PromotionReportBean.class);
                    totuptcount += (long)uptcount;
                    if (uptcount > 0) continue;
                    criteria = Criteria.where((String)"ent_id").is((Object)session.getEnt_id()).and("corp_id").is((Object)row.getString("jygs")).and("barcode").is((Object)row.getString("barcode")).and("itemname").is((Object)"");
                    if (row.containsKey((Object)"org_code")) {
                        criteria.and("mktid").is((Object)row.getString("org_code"));
                    }
                    query = new Query((CriteriaDefinition)criteria);
                    uptcount = storage.update(query, upt, PromotionReportBean.class);
                    totuptcount += (long)uptcount;
                }
            }
            start_time = System.currentTimeMillis() - start_time;
            XxlJobLogger.log((String)("render goods ends  times: " + String.valueOf(System.currentTimeMillis()) + ", count: " + totuptcount + ", elapsed: " + String.valueOf(start_time)), (Object[])new Object[0]);
        }
        return totuptcount;
    }

    public void freshData(ServiceSession session, JSONObject jsonparam) throws Exception {
        XxlJobLogger.log((String)("fresh data ,start times:" + String.valueOf(System.currentTimeMillis())), (Object[])new Object[0]);
        JSONObject param = new JSONObject();
        param.put("ent_id", (Object)session.getEnt_id());
        param.put("tmdd", jsonparam.get((Object)"tmdd"));
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        List event_list = storage.getSqlSessionTemplate().selectList("mybatis.report.select_popmemo", (Object)param);
        if (event_list == null || event_list.size() <= 0) {
            return;
        }
        long start_time = System.currentTimeMillis();
        XxlJobLogger.log((String)"fresh data ,start times: {}, size: {}", (Object[])new Object[]{start_time, event_list.size()});
        long totuptcount = 0L;
        int rows = 100;
        if (jsonparam.containsKey((Object)"batch_mode_rows") && jsonparam.getInteger("batch_mode_rows") > 0) {
            rows = jsonparam.getInteger("batch_mode_rows");
        }
        int i = 0;
        while (i < event_list.size()) {
            ArrayList list = new ArrayList();
            for (int j = 0; j < rows && i < event_list.size(); ++j, ++i) {
                String col;
                String[] cols;
                String[] popmemo_arr;
                String fdmode = "";
                double popzkfd = 0.0;
                String fdresult = "";
                Map row = (Map)event_list.get(i);
                if (StringUtils.isEmpty(row.get("popmemo"))) continue;
                String popmemo = row.get("popmemo").toString();
                String[] stringArray = popmemo_arr = popmemo.split(",");
                int n = stringArray.length;
                for (int k = 0; k < n && (cols = (col = stringArray[k]).split("[:]")).length >= 2; ++k) {
                    if (cols[0].equals("fdmode")) {
                        fdmode = cols[1];
                        continue;
                    }
                    if (cols[0].equals("popzkfd")) {
                        popzkfd = Double.parseDouble(cols[1]);
                        continue;
                    }
                    if (!cols[0].equals("fdresult") || !(fdresult = cols[1]).equals("null")) continue;
                    fdresult = "";
                }
                if (fdmode.equals("")) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("popmemo", popmemo);
                map.put("fdmode", fdmode);
                map.put("popzkfd", popzkfd);
                if (!fdresult.equals("")) {
                    map.put("fdresult", fdresult);
                }
                list.add(map);
            }
            if (list.size() <= 0) continue;
            long tm = System.currentTimeMillis();
            param.put("list", list);
            int uptcount = storage.getSqlSessionTemplate().update("mybatis.report.update_promotionreport_popmemo", (Object)param);
            totuptcount += (long)uptcount;
            if (!jsonparam.containsKey((Object)"debug_log")) continue;
            tm = System.currentTimeMillis() - tm;
            XxlJobLogger.log((String)"fresh data ,batch count: {}, total: {}, elapsed: {}", (Object[])new Object[]{uptcount, totuptcount, tm});
        }
        start_time = System.currentTimeMillis() - start_time;
        XxlJobLogger.log((String)("fresh data ,ends  times: " + String.valueOf(System.currentTimeMillis()) + ", count: " + totuptcount + ", elapsed: " + String.valueOf(start_time)), (Object[])new Object[0]);
    }

    @Override
    public ServiceResponse ClearReportData(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"{0} is NULL ", (Object[])new Object[]{"session"});
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"{0} is NULL ", (Object[])new Object[]{"param"});
        }
        if (!(jsonparam instanceof JSONObject)) {
            throw new ServiceException("50005", "{0}  is not  JSONObject ", new Object[]{"param in"});
        }
        if (!jsonparam.containsKey((Object)"tablename")) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"{0} is NULL ", (Object[])new Object[]{"tablename"});
        }
        if (jsonparam.containsKey((Object)"ent_id")) {
            JSONObject json = (JSONObject)jsonparam.clone();
            json.remove((Object)"ent_id");
            for (int i = 0; i < jsonparam.getString("ent_id").split(",").length; ++i) {
                json.put("ent_id", (Object)jsonparam.getString("ent_id").split(",")[i]);
                session.setEnt_id(Long.parseLong(json.getString("ent_id")));
                this.clearModelReport_byentid(session, json);
            }
        } else {
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            this.clearModelReport_byentid(session, jsonparam);
        }
        return ServiceResponse.buildSuccess((Object)"");
    }

    public ServiceResponse clearModelReport_byentid(ServiceSession session, JSONObject jsonparam) throws Exception {
        String[] tablenames;
        String tablename = this.getParamWithCheck(jsonparam, "tablename", true, "");
        int days = this.getParamWithCheck(jsonparam, "report_days", true, 30);
        JSONObject json = new JSONObject();
        json.put("ent_id", (Object)session.getEnt_id());
        json.put("days", (Object)days);
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        for (String name : tablenames = tablename.split(",")) {
            json.put("tablename", (Object)name);
            int count = storage.getSqlSessionTemplate().delete("mybatis.report.delete_reportdata_bydays", (Object)json);
            this.log("delete promotion report data,table:" + name + ",count:" + String.valueOf(count));
        }
        return ServiceResponse.buildSuccess((Object)"");
    }

    private long getTotalNumber(FMybatisTemplate storage, String queryid, JSONObject jsonparam) {
        JSONObject paramTotal = (JSONObject)jsonparam.clone();
        paramTotal.put("total", (Object)"gettoal");
        Map manapara = (Map)storage.getSqlSessionTemplate().selectOne(queryid, (Object)paramTotal);
        String stotal = manapara == null || manapara.get("total") == null || StringUtils.isEmpty(manapara.get("total")) ? "0" : manapara.get("total").toString();
        long totalsize = 0L;
        XxlJobLogger.log((String)("queryid: " + queryid + ",getTotalNumber :" + JSON.toJSONString((Object)manapara)), (Object[])new Object[0]);
        if (!StringUtils.isEmpty((Object)stotal)) {
            totalsize = Long.parseLong(stotal);
        }
        return totalsize;
    }

    private String tranString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private double tranDouble(Object obj) {
        return obj == null ? 0.0 : Double.parseDouble(obj.toString());
    }

    private long tranLong(Object obj) {
        return obj == null ? 0L : Long.parseLong(obj.toString());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    protected void updateLogFlag(double id, String flag, String result) {
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        param.put("opflag", flag);
        param.put("opresult", result);
        storage.getSqlSessionTemplate().update("mybatis.report.insert_report_flag", param);
    }

    public Set<BeanField> getTableFields(String tableName) {
        if (this.CACHE_FIELD.containsKey(tableName)) {
            return this.CACHE_FIELD.get(tableName);
        }
        FMybatisTemplate fso = (FMybatisTemplate)this.getStorageOperationConfig("StorageOperation");
        List list_cols = fso.getSqlSessionTemplate().selectList("mybatis.sql.findFieldByTableName", (Object)tableName);
        TreeSet<BeanField> beanFields = new TreeSet<BeanField>();
        int i = 0;
        for (Map col : list_cols) {
            BeanField bf = new BeanField();
            bf.setColID(i++);
            bf.setColName(MapUtils.getString((Map)col, (String)"column_name"));
            bf.setColType(this.batchInsService.convertToColType(fso.getDBType(), MapUtils.getString((Map)col, (String)"data_type")));
            beanFields.add(bf);
        }
        this.CACHE_FIELD.put(tableName, beanFields);
        return beanFields;
    }
}

