/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omp.event.model.component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.biz.entity.OrganizationBean;
import com.efuture.ocp.biz.utils.MdmUtils;
import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.BatchInsService;
import com.efuture.ocp.common.util.BeanField;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.DateUtils;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omp.event.model.entity.EvtMainBean;
import com.efuture.omp.event.model.intf.ModelReportService;
import com.google.common.collect.Lists;
import com.xxl.job.core.log.XxlJobLogger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component(value="omp.event.model.report.new")
public class ReportServiceNewImpl
extends BasicComponentService<EvtMainBean>
implements ModelReportService {
    int pagesize = 2000;
    int ent_id = 0;
    int exec_size = 500;
    private static ExecutorService executor = Executors.newFixedThreadPool(20);
    private BatchInsService batchInsService = new BatchInsService();
    private ConcurrentHashMap<String, Set<BeanField>> CACHE_FIELD = new ConcurrentHashMap();
    DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static ReportServiceNewImpl getInstance() {
        return (ReportServiceNewImpl)SpringBeanFactory.getBean((String)"omp.event.model.report.new", ReportServiceNewImpl.class);
    }

    private void log(String msg) {
        this.log(msg, null);
    }

    private void log(String msg, String type) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sdate = sdf.format(new Date());
        if (!StringUtils.isEmpty((Object)type)) {
            return;
        }
        this.getLogger().info((Object)(sdate + "--------------------xts info---------------" + msg));
    }

    public void setTmdd(long ent_id, String tablename) throws Exception {
        JSONObject json = new JSONObject();
        json.put("ent_id", (Object)ent_id);
        json.put("tablename", (Object)tablename);
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        int count = storage.getSqlSessionTemplate().update("mybatis.report.uptTmdd", (Object)json);
        if (count <= 0) {
            storage.getSqlSessionTemplate().update("mybatis.report.insertTmdd", (Object)json);
        }
    }

    public long getTmdd(long ent_id, String tablename) throws Exception {
        JSONObject json = new JSONObject();
        json.put("ent_id", (Object)ent_id);
        json.put("tablename", (Object)tablename);
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        Map manapara = (Map)storage.getSqlSessionTemplate().selectOne("mybatis.report.select_tmdd", (Object)json);
        return MapUtils.getLongValue((Map)manapara, (String)"tmdd", (long)0L);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    protected void updateLogFlag(double id, String flag, String result) {
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        param.put("opflag", flag);
        param.put("opresult", result);
        storage.getSqlSessionTemplate().update("mybatis.report.insert_report_flag", param);
    }

    protected String convertList2String(List<Long> seq_list) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (Long key : seq_list) {
            sb.append(key + ",");
        }
        sb.setLength(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    private String getPopMemoVal(String popMemo, String key) {
        String[] popMemoArr;
        if (StringUtils.isEmpty((Object)popMemo) || StringUtils.isEmpty((Object)key)) {
            return null;
        }
        for (String kv : popMemoArr = popMemo.split(",")) {
            String[] keyVal = kv.split(":");
            if (!key.equalsIgnoreCase(keyVal[0])) continue;
            return keyVal[1];
        }
        return null;
    }

    public Set<BeanField> getTableFields(String tableName) {
        if (this.CACHE_FIELD.containsKey(tableName)) {
            return this.CACHE_FIELD.get(tableName);
        }
        FMybatisTemplate fso = null;
        fso = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        TreeSet<BeanField> beanFields = new TreeSet<BeanField>();
        List list_cols = fso.getSqlSessionTemplate().selectList("mybatis.sql.findFieldByTableName", (Object)tableName);
        int i = 0;
        for (Map col : list_cols) {
            BeanField bf = new BeanField();
            bf.setColID(i++);
            bf.setColName(MapUtils.getString((Map)col, (String)"column_name"));
            bf.setColType(this.batchInsService.convertToColType(fso.getDBType(), MapUtils.getString((Map)col, (String)"data_type")));
            beanFields.add(bf);
        }
        this.CACHE_FIELD.put(tableName, beanFields);
        return beanFields;
    }

    private static Integer countStep(Integer size, Integer maxNum) {
        return (size + maxNum - 1) / maxNum;
    }

    @Override
    public ServiceResponse ClearReportData(ServiceSession session, JSONObject jsonparam) {
        return null;
    }

    @Override
    public ServiceResponse genTodaypromotion(ServiceSession session, JSONObject jsonparam) {
        try {
            if (jsonparam.containsKey((Object)"ent_id")) {
                String[] ent_list = DataUtils.getJsonData((JSONObject)jsonparam, (String)"ent_id", (boolean)false, (String)"").split(",");
                JSONObject json = (JSONObject)jsonparam.clone();
                json.remove((Object)"ent_id");
                for (int i = 0; i < ent_list.length; ++i) {
                    json.put("ent_id", (Object)ent_list[i]);
                    session.setEnt_id(DataUtils.getJsonData((JSONObject)json, (String)"ent_id", (boolean)true, (long)0L));
                    this.genTodaypromotion_byentid(session, json);
                }
            } else {
                jsonparam.put("ent_id", (Object)session.getEnt_id());
                this.genTodaypromotion_byentid(session, jsonparam);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XxlJobLogger.log((String)("genTodaypromotion Exception: " + ex.getMessage()), (Object[])new Object[0]);
        }
        return ServiceResponse.buildSuccess((Object)"");
    }

    public void genTodaypromotion_byentid(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (!jsonparam.containsKey((Object)"curdate")) {
            jsonparam.put("curdate", (Object)DateUtils.getTodayStr());
        }
        jsonparam.put("revdate", (Object)DateUtils.addDays((Date)jsonparam.getDate("curdate"), (int)-2));
        if (!jsonparam.containsKey((Object)"mktid")) {
            List list_orgs = MdmUtils.getMarketList((ServiceSession)session);
            for (OrganizationBean org : list_orgs) {
                if (org.getCode().equalsIgnoreCase("0000")) continue;
                jsonparam.put("mktid", (Object)org.getCode());
                this.genTodaypromotion_core(session, (JSONObject)jsonparam.clone());
            }
        } else {
            this.genTodaypromotion_core(session, jsonparam);
        }
    }

    public void genTodaypromotion_core(ServiceSession session, JSONObject jsonparam) throws Exception {
        long start_time = System.currentTimeMillis();
        String mktid = DataUtils.getJsonData((JSONObject)jsonparam, (String)"mktid", (boolean)false, (String)"");
        this.dodeletetodaytemp(session, mktid, jsonparam);
        List<Map<String, Object>> dataList = this.gentodayDatas(session, mktid, jsonparam);
        if (dataList != null && dataList.size() > 0) {
            dataList = this.rendertodayReport(session, mktid, dataList);
            this.insertTodayReport(dataList);
        }
        XxlJobLogger.log((String)"\u751f\u6210\u6570\u636e\u5b8c\u6210\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, dataList.size(), System.currentTimeMillis() - start_time});
    }

    private int insertTodayReport(List<Map<String, Object>> dataList) throws Exception {
        Set<BeanField> beanFields = this.getTableFields("todaypromotion_batch");
        this.batchInsService.batchInsert((FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class), beanFields, dataList, "todaypromotion_batch", 1000);
        return dataList.size();
    }

    @Transactional(propagation=Propagation.REQUIRED)
    protected void dodeletetodaytemp(ServiceSession session, String mktid, JSONObject json) throws Exception {
        long start_time = System.currentTimeMillis();
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        int rows = storage.getSqlSessionTemplate().delete("mybatis.report.gen.delete_todaypromotionreport", (Object)json);
        XxlJobLogger.log((String)"\u5220\u9664\u8bb0\u5f55\u5b8c\u6210\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, rows, System.currentTimeMillis() - start_time});
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<Map<String, Object>> gentodayDatas(ServiceSession session, String mktid, JSONObject json) throws Exception {
        long start_time = System.currentTimeMillis();
        FMybatisTemplate storage = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        List over_all_list = null;
        ArrayList<Map> over_list = new ArrayList<Map>();
        ArrayList need_list = new ArrayList();
        ArrayList<Map> alllist = new ArrayList<Map>();
        JSONObject over_json = (JSONObject)json.clone();
        over_json.put("datatype", (Object)"1");
        over_all_list = storage.getSqlSessionTemplate().selectList("mybatis.report.gen.select_maxeid", (Object)over_json);
        int rowno = 0;
        ArrayList templist = new ArrayList();
        for (Map row : over_all_list) {
            ++rowno;
            JSONObject json_row = (JSONObject)json.clone();
            ArrayList<Map> needtemplist = new ArrayList<Map>();
            needtemplist.add(row);
            json_row.put("list", needtemplist);
            json_row.put("datatype", (Object)"2");
            Object valid_list = storage.getSqlSessionTemplate().selectList("mybatis.report.gen.select_maxeid", (Object)json_row);
            if (valid_list != null && valid_list.size() > 0) {
                if (rowno != over_all_list.size() || templist.size() <= 0) continue;
                json_row.put("datatype", (Object)"3");
                json_row.put("list", templist);
                valid_list = storage.getSqlSessionTemplate().selectList("mybatis.report.gen.select_maxeid", (Object)json_row);
                templist.clear();
                need_list.addAll(valid_list);
                continue;
            }
            over_list.add(row);
            templist.add(row);
            if (rowno % this.exec_size != 0 && rowno != over_all_list.size()) continue;
            json_row.put("datatype", (Object)"3");
            json_row.put("list", templist);
            valid_list = storage.getSqlSessionTemplate().selectList("mybatis.report.gen.select_maxeid", (Object)json_row);
            templist.clear();
            need_list.addAll(valid_list);
        }
        JSONObject valid_json = (JSONObject)json.clone();
        valid_json.put("datatype", (Object)"4");
        List valid_list1 = storage.getSqlSessionTemplate().selectList("mybatis.report.gen.select_maxeid", (Object)valid_json);
        need_list.addAll(valid_list1);
        HashMap<String, Long> map_evt = new HashMap<String, Long>();
        HashMap<String, Long> map_seq = new HashMap<String, Long>();
        for (Map map : need_list) {
            String key = MapUtils.getString((Map)map, (String)"etype").concat(",").concat(MapUtils.getString((Map)map, (String)"org_code")).concat(",").concat(MapUtils.getString((Map)map, (String)"cstr2"));
            if (!map_evt.containsKey(key)) {
                map_evt.put(key, MapUtils.getLongValue((Map)map, (String)"evt_id"));
                map_seq.put(key, MapUtils.getLongValue((Map)map, (String)"seqno"));
                continue;
            }
            if (Long.parseLong(MapUtils.getString(map_evt, (String)key)) >= Long.parseLong(MapUtils.getString((Map)map, (String)"evt_id"))) continue;
            map_evt.put(key, MapUtils.getLongValue((Map)map, (String)"evt_id"));
            map_seq.put(key, MapUtils.getLongValue((Map)map, (String)"seqno"));
        }
        need_list.clear();
        for (String string : map_evt.keySet()) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("etype", string.split(",")[0]);
            row.put("org_code", string.split(",")[1]);
            row.put("cstr2", string.split(",")[2]);
            row.put("evt_id", (String)map_evt.get(string));
            row.put("seqno", (String)map_seq.get(string));
            need_list.add(row);
        }
        alllist.addAll(need_list);
        alllist.addAll(over_list);
        XxlJobLogger.log((String)"\u67e5\u627e\u4e3b\u952e\u5b8c\u6bd5\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, alllist.size(), System.currentTimeMillis() - start_time});
        start_time = System.currentTimeMillis();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int i = 0;
        while (i < alllist.size()) {
            arrayList.clear();
            templist.clear();
            for (int n = 0; n < 1000 && i < alllist.size(); ++n, ++i) {
                arrayList.add(MapUtils.getLongValue((Map)((Map)alllist.get(i)), (String)"seqno"));
                templist.add(alllist.get(i));
            }
            JSONObject json_row = (JSONObject)json.clone();
            json_row.put("seqstr", (Object)this.convertList2String(arrayList));
            json_row.put("list", templist);
            result.addAll(storage.getSqlSessionTemplate().selectList("mybatis.report.gen.get_todaypromotion_report", (Object)json_row));
        }
        XxlJobLogger.log((String)"\u68c0\u7d22\u6570\u636e\u5b8c\u6bd5\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, result.size(), System.currentTimeMillis() - start_time});
        return result;
    }

    private List<Map<String, Object>> rendertodayReport(ServiceSession session, String mktid, List<Map<String, Object>> dataList) throws Exception {
        long start_time = System.currentTimeMillis();
        int maxNum = 1000;
        AtomicInteger renderRows = new AtomicInteger();
        HashSet setItem = new HashSet();
        HashSet setCate = new HashSet();
        ArrayList listItem = new ArrayList();
        ArrayList listCate = new ArrayList();
        dataList.stream().forEach(map -> setItem.add(MapUtils.getString((Map)map, (String)"itemcode")));
        XxlJobLogger.log((String)"\u5546\u54c1\u53bb\u91cd\u7f16\u7801\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, setItem.size(), System.currentTimeMillis() - start_time});
        start_time = System.currentTimeMillis();
        if (setItem.size() > 0) {
            List setItemPages = Lists.partition(new ArrayList(setItem), (int)maxNum);
            setItemPages.forEach(list -> {
                try {
                    String itemList = list.stream().collect(Collectors.joining(","));
                    listItem.addAll(MdmUtils.getGoodsMframeByAll((ServiceSession)session, (String)mktid, (String)itemList));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            setItemPages = null;
        }
        XxlJobLogger.log((String)"\u83b7\u53d6\u5546\u54c1\u5b57\u5178\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, listItem.size(), System.currentTimeMillis() - start_time});
        start_time = System.currentTimeMillis();
        renderRows.set(0);
        listItem.stream().forEach(bean -> dataList.stream().filter(map -> MapUtils.getString((Map)map, (String)"itemcode").equalsIgnoreCase(bean.getItem_code())).forEach(map -> {
            map.put("barcode", bean.getBarcode());
            map.put("itemname", bean.getItem_name());
            map.put("catcode", bean.getCat_code());
            map.put("catcode_name", bean.getCat_name());
            map.put("brand", bean.getBrand_code());
            map.put("brand_name", bean.getBrand_name());
            map.put("supid", bean.getVendor_id());
            map.put("supid_name", bean.getVendor_name());
            map.put("mfid", bean.getGz_code());
            map.put("mfid_name", bean.getGz_name());
            map.put("purchase_price", bean.getPurchase_price());
            map.put("saleprice", bean.getSale_price());
            map.put("unit", bean.getUnit());
            map.put("spec", bean.getSpec());
            map.put("content", bean.getContent());
            map.put("origin", bean.getOrigin());
            renderRows.getAndIncrement();
        }));
        XxlJobLogger.log((String)"\u6e32\u67d3\u5546\u54c1\u5b8c\u6bd5\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, renderRows.get(), System.currentTimeMillis() - start_time});
        start_time = System.currentTimeMillis();
        dataList.stream().forEach(map -> setCate.add(MapUtils.getString((Map)map, (String)"catcode")));
        XxlJobLogger.log((String)"\u7c7b\u522b\u53bb\u91cd\u7f16\u7801\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, setCate.size(), System.currentTimeMillis() - start_time});
        start_time = System.currentTimeMillis();
        if (setCate.size() > 0) {
            List setCatePages = Lists.partition(new ArrayList(setCate), (int)maxNum);
            setCatePages.forEach(list -> {
                try {
                    String leafList = list.stream().collect(Collectors.joining(","));
                    listCate.addAll(MdmUtils.getCatetoryRefByLeaf((ServiceSession)session, (String)leafList));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            setCatePages = null;
        }
        XxlJobLogger.log((String)"\u83b7\u53d6\u7c7b\u522b\u5b57\u5178\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, listCate.size(), System.currentTimeMillis() - start_time});
        start_time = System.currentTimeMillis();
        renderRows.set(0);
        listCate.stream().forEach(bean -> dataList.stream().filter(map -> MapUtils.getString((Map)map, (String)"catcode").equalsIgnoreCase(bean.getClass5_code())).forEach(map -> {
            map.put("section", bean.getClass2_code());
            map.put("article", bean.getClass4_code());
            renderRows.getAndIncrement();
        }));
        XxlJobLogger.log((String)"\u6e32\u67d3\u7c7b\u522b\u5b8c\u6bd5\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, renderRows.get(), System.currentTimeMillis() - start_time});
        start_time = System.currentTimeMillis();
        dataList.stream().forEach(map -> {
            if (!"N/A".equalsIgnoreCase(MapUtils.getString((Map)map, (String)"popmemo", (String)"N/A"))) {
                String popMemo = MapUtils.getString((Map)map, (String)"popmemo");
                map.put("popmemo", popMemo);
                map.put("fdmode", this.getPopMemoVal(popMemo, "fdmode"));
                map.put("popzkfd", this.getPopMemoVal(popMemo, "popzkfd"));
                map.put("fdresult", this.getPopMemoVal(popMemo, "fdresult"));
            }
        });
        XxlJobLogger.log((String)"\u6e32\u67d3\u5206\u644a\u5b8c\u6bd5\uff1a\u95e8\u5e97\u3010{}\u3011, \u884c\u6570\u3010{}\u3011\uff0c\u8017\u65f6\u3010{} ms\u3011", (Object[])new Object[]{mktid, dataList.size(), System.currentTimeMillis() - start_time});
        start_time = System.currentTimeMillis();
        setItem.clear();
        setCate.clear();
        listItem.clear();
        listCate.clear();
        return dataList;
    }

    @Override
    public ServiceResponse genPromotionreport(ServiceSession session, JSONObject jsonparam) throws Exception {
        return null;
    }

    @Override
    public ServiceResponse genDaypromotionreport(ServiceSession session, JSONObject jsonparam) {
        return null;
    }
}

