/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omp.event.model.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.omd.storage.FStorageOperations;
import com.efuture.omp.event.model.component.PopModelServiceBase;
import com.efuture.omp.event.model.entity.EvtScopeTagBean;
import com.efuture.omp.event.model.entity.SysEnterpriseBean;
import com.efuture.omp.event.model.intf.TagRelyService;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class TagRelyServiceImpl
extends PopModelServiceBase
implements TagRelyService {
    long default_ent_id;
    static boolean isQuartzRun;
    List<String> matchLevel = null;
    List<String> dicturi = null;
    List<String> dictkey = null;

    public static TagRelyServiceImpl getInstance() {
        return (TagRelyServiceImpl)SpringBeanFactory.getBean((String)"TagRely", TagRelyServiceImpl.class);
    }

    public long getDefault_ent_id() {
        return this.default_ent_id;
    }

    public void setDefault_ent_id(long default_ent_id) {
        this.default_ent_id = default_ent_id;
    }

    public List<String> getMatchLevel() {
        return this.matchLevel;
    }

    public void setMatchLevel(List<String> matchLevel) {
        this.matchLevel = matchLevel;
    }

    public List<String> getDicturi() {
        return this.dicturi;
    }

    public void setDicturi(List<String> dicturi) {
        this.dicturi = dicturi;
    }

    public List<String> getDictkey() {
        return this.dictkey;
    }

    public void setDictkey(List<String> dictkey) {
        this.dictkey = dictkey;
    }

    public void setMatchLevel(String matchLevel) {
        this.matchLevel = this.StringToList(matchLevel);
    }

    public void setDicturi(String dicturi) {
        this.dicturi = this.StringToList(dicturi);
    }

    public void setDictkey(String dictkey) {
        this.dictkey = this.StringToList(dictkey);
    }

    public Boolean getBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() == 0) {
                return null;
            }
            if ("true".equals(str)) {
                return Boolean.TRUE;
            }
            if ("false".equals(str)) {
                return Boolean.FALSE;
            }
            if ("1".equals(str)) {
                return Boolean.TRUE;
            }
            if ("0".equals(str)) {
                return Boolean.FALSE;
            }
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    private List<String> StringToList(String str) {
        String[] strs;
        ArrayList<String> result = new ArrayList<String>();
        for (String ss : strs = str.split(",")) {
            result.add(ss.trim());
        }
        return result;
    }

    private String ListToString(List<String> list) {
        String result = null;
        for (String ss : list) {
            if (StringUtils.isEmpty(result)) {
                result = ss;
                continue;
            }
            result = result.concat(",").concat(ss);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONArray getAllDictLevel(ServiceSession session, JSONObject jsonparam, String uri, String dictKey) throws Exception {
        JSONArray array = new JSONArray();
        int page_no = 1;
        int page_size = 300;
        while (true) {
            JSONArray ary;
            jsonparam.put("page_no", (Object)page_no);
            jsonparam.put("page_size", (Object)page_size);
            ServiceResponse response = RestClientUtils.getRestUtils().sendRequest((Object)session, uri, (Object)jsonparam.toJSONString());
            JSONObject json = (JSONObject)response.getData();
            if (json == null || !json.containsKey((Object)dictKey) || (ary = json.getJSONArray(dictKey)) == null || ary.size() <= 0) return array;
            ++page_no;
            array.addAll((Collection)ary);
            if (!json.containsKey((Object)"total_results")) continue;
            int total = Integer.parseInt(json.get((Object)"total_results").toString());
            if (array.size() >= total) return array;
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse synctagrely(ServiceSession session, JSONObject jsonparam) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (StringUtils.isEmpty((Object)jsonparam)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        long starttime = System.currentTimeMillis();
        StringBuffer buff = null;
        List<SysEnterpriseBean> ents = new ArrayList();
        try {
            ents = this.doSearch(jsonparam, SysEnterpriseBean.class, buff);
            if (StringUtils.isEmpty(ents)) {
                ents = new ArrayList();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XxlJobLogger.log((String)("\u67e5\u627e\u591a\u4f01\u4e1a\u914d\u7f6e\u5931\u8d25 {} \uff0c\u6309\u9ed8\u8ba4\u4f01\u4e1a\u751f\u6210! " + ex.getMessage()), (Object[])new Object[0]);
        }
        if (ents.size() <= 0) {
            SysEnterpriseBean ent = new SysEnterpriseBean();
            ent.setEnt_id(this.default_ent_id);
            ent.setMatchlevel(this.ListToString(this.getMatchLevel()));
            ent.setDicturi(this.ListToString(this.getDicturi()));
            ent.setDictkey(this.ListToString(this.getDictkey()));
            ents.add(ent);
        }
        long start_time = System.currentTimeMillis();
        this.getLogger().info((Object)("ents:" + String.valueOf(ents.size())));
        JSONObject json = new JSONObject();
        for (SysEnterpriseBean ent : ents) {
            XxlJobLogger.log((String)"\u5f00\u59cb\u751f\u6210\uff0c\u4f01\u4e1a {} ", (Object[])new Object[]{ent.getEnt_id()});
            session.setEnt_id(ent.getEnt_id());
            if (StringUtils.isEmpty((Object)ent.getMatchlevel())) continue;
            List<String> ml_list = this.StringToList(ent.getMatchlevel());
            List<String> uri_list = this.StringToList(ent.getDicturi());
            List<String> key_list = this.StringToList(ent.getDictkey());
            for (int i = 0; i < ml_list.size(); ++i) {
                this.getLogger().info((Object)String.format("QuartzSync:%s-%s begin", String.valueOf(ent.getEnt_id()), ml_list.get(i).toString()));
                XxlJobLogger.log((String)"\u5f00\u59cb\u751f\u6210\uff0c\u4f01\u4e1a {} \uff0c\u7ef4\u5ea6 {} ", (Object[])new Object[]{ent.getEnt_id(), ml_list.get(i)});
                if (StringUtils.isEmpty((Object)uri_list.get(i)) || StringUtils.isEmpty((Object)RestClientUtils.getRestUtils().queryServiceURI(uri_list.get(i)))) continue;
                jsonparam.put("fields", (Object)"code,name,parent_id,is_parent,jygs");
                JSONArray array = this.getAllDictLevel(session, jsonparam, uri_list.get(i).toString(), key_list.get(i).toString());
                this.getLogger().info((Object)String.format("QuartzSync:%s-%s:%d", String.valueOf(ent.getEnt_id()), key_list.get(i).toString(), array.size()));
                XxlJobLogger.log((String)"\u5f00\u59cb\u751f\u6210\uff0c\u4f01\u4e1a {}, \u7ef4\u5ea6 {}, \u884c\u6570 {} ", (Object[])new Object[]{ent.getEnt_id(), ml_list.get(i), array.size()});
                JSONObject jsonlev = new JSONObject();
                jsonlev.put("total", (Object)(array != null ? array.size() : 0));
                jsonlev.put("update", (Object)this.doSyncTagRely(session, array, ml_list.get(i).toLowerCase()));
                jsonlev.put("elapsed", (Object)(System.currentTimeMillis() - starttime + " ms"));
                this.getLogger().info((Object)String.format("QuartzSync:%s:%s", key_list.get(i).toString(), jsonlev.toJSONString()));
                XxlJobLogger.log((String)"\u5f00\u59cb\u751f\u6210\uff0c\u4f01\u4e1a {}, \u7ef4\u5ea6 {}, \u7ed3\u679c {} ", (Object[])new Object[]{ent.getEnt_id(), ml_list.get(i), jsonlev.toString()});
                json.put(String.valueOf(ent.getEnt_id()).concat("-").concat(ml_list.get(i).toString()), (Object)jsonlev);
            }
        }
        XxlJobLogger.log((String)"\u672c\u6b21\u6267\u884c\u5b8c\u6bd5, \u8017\u65f6 {}", (Object[])new Object[]{System.currentTimeMillis() - start_time});
        return ServiceResponse.buildSuccess((Object)json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quartSyncTagRely() throws Exception {
        if (isQuartzRun) {
            return;
        }
        try {
            isQuartzRun = true;
            ServiceSession session = new ServiceSession();
            session.setEnt_id(this.default_ent_id);
            JSONObject jsonparam = new JSONObject();
            ServiceResponse resp = this.synctagrely(session, jsonparam);
            this.getLogger().info((Object)"QuartzSync:".concat(((JSONObject)resp.getData()).toString()));
        }
        finally {
            isQuartzRun = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doSyncTagRely(ServiceSession session, JSONArray array, String ckey) throws Exception {
        if (array == null) {
            return 0;
        }
        int count = 0;
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            long utctime = this.getTimestamp(storage);
            for (int i = 0; i < array.size(); ++i) {
                JSONObject json = array.getJSONObject(i);
                if (!json.containsKey((Object)"is_parent") || this.getBoolean(json.get((Object)"is_parent")).booleanValue()) continue;
                String code = json.getString("code");
                StringBuffer sb = new StringBuffer(code + ",");
                String parent = DataUtils.getJsonData((JSONObject)json, (String)"parent_code", (boolean)false, (String)DataUtils.getJsonData((JSONObject)json, (String)"parent_id", (boolean)false, (String)"0"));
                String corp_id = json.getString("jygs");
                while (!StringUtils.isEmpty((Object)parent) && !"0".equals(parent)) {
                    boolean exist = false;
                    for (int j = 0; j < array.size(); ++j) {
                        JSONObject jsn = array.getJSONObject(j);
                        if (!parent.equalsIgnoreCase(jsn.getString("code")) || !corp_id.equalsIgnoreCase(jsn.getString("jygs"))) continue;
                        sb.append(jsn.getString("code") + ",");
                        exist = true;
                        parent = DataUtils.getJsonData((JSONObject)jsn, (String)"parent_code", (boolean)false, (String)DataUtils.getJsonData((JSONObject)jsn, (String)"parent_id", (boolean)true, (String)""));
                        break;
                    }
                    if (exist) continue;
                    break;
                }
                sb.setLength(sb.length() - 1);
                String level = sb.toString();
                if (code.equalsIgnoreCase(level)) continue;
                String key = session.getEnt_id() + "." + corp_id + "." + ckey + ".%." + code;
                Criteria criteria = Criteria.where((String)"tag_key").is((Object)key);
                Query query = new Query((CriteriaDefinition)criteria);
                EvtScopeTagBean tag = (EvtScopeTagBean)((Object)storage.selectOne(query, EvtScopeTagBean.class));
                if (tag == null) {
                    tag = new EvtScopeTagBean();
                    tag.setCorp_id(corp_id);
                    tag.setTag_key(key);
                    tag.setCkey(ckey);
                    tag.setOrg_code("%");
                    tag.setTag_code(code);
                    tag.setTag_rely(level);
                    tag.setNoid(0);
                    tag.setTmdd(utctime);
                    tag.initInsertMember(session);
                    storage.insert((Object)tag);
                    ++count;
                    continue;
                }
                if (level.equalsIgnoreCase(tag.getTag_rely())) continue;
                Update upt = new Update();
                upt.set("tag_rely", (Object)level);
                upt.set("tmdd", (Object)utctime);
                tag.initInsertMember(session);
                storage.update(query, upt, EvtScopeTagBean.class);
                ++count;
            }
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
        return count;
    }
}

