/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omp.event.model.sync;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.slice.filter.SliceBase;
import com.efuture.ocp.common.trans.TransactionManager;
import com.efuture.ocp.common.util.BatchInsService;
import com.efuture.ocp.common.util.BeanField;
import com.efuture.ocp.common.util.DataUtils;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.Utils;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import com.efuture.omd.storage.parser.QueryExtractor;
import com.efuture.omp.event.model.component.PopModelSliceBase;
import com.xxl.job.core.log.XxlJobLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class SyncModelDataServiceImpl
extends PopModelSliceBase {
    private long loc_entid;
    private boolean enable;
    private String mastertable;
    private String mastertable_tmddcolname;
    private String subtables;
    private String metadataColName = "metadata";
    private String store;
    private String billid;
    private String url;
    private String RestClientObj = "RestUtils";
    private int pagesize;
    private int subPagesize;
    private int seconds = 10;
    private BatchInsService batchInsService = new BatchInsService();
    private ConcurrentHashMap<String, Set<BeanField>> CACHE_FIELD = new ConcurrentHashMap();
    private boolean isRunning = false;

    public static SyncModelDataServiceImpl getInstance() {
        return (SyncModelDataServiceImpl)((Object)SpringBeanFactory.getBean((String)"SyncModelService", SyncModelDataServiceImpl.class));
    }

    public JSONObject getEventList(long tmdd, long maxtmdd, int pageno) {
        return this.getEventList(tmdd, maxtmdd, pageno, 1, null);
    }

    public JSONObject getEventList(long tmdd, long maxtmdd, int pageno, int subPageNo, List<String> evts) {
        JSONObject postparam = new JSONObject();
        if (!StringUtils.isEmpty((Object)this.billid)) {
            postparam.put("billid", (Object)this.billid);
            postparam.put("tmdd", (Object)0);
            postparam.put("maxtmdd", (Object)maxtmdd);
        } else {
            postparam.put("tmdd", (Object)tmdd);
            postparam.put("maxtmdd", (Object)maxtmdd);
        }
        if (this.subPagesize <= this.pagesize) {
            this.subPagesize = this.pagesize + 1;
        }
        postparam.put("mastertable", (Object)this.mastertable);
        postparam.put("store", (Object)this.store);
        postparam.put("page_no", (Object)pageno);
        postparam.put("page_size", (Object)this.pagesize);
        postparam.put("sub_pageno", (Object)subPageNo);
        postparam.put("sub_pagesize", (Object)this.subPagesize);
        if (evts != null && evts.size() > 0) {
            postparam.put("evt_list", (Object)String.join((CharSequence)",", evts));
        }
        RestClientUtils restclient = (RestClientUtils)SpringBeanFactory.getBean((String)this.RestClientObj, RestClientUtils.class);
        ServiceResponse retdata = null;
        try {
            XxlJobLogger.log((String)("\u68c0\u7d22\u6a21\u578b\uff1a" + postparam.toString()), (Object[])new Object[0]);
            retdata = restclient.sendRequest(null, this.url, (Object)postparam.toString(), "HGO:");
        }
        catch (Exception e) {
            this.getLogger().error((Object)e.getMessage());
            XxlJobLogger.log((String)("\u68c0\u7d22\u5f02\u5e38\uff1a" + e.getMessage()), (Object[])new Object[0]);
            return null;
        }
        return (JSONObject)retdata.getData();
    }

    public long getLastSyncdate(String tablename) {
        Criteria criteria;
        Query query;
        FStorageOperations fso = this.getStorageOperations();
        Map querydata = fso.selectOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"ent_id").is((Object)this.loc_entid).and("tablename").is((Object)tablename))), "lastsyncdate");
        if (querydata != null && querydata.containsKey("lastsyncdate")) {
            return Long.parseLong(querydata.get("lastsyncdate").toString());
        }
        return 0L;
    }

    public JSONObject getTableMetadata(String tablename, String metadata) {
        JSONObject jsonmeta = JSONObject.parseObject((String)metadata);
        JSONObject rtn = new JSONObject();
        rtn.put("tablekey", jsonmeta.get((Object)tablename));
        return rtn;
    }

    public void delsubtabledata(String keyvalue, String metadata) {
        String[] subtabs = this.subtables.split(",");
        for (int i = 0; i < subtabs.length; ++i) {
            String subtable = subtabs[i];
            if (StringUtils.isEmpty((Object)subtable)) continue;
            this.deldata(subtable, metadata, keyvalue);
        }
    }

    public void deldata(String tab, String metadata, String keyvalue) {
        JSONObject tableMetadata = this.getTableMetadata(tab, metadata);
        String tablekey = (String)tableMetadata.get((Object)"tablekey");
        FStorageOperations fso = this.getStorageOperations();
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)this.loc_entid).and(tablekey).is((Object)keyvalue);
        Query query = new Query((CriteriaDefinition)criteria);
        fso.delete(query, tab);
    }

    public int delSubTableDataBatch(List<String> keyvalues, String metadata) throws Exception {
        String[] subtabs = this.subtables.split(",");
        int rows = 0;
        for (int i = 0; i < subtabs.length; ++i) {
            String subtable = subtabs[i];
            if (StringUtils.isEmpty((Object)subtable)) continue;
            rows += this.deldataBatch(subtable, metadata, keyvalues);
        }
        return rows;
    }

    public int deldataBatch(String tab, String metadata, List<String> keyvalues) throws Exception {
        JSONObject tableMetadata = this.getTableMetadata(tab, metadata);
        String tablekey = DataUtils.getJsonData((JSONObject)tableMetadata, (String)"tablekey", (boolean)false, (String)"");
        if (StringUtils.isEmpty((Object)tablekey)) {
            return 0;
        }
        FStorageOperations fso = this.getStorageOperations();
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)this.loc_entid).and(tablekey).in(keyvalues);
        Query query = new Query((CriteriaDefinition)criteria);
        return fso.delete(query, tab);
    }

    private List<String> getMetaSlice(String metadata) {
        ArrayList<String> result = new ArrayList<String>();
        JSONObject jsonmeta = JSONObject.parseObject((String)metadata);
        if (jsonmeta.containsKey((Object)"slice")) {
            result.addAll((List)jsonmeta.get((Object)"slice"));
        }
        if (result.size() <= 0 && !this.isWriteSlice()) {
            result.add("N/A");
        }
        return result;
    }

    private boolean hasNextPage(String metadata) throws Exception {
        JSONObject jsonmeta = JSONObject.parseObject((String)metadata);
        return DataUtils.getJsonData((JSONObject)jsonmeta, (String)"next_page", (boolean)false, (String)"N").equalsIgnoreCase("Y");
    }

    public long doInsDb(String tab, Object data, String metadata, List<String> keyVals) {
        JSONObject tableMetadata = this.getTableMetadata(tab, metadata);
        JSONObject tabdata = (JSONObject)data;
        String tablekey = (String)tableMetadata.get((Object)"tablekey");
        String tmddColName = this.mastertable_tmddcolname;
        String tablekeyvalue = null;
        if (StringUtils.isEmpty((Object)tablekey)) {
            this.getLogger().error(data);
            return 0L;
        }
        tablekeyvalue = tabdata.getString(tablekey);
        tabdata.remove((Object)"rownum_");
        tabdata.put("ent_id", (Object)this.loc_entid);
        keyVals.add(tablekeyvalue);
        FStorageOperations fso = this.getStorageOperations();
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)this.loc_entid).and(tablekey).is((Object)tablekeyvalue);
        Query query = new Query((CriteriaDefinition)criteria);
        if (tab.equalsIgnoreCase(this.mastertable)) {
            fso.delete(query, tab);
        }
        fso.insert((Object)tabdata, tab);
        if (tab.equalsIgnoreCase(this.mastertable) && tabdata.containsKey((Object)tmddColName)) {
            return tabdata.getLongValue(tmddColName);
        }
        return 0L;
    }

    public ServiceResponse syncmodel(ServiceSession session, JSONObject jsonparam) throws Exception {
        this.checkPara(session, jsonparam);
        this.setMastertable(DataUtils.getJsonData((JSONObject)jsonparam, (String)"master_table", (boolean)true, (String)""));
        this.setSubtables(DataUtils.getJsonData((JSONObject)jsonparam, (String)"sub_table", (boolean)false, (String)""));
        this.setMastertable_tmddcolname(DataUtils.getJsonData((JSONObject)jsonparam, (String)"tmdd_col", (boolean)true, (String)""));
        this.setUrl(DataUtils.getJsonData((JSONObject)jsonparam, (String)"remote_url", (boolean)true, (String)""));
        this.setStore(Utils.getEnvValue((String)DataUtils.getJsonData((JSONObject)jsonparam, (String)"store", (boolean)false, (String)"")));
        this.setPagesize(DataUtils.getJsonData((JSONObject)jsonparam, (String)"page_size", (boolean)false, (int)10));
        this.setEnable(true);
        this.setLoc_entid(DataUtils.getJsonData((JSONObject)jsonparam, (String)"ent_id", (boolean)false, (long)0L));
        this.setBillid(DataUtils.getJsonData((JSONObject)jsonparam, (String)"billid", (boolean)false, (String)""));
        this.setSeconds(DataUtils.getJsonData((JSONObject)jsonparam, (String)"seconds", (boolean)false, (int)10));
        this.setSubPagesize(DataUtils.getJsonData((JSONObject)jsonparam, (String)"sub_pagesize", (boolean)false, (int)10000));
        return ServiceResponse.buildSuccess((Object)this.doSync());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String doSync() throws Exception {
        if (this.isRunning) {
            return null;
        }
        try {
            this.isRunning = true;
            if (!this.isEnable() || StringUtils.isEmpty((Object)this.store)) {
                XxlJobLogger.log((String)"\u672a\u5f00\u542f\u540c\u6b65\u53c2\u6570\uff01", (Object[])new Object[0]);
                String string = null;
                return string;
            }
            String string = this.doManualSync();
            return string;
        }
        finally {
            this.isRunning = false;
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String doManualSync() throws Exception {
        long first_time = System.currentTimeMillis();
        long lastdate = this.getLastSyncdate(this.mastertable);
        long thisdate = 0L;
        int thiseventnum = 0;
        String metadata = null;
        FMybatisTemplate fso = (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        Map map = (Map)fso.getSqlSessionTemplate().selectOne("mybatis.sql.select_UNIX_TIMESTAMP");
        long utctime = Long.parseLong(map.get("utctime").toString());
        utctime -= (long)this.seconds;
        long start_time = 0L;
        long group_time = 0L;
        int pageno = 1;
        String rtnmsg = "\u6ca1\u6709\u6570\u636e\u9700\u8981\u540c\u6b65";
        String currSlice = null;
        while (true) {
            start_time = System.currentTimeMillis();
            group_time = System.currentTimeMillis();
            JSONObject eventlist = this.getEventList(lastdate, utctime, pageno);
            XxlJobLogger.log((String)"\u68c0\u7d22\u5b8c\u6bd5\uff0c\u5f00\u59cb\u540c\u6b65\uff1a{} ms", (Object[])new Object[]{System.currentTimeMillis() - start_time});
            start_time = System.currentTimeMillis();
            if (eventlist == null || eventlist.size() < 1) {
                XxlJobLogger.log((String)"\u672c\u6b21\u6267\u884c\u5b8c\u6bd5\uff0c\u7d2f\u8ba1\u540c\u6b65 {} \u7ec4\u6d3b\u52a8\uff0c\u7d2f\u8ba1\u8017\u65f6\uff1a {} ms", (Object[])new Object[]{String.valueOf(thiseventnum), System.currentTimeMillis() - first_time});
                return rtnmsg;
            }
            int subPageno = 1;
            ArrayList<String> keyVals = null;
            while (true) {
                metadata = eventlist.containsKey(this.metadataColName) ? eventlist.get(this.metadataColName).toString() : this.getMetadata(this.mastertable);
                for (String slice : this.getMetaSlice(metadata)) {
                    if (!"N/A".equalsIgnoreCase(slice)) {
                        currSlice = SliceBase.getCurrentSlice();
                        SliceBase.setCurrentSlice((String)slice);
                    }
                    TransactionStatus transStatus = null;
                    if (fso.getDBType() != QueryExtractor.DBTYPE.SQLITE) {
                        transStatus = TransactionManager.newTransaction((String[])new String[0]);
                    }
                    try {
                        List mtabledata = (List)eventlist.get(this.mastertable);
                        if (mtabledata != null && mtabledata.size() > 0) {
                            keyVals = new ArrayList<String>();
                            thiseventnum += mtabledata.size();
                            for (int i = 0; i < mtabledata.size(); ++i) {
                                JSONObject rowdata = (JSONObject)mtabledata.get(i);
                                Object thisKeyVal = null;
                                long rowdate = this.doInsDb(this.mastertable, rowdata, metadata, keyVals);
                                if (rowdate <= thisdate) continue;
                                thisdate = rowdate;
                            }
                            XxlJobLogger.log((String)"\u63d2\u5165\u4e3b\u8868{}\u5b8c\u6210: {} \u884c, {} ms", (Object[])new Object[]{this.mastertable, mtabledata.size(), System.currentTimeMillis() - start_time});
                            if (keyVals != null && keyVals.size() > 0) {
                                int detail_rows = this.delSubTableDataBatch(keyVals, metadata);
                                XxlJobLogger.log((String)"\u5220\u9664\u5b50\u8868\u5b8c\u6210: {} \u884c, {} ms", (Object[])new Object[]{detail_rows, System.currentTimeMillis() - start_time});
                            }
                        }
                        start_time = System.currentTimeMillis();
                        for (Map.Entry entry : eventlist.entrySet()) {
                            String tablename = (String)entry.getKey();
                            if (tablename.equalsIgnoreCase(this.metadataColName)) continue;
                            List<Map<String, Object>> tabledata = this.filterSliceData((List)entry.getValue(), slice);
                            if (tablename.equalsIgnoreCase(this.mastertable) || tabledata == null || tabledata.size() <= 0) continue;
                            Set<BeanField> fields = this.getTableFields(tablename);
                            this.batchInsService.batchInsert((FMybatisTemplate)SpringBeanFactory.getBean((String)"StorageOperation", FMybatisTemplate.class), fields, tabledata, tablename, 1000);
                            XxlJobLogger.log((String)"\u63d2\u5165\u5b50\u8868{}\u5b8c\u6210: {} \u884c, {} ms", (Object[])new Object[]{tablename, tabledata.size(), System.currentTimeMillis() - start_time});
                            start_time = System.currentTimeMillis();
                        }
                        if (thisdate == 0L) {
                            thisdate = utctime;
                        }
                        this.uptThisDate(this.mastertable, thisdate);
                        if (fso.getDBType() == QueryExtractor.DBTYPE.SQLITE) continue;
                        TransactionManager.commit((TransactionStatus)transStatus, (String[])new String[0]);
                    }
                    catch (Exception e) {
                        if (fso.getDBType() != QueryExtractor.DBTYPE.SQLITE) {
                            TransactionManager.rollback((TransactionStatus)transStatus, (String[])new String[0]);
                            continue;
                        }
                        throw e;
                    }
                }
                SliceBase.setCurrentSlice(currSlice);
                if (!this.hasNextPage(metadata) || (eventlist = this.getEventList(lastdate, utctime, pageno, ++subPageno, keyVals)) == null || eventlist.size() < 1) break;
                XxlJobLogger.log((String)"\u68c0\u7d22\u5b50\u5206\u9875{}\u5b8c\u6bd5\uff0c\u5f00\u59cb\u540c\u6b65\uff1a{} ms", (Object[])new Object[]{subPageno, System.currentTimeMillis() - start_time});
                start_time = System.currentTimeMillis();
            }
            rtnmsg = "\u5df2\u540c\u6b65 " + String.valueOf(thiseventnum) + " \u7ec4\u6570\u636e";
            XxlJobLogger.log((String)"\u5df2\u540c\u6b65 {} \u7ec4\u6570\u636e\uff0c\u672c\u8f6e\u8017\u65f6\uff1a {} ms", (Object[])new Object[]{String.valueOf(thiseventnum), System.currentTimeMillis() - group_time});
            ++pageno;
        }
    }

    public Set<BeanField> getTableFields(String tableName) {
        if (this.CACHE_FIELD.containsKey(tableName)) {
            return this.CACHE_FIELD.get(tableName);
        }
        FMybatisTemplate fso = null;
        fso = this.isWriteSlice() ? (FMybatisTemplate)this.getStorageOperationConfig("GlobalStorageOperation") : (FMybatisTemplate)this.getStorageOperations(FMybatisTemplate.class);
        TreeSet<BeanField> beanFields = new TreeSet<BeanField>();
        List list_cols = fso.getSqlSessionTemplate().selectList("mybatis.sql.findFieldByTableName", (Object)tableName);
        int i = 0;
        for (Map col : list_cols) {
            BeanField bf = new BeanField();
            bf.setColID(i++);
            bf.setColName(MapUtils.getString((Map)col, (String)"column_name"));
            bf.setColType(this.batchInsService.convertToColType(fso.getDBType(), MapUtils.getString((Map)col, (String)"data_type")));
            beanFields.add(bf);
        }
        this.CACHE_FIELD.put(tableName, beanFields);
        return beanFields;
    }

    private String getMetadata(String mastertable) {
        return null;
    }

    private synchronized void uptThisDate(String tablename, long thisdate) {
        Criteria criteria;
        Query query;
        if (!StringUtils.isEmpty((Object)this.billid)) {
            return;
        }
        FStorageOperations fso = this.getStorageOperations();
        HashMap<String, Object> querydata = fso.selectOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"ent_id").is((Object)this.loc_entid).and("tablename").is((Object)tablename))), "lastsyncdate");
        if (querydata != null) {
            Update upt = new Update();
            upt.set("lastsyncdate", (Object)thisdate);
            fso.update(query, upt, "lastsyncdate");
        } else {
            querydata = new HashMap<String, Object>();
            querydata.put("ent_id", this.loc_entid);
            querydata.put("tablename", tablename);
            querydata.put("lastsyncdate", thisdate);
            fso.insert(querydata, "lastsyncdate");
        }
    }

    public long getLoc_entid() {
        return this.loc_entid;
    }

    public void setLoc_entid(long loc_entid) {
        this.loc_entid = loc_entid;
    }

    public String getMastertable() {
        return this.mastertable;
    }

    public void setMastertable(String mastertable) {
        this.mastertable = mastertable;
    }

    public String getMastertable_tmddcolname() {
        return this.mastertable_tmddcolname;
    }

    public void setMastertable_tmddcolname(String mastertable_tmddcolname) {
        this.mastertable_tmddcolname = mastertable_tmddcolname;
    }

    public String getMetadataColName() {
        return this.metadataColName;
    }

    public void setMetadataColName(String metadataColName) {
        this.metadataColName = metadataColName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRestClientObj() {
        return this.RestClientObj;
    }

    public void setRestClientObj(String restClientObj) {
        this.RestClientObj = restClientObj;
    }

    public String getSubtables() {
        return this.subtables;
    }

    public void setSubtables(String subtables) {
        this.subtables = subtables;
    }

    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getBillid() {
        return this.billid;
    }

    public void setBillid(String billid) {
        this.billid = billid;
    }

    public int getPagesize() {
        return this.pagesize;
    }

    public void setPagesize(int pagesize) {
        this.pagesize = pagesize;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public int getSubPagesize() {
        return this.subPagesize;
    }

    public void setSubPagesize(int subPagesize) {
        this.subPagesize = subPagesize;
    }
}

