package com.efuture.ocp.taskcore.consumer;

import java.util.Date;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

import com.efuture.ocp.taskcore.service.TaskUtils;
import com.efuture.omd.storage.FStorageOperations;

public class ConsumerRegService implements IConsumerRegService {

	
	public ConsumerReg reg(String topic) {
		ConsumerReg cr;
		String regkey = null;
		String key = TaskUtils.getClientKey();
		regkey = topic + "-" + key;

		Criteria criteria = Criteria.where("consumerkey").is(regkey);
		Query query = new Query(criteria);
		FStorageOperations fso = TaskUtils.getStorageOperations();
		cr = fso.selectOne(query, ConsumerReg.class, "consumer_reg");

		if (cr != null) {
			cr.setStatus("Y");
			Update update = new Update();
			update.set("status", "Y");
			update.set("lastdate", new Date());
			fso.update(query, update, "consumer_reg");
		} else {
			cr = new ConsumerReg();
			cr.setConsumerkey(regkey);
			cr.setTopic(topic);
			cr.setStatus("Y");
			cr.setLastdate(new Date());
			fso.insert(cr, "consumer_reg");
		}
		return cr;
	}
}
