package com.efuture.ocp.taskcore.message;

import java.util.List;

import com.efuture.ocp.taskcore.consumer.ConsumerNode;

public interface IMessageHandle {
	
	public interface msg_produce_rtncode{
		int SUCCESS = 0;
		int COMM_ERR = -1;
	}
	
	/**
	 * 产生一个消息
	 * @param msg
	 */
	public int produce(Message msg);
	
	/**
	 * 获取新的消息
	 * @param node
	 * @param msg
	 * @return
	 */
	public List<Message> pullNewMessage(ConsumerNode node);
	
	/**
	 * 锁定消息
	 * @param node
	 * @param msg
	 * @return
	 */
	public int lockMessage(ConsumerNode node,Message msg);
	
	/**
	 * 消费完回调处理
	 * @param node
	 * @param msg
	 */
	public void consumeCallbackMessage(ConsumerNode node,Message msg);
}
