package com.efuture.ocp.taskcore.service;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.consumer.ConsumerNode;
import com.efuture.ocp.taskcore.consumer.ConsumerReg;
import com.efuture.ocp.taskcore.consumer.IConsumerHandle;
import com.efuture.ocp.taskcore.consumer.IConsumerRegService;
import com.efuture.ocp.taskcore.message.IMessageHandle;

/**
 * 任务消费 1.每个任务一个实例 2.使用Spring task 配置 执行
 * 
 * @author zhouwudong
 *
 */
public class TaskConsumer implements InitializingBean{
	private static Logger logger = Logger.getLogger(TaskConsumer.class);

	private ConsumerReg consumerreg;

	private ConsumerNode nodeconfig;

	private IConsumerRegService consumerRegService;
	private IConsumerHandle consumerHandler;

	private IMessageHandle messagehandle;

	private IMessageDupHandle messagedup;

	private boolean ib_init = false;

	private boolean canrun = true;

	private TaskConsumerService consumer;

	private String consumerobj;

	public boolean isCanrun() {
		return canrun;
	}

	public void setCanrun(boolean canrun) {
		this.canrun = canrun;
	}

	/**
	 * 消费主题
	 */
	private String topic;

	public IConsumerHandle getConsumerHandler() {
		return consumerHandler;
	}

	public IMessageHandle getMessagehandle() {
		return messagehandle;
	}

	public IMessageDupHandle getMessagedup() {
		return messagedup;
	}

	public String getTopic() {
		return topic;
	}

	public void setConsumerHandler(IConsumerHandle consumerHandler) {
		this.consumerHandler = consumerHandler;
	}

	public void setMessagehandle(IMessageHandle messagehandle) {
		this.messagehandle = messagehandle;
	}

	public void setMessagedup(IMessageDupHandle messagedup) {
		this.messagedup = messagedup;
	}

	public IConsumerRegService getConsumerRegService() {
		return consumerRegService;
	}

	public void setConsumerRegService(IConsumerRegService consumerRegService) {
		this.consumerRegService = consumerRegService;
	}

	public void setTopic(String topic) {
		this.topic = topic;
	}

	/**
	 * 初始化消费节点的配置 0.注册消费节点 1.从数据库读出配置并设置到nodeconfig中
	 */

	public void init() {
		TaskConsumerService thisconsumer = getConsumer();
		if (thisconsumer != null) {
			thisconsumer.init();
			ib_init = true;
		}
	}

	/**
	 * 消费消息
	 */
	public void consumer() {
		if(ib_init){
			getConsumer().consumer();
		}
		else
		{
			logger.error("TaskConsumer:没有初始化成功！");
		}
		
	}

	public TaskConsumerService getConsumer() {
		if (consumer == null) {
			if (!StringUtils.isEmpty(consumerobj) ) {
				if(SpringBeanFactory.containsBean(consumerobj)){
					consumer = SpringBeanFactory.getBean(consumerobj, TaskConsumerService.class);
					consumer.setCanrun(this.canrun);
					consumer.setConsumerHandler(this.consumerHandler);
					consumer.setConsumerRegService(getConsumerRegService());
					consumer.setMessagedup(getMessagedup());
					consumer.setMessagehandle(getMessagehandle());
					consumer.setTopic(getTopic());
				}
				else
				{
					logger.error("没有找到对象:"+consumerobj);
				}
			} else {
				consumer = new PullMessageTaskConsumer(this.consumerRegService, this.consumerHandler,
						this.messagehandle, this.messagedup, this.canrun, this.getTopic());
			}

		}
		return consumer;
	}

	public void setConsumer(TaskConsumerService consumer) {
		this.consumer = consumer;
	}

	public ConsumerReg getConsumerreg() {
		return consumerreg;
	}

	public void setConsumerreg(ConsumerReg consumerreg) {
		this.consumerreg = consumerreg;
	}

	public ConsumerNode getNodeconfig() {
		return nodeconfig;
	}

	public void setNodeconfig(ConsumerNode nodeconfig) {
		this.nodeconfig = nodeconfig;
	}

	public String getConsumerobj() {

		return consumerobj;
	}

	public void setConsumerobj(String consumerobj) {
		this.consumerobj = consumerobj;
	}

	public void afterPropertiesSet() throws Exception {
		init();
	}

}
