package com.efuture.ocp.taskcore.service;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;

import org.apache.log4j.Logger;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.MessageConfig;
import com.efuture.omd.storage.FStorageOperations;

public class TaskUtils {

	public final static String StorageOperation = "StorageOperation_task";
	private static Logger logger = Logger.getLogger(TaskProducer.class);

	private static List<MessageConfig> messageConfig;

	public static FStorageOperations getStorageOperations() {
		return SpringBeanFactory.getBean(StorageOperation, FStorageOperations.class);
	}

	public static String getClientKey() {
		String ip = null;
		String port = null;
		try {
			ip = getHostAddress();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			ip = "";
		}
		try {
			port = getServerPort(false);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			port = "";
		}
		String ClientKey = ip + ":" + port;

		return ClientKey;

	}

	public static String getHostAddress() throws UnknownHostException {
		Enumeration<NetworkInterface> netInterfaces = null;
		try {
			netInterfaces = NetworkInterface.getNetworkInterfaces();
			while (netInterfaces.hasMoreElements()) {
				NetworkInterface ni = netInterfaces.nextElement();
				Enumeration<InetAddress> ips = ni.getInetAddresses();
				while (ips.hasMoreElements()) {
					InetAddress ip = ips.nextElement();
					if (ip.isSiteLocalAddress()) {
						return ip.getHostAddress();
					}
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
		return InetAddress.getLocalHost().getHostAddress();
	}

	/**
	 * 获取服务端口号
	 * 
	 * @return 端口号
	 * @throws ReflectionException
	 * @throws MBeanException
	 * @throws InstanceNotFoundException
	 * @throws AttributeNotFoundException
	 */
	public static String getServerPort(boolean secure)
			throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
		MBeanServer mBeanServer = null;
		if (MBeanServerFactory.findMBeanServer(null).size() > 0) {
			mBeanServer = (MBeanServer) MBeanServerFactory.findMBeanServer(null).get(0);
		}

		if (mBeanServer == null) {
			logger.debug("调用findMBeanServer查询到的结果为null");
			return "";
		}

		Set<ObjectName> names = null;
		try {
			names = mBeanServer.queryNames(new ObjectName("Catalina:type=Connector,*"), null);
		} catch (Exception e) {
			return "";
		}
		Iterator<ObjectName> it = names.iterator();
		ObjectName oname = null;
		while (it.hasNext()) {
			oname = (ObjectName) it.next();
			String protocol = (String) mBeanServer.getAttribute(oname, "protocol");
			String scheme = (String) mBeanServer.getAttribute(oname, "scheme");
			Boolean secureValue = (Boolean) mBeanServer.getAttribute(oname, "secure");
			Boolean SSLEnabled = (Boolean) mBeanServer.getAttribute(oname, "SSLEnabled");
			if (SSLEnabled != null && SSLEnabled) {// tomcat6开始用SSLEnabled
				secureValue = true;// SSLEnabled=true但secure未配置的情况
				scheme = "https";
			}
			if (protocol != null && ("HTTP/1.1".equals(protocol) || protocol.contains("http"))) {
				if (secure && "https".equals(scheme) && secureValue) {
					return ((Integer) mBeanServer.getAttribute(oname, "port")).toString();
				} else if (!secure && !"https".equals(scheme) && !secureValue) {
					return ((Integer) mBeanServer.getAttribute(oname, "port")).toString();
				}
			}
		}
		return "";
	}

	private static synchronized void initMessageConfig() {
		if (messageConfig == null) {
			Criteria criteria = Criteria.where("topicstatus").is("Y");
			Query query = new Query(criteria);
			messageConfig = getStorageOperations().select(query, MessageConfig.class, "message_config");
		}
	}

	private static List<MessageConfig> getMessageConfig() {
		if (messageConfig == null) {
			initMessageConfig();
		}
		return messageConfig;
	}

	public static MessageConfig getMessageConfigbyTopic(String topic) {
		List<MessageConfig> config = getMessageConfig();
		if (config == null || config.size() < 1) {
			return null;
		}
		MessageConfig rtn;
		for (int i = 0; i < config.size(); i++) {
			if (config.get(i).getTopic().equalsIgnoreCase(topic)) {
				rtn = config.get(i);
				return rtn;
			}
		}
		return null;
	}

	public static List<MessageConfig> getMessageConfigbyEvent(String event) {
		List<MessageConfig> config = getMessageConfig();
		if (config == null || config.size() < 1) {
			return null;
		}
		List<MessageConfig> rtn = new ArrayList<MessageConfig>();
		for (int i = 0; i < config.size(); i++) {
			if (config.get(i).getEvent().equalsIgnoreCase(event)) {
				rtn.add(config.get(i));
			}
		}
		return rtn;
	}

}
