package com.efuture.ocp.taskcore.transmanager;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.service.TaskProducer;

public class EventTransService {
	
	
	@Autowired
	private static ApplicationContext applicationContext;
	
	protected transient static Log logger = LogFactory.getLog(EventTransService.class);
	// 操作列表
	private static final ThreadLocal<List<Message>> MESSAGELIST = new ThreadLocal<List<Message>>();

	private static final ThreadLocal<List<ApplicationEvent>> EVENTLIST = new ThreadLocal<List<ApplicationEvent>>();

	public static void addEvent(ApplicationEvent event) {
		List<ApplicationEvent> eventlist = EVENTLIST.get();
		if (eventlist == null) {
			eventlist = new ArrayList<ApplicationEvent>();
		}
		eventlist.add(event);
		EVENTLIST.set(eventlist);
	}

	public static void addMsg(Message msg) {
		List<Message> msglist = MESSAGELIST.get();
		if (msglist == null) {
			msglist = new ArrayList<Message>();
		}
		msglist.add(msg);
		MESSAGELIST.set(msglist);
	}

	private static void doMessageRollback() {
		List<Message> msglist = MESSAGELIST.get();
		if (msglist != null && msglist.size() > 0) {
			logger.info("doRollback--->有消息{" + msglist.size() + "}未提交!");
			logger.info("************************************************************");
			logger.info(JSONObject.toJSON(msglist));
			logger.info("************************************************************");
		}
		MESSAGELIST.remove();
	}

	private static void doEventRollback() {
		List<ApplicationEvent> eventlist = EVENTLIST.get();
		if (eventlist != null && eventlist.size() > 0) {
			logger.info("doRollback:eventlist--->有消息{" + eventlist.size() + "}未提交!");
			logger.info("************************************************************");
			logger.info(JSONObject.toJSON(eventlist));
			logger.info("************************************************************");
		}
		EVENTLIST.remove();
	}

	public static void doRollback() {
		doMessageRollback();
		doEventRollback();
	}

	private static void doMessageBegin() {
		List<Message> msglist = MESSAGELIST.get();
		if (msglist != null && msglist.size() > 0) {
			logger.info("doBegin--->有消息{" + msglist.size() + "}未提交!");
			logger.info("************************************************************");
			logger.info(JSONObject.toJSON(msglist));
			logger.info("************************************************************");
		}
		MESSAGELIST.remove();
	}

	private static void doEventBegin() {
		List<ApplicationEvent> eventlist = EVENTLIST.get();
		if (eventlist != null && eventlist.size() > 0) {
			logger.info("doBegin:eventlist--->有消息{" + eventlist.size() + "}未提交!");
			logger.info("************************************************************");
			logger.info(JSONObject.toJSON(eventlist));
			logger.info("************************************************************");
		}
		EVENTLIST.remove();
	}

	public static void doBegin() {
		doMessageBegin();
		doEventBegin();
	}
	
	
	private static void doMessageCommit(){
		List<Message> msglist = MESSAGELIST.get();

		try {
			if (msglist != null) {
				for (Message msg : msglist) {
					TaskProducer.asyncproduce(msg);
				}
			}
		} catch (Exception e) {
			logger.error("提交消息错误!", e);
			logger.error("************************************************************");
			logger.error(JSONObject.toJSON(msglist));
			logger.error("************************************************************");
		} finally {
			MESSAGELIST.remove();
		}
	}
	
	private static void doEventCommit(){
		List<ApplicationEvent> eventlist = EVENTLIST.get();

		try {
			if (eventlist != null) {
				for (ApplicationEvent event : eventlist) {
					SpringBeanFactory.getContext().publishEvent(event);
				}
			}
		} catch (Exception e) {
			logger.error("提交消息错误!", e);
			logger.error("************************************************************");
			logger.error(JSONObject.toJSON(eventlist));
			logger.error("************************************************************");
		} finally {
			EVENTLIST.remove();
		}
	}
	
	
	public static void doCommit() {
		doMessageCommit();
		doEventCommit();

	}
}
