package com.efuture.ocp.taskcore.autorollback;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.autorollback.RollBackOperationData;
import com.efuture.ocp.common.autorollback.RollbackHandle;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.taskcore.service.TaskProducer;

public class DbmsgAutoRollbackHandle implements RollbackHandle {

	public static Logger logger = Logger.getLogger(DbmsgAutoRollbackHandle.class);

	public void dorollback(List<RollBackOperationData> oplist) {
		for (RollBackOperationData data : oplist) {
			sendRollbackMsg(data);
		}
	}

	public RollBackOperationData getMsgData(RollBackOperationData data) {
		String getmsgbean = data.getUrlkey() + ".rollback";

		// 默认处理
		data.setEvent(data.getUrlkey());
		data.setTopic("standardrollback");
		JSONObject rollback = (JSONObject) JSONObject.parse(data.getParam());
		rollback.put("ent_id", data.getSession().getEnt_id());
		rollback.put("urlkey", data.getUrlkey());
		//默认给一个ID
		data.setMsgkey(data.getUrlkey().concat("-").concat(String.valueOf(UniqueID.getUniqueIDArray(10).get(4))));
		data.setRollbackparam(rollback.toJSONString());
		//如果有自定义的msg处理，则使用自定义的msg处理
		if (!SpringBeanFactory.containsBean(getmsgbean)) {
			logger.error("AutoRollback-->没有定义：" + getmsgbean);
			return data;
		}
		CustomAutoRollback getmsg = SpringBeanFactory.getBean(getmsgbean, CustomAutoRollback.class);
		if (!getmsg.ibCanUse()) {
			return data;
		}

		return getmsg.getMsgData(data);
	}

	public void sendRollbackMsg(RollBackOperationData data) {
		if (StringUtils.isEmpty(data)) {
			return;
		}
		RollBackOperationData msgdata = null;
		try {
			msgdata = getMsgData(data);
		} catch (Exception ex) {
			logger.error("AutoRollback-->获取冲正信息失败:".concat(ex.getMessage()));
			return;
		}
		String keyvalue = msgdata.getMsgkey();
		if (StringUtils.isEmpty(keyvalue)) {
			logger.error("AutoRollback-->".concat(data.getUrlkey()).concat("没有keyvalue"));
			return;
		}
		String event = msgdata.getEvent();
		String topic = msgdata.getTopic();
		String param = msgdata.getRollbackparam();
		logger.info("TaskProducer->DbmsgAutoRollbackHandle:".concat(keyvalue));
		try {
			TaskProducer.produce(data.getSession().getEnt_id(), topic, event, keyvalue, param);
		} catch (Exception ex) {
			logger.error("TaskProducer->DbmsgAutoRollbackHandle:".concat(ex.getMessage()));
		}

	}

}
