package com.efuture.ocp.taskcore.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.omd.storage.FStorageOperations;

public class MessageDupService implements IMessageDupHandle {
	public  static String StorageOperation = "StorageOperation_task";

	public FStorageOperations getStorageOperations() {
		return SpringBeanFactory.getBean(StorageOperation, FStorageOperations.class);
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.IMessageDupHandle#checkMessageDup(com.efuture.ocp.taskcore.message.Message)
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW,value = "tasktransactionManager")
	public int checkMessageDup(Message msg)  {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("ent_id", msg.getEnt_id());
		map.put("topic", msg.getTopic());
		map.put("instime", new Date());
		String keyvalue = msg.getKeyvalue();
		if(msg.getExecnode() != null && !msg.getExecnode().equals("")){
			keyvalue = msg.getExecnode()+"-"+keyvalue;
		}
		map.put("keyvalue", keyvalue);
		try {
			getStorageOperations().insert(map, "messagedup");
			return 1;
		} catch (DuplicateKeyException e) {
			return -1;
		}
		catch (Exception ex){
			
			throw  new ServiceException("7001",ex.getMessage());
		}

	}
	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.IMessageDupHandle#delMessageDup(com.efuture.ocp.taskcore.message.Message)
	 */
	@Transactional(propagation = Propagation.REQUIRES_NEW,value = "tasktransactionManager")
	public void delMessageDup(Message msg) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("ent_id", msg.getEnt_id());
		map.put("topic", msg.getTopic());
		String keyvalue = msg.getKeyvalue();
		if(msg.getExecnode() != null && !msg.getExecnode().equals("")){
			keyvalue = msg.getExecnode()+"-"+keyvalue;
		}
		map.put("keyvalue", keyvalue);
		Criteria criteria = Criteria.where("ent_id").is(msg.getEnt_id()).and("topic").is(msg.getTopic()).and("keyvalue")
				.is(keyvalue);
		Query query = new Query(criteria);
		try {
			getStorageOperations().delete(query, "messagedup");
		} catch (Exception e) {

		}

	}
}
