package com.efuture.ocp.taskcore.transmanager;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;

@SuppressWarnings("serial")
public class EventDataSourceTransactionManager extends DataSourceTransactionManager {
	/**
	 * 增加处理消息
	 */
    private ThreadLocal<List<Object>> trans_ignore = new ThreadLocal<List<Object>>();
    
    @Value("${eventdstsm.ignorekeys:}")
    private List<String> ignoreKeys = null;
    
    public List<String> getIgnoreKeys()
    {
        return ignoreKeys;
    }
    
    public void setIgnoreKeys(List<String> ignoreKeys)
    {
        if (ignoreKeys != null)
        {
            this.ignoreKeys = new ArrayList<String>();
            for (String key : ignoreKeys)
            {
                String[] ss = key.split(",");
                for (String s : ss) this.ignoreKeys.add(s);
            }
        }
        else
        {
            this.ignoreKeys = ignoreKeys;
        }
    }
    
    private boolean isIgnore(String methodName)
    {
        for (String key : ignoreKeys)
        {
            if (methodName.contains(key))
            {
                return true;
            }
        }
        return false;
    }
    
	@Override
	protected void doBegin(Object transaction, TransactionDefinition definition) {
		super.doBegin(transaction, definition);
		
		String name = definition.getName();
		if (isIgnore(name))
		{
		    List<Object> ignore_objs = trans_ignore.get();
		    if (ignore_objs == null)
		    {
		        ignore_objs = new ArrayList<Object>();
		    }
		    ignore_objs.add(transaction);
		    trans_ignore.set(ignore_objs);
		    logger.debug("Ignore EventTransService Begin:"+transaction.toString());
		}
		else
		{
		    EventTransService.doBegin();
		}
		logger.debug("开始事物"+transaction.toString());
	}
	
	@Override
	protected void doCommit(DefaultTransactionStatus status){
		super.doCommit(status);
		logger.debug("提交事物"+status.toString());
		try {
		    List<Object> ignore_objs = trans_ignore.get();
		    if (ignore_objs != null && ignore_objs.contains(status.getTransaction()))
		    {
		        trans_ignore.get().remove(status.getTransaction());
		        logger.debug("Ignore EventTransService Commit:"+status.toString());
		    }
		    else
		    {
		        EventTransService.doCommit();
		    }
		} catch (Exception e) {
			logger.error("提交消息错误", e);
		}
	}
	@Override
	protected void doRollback(DefaultTransactionStatus status) {
 		super.doRollback(status);
		logger.debug("回滚事物"+status.toString());
		try {
		    if (trans_ignore.get().contains(status.getTransaction()))
            {
                trans_ignore.get().remove(status.getTransaction());
                logger.debug("Ignore EventTransService Rollback:"+status.toString());
            }
		    else
		    {
		        EventTransService.doRollback();
		    }
		} catch (Exception e) {
			logger.error("取消消息错误", e);
		}
	}

 
}
